/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.AsyncResult;
import Ice.BooleanHolder;
import Ice.Communicator;
import Ice.CompressBatch;
import Ice.ConnectionI;
import Ice.Exception;
import Ice.Instrumentation.InvocationObserver;
import Ice.LocalException;
import IceInternal.AsyncResultI;
import IceInternal.CallbackBase;
import IceInternal.Instance;
import IceInternal.ObserverHelper;
import IceInternal.OutgoingAsyncBase;
import IceInternal.RetryException;
import java.util.concurrent.Callable;

public class CommunicatorFlushBatch
extends AsyncResultI {
    private int _useCount;

    public static CommunicatorFlushBatch check(AsyncResult r, Communicator com, String operation) {
        CommunicatorFlushBatch.check(r, operation);
        if (!(r instanceof CommunicatorFlushBatch)) {
            throw new IllegalArgumentException("Incorrect AsyncResult object for end_" + operation + " method");
        }
        if (r.getCommunicator() != com) {
            throw new IllegalArgumentException("Communicator for call to end_" + operation + " does not match communicator that was used to call corresponding begin_" + operation + " method");
        }
        return (CommunicatorFlushBatch)r;
    }

    public CommunicatorFlushBatch(Communicator communicator, Instance instance, String op, CallbackBase callback) {
        super(communicator, instance, op, callback);
        this._observer = ObserverHelper.get(instance, op);
        this._useCount = 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushConnection(final ConnectionI con, final CompressBatch compressBatch) {
        CommunicatorFlushBatch communicatorFlushBatch = this;
        synchronized (communicatorFlushBatch) {
            ++this._useCount;
        }
        try {
            class FlushBatch
            extends OutgoingAsyncBase {
                public FlushBatch() {
                    super(CommunicatorFlushBatch.this.getCommunicator(), CommunicatorFlushBatch.this._instance, CommunicatorFlushBatch.this.getOperation(), null);
                }

                @Override
                public boolean sent() {
                    if (this._childObserver != null) {
                        this._childObserver.detach();
                        this._childObserver = null;
                    }
                    CommunicatorFlushBatch.this.doCheck(false);
                    return false;
                }

                @Override
                public boolean completed(Exception ex) {
                    if (this._childObserver != null) {
                        this._childObserver.failed(ex.ice_id());
                        this._childObserver.detach();
                        this._childObserver = null;
                    }
                    CommunicatorFlushBatch.this.doCheck(false);
                    return false;
                }

                @Override
                protected InvocationObserver getObserver() {
                    return CommunicatorFlushBatch.this._observer;
                }
            }
            final FlushBatch flushBatch = new FlushBatch();
            final BooleanHolder compress = new BooleanHolder();
            final int batchRequestNum = con.getBatchRequestQueue().swap(flushBatch.getOs(), compress);
            if (batchRequestNum == 0) {
                flushBatch.sent();
            } else if (this._instance.queueRequests()) {
                this._instance.getQueueExecutor().executeNoThrow(new Callable<Void>(){
                    {
                    }

                    @Override
                    public Void call() throws RetryException {
                        boolean comp = compressBatch == CompressBatch.Yes ? true : (compressBatch == CompressBatch.No ? false : (Boolean)compress.value);
                        con.sendAsyncRequest(flushBatch, comp, false, batchRequestNum);
                        return null;
                    }
                });
            } else {
                boolean comp = compressBatch == CompressBatch.Yes ? true : (compressBatch == CompressBatch.No ? false : (Boolean)compress.value);
                con.sendAsyncRequest(flushBatch, comp, false, batchRequestNum);
            }
        }
        catch (RetryException ex) {
            this.doCheck(false);
            throw ex.get();
        }
        catch (LocalException ex) {
            this.doCheck(false);
            throw ex;
        }
    }

    public void ready() {
        this.doCheck(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCheck(boolean userThread) {
        CommunicatorFlushBatch communicatorFlushBatch = this;
        synchronized (communicatorFlushBatch) {
            assert (this._useCount > 0);
            if (--this._useCount > 0) {
                return;
            }
        }
        if (this.sent(true)) {
            if (userThread) {
                this._sentSynchronously = true;
                this.invokeSent();
            } else {
                this.invokeSentAsync();
            }
        }
    }
}

