/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import IceInternal.EventHandler;
import IceInternal.Instance;
import IceInternal.ReadyCallback;
import IceInternal.Selector;
import IceInternal.ThreadPool;
import IceInternal.ThreadPoolCurrent;
import IceInternal.ThreadPoolWorkItem;
import IceUtilInternal.Assert;
import java.nio.channels.SelectableChannel;
import java.util.LinkedList;

final class ThreadPoolWorkQueue
extends EventHandler {
    private final ThreadPool _threadPool;
    private boolean _destroyed;
    private Selector _selector;
    private LinkedList<ThreadPoolWorkItem> _workItems = new LinkedList();

    ThreadPoolWorkQueue(Instance instance, ThreadPool threadPool, Selector selector) {
        this._threadPool = threadPool;
        this._selector = selector;
        this._destroyed = false;
        this._registered = 1;
    }

    protected synchronized void finalize() throws Throwable {
        try {
            Assert.FinalizerAssert(this._destroyed);
        }
        catch (Exception exception) {
        }
        finally {
            super.finalize();
        }
    }

    void destroy() {
        assert (!this._destroyed);
        this._destroyed = true;
        this._selector.ready(this, 1, true);
    }

    void queue(ThreadPoolWorkItem item) {
        assert (item != null);
        this._workItems.add(item);
        if (this._workItems.size() == 1) {
            this._selector.ready(this, 1, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void message(ThreadPoolCurrent current) {
        ThreadPoolWorkItem workItem = null;
        ThreadPool threadPool = this._threadPool;
        synchronized (threadPool) {
            if (!this._workItems.isEmpty()) {
                workItem = this._workItems.removeFirst();
                assert (workItem != null);
            }
            if (this._workItems.isEmpty() && !this._destroyed) {
                this._selector.ready(this, 1, false);
            }
        }
        if (workItem == null) {
            assert (this._destroyed);
            this._threadPool.ioCompleted(current);
            throw new ThreadPool.DestroyedException();
        }
        workItem.execute(current);
    }

    @Override
    public void finished(ThreadPoolCurrent current, boolean close) {
        assert (false);
    }

    @Override
    public String toString() {
        return "work queue";
    }

    @Override
    public SelectableChannel fd() {
        return null;
    }

    @Override
    public void setReadyCallback(ReadyCallback callback) {
    }
}

