// **********************************************************************
//
// Copyright (c) 2003-2017 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.0
//
// <auto-generated>
//
// Generated from file `IceStorm.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package IceStorm;

/**
 * Publishers publish information on a particular topic. A topic
 * logically represents a type.
 *
 * @see TopicManager
 *
 **/
public interface TopicPrx extends Ice.ObjectPrx
{
    /**
     * Get the name of this topic.
     *
     * @return The name of the topic.
     *
     * @see TopicManager#create
     *
     **/
    public String getName();

    /**
     * Get the name of this topic.
     *
     * @param context The Context map to send with the invocation.
     * @return The name of the topic.
     *
     * @see TopicManager#create
     *
     **/
    public String getName(java.util.Map<String, String> context);

    /**
     * Get the name of this topic.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getName();

    /**
     * Get the name of this topic.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getName(java.util.Map<String, String> context);

    /**
     * Get the name of this topic.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getName(Ice.Callback cb);

    /**
     * Get the name of this topic.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getName(java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Get the name of this topic.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getName(Callback_Topic_getName cb);

    /**
     * Get the name of this topic.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getName(java.util.Map<String, String> context, Callback_Topic_getName cb);

    /**
     * Get the name of this topic.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getName(IceInternal.Functional_GenericCallback1<String> responseCb,
                                         IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Get the name of this topic.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getName(IceInternal.Functional_GenericCallback1<String> responseCb,
                                         IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                         IceInternal.Functional_BoolCallback sentCb);

    /**
     * Get the name of this topic.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getName(java.util.Map<String, String> context,
                                         IceInternal.Functional_GenericCallback1<String> responseCb,
                                         IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Get the name of this topic.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getName(java.util.Map<String, String> context,
                                         IceInternal.Functional_GenericCallback1<String> responseCb,
                                         IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                         IceInternal.Functional_BoolCallback sentCb);

    /**
     * Get the name of this topic.
     *
     * @param result The asynchronous result object.
     * @return The name of the topic.
     *
     * @see TopicManager#create
     *
     **/
    public String end_getName(Ice.AsyncResult result);

    /**
     * Get a proxy to a publisher object for this topic. To publish
     * data to a topic, the publisher calls {@link Topic#getPublisher} and then
     * casts to the topic type. An unchecked cast must be used on this
     * proxy. If a replicated IceStorm deployment is used this call
     * may return a replicated proxy.
     *
     * @return A proxy to publish data on this topic.
     *
     **/
    public Ice.ObjectPrx getPublisher();

    /**
     * Get a proxy to a publisher object for this topic. To publish
     * data to a topic, the publisher calls {@link Topic#getPublisher} and then
     * casts to the topic type. An unchecked cast must be used on this
     * proxy. If a replicated IceStorm deployment is used this call
     * may return a replicated proxy.
     *
     * @param context The Context map to send with the invocation.
     * @return A proxy to publish data on this topic.
     *
     **/
    public Ice.ObjectPrx getPublisher(java.util.Map<String, String> context);

    /**
     * Get a proxy to a publisher object for this topic. To publish
     * data to a topic, the publisher calls {@link Topic#getPublisher} and then
     * casts to the topic type. An unchecked cast must be used on this
     * proxy. If a replicated IceStorm deployment is used this call
     * may return a replicated proxy.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getPublisher();

    /**
     * Get a proxy to a publisher object for this topic. To publish
     * data to a topic, the publisher calls {@link Topic#getPublisher} and then
     * casts to the topic type. An unchecked cast must be used on this
     * proxy. If a replicated IceStorm deployment is used this call
     * may return a replicated proxy.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getPublisher(java.util.Map<String, String> context);

    /**
     * Get a proxy to a publisher object for this topic. To publish
     * data to a topic, the publisher calls {@link Topic#getPublisher} and then
     * casts to the topic type. An unchecked cast must be used on this
     * proxy. If a replicated IceStorm deployment is used this call
     * may return a replicated proxy.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getPublisher(Ice.Callback cb);

    /**
     * Get a proxy to a publisher object for this topic. To publish
     * data to a topic, the publisher calls {@link Topic#getPublisher} and then
     * casts to the topic type. An unchecked cast must be used on this
     * proxy. If a replicated IceStorm deployment is used this call
     * may return a replicated proxy.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getPublisher(java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Get a proxy to a publisher object for this topic. To publish
     * data to a topic, the publisher calls {@link Topic#getPublisher} and then
     * casts to the topic type. An unchecked cast must be used on this
     * proxy. If a replicated IceStorm deployment is used this call
     * may return a replicated proxy.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getPublisher(Callback_Topic_getPublisher cb);

    /**
     * Get a proxy to a publisher object for this topic. To publish
     * data to a topic, the publisher calls {@link Topic#getPublisher} and then
     * casts to the topic type. An unchecked cast must be used on this
     * proxy. If a replicated IceStorm deployment is used this call
     * may return a replicated proxy.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getPublisher(java.util.Map<String, String> context, Callback_Topic_getPublisher cb);

    /**
     * Get a proxy to a publisher object for this topic. To publish
     * data to a topic, the publisher calls {@link Topic#getPublisher} and then
     * casts to the topic type. An unchecked cast must be used on this
     * proxy. If a replicated IceStorm deployment is used this call
     * may return a replicated proxy.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getPublisher(IceInternal.Functional_GenericCallback1<Ice.ObjectPrx> responseCb,
                                              IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Get a proxy to a publisher object for this topic. To publish
     * data to a topic, the publisher calls {@link Topic#getPublisher} and then
     * casts to the topic type. An unchecked cast must be used on this
     * proxy. If a replicated IceStorm deployment is used this call
     * may return a replicated proxy.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getPublisher(IceInternal.Functional_GenericCallback1<Ice.ObjectPrx> responseCb,
                                              IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                              IceInternal.Functional_BoolCallback sentCb);

    /**
     * Get a proxy to a publisher object for this topic. To publish
     * data to a topic, the publisher calls {@link Topic#getPublisher} and then
     * casts to the topic type. An unchecked cast must be used on this
     * proxy. If a replicated IceStorm deployment is used this call
     * may return a replicated proxy.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getPublisher(java.util.Map<String, String> context,
                                              IceInternal.Functional_GenericCallback1<Ice.ObjectPrx> responseCb,
                                              IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Get a proxy to a publisher object for this topic. To publish
     * data to a topic, the publisher calls {@link Topic#getPublisher} and then
     * casts to the topic type. An unchecked cast must be used on this
     * proxy. If a replicated IceStorm deployment is used this call
     * may return a replicated proxy.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getPublisher(java.util.Map<String, String> context,
                                              IceInternal.Functional_GenericCallback1<Ice.ObjectPrx> responseCb,
                                              IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                              IceInternal.Functional_BoolCallback sentCb);

    /**
     * Get a proxy to a publisher object for this topic. To publish
     * data to a topic, the publisher calls {@link Topic#getPublisher} and then
     * casts to the topic type. An unchecked cast must be used on this
     * proxy. If a replicated IceStorm deployment is used this call
     * may return a replicated proxy.
     *
     * @param result The asynchronous result object.
     * @return A proxy to publish data on this topic.
     *
     **/
    public Ice.ObjectPrx end_getPublisher(Ice.AsyncResult result);

    /**
     * Get a non-replicated proxy to a publisher object for this
     * topic. To publish data to a topic, the publisher calls
     * {@link Topic#getPublisher} and then casts to the topic type. An unchecked
     * cast must be used on this proxy.
     *
     * @return A proxy to publish data on this topic.
     *
     **/
    public Ice.ObjectPrx getNonReplicatedPublisher();

    /**
     * Get a non-replicated proxy to a publisher object for this
     * topic. To publish data to a topic, the publisher calls
     * {@link Topic#getPublisher} and then casts to the topic type. An unchecked
     * cast must be used on this proxy.
     *
     * @param context The Context map to send with the invocation.
     * @return A proxy to publish data on this topic.
     *
     **/
    public Ice.ObjectPrx getNonReplicatedPublisher(java.util.Map<String, String> context);

    /**
     * Get a non-replicated proxy to a publisher object for this
     * topic. To publish data to a topic, the publisher calls
     * {@link Topic#getPublisher} and then casts to the topic type. An unchecked
     * cast must be used on this proxy.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getNonReplicatedPublisher();

    /**
     * Get a non-replicated proxy to a publisher object for this
     * topic. To publish data to a topic, the publisher calls
     * {@link Topic#getPublisher} and then casts to the topic type. An unchecked
     * cast must be used on this proxy.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getNonReplicatedPublisher(java.util.Map<String, String> context);

    /**
     * Get a non-replicated proxy to a publisher object for this
     * topic. To publish data to a topic, the publisher calls
     * {@link Topic#getPublisher} and then casts to the topic type. An unchecked
     * cast must be used on this proxy.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getNonReplicatedPublisher(Ice.Callback cb);

    /**
     * Get a non-replicated proxy to a publisher object for this
     * topic. To publish data to a topic, the publisher calls
     * {@link Topic#getPublisher} and then casts to the topic type. An unchecked
     * cast must be used on this proxy.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getNonReplicatedPublisher(java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Get a non-replicated proxy to a publisher object for this
     * topic. To publish data to a topic, the publisher calls
     * {@link Topic#getPublisher} and then casts to the topic type. An unchecked
     * cast must be used on this proxy.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getNonReplicatedPublisher(Callback_Topic_getNonReplicatedPublisher cb);

    /**
     * Get a non-replicated proxy to a publisher object for this
     * topic. To publish data to a topic, the publisher calls
     * {@link Topic#getPublisher} and then casts to the topic type. An unchecked
     * cast must be used on this proxy.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getNonReplicatedPublisher(java.util.Map<String, String> context, Callback_Topic_getNonReplicatedPublisher cb);

    /**
     * Get a non-replicated proxy to a publisher object for this
     * topic. To publish data to a topic, the publisher calls
     * {@link Topic#getPublisher} and then casts to the topic type. An unchecked
     * cast must be used on this proxy.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getNonReplicatedPublisher(IceInternal.Functional_GenericCallback1<Ice.ObjectPrx> responseCb,
                                                           IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Get a non-replicated proxy to a publisher object for this
     * topic. To publish data to a topic, the publisher calls
     * {@link Topic#getPublisher} and then casts to the topic type. An unchecked
     * cast must be used on this proxy.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getNonReplicatedPublisher(IceInternal.Functional_GenericCallback1<Ice.ObjectPrx> responseCb,
                                                           IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                           IceInternal.Functional_BoolCallback sentCb);

    /**
     * Get a non-replicated proxy to a publisher object for this
     * topic. To publish data to a topic, the publisher calls
     * {@link Topic#getPublisher} and then casts to the topic type. An unchecked
     * cast must be used on this proxy.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getNonReplicatedPublisher(java.util.Map<String, String> context,
                                                           IceInternal.Functional_GenericCallback1<Ice.ObjectPrx> responseCb,
                                                           IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Get a non-replicated proxy to a publisher object for this
     * topic. To publish data to a topic, the publisher calls
     * {@link Topic#getPublisher} and then casts to the topic type. An unchecked
     * cast must be used on this proxy.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getNonReplicatedPublisher(java.util.Map<String, String> context,
                                                           IceInternal.Functional_GenericCallback1<Ice.ObjectPrx> responseCb,
                                                           IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                           IceInternal.Functional_BoolCallback sentCb);

    /**
     * Get a non-replicated proxy to a publisher object for this
     * topic. To publish data to a topic, the publisher calls
     * {@link Topic#getPublisher} and then casts to the topic type. An unchecked
     * cast must be used on this proxy.
     *
     * @param result The asynchronous result object.
     * @return A proxy to publish data on this topic.
     *
     **/
    public Ice.ObjectPrx end_getNonReplicatedPublisher(Ice.AsyncResult result);

    /**
     * Subscribe with the given <tt>qos</tt> to this topic.  A
     * per-subscriber publisher object is returned.
     *
     * @param theQoS The quality of service parameters for this
     * subscription.
     *
     * @param subscriber The subscriber's proxy.
     *
     * @return The per-subscriber publisher object.
     *
     * @throws AlreadySubscribed Raised if the subscriber object is
     * already subscribed.
     *
     * @throws InvalidSubscriber Raised if the subscriber object is null.
     *
     * @throws BadQoS Raised if the requested quality of service
     * is unavailable or invalid.
     *
     * @see #unsubscribe
     *
     **/
    public Ice.ObjectPrx subscribeAndGetPublisher(java.util.Map<java.lang.String, java.lang.String> theQoS, Ice.ObjectPrx subscriber)
        throws AlreadySubscribed,
               BadQoS,
               InvalidSubscriber;

    /**
     * Subscribe with the given <tt>qos</tt> to this topic.  A
     * per-subscriber publisher object is returned.
     *
     * @param theQoS The quality of service parameters for this
     * subscription.
     *
     * @param subscriber The subscriber's proxy.
     *
     * @param context The Context map to send with the invocation.
     * @return The per-subscriber publisher object.
     *
     * @throws AlreadySubscribed Raised if the subscriber object is
     * already subscribed.
     *
     * @throws InvalidSubscriber Raised if the subscriber object is null.
     *
     * @throws BadQoS Raised if the requested quality of service
     * is unavailable or invalid.
     *
     * @see #unsubscribe
     *
     **/
    public Ice.ObjectPrx subscribeAndGetPublisher(java.util.Map<java.lang.String, java.lang.String> theQoS, Ice.ObjectPrx subscriber, java.util.Map<String, String> context)
        throws AlreadySubscribed,
               BadQoS,
               InvalidSubscriber;

    /**
     * Subscribe with the given <tt>qos</tt> to this topic.  A
     * per-subscriber publisher object is returned.
     *
     * @param theQoS The quality of service parameters for this
     * subscription.
     *
     * @param subscriber The subscriber's proxy.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_subscribeAndGetPublisher(java.util.Map<java.lang.String, java.lang.String> theQoS, Ice.ObjectPrx subscriber);

    /**
     * Subscribe with the given <tt>qos</tt> to this topic.  A
     * per-subscriber publisher object is returned.
     *
     * @param theQoS The quality of service parameters for this
     * subscription.
     *
     * @param subscriber The subscriber's proxy.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_subscribeAndGetPublisher(java.util.Map<java.lang.String, java.lang.String> theQoS, Ice.ObjectPrx subscriber, java.util.Map<String, String> context);

    /**
     * Subscribe with the given <tt>qos</tt> to this topic.  A
     * per-subscriber publisher object is returned.
     *
     * @param theQoS The quality of service parameters for this
     * subscription.
     *
     * @param subscriber The subscriber's proxy.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_subscribeAndGetPublisher(java.util.Map<java.lang.String, java.lang.String> theQoS, Ice.ObjectPrx subscriber, Ice.Callback cb);

    /**
     * Subscribe with the given <tt>qos</tt> to this topic.  A
     * per-subscriber publisher object is returned.
     *
     * @param theQoS The quality of service parameters for this
     * subscription.
     *
     * @param subscriber The subscriber's proxy.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_subscribeAndGetPublisher(java.util.Map<java.lang.String, java.lang.String> theQoS, Ice.ObjectPrx subscriber, java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Subscribe with the given <tt>qos</tt> to this topic.  A
     * per-subscriber publisher object is returned.
     *
     * @param theQoS The quality of service parameters for this
     * subscription.
     *
     * @param subscriber The subscriber's proxy.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_subscribeAndGetPublisher(java.util.Map<java.lang.String, java.lang.String> theQoS, Ice.ObjectPrx subscriber, Callback_Topic_subscribeAndGetPublisher cb);

    /**
     * Subscribe with the given <tt>qos</tt> to this topic.  A
     * per-subscriber publisher object is returned.
     *
     * @param theQoS The quality of service parameters for this
     * subscription.
     *
     * @param subscriber The subscriber's proxy.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_subscribeAndGetPublisher(java.util.Map<java.lang.String, java.lang.String> theQoS, Ice.ObjectPrx subscriber, java.util.Map<String, String> context, Callback_Topic_subscribeAndGetPublisher cb);

    /**
     * Subscribe with the given <tt>qos</tt> to this topic.  A
     * per-subscriber publisher object is returned.
     *
     * @param theQoS The quality of service parameters for this
     * subscription.
     *
     * @param subscriber The subscriber's proxy.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_subscribeAndGetPublisher(java.util.Map<java.lang.String, java.lang.String> theQoS,
                                                          Ice.ObjectPrx subscriber,
                                                          IceInternal.Functional_GenericCallback1<Ice.ObjectPrx> responseCb,
                                                          IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                          IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Subscribe with the given <tt>qos</tt> to this topic.  A
     * per-subscriber publisher object is returned.
     *
     * @param theQoS The quality of service parameters for this
     * subscription.
     *
     * @param subscriber The subscriber's proxy.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_subscribeAndGetPublisher(java.util.Map<java.lang.String, java.lang.String> theQoS,
                                                          Ice.ObjectPrx subscriber,
                                                          IceInternal.Functional_GenericCallback1<Ice.ObjectPrx> responseCb,
                                                          IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                          IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                          IceInternal.Functional_BoolCallback sentCb);

    /**
     * Subscribe with the given <tt>qos</tt> to this topic.  A
     * per-subscriber publisher object is returned.
     *
     * @param theQoS The quality of service parameters for this
     * subscription.
     *
     * @param subscriber The subscriber's proxy.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_subscribeAndGetPublisher(java.util.Map<java.lang.String, java.lang.String> theQoS,
                                                          Ice.ObjectPrx subscriber,
                                                          java.util.Map<String, String> context,
                                                          IceInternal.Functional_GenericCallback1<Ice.ObjectPrx> responseCb,
                                                          IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                          IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Subscribe with the given <tt>qos</tt> to this topic.  A
     * per-subscriber publisher object is returned.
     *
     * @param theQoS The quality of service parameters for this
     * subscription.
     *
     * @param subscriber The subscriber's proxy.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_subscribeAndGetPublisher(java.util.Map<java.lang.String, java.lang.String> theQoS,
                                                          Ice.ObjectPrx subscriber,
                                                          java.util.Map<String, String> context,
                                                          IceInternal.Functional_GenericCallback1<Ice.ObjectPrx> responseCb,
                                                          IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                          IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                          IceInternal.Functional_BoolCallback sentCb);

    /**
     * Subscribe with the given <tt>qos</tt> to this topic.  A
     * per-subscriber publisher object is returned.
     *
     * @param result The asynchronous result object.
     * @return The per-subscriber publisher object.
     *
     * @throws AlreadySubscribed Raised if the subscriber object is
     * already subscribed.
     *
     * @throws InvalidSubscriber Raised if the subscriber object is null.
     *
     * @throws BadQoS Raised if the requested quality of service
     * is unavailable or invalid.
     *
     * @see #unsubscribe
     *
     **/
    public Ice.ObjectPrx end_subscribeAndGetPublisher(Ice.AsyncResult result)
        throws AlreadySubscribed,
               BadQoS,
               InvalidSubscriber;

    /**
     * Unsubscribe the given <tt>subscriber</tt>.
     *
     * @param subscriber The proxy of an existing subscriber.
     *
     * @see #subscribeAndGetPublisher
     *
     **/
    public void unsubscribe(Ice.ObjectPrx subscriber);

    /**
     * Unsubscribe the given <tt>subscriber</tt>.
     *
     * @param subscriber The proxy of an existing subscriber.
     *
     * @see #subscribeAndGetPublisher
     *
     * @param context The Context map to send with the invocation.
     **/
    public void unsubscribe(Ice.ObjectPrx subscriber, java.util.Map<String, String> context);

    /**
     * Unsubscribe the given <tt>subscriber</tt>.
     *
     * @param subscriber The proxy of an existing subscriber.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_unsubscribe(Ice.ObjectPrx subscriber);

    /**
     * Unsubscribe the given <tt>subscriber</tt>.
     *
     * @param subscriber The proxy of an existing subscriber.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_unsubscribe(Ice.ObjectPrx subscriber, java.util.Map<String, String> context);

    /**
     * Unsubscribe the given <tt>subscriber</tt>.
     *
     * @param subscriber The proxy of an existing subscriber.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_unsubscribe(Ice.ObjectPrx subscriber, Ice.Callback cb);

    /**
     * Unsubscribe the given <tt>subscriber</tt>.
     *
     * @param subscriber The proxy of an existing subscriber.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_unsubscribe(Ice.ObjectPrx subscriber, java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Unsubscribe the given <tt>subscriber</tt>.
     *
     * @param subscriber The proxy of an existing subscriber.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_unsubscribe(Ice.ObjectPrx subscriber, Callback_Topic_unsubscribe cb);

    /**
     * Unsubscribe the given <tt>subscriber</tt>.
     *
     * @param subscriber The proxy of an existing subscriber.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_unsubscribe(Ice.ObjectPrx subscriber, java.util.Map<String, String> context, Callback_Topic_unsubscribe cb);

    /**
     * Unsubscribe the given <tt>subscriber</tt>.
     *
     * @param subscriber The proxy of an existing subscriber.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_unsubscribe(Ice.ObjectPrx subscriber,
                                             IceInternal.Functional_VoidCallback responseCb,
                                             IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Unsubscribe the given <tt>subscriber</tt>.
     *
     * @param subscriber The proxy of an existing subscriber.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_unsubscribe(Ice.ObjectPrx subscriber,
                                             IceInternal.Functional_VoidCallback responseCb,
                                             IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                             IceInternal.Functional_BoolCallback sentCb);

    /**
     * Unsubscribe the given <tt>subscriber</tt>.
     *
     * @param subscriber The proxy of an existing subscriber.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_unsubscribe(Ice.ObjectPrx subscriber,
                                             java.util.Map<String, String> context,
                                             IceInternal.Functional_VoidCallback responseCb,
                                             IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Unsubscribe the given <tt>subscriber</tt>.
     *
     * @param subscriber The proxy of an existing subscriber.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_unsubscribe(Ice.ObjectPrx subscriber,
                                             java.util.Map<String, String> context,
                                             IceInternal.Functional_VoidCallback responseCb,
                                             IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                             IceInternal.Functional_BoolCallback sentCb);

    /**
     * Unsubscribe the given <tt>subscriber</tt>.
     *
     * @param result The asynchronous result object.
     * @see #subscribeAndGetPublisher
     *
     **/
    public void end_unsubscribe(Ice.AsyncResult result);

    /**
     * Create a link to the given topic. All events originating
     * on this topic will also be sent to <tt>linkTo</tt>.
     *
     * @param linkTo The topic to link to.
     *
     * @param cost The cost to the linked topic.
     *
     * @throws LinkExists Raised if a link to the same topic already
     * exists.
     *
     **/
    public void link(TopicPrx linkTo, int cost)
        throws LinkExists;

    /**
     * Create a link to the given topic. All events originating
     * on this topic will also be sent to <tt>linkTo</tt>.
     *
     * @param linkTo The topic to link to.
     *
     * @param cost The cost to the linked topic.
     *
     * @throws LinkExists Raised if a link to the same topic already
     * exists.
     *
     * @param context The Context map to send with the invocation.
     **/
    public void link(TopicPrx linkTo, int cost, java.util.Map<String, String> context)
        throws LinkExists;

    /**
     * Create a link to the given topic. All events originating
     * on this topic will also be sent to <tt>linkTo</tt>.
     *
     * @param linkTo The topic to link to.
     *
     * @param cost The cost to the linked topic.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_link(TopicPrx linkTo, int cost);

    /**
     * Create a link to the given topic. All events originating
     * on this topic will also be sent to <tt>linkTo</tt>.
     *
     * @param linkTo The topic to link to.
     *
     * @param cost The cost to the linked topic.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_link(TopicPrx linkTo, int cost, java.util.Map<String, String> context);

    /**
     * Create a link to the given topic. All events originating
     * on this topic will also be sent to <tt>linkTo</tt>.
     *
     * @param linkTo The topic to link to.
     *
     * @param cost The cost to the linked topic.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_link(TopicPrx linkTo, int cost, Ice.Callback cb);

    /**
     * Create a link to the given topic. All events originating
     * on this topic will also be sent to <tt>linkTo</tt>.
     *
     * @param linkTo The topic to link to.
     *
     * @param cost The cost to the linked topic.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_link(TopicPrx linkTo, int cost, java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Create a link to the given topic. All events originating
     * on this topic will also be sent to <tt>linkTo</tt>.
     *
     * @param linkTo The topic to link to.
     *
     * @param cost The cost to the linked topic.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_link(TopicPrx linkTo, int cost, Callback_Topic_link cb);

    /**
     * Create a link to the given topic. All events originating
     * on this topic will also be sent to <tt>linkTo</tt>.
     *
     * @param linkTo The topic to link to.
     *
     * @param cost The cost to the linked topic.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_link(TopicPrx linkTo, int cost, java.util.Map<String, String> context, Callback_Topic_link cb);

    /**
     * Create a link to the given topic. All events originating
     * on this topic will also be sent to <tt>linkTo</tt>.
     *
     * @param linkTo The topic to link to.
     *
     * @param cost The cost to the linked topic.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_link(TopicPrx linkTo,
                                      int cost,
                                      IceInternal.Functional_VoidCallback responseCb,
                                      IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                      IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Create a link to the given topic. All events originating
     * on this topic will also be sent to <tt>linkTo</tt>.
     *
     * @param linkTo The topic to link to.
     *
     * @param cost The cost to the linked topic.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_link(TopicPrx linkTo,
                                      int cost,
                                      IceInternal.Functional_VoidCallback responseCb,
                                      IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                      IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                      IceInternal.Functional_BoolCallback sentCb);

    /**
     * Create a link to the given topic. All events originating
     * on this topic will also be sent to <tt>linkTo</tt>.
     *
     * @param linkTo The topic to link to.
     *
     * @param cost The cost to the linked topic.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_link(TopicPrx linkTo,
                                      int cost,
                                      java.util.Map<String, String> context,
                                      IceInternal.Functional_VoidCallback responseCb,
                                      IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                      IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Create a link to the given topic. All events originating
     * on this topic will also be sent to <tt>linkTo</tt>.
     *
     * @param linkTo The topic to link to.
     *
     * @param cost The cost to the linked topic.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_link(TopicPrx linkTo,
                                      int cost,
                                      java.util.Map<String, String> context,
                                      IceInternal.Functional_VoidCallback responseCb,
                                      IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                      IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                      IceInternal.Functional_BoolCallback sentCb);

    /**
     * Create a link to the given topic. All events originating
     * on this topic will also be sent to <tt>linkTo</tt>.
     *
     * @param result The asynchronous result object.
     * @throws LinkExists Raised if a link to the same topic already
     * exists.
     *
     **/
    public void end_link(Ice.AsyncResult result)
        throws LinkExists;

    /**
     * Destroy the link from this topic to the given topic <tt>linkTo</tt>.
     *
     * @param linkTo The topic to destroy the link to.
     *
     * @throws NoSuchLink Raised if a link to the topic does not exist.
     *
     **/
    public void unlink(TopicPrx linkTo)
        throws NoSuchLink;

    /**
     * Destroy the link from this topic to the given topic <tt>linkTo</tt>.
     *
     * @param linkTo The topic to destroy the link to.
     *
     * @throws NoSuchLink Raised if a link to the topic does not exist.
     *
     * @param context The Context map to send with the invocation.
     **/
    public void unlink(TopicPrx linkTo, java.util.Map<String, String> context)
        throws NoSuchLink;

    /**
     * Destroy the link from this topic to the given topic <tt>linkTo</tt>.
     *
     * @param linkTo The topic to destroy the link to.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_unlink(TopicPrx linkTo);

    /**
     * Destroy the link from this topic to the given topic <tt>linkTo</tt>.
     *
     * @param linkTo The topic to destroy the link to.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_unlink(TopicPrx linkTo, java.util.Map<String, String> context);

    /**
     * Destroy the link from this topic to the given topic <tt>linkTo</tt>.
     *
     * @param linkTo The topic to destroy the link to.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_unlink(TopicPrx linkTo, Ice.Callback cb);

    /**
     * Destroy the link from this topic to the given topic <tt>linkTo</tt>.
     *
     * @param linkTo The topic to destroy the link to.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_unlink(TopicPrx linkTo, java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Destroy the link from this topic to the given topic <tt>linkTo</tt>.
     *
     * @param linkTo The topic to destroy the link to.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_unlink(TopicPrx linkTo, Callback_Topic_unlink cb);

    /**
     * Destroy the link from this topic to the given topic <tt>linkTo</tt>.
     *
     * @param linkTo The topic to destroy the link to.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_unlink(TopicPrx linkTo, java.util.Map<String, String> context, Callback_Topic_unlink cb);

    /**
     * Destroy the link from this topic to the given topic <tt>linkTo</tt>.
     *
     * @param linkTo The topic to destroy the link to.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_unlink(TopicPrx linkTo,
                                        IceInternal.Functional_VoidCallback responseCb,
                                        IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                        IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Destroy the link from this topic to the given topic <tt>linkTo</tt>.
     *
     * @param linkTo The topic to destroy the link to.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_unlink(TopicPrx linkTo,
                                        IceInternal.Functional_VoidCallback responseCb,
                                        IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                        IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                        IceInternal.Functional_BoolCallback sentCb);

    /**
     * Destroy the link from this topic to the given topic <tt>linkTo</tt>.
     *
     * @param linkTo The topic to destroy the link to.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_unlink(TopicPrx linkTo,
                                        java.util.Map<String, String> context,
                                        IceInternal.Functional_VoidCallback responseCb,
                                        IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                        IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Destroy the link from this topic to the given topic <tt>linkTo</tt>.
     *
     * @param linkTo The topic to destroy the link to.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_unlink(TopicPrx linkTo,
                                        java.util.Map<String, String> context,
                                        IceInternal.Functional_VoidCallback responseCb,
                                        IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                        IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                        IceInternal.Functional_BoolCallback sentCb);

    /**
     * Destroy the link from this topic to the given topic <tt>linkTo</tt>.
     *
     * @param result The asynchronous result object.
     * @throws NoSuchLink Raised if a link to the topic does not exist.
     *
     **/
    public void end_unlink(Ice.AsyncResult result)
        throws NoSuchLink;

    /**
     * Retrieve information on the current links.
     *
     * @return A sequence of LinkInfo objects.
     *
     **/
    public LinkInfo[] getLinkInfoSeq();

    /**
     * Retrieve information on the current links.
     *
     * @param context The Context map to send with the invocation.
     * @return A sequence of LinkInfo objects.
     *
     **/
    public LinkInfo[] getLinkInfoSeq(java.util.Map<String, String> context);

    /**
     * Retrieve information on the current links.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getLinkInfoSeq();

    /**
     * Retrieve information on the current links.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getLinkInfoSeq(java.util.Map<String, String> context);

    /**
     * Retrieve information on the current links.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getLinkInfoSeq(Ice.Callback cb);

    /**
     * Retrieve information on the current links.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getLinkInfoSeq(java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Retrieve information on the current links.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getLinkInfoSeq(Callback_Topic_getLinkInfoSeq cb);

    /**
     * Retrieve information on the current links.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getLinkInfoSeq(java.util.Map<String, String> context, Callback_Topic_getLinkInfoSeq cb);

    /**
     * Retrieve information on the current links.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getLinkInfoSeq(IceInternal.Functional_GenericCallback1<LinkInfo[]> responseCb,
                                                IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Retrieve information on the current links.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getLinkInfoSeq(IceInternal.Functional_GenericCallback1<LinkInfo[]> responseCb,
                                                IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                IceInternal.Functional_BoolCallback sentCb);

    /**
     * Retrieve information on the current links.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getLinkInfoSeq(java.util.Map<String, String> context,
                                                IceInternal.Functional_GenericCallback1<LinkInfo[]> responseCb,
                                                IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Retrieve information on the current links.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getLinkInfoSeq(java.util.Map<String, String> context,
                                                IceInternal.Functional_GenericCallback1<LinkInfo[]> responseCb,
                                                IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                IceInternal.Functional_BoolCallback sentCb);

    /**
     * Retrieve information on the current links.
     *
     * @param result The asynchronous result object.
     * @return A sequence of LinkInfo objects.
     *
     **/
    public LinkInfo[] end_getLinkInfoSeq(Ice.AsyncResult result);

    /**
     * Retrieve the list of subscribers for this topic.
     *
     * @return The sequence of Ice identities for the subscriber objects.
     *
     **/
    public Ice.Identity[] getSubscribers();

    /**
     * Retrieve the list of subscribers for this topic.
     *
     * @param context The Context map to send with the invocation.
     * @return The sequence of Ice identities for the subscriber objects.
     *
     **/
    public Ice.Identity[] getSubscribers(java.util.Map<String, String> context);

    /**
     * Retrieve the list of subscribers for this topic.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getSubscribers();

    /**
     * Retrieve the list of subscribers for this topic.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getSubscribers(java.util.Map<String, String> context);

    /**
     * Retrieve the list of subscribers for this topic.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getSubscribers(Ice.Callback cb);

    /**
     * Retrieve the list of subscribers for this topic.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getSubscribers(java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Retrieve the list of subscribers for this topic.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getSubscribers(Callback_Topic_getSubscribers cb);

    /**
     * Retrieve the list of subscribers for this topic.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getSubscribers(java.util.Map<String, String> context, Callback_Topic_getSubscribers cb);

    /**
     * Retrieve the list of subscribers for this topic.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getSubscribers(IceInternal.Functional_GenericCallback1<Ice.Identity[]> responseCb,
                                                IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Retrieve the list of subscribers for this topic.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getSubscribers(IceInternal.Functional_GenericCallback1<Ice.Identity[]> responseCb,
                                                IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                IceInternal.Functional_BoolCallback sentCb);

    /**
     * Retrieve the list of subscribers for this topic.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getSubscribers(java.util.Map<String, String> context,
                                                IceInternal.Functional_GenericCallback1<Ice.Identity[]> responseCb,
                                                IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Retrieve the list of subscribers for this topic.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getSubscribers(java.util.Map<String, String> context,
                                                IceInternal.Functional_GenericCallback1<Ice.Identity[]> responseCb,
                                                IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                IceInternal.Functional_BoolCallback sentCb);

    /**
     * Retrieve the list of subscribers for this topic.
     *
     * @param result The asynchronous result object.
     * @return The sequence of Ice identities for the subscriber objects.
     *
     **/
    public Ice.Identity[] end_getSubscribers(Ice.AsyncResult result);

    /**
     * Destroy the topic.
     *
     **/
    public void destroy();

    /**
     * Destroy the topic.
     *
     * @param context The Context map to send with the invocation.
     **/
    public void destroy(java.util.Map<String, String> context);

    /**
     * Destroy the topic.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_destroy();

    /**
     * Destroy the topic.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_destroy(java.util.Map<String, String> context);

    /**
     * Destroy the topic.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_destroy(Ice.Callback cb);

    /**
     * Destroy the topic.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_destroy(java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Destroy the topic.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_destroy(Callback_Topic_destroy cb);

    /**
     * Destroy the topic.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_destroy(java.util.Map<String, String> context, Callback_Topic_destroy cb);

    /**
     * Destroy the topic.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_destroy(IceInternal.Functional_VoidCallback responseCb,
                                         IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Destroy the topic.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_destroy(IceInternal.Functional_VoidCallback responseCb,
                                         IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                         IceInternal.Functional_BoolCallback sentCb);

    /**
     * Destroy the topic.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_destroy(java.util.Map<String, String> context,
                                         IceInternal.Functional_VoidCallback responseCb,
                                         IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Destroy the topic.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_destroy(java.util.Map<String, String> context,
                                         IceInternal.Functional_VoidCallback responseCb,
                                         IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                         IceInternal.Functional_BoolCallback sentCb);

    /**
     * Destroy the topic.
     *
     * @param result The asynchronous result object.
     **/
    public void end_destroy(Ice.AsyncResult result);
}
