/*
 * Decompiled with CFR 0.152.
 */
package org.jcodings.unicode;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.jcodings.ApplyAllCaseFoldFunction;
import org.jcodings.CaseFoldCodeItem;
import org.jcodings.CodeRange;
import org.jcodings.IntHolder;
import org.jcodings.MultiByteEncoding;
import org.jcodings.exception.CharacterPropertyException;
import org.jcodings.unicode.UnicodeProperties;
import org.jcodings.util.ArrayReader;
import org.jcodings.util.CaseInsensitiveBytesHash;
import org.jcodings.util.IntArrayHash;
import org.jcodings.util.IntHash;

public abstract class UnicodeEncoding
extends MultiByteEncoding {
    private static final int MAX_WORD_LENGTH = 44;
    private static final int PROPERTY_NAME_MAX_SIZE = 45;
    static final int I_WITH_DOT_ABOVE = 304;
    static final int DOTLESS_i = 305;
    static final int DOT_ABOVE = 775;
    static final int CASE_MAPPING_SLACK = 12;
    static final short[] UNICODE_ISO_8859_1_CTypeTable = new short[]{16392, 16392, 16392, 16392, 16392, 16392, 16392, 16392, 16392, 16908, 16905, 16904, 16904, 16904, 16392, 16392, 16392, 16392, 16392, 16392, 16392, 16392, 16392, 16392, 16392, 16392, 16392, 16392, 16392, 16392, 16392, 16392, 17028, 16800, 16800, 16800, 16800, 16800, 16800, 16800, 16800, 16800, 16800, 16800, 16800, 16800, 16800, 16800, 30896, 30896, 30896, 30896, 30896, 30896, 30896, 30896, 30896, 30896, 16800, 16800, 16800, 16800, 16800, 16800, 16800, 31906, 31906, 31906, 31906, 31906, 31906, 29858, 29858, 29858, 29858, 29858, 29858, 29858, 29858, 29858, 29858, 29858, 29858, 29858, 29858, 29858, 29858, 29858, 29858, 29858, 29858, 16800, 16800, 16800, 16800, 20896, 16800, 30946, 30946, 30946, 30946, 30946, 30946, 28898, 28898, 28898, 28898, 28898, 28898, 28898, 28898, 28898, 28898, 28898, 28898, 28898, 28898, 28898, 28898, 28898, 28898, 28898, 28898, 16800, 16800, 16800, 16800, 16392, 8, 8, 8, 8, 8, 648, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 644, 416, 160, 160, 160, 160, 160, 160, 160, 160, 12514, 416, 160, 168, 160, 160, 160, 160, 4256, 4256, 160, 12514, 160, 416, 160, 4256, 12514, 416, 4256, 4256, 4256, 416, 13474, 13474, 13474, 13474, 13474, 13474, 13474, 13474, 13474, 13474, 13474, 13474, 13474, 13474, 13474, 13474, 13474, 13474, 13474, 13474, 13474, 13474, 13474, 160, 13474, 13474, 13474, 13474, 13474, 13474, 13474, 12514, 12514, 12514, 12514, 12514, 12514, 12514, 12514, 12514, 12514, 12514, 12514, 12514, 12514, 12514, 12514, 12514, 12514, 12514, 12514, 12514, 12514, 12514, 12514, 160, 12514, 12514, 12514, 12514, 12514, 12514, 12514, 12514};

    protected UnicodeEncoding(String name2, int minLength, int maxLength, int[] EncLen, int[][] Trans) {
        super(name2, minLength, maxLength, EncLen, Trans, UNICODE_ISO_8859_1_CTypeTable);
        this.isUnicode = true;
    }

    protected UnicodeEncoding(String name2, int minLength, int maxLength, int[] EncLen) {
        this(name2, minLength, maxLength, EncLen, null);
    }

    public String getCharsetName() {
        return new String(this.getName());
    }

    public boolean isCodeCType(int code, int ctype) {
        if (ctype <= 14 && code < 256) {
            return this.isCodeCTypeInternal(code, ctype);
        }
        if (ctype > UnicodeProperties.CodeRangeTable.length) {
            throw new InternalError("undefined type (bug)");
        }
        return CodeRange.isInCodeRange(UnicodeProperties.CodeRangeTable[ctype].getRange(), code);
    }

    protected final int[] ctypeCodeRange(int ctype) {
        if (ctype >= UnicodeProperties.CodeRangeTable.length) {
            throw new InternalError("undefined type (bug)");
        }
        return UnicodeProperties.CodeRangeTable[ctype].getRange();
    }

    public int propertyNameToCType(byte[] name2, int p2, int end2) {
        byte[] buf = new byte[45];
        int len = 0;
        for (int p_ = p2; p_ < end2; p_ += this.length(name2, p_, end2)) {
            int code = this.mbcToCode(name2, p_, end2);
            if (code == 32 || code == 45 || code == 95) continue;
            if (code >= 128) {
                throw new CharacterPropertyException("invalid character property name <%n>");
            }
            buf[len++] = (byte)code;
            if (len < 45) continue;
            throw new CharacterPropertyException("invalid character property name <%n>", name2, p2, end2);
        }
        Integer ctype = (Integer)CTypeName.CTypeNameHash.get(buf, 0, len);
        if (ctype == null) {
            throw new CharacterPropertyException("invalid character property name <%n>", name2, p2, end2);
        }
        return ctype;
    }

    public int mbcCaseFold(int flag, byte[] bytes2, IntHolder pp, int end2, byte[] fold) {
        int p2 = pp.value;
        int foldP = 0;
        int code = this.mbcToCode(bytes2, p2, end2);
        int len = this.length(bytes2, p2, end2);
        pp.value += len;
        CodeList to = CaseFold.Hash.get(code);
        if (to != null) {
            if (to.codes.length == 1) {
                return this.codeToMbc(to.codes[0], fold, foldP);
            }
            int rlen = 0;
            for (int i2 = 0; i2 < to.codes.length; ++i2) {
                len = this.codeToMbc(to.codes[i2], fold, foldP);
                foldP += len;
                rlen += len;
            }
            return rlen;
        }
        for (int i3 = 0; i3 < len; ++i3) {
            fold[foldP++] = bytes2[p2++];
        }
        return len;
    }

    public void applyAllCaseFold(int flag, ApplyAllCaseFoldFunction fun, Object arg2) {
        int k;
        int j;
        CodeList to;
        int from;
        int i2;
        int[] code = new int[]{0};
        for (i2 = 0; i2 < CaseUnfold11.From.length; ++i2) {
            from = CaseUnfold11.From[i2];
            to = CaseUnfold11.To[i2];
            for (j = 0; j < to.codes.length; ++j) {
                code[0] = from;
                fun.apply(to.codes[j], code, 1, arg2);
                code[0] = to.codes[j];
                fun.apply(from, code, 1, arg2);
                for (k = 0; k < j; ++k) {
                    code[0] = to.codes[k];
                    fun.apply(to.codes[j], code, 1, arg2);
                    code[0] = to.codes[j];
                    fun.apply(to.codes[k], code, 1, arg2);
                }
            }
        }
        for (i2 = 0; i2 < CaseUnfold11.Locale_From.length; ++i2) {
            from = CaseUnfold11.Locale_From[i2];
            to = CaseUnfold11.Locale_To[i2];
            for (j = 0; j < to.codes.length; ++j) {
                code[0] = from;
                fun.apply(to.codes[j], code, 1, arg2);
                code[0] = to.codes[j];
                fun.apply(from, code, 1, arg2);
                for (k = 0; k < j; ++k) {
                    code[0] = to.codes[k];
                    fun.apply(to.codes[j], code, 1, arg2);
                    code[0] = to.codes[j];
                    fun.apply(to.codes[k], code, 1, arg2);
                }
            }
        }
        if ((flag & 0x40000000) != 0) {
            for (i2 = 0; i2 < CaseUnfold12.From.length; ++i2) {
                int[] from2 = CaseUnfold12.From[i2];
                to = CaseUnfold12.To[i2];
                for (j = 0; j < to.codes.length; ++j) {
                    fun.apply(to.codes[j], from2, 2, arg2);
                    for (k = 0; k < to.codes.length; ++k) {
                        if (k == j) continue;
                        code[0] = to.codes[k];
                        fun.apply(to.codes[j], code, 1, arg2);
                    }
                }
            }
            for (i2 = 0; i2 < CaseUnfold12.Locale_From.length; ++i2) {
                int[] from3 = CaseUnfold12.Locale_From[i2];
                to = CaseUnfold12.Locale_To[i2];
                for (j = 0; j < to.codes.length; ++j) {
                    fun.apply(to.codes[j], from3, 2, arg2);
                    for (k = 0; k < to.codes.length; ++k) {
                        if (k == j) continue;
                        code[0] = to.codes[k];
                        fun.apply(to.codes[j], code, 1, arg2);
                    }
                }
            }
            for (i2 = 0; i2 < CaseUnfold13.From.length; ++i2) {
                int[] from4 = CaseUnfold13.From[i2];
                to = CaseUnfold13.To[i2];
                for (j = 0; j < to.codes.length; ++j) {
                    fun.apply(to.codes[j], from4, 3, arg2);
                    for (k = 0; k < to.codes.length; ++k) {
                        if (k == j) continue;
                        code[0] = to.codes[k];
                        fun.apply(to.codes[j], code, 1, arg2);
                    }
                }
            }
        }
    }

    public CaseFoldCodeItem[] caseFoldCodesByString(int flag, byte[] bytes2, int p2, int end2) {
        int code = this.mbcToCode(bytes2, p2, end2);
        int len = this.length(bytes2, p2, end2);
        int n = 0;
        int fn = 0;
        CodeList to = CaseFold.Hash.get(code);
        CaseFoldCodeItem[] items = null;
        if (to != null) {
            items = new CaseFoldCodeItem[13];
            if (to.codes.length == 1) {
                int origCode = code;
                items[0] = CaseFoldCodeItem.create(len, to.codes[0]);
                ++n;
                code = to.codes[0];
                to = CaseUnfold11.Hash.get(code);
                if (to != null) {
                    for (int i2 = 0; i2 < to.codes.length; ++i2) {
                        if (to.codes[i2] == origCode) continue;
                        items[n] = CaseFoldCodeItem.create(len, to.codes[i2]);
                        ++n;
                    }
                }
            } else if ((flag & 0x40000000) != 0) {
                CodeList z2;
                int j;
                int i3;
                int[][] cs = new int[3][4];
                int[] ncs = new int[3];
                for (fn = 0; fn < to.codes.length; ++fn) {
                    cs[fn][0] = to.codes[fn];
                    CodeList z3 = CaseUnfold11.Hash.get(cs[fn][0]);
                    if (z3 != null) {
                        for (i3 = 0; i3 < z3.codes.length; ++i3) {
                            cs[fn][i3 + 1] = z3.codes[i3];
                        }
                        ncs[fn] = z3.codes.length + 1;
                        continue;
                    }
                    ncs[fn] = 1;
                }
                if (fn == 2) {
                    for (int i4 = 0; i4 < ncs[0]; ++i4) {
                        for (j = 0; j < ncs[1]; ++j) {
                            items[n] = CaseFoldCodeItem.create(len, cs[0][i4], cs[1][j]);
                            ++n;
                        }
                    }
                    z2 = CaseUnfold12.Hash.get(to.codes);
                    if (z2 != null) {
                        for (i3 = 0; i3 < z2.codes.length; ++i3) {
                            if (z2.codes[i3] == code) continue;
                            items[n] = CaseFoldCodeItem.create(len, z2.codes[i3]);
                            ++n;
                        }
                    }
                } else {
                    for (int i5 = 0; i5 < ncs[0]; ++i5) {
                        for (j = 0; j < ncs[1]; ++j) {
                            for (int k = 0; k < ncs[2]; ++k) {
                                items[n] = CaseFoldCodeItem.create(len, cs[0][i5], cs[1][j], cs[2][k]);
                                ++n;
                            }
                        }
                    }
                    z2 = CaseUnfold13.Hash.get(to.codes);
                    if (z2 != null) {
                        for (i3 = 0; i3 < z2.codes.length; ++i3) {
                            if (z2.codes[i3] == code) continue;
                            items[n] = CaseFoldCodeItem.create(len, z2.codes[i3]);
                            ++n;
                        }
                    }
                }
                flag = 0;
            }
        } else {
            to = CaseUnfold11.Hash.get(code);
            if (to != null) {
                items = new CaseFoldCodeItem[13];
                for (int i6 = 0; i6 < to.codes.length; ++i6) {
                    items[n] = CaseFoldCodeItem.create(len, to.codes[i6]);
                    ++n;
                }
            }
        }
        if ((flag & 0x40000000) != 0) {
            if (items == null) {
                items = new CaseFoldCodeItem[13];
            }
            if ((p2 += len) < end2) {
                int codes0 = code;
                code = this.mbcToCode(bytes2, p2, end2);
                to = CaseFold.Hash.get(code);
                int codes1 = to != null && to.codes.length == 1 ? to.codes[0] : code;
                int clen = this.length(bytes2, p2, end2);
                len += clen;
                CodeList z2 = CaseUnfold12.Hash.get(codes0, codes1);
                if (z2 != null) {
                    for (int i7 = 0; i7 < z2.codes.length; ++i7) {
                        items[n] = CaseFoldCodeItem.create(len, z2.codes[i7]);
                        ++n;
                    }
                }
                if ((p2 += clen) < end2) {
                    code = this.mbcToCode(bytes2, p2, end2);
                    to = CaseFold.Hash.get(code);
                    int codes2 = to != null && to.codes.length == 1 ? to.codes[0] : code;
                    clen = this.length(bytes2, p2, end2);
                    len += clen;
                    z2 = CaseUnfold13.Hash.get(codes0, codes1, codes2);
                    if (z2 != null) {
                        for (int i8 = 0; i8 < z2.codes.length; ++i8) {
                            items[n] = CaseFoldCodeItem.create(len, z2.codes[i8]);
                            ++n;
                        }
                    }
                }
            }
        }
        if (items == null || n == 0) {
            return EMPTY_FOLD_CODES;
        }
        if (n < items.length) {
            CaseFoldCodeItem[] tmp = new CaseFoldCodeItem[n];
            System.arraycopy(items, 0, tmp, 0, n);
            return tmp;
        }
        return items;
    }

    public final int caseMap(IntHolder flagP, byte[] bytes2, IntHolder pp, int end2, byte[] to, int toP, int toEnd) {
        int flags2 = flagP.value;
        int toStart = toP;
        toEnd -= 12;
        flags2 |= (flags2 & 0x6000) << 3;
        while (pp.value < end2 && toP <= toEnd) {
            int length2 = this.length(bytes2, pp.value, end2);
            if (length2 < 0) {
                return length2;
            }
            int code = this.mbcToCode(bytes2, pp.value, end2);
            pp.value += length2;
            if (code <= 122) {
                if (code >= 97 && code <= 122) {
                    if ((flags2 & 0x2000) != 0) {
                        code = ((flags2 |= 0x40000) & 0x100000) != 0 && code == 105 ? 304 : (code -= 32);
                    }
                } else if (code >= 65 && code <= 90 && (flags2 & 0x84000) != 0) {
                    code = ((flags2 |= 0x40000) & 0x100000) != 0 && code == 73 ? 305 : (code += 32);
                }
            } else if ((flags2 & 0x400000) == 0 && code >= 181) {
                if (code == 304) {
                    if ((flags2 & 0x84000) != 0) {
                        code = 105;
                        if (((flags2 |= 0x40000) & 0x100000) == 0) {
                            toP += this.codeToMbc(code, to, toP);
                            code = 775;
                        }
                    }
                } else if (code == 305) {
                    if ((flags2 & 0x2000) != 0) {
                        flags2 |= 0x40000;
                        code = 73;
                    }
                } else {
                    CodeList folded = CaseFold.Hash.get(code);
                    if (folded != null) {
                        if (((flags2 & 0x8000) == 0 || (folded.flags & 0x800000) == 0) && (flags2 & folded.flags) != 0) {
                            int[] codes;
                            boolean specialCopy = false;
                            if (((flags2 |= 0x40000) & folded.flags & 0x838000) != 0) {
                                int specialStart = (folded.flags & 0x1FF8) >>> 3;
                                if ((folded.flags & 0x800000) != 0) {
                                    if ((flags2 & 0x6000) == 24576) {
                                        specialCopy = true;
                                    } else {
                                        ++specialStart;
                                    }
                                }
                                if (!specialCopy && (folded.flags & 0x8000) != 0) {
                                    if ((flags2 & 0x8000) != 0) {
                                        specialCopy = true;
                                    } else {
                                        ++specialStart;
                                    }
                                }
                                if (!specialCopy && (folded.flags & 0x20000) != 0 && (flags2 & 0x20000) == 0) {
                                    ++specialStart;
                                }
                                codes = CaseMappingSpecials.Values.get(specialStart);
                            } else {
                                codes = folded.codes;
                            }
                            code = codes[0];
                            for (int i2 = 1; i2 < codes.length; ++i2) {
                                toP += this.codeToMbc(code, to, toP);
                                code = codes[i2];
                            }
                        }
                    } else {
                        folded = CaseUnfold11.Hash.get(code);
                        if (folded != null && (flags2 & folded.flags) != 0) {
                            code = folded.codes[((flags2 |= 0x40000) & folded.flags & 0x8000) != 0 ? 1 : 0];
                        }
                    }
                }
            }
            toP += this.codeToMbc(code, to, toP);
            if ((flags2 & 0x8000) == 0) continue;
            flags2 ^= 0x3E000;
        }
        flagP.value = flags2;
        return toP - toStart;
    }

    private static Object[] readFoldN(int fromSize, String table) {
        try {
            DataInputStream dis = ArrayReader.openStream(table);
            int size2 = dis.readInt();
            int[][] from = new int[size2][];
            CodeList[] to = new CodeList[size2];
            for (int i2 = 0; i2 < size2; ++i2) {
                from[i2] = new int[fromSize];
                for (int j = 0; j < fromSize; ++j) {
                    from[i2][j] = dis.readInt();
                }
                to[i2] = new CodeList(dis);
            }
            dis.close();
            return new Object[]{from, to};
        }
        catch (IOException iot) {
            throw new RuntimeException(iot);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CaseMappingSpecials {
        static final ArrayList<int[]> Values = CaseMappingSpecials.read();

        private CaseMappingSpecials() {
        }

        static ArrayList<int[]> read() {
            try {
                DataInputStream dis = ArrayReader.openStream("CaseMappingSpecials");
                int size2 = dis.readInt();
                ArrayList<int[]> values2 = new ArrayList<int[]>(size2);
                for (int i2 = 0; i2 < size2; ++i2) {
                    int packed = dis.readInt();
                    int length2 = packed >>> 25;
                    int[] codes = new int[length2];
                    codes[0] = packed & 0x1FFFFFF;
                    for (int j = 1; j < length2; ++j) {
                        ++i2;
                        codes[j] = dis.readInt();
                    }
                    values2.add(codes);
                }
                dis.close();
                return values2;
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CaseUnfold13 {
        private static final int[][] From;
        private static final CodeList[] To;
        static final IntArrayHash<CodeList> Hash;

        private CaseUnfold13() {
        }

        private static IntArrayHash<CodeList> initializeUnfold3Hash() {
            IntArrayHash<CodeList> unfold3 = new IntArrayHash<CodeList>(From.length);
            for (int i2 = 0; i2 < From.length; ++i2) {
                unfold3.putDirect(From[i2], To[i2]);
            }
            return unfold3;
        }

        static {
            Object[] unfold = UnicodeEncoding.readFoldN(3, "CaseUnfold_13");
            From = (int[][])unfold[0];
            To = (CodeList[])unfold[1];
            Hash = CaseUnfold13.initializeUnfold3Hash();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CaseUnfold12 {
        private static final int[][] From;
        private static final CodeList[] To;
        private static final int[][] Locale_From;
        private static final CodeList[] Locale_To;
        static final IntArrayHash<CodeList> Hash;

        private CaseUnfold12() {
        }

        private static IntArrayHash<CodeList> initializeUnfold2Hash() {
            int i2;
            IntArrayHash<CodeList> unfold2 = new IntArrayHash<CodeList>(From.length + Locale_From.length);
            for (i2 = 0; i2 < From.length; ++i2) {
                unfold2.putDirect(From[i2], To[i2]);
            }
            for (i2 = 0; i2 < Locale_From.length; ++i2) {
                unfold2.putDirect(Locale_From[i2], Locale_To[i2]);
            }
            return unfold2;
        }

        static {
            Object[] unfold = UnicodeEncoding.readFoldN(2, "CaseUnfold_12");
            From = (int[][])unfold[0];
            To = (CodeList[])unfold[1];
            unfold = UnicodeEncoding.readFoldN(2, "CaseUnfold_12_Locale");
            Locale_From = (int[][])unfold[0];
            Locale_To = (CodeList[])unfold[1];
            Hash = CaseUnfold12.initializeUnfold2Hash();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CaseUnfold11 {
        private static final int[] From;
        private static final CodeList[] To;
        private static final int[] Locale_From;
        private static final CodeList[] Locale_To;
        static final IntHash<CodeList> Hash;

        private CaseUnfold11() {
        }

        static Object[] read(String table) {
            try {
                DataInputStream dis = ArrayReader.openStream(table);
                int size2 = dis.readInt();
                int[] from = new int[size2];
                CodeList[] to = new CodeList[size2];
                for (int i2 = 0; i2 < size2; ++i2) {
                    from[i2] = dis.readInt();
                    to[i2] = new CodeList(dis);
                }
                dis.close();
                return new Object[]{from, to};
            }
            catch (IOException iot) {
                throw new RuntimeException(iot);
            }
        }

        static IntHash<CodeList> initializeUnfold1Hash() {
            int i2;
            IntHash<CodeList> hash2 = new IntHash<CodeList>(From.length + Locale_From.length);
            for (i2 = 0; i2 < From.length; ++i2) {
                hash2.putDirect(From[i2], To[i2]);
            }
            for (i2 = 0; i2 < Locale_From.length; ++i2) {
                hash2.putDirect(Locale_From[i2], Locale_To[i2]);
            }
            return hash2;
        }

        static {
            Object[] unfold = CaseUnfold11.read("CaseUnfold_11");
            From = (int[])unfold[0];
            To = (CodeList[])unfold[1];
            unfold = CaseUnfold11.read("CaseUnfold_11_Locale");
            Locale_From = (int[])unfold[0];
            Locale_To = (CodeList[])unfold[1];
            Hash = CaseUnfold11.initializeUnfold1Hash();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CaseFold {
        static final IntHash<CodeList> Hash = CaseFold.read("CaseFold");

        private CaseFold() {
        }

        static IntHash<CodeList> read(String table) {
            try {
                DataInputStream dis = ArrayReader.openStream(table);
                int size2 = dis.readInt();
                IntHash<CodeList> hash2 = new IntHash<CodeList>(size2);
                for (int i2 = 0; i2 < size2; ++i2) {
                    hash2.putDirect(dis.readInt(), new CodeList(dis));
                }
                dis.close();
                return hash2;
            }
            catch (IOException iot) {
                throw new RuntimeException(iot);
            }
        }
    }

    private static class CodeList {
        final int[] codes;
        final int flags;

        CodeList(DataInputStream dis) throws IOException {
            int packed = dis.readInt();
            this.flags = packed & 0xFFFFFFF8;
            int length2 = packed & 7;
            this.codes = new int[length2];
            for (int j = 0; j < length2; ++j) {
                this.codes[j] = dis.readInt();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CTypeName {
        private static final CaseInsensitiveBytesHash<Integer> CTypeNameHash = CTypeName.initializeCTypeNameTable();

        CTypeName() {
        }

        private static CaseInsensitiveBytesHash<Integer> initializeCTypeNameTable() {
            CaseInsensitiveBytesHash<Integer> table = new CaseInsensitiveBytesHash<Integer>();
            for (int i2 = 0; i2 < UnicodeProperties.CodeRangeTable.length; ++i2) {
                table.putDirect(UnicodeProperties.CodeRangeTable[i2].name, i2);
            }
            return table;
        }
    }

    static final class CodeRangeEntry {
        final String table;
        final byte[] name;
        int[] range;

        CodeRangeEntry(String name2, String table) {
            this.table = table;
            this.name = name2.getBytes();
        }

        public int[] getRange() {
            if (this.range == null) {
                this.range = ArrayReader.readIntArray(this.table);
            }
            return this.range;
        }
    }
}

