/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.opti;

import java.util.ArrayList;
import org.apache.xerces.impl.xs.opti.AttrImpl;
import org.apache.xerces.impl.xs.opti.DefaultDocument;
import org.apache.xerces.impl.xs.opti.ElementImpl;
import org.apache.xerces.impl.xs.opti.NodeImpl;
import org.apache.xerces.impl.xs.opti.SchemaDOMImplementation;
import org.apache.xerces.util.XMLSymbols;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLString;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SchemaDOM
extends DefaultDocument {
    static final int relationsRowResizeFactor = 15;
    static final int relationsColResizeFactor = 10;
    NodeImpl[][] relations;
    ElementImpl parent;
    int currLoc;
    int nextFreeLoc;
    boolean hidden;
    boolean inCDATA;
    private StringBuffer fAnnotationBuffer = null;

    public SchemaDOM() {
        this.reset();
    }

    public ElementImpl startElement(QName qName, XMLAttributes xMLAttributes, int n, int n2, int n3) {
        ElementImpl elementImpl = new ElementImpl(n, n2, n3);
        this.processElement(qName, xMLAttributes, elementImpl);
        this.parent = elementImpl;
        return elementImpl;
    }

    public ElementImpl emptyElement(QName qName, XMLAttributes xMLAttributes, int n, int n2, int n3) {
        ElementImpl elementImpl = new ElementImpl(n, n2, n3);
        this.processElement(qName, xMLAttributes, elementImpl);
        return elementImpl;
    }

    public ElementImpl startElement(QName qName, XMLAttributes xMLAttributes, int n, int n2) {
        return this.startElement(qName, xMLAttributes, n, n2, -1);
    }

    public ElementImpl emptyElement(QName qName, XMLAttributes xMLAttributes, int n, int n2) {
        return this.emptyElement(qName, xMLAttributes, n, n2, -1);
    }

    private void processElement(QName qName, XMLAttributes xMLAttributes, ElementImpl elementImpl) {
        elementImpl.prefix = qName.prefix;
        elementImpl.localpart = qName.localpart;
        elementImpl.rawname = qName.rawname;
        elementImpl.uri = qName.uri;
        elementImpl.schemaDOM = this;
        Attr[] attrArray = new Attr[xMLAttributes.getLength()];
        int n = 0;
        while (n < xMLAttributes.getLength()) {
            attrArray[n] = new AttrImpl(elementImpl, xMLAttributes.getPrefix(n), xMLAttributes.getLocalName(n), xMLAttributes.getQName(n), xMLAttributes.getURI(n), xMLAttributes.getValue(n));
            ++n;
        }
        elementImpl.attrs = attrArray;
        if (this.nextFreeLoc == this.relations.length) {
            this.resizeRelations();
        }
        if (this.relations[this.currLoc][0] != this.parent) {
            this.relations[this.nextFreeLoc][0] = this.parent;
            this.currLoc = this.nextFreeLoc++;
        }
        boolean bl = false;
        int n2 = 1;
        n2 = 1;
        while (n2 < this.relations[this.currLoc].length) {
            if (this.relations[this.currLoc][n2] == null) {
                bl = true;
                break;
            }
            ++n2;
        }
        if (!bl) {
            this.resizeRelations(this.currLoc);
        }
        this.relations[this.currLoc][n2] = elementImpl;
        this.parent.parentRow = this.currLoc;
        elementImpl.row = this.currLoc;
        elementImpl.col = n2;
    }

    public void endElement() {
        this.currLoc = this.parent.row;
        this.parent = (ElementImpl)this.relations[this.currLoc][0];
    }

    void comment(XMLString xMLString) {
        this.fAnnotationBuffer.append("<!--");
        if (xMLString.length > 0) {
            this.fAnnotationBuffer.append(xMLString.ch, xMLString.offset, xMLString.length);
        }
        this.fAnnotationBuffer.append("-->");
    }

    void processingInstruction(String string, XMLString xMLString) {
        this.fAnnotationBuffer.append("<?").append(string);
        if (xMLString.length > 0) {
            this.fAnnotationBuffer.append(' ').append(xMLString.ch, xMLString.offset, xMLString.length);
        }
        this.fAnnotationBuffer.append("?>");
    }

    void characters(XMLString xMLString) {
        if (!this.inCDATA) {
            StringBuffer stringBuffer = this.fAnnotationBuffer;
            int n = xMLString.offset;
            while (n < xMLString.offset + xMLString.length) {
                char c = xMLString.ch[n];
                if (c == '&') {
                    stringBuffer.append("&amp;");
                } else if (c == '<') {
                    stringBuffer.append("&lt;");
                } else if (c == '>') {
                    stringBuffer.append("&gt;");
                } else if (c == '\r') {
                    stringBuffer.append("&#xD;");
                } else {
                    stringBuffer.append(c);
                }
                ++n;
            }
        } else {
            this.fAnnotationBuffer.append(xMLString.ch, xMLString.offset, xMLString.length);
        }
    }

    void charactersRaw(String string) {
        this.fAnnotationBuffer.append(string);
    }

    void endAnnotation(QName qName, ElementImpl elementImpl) {
        this.fAnnotationBuffer.append("\n</").append(qName.rawname).append(">");
        elementImpl.fAnnotation = this.fAnnotationBuffer.toString();
        this.fAnnotationBuffer = null;
    }

    void endAnnotationElement(QName qName) {
        this.endAnnotationElement(qName.rawname);
    }

    void endAnnotationElement(String string) {
        this.fAnnotationBuffer.append("</").append(string).append(">");
    }

    void endSyntheticAnnotationElement(QName qName, boolean bl) {
        this.endSyntheticAnnotationElement(qName.rawname, bl);
    }

    void endSyntheticAnnotationElement(String string, boolean bl) {
        if (bl) {
            this.fAnnotationBuffer.append("\n</").append(string).append(">");
            this.parent.fSyntheticAnnotation = this.fAnnotationBuffer.toString();
            this.fAnnotationBuffer = null;
        } else {
            this.fAnnotationBuffer.append("</").append(string).append(">");
        }
    }

    void startAnnotationCDATA() {
        this.inCDATA = true;
        this.fAnnotationBuffer.append("<![CDATA[");
    }

    void endAnnotationCDATA() {
        this.fAnnotationBuffer.append("]]>");
        this.inCDATA = false;
    }

    private void resizeRelations() {
        NodeImpl[][] nodeImplArrayArray = new NodeImpl[this.relations.length + 15][];
        System.arraycopy(this.relations, 0, nodeImplArrayArray, 0, this.relations.length);
        int n = this.relations.length;
        while (n < nodeImplArrayArray.length) {
            nodeImplArrayArray[n] = new NodeImpl[10];
            ++n;
        }
        this.relations = nodeImplArrayArray;
    }

    private void resizeRelations(int n) {
        NodeImpl[] nodeImplArray = new NodeImpl[this.relations[n].length + 10];
        System.arraycopy(this.relations[n], 0, nodeImplArray, 0, this.relations[n].length);
        this.relations[n] = nodeImplArray;
    }

    public void reset() {
        if (this.relations != null) {
            int n = 0;
            while (n < this.relations.length) {
                int n2 = 0;
                while (n2 < this.relations[n].length) {
                    this.relations[n][n2] = null;
                    ++n2;
                }
                ++n;
            }
        }
        this.relations = new NodeImpl[15][];
        this.parent = new ElementImpl(0, 0, 0);
        this.parent.rawname = "DOCUMENT_NODE";
        this.currLoc = 0;
        this.nextFreeLoc = 1;
        this.inCDATA = false;
        int n = 0;
        while (n < 15) {
            this.relations[n] = new NodeImpl[10];
            ++n;
        }
        this.relations[this.currLoc][0] = this.parent;
    }

    public void printDOM() {
    }

    public static void traverse(Node node, int n) {
        Object object;
        SchemaDOM.indent(n);
        System.out.print("<" + node.getNodeName());
        if (node.hasAttributes()) {
            object = node.getAttributes();
            int n2 = 0;
            while (n2 < object.getLength()) {
                System.out.print("  " + ((Attr)object.item(n2)).getName() + "=\"" + ((Attr)object.item(n2)).getValue() + "\"");
                ++n2;
            }
        }
        if (node.hasChildNodes()) {
            System.out.println(">");
            n += 4;
            object = node.getFirstChild();
            while (object != null) {
                SchemaDOM.traverse((Node)object, n);
                object = object.getNextSibling();
            }
            SchemaDOM.indent(n -= 4);
            System.out.println("</" + node.getNodeName() + ">");
        } else {
            System.out.println("/>");
        }
    }

    public static void indent(int n) {
        int n2 = 0;
        while (n2 < n) {
            System.out.print(' ');
            ++n2;
        }
    }

    public Element getDocumentElement() {
        return (ElementImpl)this.relations[0][1];
    }

    public DOMImplementation getImplementation() {
        return SchemaDOMImplementation.getDOMImplementation();
    }

    void startAnnotation(QName qName, XMLAttributes xMLAttributes, NamespaceContext namespaceContext) {
        this.startAnnotation(qName.rawname, xMLAttributes, namespaceContext);
    }

    void startAnnotation(String string, XMLAttributes xMLAttributes, NamespaceContext namespaceContext) {
        String string2;
        String string3;
        Object object;
        if (this.fAnnotationBuffer == null) {
            this.fAnnotationBuffer = new StringBuffer(256);
        }
        this.fAnnotationBuffer.append("<").append(string).append(" ");
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < xMLAttributes.getLength()) {
            object = xMLAttributes.getValue(n);
            string3 = xMLAttributes.getPrefix(n);
            string2 = xMLAttributes.getQName(n);
            if (string3 == XMLSymbols.PREFIX_XMLNS || string2 == XMLSymbols.PREFIX_XMLNS) {
                arrayList.add(string3 == XMLSymbols.PREFIX_XMLNS ? xMLAttributes.getLocalName(n) : XMLSymbols.EMPTY_STRING);
            }
            this.fAnnotationBuffer.append(string2).append("=\"").append(SchemaDOM.processAttValue((String)object)).append("\" ");
            ++n;
        }
        object = namespaceContext.getAllPrefixes();
        while (object.hasMoreElements()) {
            string3 = (String)object.nextElement();
            string2 = namespaceContext.getURI(string3);
            if (string2 == null) {
                string2 = XMLSymbols.EMPTY_STRING;
            }
            if (arrayList.contains(string3)) continue;
            if (string3 == XMLSymbols.EMPTY_STRING) {
                this.fAnnotationBuffer.append("xmlns").append("=\"").append(SchemaDOM.processAttValue(string2)).append("\" ");
                continue;
            }
            this.fAnnotationBuffer.append("xmlns:").append(string3).append("=\"").append(SchemaDOM.processAttValue(string2)).append("\" ");
        }
        this.fAnnotationBuffer.append(">\n");
    }

    void startAnnotationElement(QName qName, XMLAttributes xMLAttributes) {
        this.startAnnotationElement(qName.rawname, xMLAttributes);
    }

    void startAnnotationElement(String string, XMLAttributes xMLAttributes) {
        this.fAnnotationBuffer.append("<").append(string);
        int n = 0;
        while (n < xMLAttributes.getLength()) {
            String string2 = xMLAttributes.getValue(n);
            this.fAnnotationBuffer.append(" ").append(xMLAttributes.getQName(n)).append("=\"").append(SchemaDOM.processAttValue(string2)).append("\"");
            ++n;
        }
        this.fAnnotationBuffer.append(">");
    }

    private static String processAttValue(String string) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == '\"' || c == '<' || c == '&' || c == '\t' || c == '\n' || c == '\r') {
                return SchemaDOM.escapeAttValue(string, n2);
            }
            ++n2;
        }
        return string;
    }

    private static String escapeAttValue(String string, int n) {
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer(n2);
        stringBuffer.append(string.substring(0, n));
        int n3 = n;
        while (n3 < n2) {
            char c = string.charAt(n3);
            if (c == '\"') {
                stringBuffer.append("&quot;");
            } else if (c == '<') {
                stringBuffer.append("&lt;");
            } else if (c == '&') {
                stringBuffer.append("&amp;");
            } else if (c == '\t') {
                stringBuffer.append("&#x9;");
            } else if (c == '\n') {
                stringBuffer.append("&#xA;");
            } else if (c == '\r') {
                stringBuffer.append("&#xD;");
            } else {
                stringBuffer.append(c);
            }
            ++n3;
        }
        return stringBuffer.toString();
    }
}

