/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.AbstractRubyMethod;
import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyProc;
import org.jruby.RubyString;
import org.jruby.RubyUnboundMethod;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.internal.runtime.methods.AliasMethod;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.IRMethodArgs;
import org.jruby.internal.runtime.methods.ProcMethod;
import org.jruby.runtime.ArgumentDescriptor;
import org.jruby.runtime.Block;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.MethodBlockBody;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.PositionAware;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"Method"})
public class RubyMethod
extends AbstractRubyMethod {
    protected IRubyObject receiver;

    protected RubyMethod(Ruby runtime, RubyClass rubyClass) {
        super(runtime, rubyClass);
    }

    public static RubyClass createMethodClass(Ruby runtime) {
        RubyClass methodClass = runtime.defineClass("Method", runtime.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        runtime.setMethod(methodClass);
        methodClass.setClassIndex(ClassIndex.METHOD);
        methodClass.setReifiedClass(RubyMethod.class);
        methodClass.defineAnnotatedMethods(AbstractRubyMethod.class);
        methodClass.defineAnnotatedMethods(RubyMethod.class);
        return methodClass;
    }

    public static RubyMethod newMethod(RubyModule implementationModule, String methodName, RubyModule originModule, String originName, DynamicMethod method, IRubyObject receiver2) {
        Ruby runtime = implementationModule.getRuntime();
        RubyMethod newMethod = new RubyMethod(runtime, runtime.getMethod());
        newMethod.implementationModule = implementationModule;
        newMethod.methodName = methodName;
        newMethod.originModule = originModule;
        newMethod.originName = originName;
        newMethod.method = method;
        newMethod.receiver = receiver2;
        return newMethod;
    }

    @JRubyMethod(name={"call", "[]"})
    public IRubyObject call(ThreadContext context, Block block) {
        return this.method.call(context, this.receiver, this.implementationModule, this.methodName, block);
    }

    @JRubyMethod(name={"call", "[]"})
    public IRubyObject call(ThreadContext context, IRubyObject arg2, Block block) {
        return this.method.call(context, this.receiver, this.implementationModule, this.methodName, arg2, block);
    }

    @JRubyMethod(name={"call", "[]"})
    public IRubyObject call(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        return this.method.call(context, this.receiver, this.implementationModule, this.methodName, arg0, arg1, block);
    }

    @JRubyMethod(name={"call", "[]"})
    public IRubyObject call(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        return this.method.call(context, this.receiver, this.implementationModule, this.methodName, arg0, arg1, arg2, block);
    }

    @JRubyMethod(name={"call", "[]"}, rest=true)
    public IRubyObject call(ThreadContext context, IRubyObject[] args2, Block block) {
        return this.method.call(context, this.receiver, this.implementationModule, this.methodName, args2, block);
    }

    @Override
    @JRubyMethod
    public RubyFixnum arity() {
        int value2 = this.method instanceof IRMethodArgs ? ((IRMethodArgs)((Object)this.method)).getSignature().arityValue() : this.method.getArity().getValue();
        return this.getRuntime().newFixnum(value2);
    }

    @Override
    @JRubyMethod(name={"=="}, required=1)
    public RubyBoolean op_equal(ThreadContext context, IRubyObject other) {
        if (!(other instanceof RubyMethod)) {
            return context.runtime.getFalse();
        }
        if (this.method instanceof ProcMethod) {
            return context.runtime.newBoolean(((ProcMethod)this.method).isSame(((RubyMethod)other).getMethod()));
        }
        RubyMethod otherMethod = (RubyMethod)other;
        return context.runtime.newBoolean(this.receiver == otherMethod.receiver && this.originModule == otherMethod.originModule && (this.isMethodMissingMatch(otherMethod.getMethod().getRealMethod()) || this.isSerialMatch(otherMethod.getMethod().getRealMethod())));
    }

    private boolean isMethodMissingMatch(DynamicMethod other) {
        return this.method.getRealMethod() instanceof RubyModule.RespondToMissingMethod && ((RubyModule.RespondToMissingMethod)this.method.getRealMethod()).equals(other);
    }

    private boolean isSerialMatch(DynamicMethod otherMethod) {
        return this.method.getRealMethod().getSerialNumber() == otherMethod.getRealMethod().getSerialNumber();
    }

    @Override
    @JRubyMethod(name={"eql?"}, required=1)
    public IRubyObject op_eql19(ThreadContext context, IRubyObject other) {
        return this.op_equal(context, other);
    }

    @Override
    @JRubyMethod(name={"clone"})
    public RubyMethod rbClone() {
        return RubyMethod.newMethod(this.implementationModule, this.methodName, this.originModule, this.originName, this.method, this.receiver);
    }

    @JRubyMethod
    public IRubyObject to_proc(ThreadContext context) {
        ArgumentDescriptor[] argsDesc;
        Signature signature;
        Ruby runtime = context.runtime;
        if (this.method instanceof IRMethodArgs) {
            signature = ((IRMethodArgs)((Object)this.method)).getSignature();
            argsDesc = ((IRMethodArgs)((Object)this.method)).getArgumentDescriptors();
        } else {
            signature = Signature.from(this.method.getArity());
            argsDesc = Helpers.methodToArgumentDescriptors(this.method);
        }
        int line = this.getLine();
        MethodBlockBody body = new MethodBlockBody(runtime.getStaticScopeFactory().getDummyScope(), signature, this.method, argsDesc, this.receiver, this.originModule, this.originName, this.getFilename(), line == -1 ? -1 : line - 1);
        Block b2 = MethodBlockBody.createMethodBlock(body);
        return RubyProc.newProc(runtime, b2, Block.Type.LAMBDA);
    }

    @JRubyMethod
    public RubyUnboundMethod unbind() {
        RubyUnboundMethod unboundMethod = RubyUnboundMethod.newUnboundMethod(this.implementationModule, this.methodName, this.originModule, this.originName, this.method);
        unboundMethod.infectBy(this);
        return unboundMethod;
    }

    @Override
    @JRubyMethod(name={"inspect", "to_s"})
    public IRubyObject inspect() {
        Ruby runtime = this.getRuntime();
        ThreadContext context = runtime.getCurrentContext();
        RubyString str = RubyString.newString(runtime, "#<");
        String sharp = "#";
        str.catString(this.getType().getName()).catString(": ");
        RubyModule mklass = this.method.getImplementationClass();
        RubyModule definedClass = this.method instanceof AliasMethod ? this.method.getRealMethod().getImplementationClass() : this.method.getDefinedClass();
        if (definedClass.isIncluded()) {
            definedClass = definedClass.getMetaClass();
        }
        if (this.implementationModule.isSingleton()) {
            IRubyObject attached = ((MetaClass)this.implementationModule).getAttached();
            if (this.receiver == null) {
                str.cat19(RubyMethod.inspect(context, this.implementationModule).convertToString());
            } else if (this.receiver == attached) {
                str.cat19(RubyMethod.inspect(context, attached).convertToString());
                sharp = ".";
            } else {
                str.cat19(RubyMethod.inspect(context, this.receiver).convertToString());
                str.catString("(");
                str.cat19(RubyMethod.inspect(context, attached).convertToString());
                str.catString(")");
                sharp = ".";
            }
        } else {
            str.catString(this.originModule.getName());
            if (this.implementationModule != this.originModule) {
                str.catString("(");
                str.catString(this.implementationModule.getName());
                str.catString(")");
            }
        }
        str.catString(sharp);
        str.catString(this.methodName);
        if (!this.methodName.equals(this.method.getName())) {
            str.catString("(");
            str.catString(this.method.getName());
            str.catString(")");
        }
        if (this.method.isNotImplemented()) {
            str.catString(" (not-implemented)");
        }
        str.catString(">");
        return str;
    }

    @JRubyMethod
    public IRubyObject receiver(ThreadContext context) {
        return this.receiver;
    }

    @Override
    @JRubyMethod
    public IRubyObject owner(ThreadContext context) {
        return this.implementationModule;
    }

    @Override
    @JRubyMethod
    public IRubyObject source_location(ThreadContext context) {
        Ruby runtime = context.runtime;
        String filename2 = this.getFilename();
        if (filename2 != null) {
            return runtime.newArray((IRubyObject)runtime.newString(filename2), (IRubyObject)runtime.newFixnum(this.getLine()));
        }
        return context.runtime.getNil();
    }

    @Override
    public String getFilename() {
        DynamicMethod realMethod = this.method.getRealMethod();
        if (realMethod instanceof PositionAware) {
            PositionAware poser = (PositionAware)((Object)realMethod);
            return poser.getFile();
        }
        return null;
    }

    @Override
    public int getLine() {
        DynamicMethod realMethod = this.method.getRealMethod();
        if (realMethod instanceof PositionAware) {
            PositionAware poser = (PositionAware)((Object)realMethod);
            return poser.getLine() + 1;
        }
        return -1;
    }

    @Override
    @JRubyMethod
    public IRubyObject parameters(ThreadContext context) {
        return Helpers.methodToParameters(context.runtime, this);
    }

    @JRubyMethod(optional=1)
    public IRubyObject curry(ThreadContext context, IRubyObject[] args2) {
        return this.to_proc(context).callMethod(context, "curry", args2);
    }

    @JRubyMethod
    public IRubyObject super_method(ThreadContext context) {
        RubyClass superClass = Helpers.findImplementerIfNecessary(this.receiver.getMetaClass(), this.implementationModule).getSuperClass();
        return this.super_method(context, this.receiver, superClass);
    }

    @JRubyMethod
    public IRubyObject original_name(ThreadContext context) {
        if (this.method instanceof AliasMethod) {
            return context.runtime.newSymbol(((AliasMethod)this.method).getOldName());
        }
        return this.name(context);
    }
}

