/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.errors.LockFailedException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.LockFile;
import org.eclipse.jgit.internal.storage.file.RefDirectory;
import org.eclipse.jgit.internal.storage.file.ReflogWriter;
import org.eclipse.jgit.lib.BatchRefUpdate;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdRef;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.ReceiveCommand;
import org.eclipse.jgit.util.RefList;

class PackedBatchRefUpdate
extends BatchRefUpdate {
    private RefDirectory refdb;

    PackedBatchRefUpdate(RefDirectory refdb) {
        super(refdb);
        this.refdb = refdb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(RevWalk walk2, ProgressMonitor monitor, List<String> options) throws IOException {
        if (!this.isAtomic()) {
            super.execute(walk2, monitor, options);
            return;
        }
        List<ReceiveCommand> pending = ReceiveCommand.filter(this.getCommands(), ReceiveCommand.Result.NOT_ATTEMPTED);
        if (pending.isEmpty()) {
            return;
        }
        if (pending.size() == 1) {
            super.execute(walk2, monitor, options);
            return;
        }
        if (PackedBatchRefUpdate.containsSymrefs(pending)) {
            PackedBatchRefUpdate.reject(pending.get(0), ReceiveCommand.Result.REJECTED_OTHER_REASON, JGitText.get().atomicSymRefNotSupported, pending);
            return;
        }
        if (!this.blockUntilTimestamps(MAX_WAIT)) {
            return;
        }
        if (options != null) {
            this.setPushOptions(options);
        }
        if (!this.checkConflictingNames(pending)) {
            return;
        }
        if (!this.checkObjectExistence(walk2, pending)) {
            return;
        }
        if (!this.checkNonFastForwards(walk2, pending)) {
            return;
        }
        try {
            this.refdb.pack(pending.stream().map(ReceiveCommand::getRefName).collect(Collectors.toList()));
        }
        catch (LockFailedException e2) {
            PackedBatchRefUpdate.lockFailure(pending.get(0), pending);
            return;
        }
        Map<String, LockFile> locks = null;
        this.refdb.inProcessPackedRefsLock.lock();
        try {
            RefDirectory.PackedRefList oldPackedList;
            if (!this.refdb.isInClone()) {
                locks = this.lockLooseRefs(pending);
                if (locks == null) {
                    return;
                }
                oldPackedList = this.refdb.pack(locks);
            } else {
                oldPackedList = this.refdb.getPackedRefs();
            }
            RefList<Ref> newRefs = PackedBatchRefUpdate.applyUpdates(walk2, oldPackedList, pending);
            if (newRefs == null) {
                return;
            }
            LockFile packedRefsLock = this.refdb.lockPackedRefs();
            if (packedRefsLock == null) {
                PackedBatchRefUpdate.lockFailure(pending.get(0), pending);
                return;
            }
            this.refdb.commitPackedRefs(packedRefsLock, newRefs, oldPackedList, true);
        }
        finally {
            try {
                PackedBatchRefUpdate.unlockAll(locks);
            }
            finally {
                this.refdb.inProcessPackedRefsLock.unlock();
            }
        }
        this.refdb.fireRefsChanged();
        pending.forEach(c -> c.setResult(ReceiveCommand.Result.OK));
        this.writeReflog(pending);
    }

    private static boolean containsSymrefs(List<ReceiveCommand> commands) {
        for (ReceiveCommand cmd : commands) {
            if (cmd.getOldSymref() == null && cmd.getNewSymref() == null) continue;
            return true;
        }
        return false;
    }

    private boolean checkConflictingNames(List<ReceiveCommand> commands) throws IOException {
        HashSet<String> takenNames = new HashSet<String>();
        HashSet<String> takenPrefixes = new HashSet<String>();
        HashSet<String> deletes = new HashSet<String>();
        for (ReceiveCommand cmd : commands) {
            if (cmd.getType() != ReceiveCommand.Type.DELETE) {
                takenNames.add(cmd.getRefName());
                PackedBatchRefUpdate.addPrefixesTo(cmd.getRefName(), takenPrefixes);
                continue;
            }
            deletes.add(cmd.getRefName());
        }
        Set<String> initialRefs = this.refdb.getRefs("").keySet();
        for (String name2 : initialRefs) {
            if (deletes.contains(name2)) continue;
            takenNames.add(name2);
            PackedBatchRefUpdate.addPrefixesTo(name2, takenPrefixes);
        }
        for (ReceiveCommand cmd : commands) {
            if (cmd.getType() != ReceiveCommand.Type.DELETE && takenPrefixes.contains(cmd.getRefName())) {
                PackedBatchRefUpdate.lockFailure(cmd, commands);
                return false;
            }
            for (String prefix : PackedBatchRefUpdate.getPrefixes(cmd.getRefName())) {
                if (!takenNames.contains(prefix)) continue;
                PackedBatchRefUpdate.lockFailure(cmd, commands);
                return false;
            }
        }
        return true;
    }

    private boolean checkObjectExistence(RevWalk walk2, List<ReceiveCommand> commands) throws IOException {
        for (ReceiveCommand cmd : commands) {
            try {
                if (cmd.getNewId().equals(ObjectId.zeroId())) continue;
                walk2.parseAny(cmd.getNewId());
            }
            catch (MissingObjectException e2) {
                PackedBatchRefUpdate.reject(cmd, ReceiveCommand.Result.REJECTED_MISSING_OBJECT, commands);
                return false;
            }
        }
        return true;
    }

    private boolean checkNonFastForwards(RevWalk walk2, List<ReceiveCommand> commands) throws IOException {
        if (this.isAllowNonFastForwards()) {
            return true;
        }
        for (ReceiveCommand cmd : commands) {
            cmd.updateType(walk2);
            if (cmd.getType() != ReceiveCommand.Type.UPDATE_NONFASTFORWARD) continue;
            PackedBatchRefUpdate.reject(cmd, ReceiveCommand.Result.REJECTED_NONFASTFORWARD, commands);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Map<String, LockFile> lockLooseRefs(List<ReceiveCommand> commands) throws IOException {
        ReceiveCommand failed = null;
        HashMap<String, LockFile> locks = new HashMap<String, LockFile>();
        try {
            block3: for (int ms : this.refdb.getRetrySleepMs()) {
                failed = null;
                PackedBatchRefUpdate.unlockAll(locks);
                locks.clear();
                RefDirectory.sleep(ms);
                for (ReceiveCommand c : commands) {
                    LockFile lock;
                    String name2 = c.getRefName();
                    if (locks.put(name2, lock = new LockFile(this.refdb.fileFor(name2))) != null) {
                        throw new IOException(MessageFormat.format(JGitText.get().duplicateRef, name2));
                    }
                    if (lock.lock()) continue;
                    failed = c;
                    continue block3;
                }
                HashMap<String, LockFile> result = locks;
                locks = null;
                HashMap<String, LockFile> hashMap = result;
                return hashMap;
            }
        }
        finally {
            PackedBatchRefUpdate.unlockAll(locks);
        }
        PackedBatchRefUpdate.lockFailure(failed != null ? failed : commands.get(0), commands);
        return null;
    }

    private static RefList<Ref> applyUpdates(RevWalk walk2, RefList<Ref> refs, List<ReceiveCommand> commands) throws IOException {
        int nDeletes = 0;
        ArrayList<ReceiveCommand> adds = new ArrayList<ReceiveCommand>(commands.size());
        for (ReceiveCommand c : commands) {
            if (c.getType() == ReceiveCommand.Type.CREATE) {
                adds.add(c);
                continue;
            }
            if (c.getType() != ReceiveCommand.Type.DELETE) continue;
            ++nDeletes;
        }
        int addIdx = 0;
        Map<String, ReceiveCommand> byName = PackedBatchRefUpdate.byName(commands);
        RefList.Builder<Ref> b = new RefList.Builder<Ref>(refs.size() - nDeletes + adds.size());
        for (Ref ref2 : refs) {
            ReceiveCommand currAdd;
            String name2 = ref2.getName();
            ReceiveCommand cmd = byName.remove(name2);
            if (cmd == null) {
                b.add(ref2);
                continue;
            }
            if (!cmd.getOldId().equals(ref2.getObjectId())) {
                PackedBatchRefUpdate.lockFailure(cmd, commands);
                return null;
            }
            while (addIdx < adds.size() && (currAdd = (ReceiveCommand)adds.get(addIdx)).getRefName().compareTo(name2) < 0) {
                b.add(PackedBatchRefUpdate.peeledRef(walk2, currAdd));
                byName.remove(currAdd.getRefName());
                ++addIdx;
            }
            if (cmd.getType() == ReceiveCommand.Type.DELETE) continue;
            b.add(PackedBatchRefUpdate.peeledRef(walk2, cmd));
        }
        while (addIdx < adds.size()) {
            ReceiveCommand cmd = (ReceiveCommand)adds.get(addIdx++);
            byName.remove(cmd.getRefName());
            b.add(PackedBatchRefUpdate.peeledRef(walk2, cmd));
        }
        if (!byName.isEmpty()) {
            PackedBatchRefUpdate.lockFailure(byName.values().iterator().next(), commands);
            return null;
        }
        return b.toRefList();
    }

    private void writeReflog(List<ReceiveCommand> commands) {
        PersonIdent ident = this.getRefLogIdent();
        if (ident == null) {
            ident = new PersonIdent(this.refdb.getRepository());
        }
        for (ReceiveCommand cmd : commands) {
            String strResult;
            if (cmd.getResult() != ReceiveCommand.Result.OK) continue;
            String name2 = cmd.getRefName();
            if (cmd.getType() == ReceiveCommand.Type.DELETE) {
                try {
                    RefDirectory.delete(this.refdb.logFor(name2), RefDirectory.levelsIn(name2));
                }
                catch (IOException iOException) {}
                continue;
            }
            if (this.isRefLogDisabled(cmd)) continue;
            String msg = this.getRefLogMessage(cmd);
            if (this.isRefLogIncludingResult(cmd) && (strResult = this.toResultString(cmd)) != null) {
                msg = msg.isEmpty() ? strResult : msg + ": " + strResult;
            }
            try {
                new ReflogWriter(this.refdb, this.isForceRefLog(cmd)).log(name2, cmd.getOldId(), cmd.getNewId(), ident, msg);
            }
            catch (IOException iOException) {}
        }
    }

    private String toResultString(ReceiveCommand cmd) {
        switch (cmd.getType()) {
            case CREATE: {
                return "created";
            }
            case UPDATE: {
                return this.isAllowNonFastForwards() ? "forced-update" : "fast-forward";
            }
            case UPDATE_NONFASTFORWARD: {
                return "forced-update";
            }
        }
        return null;
    }

    private static Map<String, ReceiveCommand> byName(List<ReceiveCommand> commands) {
        LinkedHashMap<String, ReceiveCommand> ret = new LinkedHashMap<String, ReceiveCommand>();
        for (ReceiveCommand cmd : commands) {
            ret.put(cmd.getRefName(), cmd);
        }
        return ret;
    }

    private static Ref peeledRef(RevWalk walk2, ReceiveCommand cmd) throws IOException {
        ObjectId newId = cmd.getNewId().copy();
        RevObject obj = walk2.parseAny(newId);
        if (obj instanceof RevTag) {
            return new ObjectIdRef.PeeledTag(Ref.Storage.PACKED, cmd.getRefName(), newId, walk2.peel(obj).copy());
        }
        return new ObjectIdRef.PeeledNonTag(Ref.Storage.PACKED, cmd.getRefName(), newId);
    }

    private static void unlockAll(@Nullable Map<?, LockFile> locks) {
        if (locks != null) {
            locks.values().forEach(LockFile::unlock);
        }
    }

    private static void lockFailure(ReceiveCommand cmd, List<ReceiveCommand> commands) {
        PackedBatchRefUpdate.reject(cmd, ReceiveCommand.Result.LOCK_FAILURE, commands);
    }

    private static void reject(ReceiveCommand cmd, ReceiveCommand.Result result, List<ReceiveCommand> commands) {
        PackedBatchRefUpdate.reject(cmd, result, null, commands);
    }

    private static void reject(ReceiveCommand cmd, ReceiveCommand.Result result, String why, List<ReceiveCommand> commands) {
        cmd.setResult(result, why);
        for (ReceiveCommand c2 : commands) {
            if (c2.getResult() != ReceiveCommand.Result.OK) continue;
            c2.setResult(ReceiveCommand.Result.NOT_ATTEMPTED);
        }
        ReceiveCommand.abort(commands);
    }
}

