/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.checkers.CoroutineCallCheckerKt;
import org.jetbrains.kotlin.resolve.calls.checkers.CoroutineCallCheckerKt$WhenMappings;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.HierarchicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeKind;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000N\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u001a,\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a\n\u0010\u0015\u001a\u00020\u0016*\u00020\u0001\u001a\n\u0010\u0017\u001a\u00020\u0016*\u00020\u0018\u001a\n\u0010\u0017\u001a\u00020\u0016*\u00020\u0019\u001a\u0014\u0010\u001a\u001a\u00020\u0016*\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0018H\u0002\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0003\u00a8\u0006\u001d"}, d2={"COROUTINE_CONTEXT_1_2_20_FQ_NAME", "Lorg/jetbrains/kotlin/name/FqName;", "getCOROUTINE_CONTEXT_1_2_20_FQ_NAME", "()Lorg/jetbrains/kotlin/name/FqName;", "COROUTINE_CONTEXT_FQ_NAME", "getCOROUTINE_CONTEXT_FQ_NAME", "checkCoroutinesFeature", "", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "reportOn", "Lcom/intellij/psi/PsiElement;", "checkRestrictsSuspension", "enclosingCallableDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "isBuiltInCorouineContext", "", "isBuiltInCoroutineContext", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "isScopeForDefaultParameterValuesOf", "Lorg/jetbrains/kotlin/resolve/scopes/HierarchicalScope;", "enclosingSuspendFunction", "frontend"})
public final class CoroutineCallCheckerKt {
    @NotNull
    private static final FqName COROUTINE_CONTEXT_1_2_20_FQ_NAME = DescriptorUtils.COROUTINES_INTRINSICS_PACKAGE_FQ_NAME.child(Name.identifier("coroutineContext"));
    @NotNull
    private static final FqName COROUTINE_CONTEXT_FQ_NAME = DescriptorUtils.COROUTINES_PACKAGE_FQ_NAME.child(Name.identifier("coroutineContext"));

    @NotNull
    public static final FqName getCOROUTINE_CONTEXT_1_2_20_FQ_NAME() {
        return COROUTINE_CONTEXT_1_2_20_FQ_NAME;
    }

    @NotNull
    public static final FqName getCOROUTINE_CONTEXT_FQ_NAME() {
        return COROUTINE_CONTEXT_FQ_NAME;
    }

    public static final boolean isBuiltInCorouineContext(@NotNull FqName $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return Intrinsics.areEqual($receiver, COROUTINE_CONTEXT_1_2_20_FQ_NAME) || Intrinsics.areEqual($receiver, COROUTINE_CONTEXT_FQ_NAME);
    }

    public static final boolean isBuiltInCoroutineContext(@NotNull FunctionDescriptor $receiver) {
        Object object;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        FunctionDescriptor functionDescriptor = $receiver;
        if (!(functionDescriptor instanceof PropertyGetterDescriptor)) {
            functionDescriptor = null;
        }
        return (object = (PropertyGetterDescriptor)functionDescriptor) != null && (object = object.getCorrespondingProperty()) != null && (object = DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)object)) != null && CoroutineCallCheckerKt.isBuiltInCorouineContext((FqName)object);
    }

    public static final boolean isBuiltInCoroutineContext(@NotNull PropertyDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return CoroutineCallCheckerKt.isBuiltInCorouineContext(DescriptorUtilsKt.getFqNameSafe($receiver));
    }

    private static final boolean isScopeForDefaultParameterValuesOf(@NotNull HierarchicalScope $receiver, FunctionDescriptor enclosingSuspendFunction) {
        return $receiver instanceof LexicalScope && ((LexicalScope)$receiver).getKind() == LexicalScopeKind.DEFAULT_VALUE && Intrinsics.areEqual(((LexicalScope)$receiver).getOwnerDescriptor(), enclosingSuspendFunction);
    }

    public static final void checkCoroutinesFeature(@NotNull LanguageVersionSettings languageVersionSettings, @NotNull DiagnosticSink diagnosticHolder, @NotNull PsiElement reportOn) {
        Intrinsics.checkParameterIsNotNull(languageVersionSettings, "languageVersionSettings");
        Intrinsics.checkParameterIsNotNull(diagnosticHolder, "diagnosticHolder");
        Intrinsics.checkParameterIsNotNull(reportOn, "reportOn");
        Pair<LanguageFeature, LanguageVersionSettings> diagnosticData = TuplesKt.to(LanguageFeature.Coroutines, languageVersionSettings);
        switch (CoroutineCallCheckerKt$WhenMappings.$EnumSwitchMapping$0[languageVersionSettings.getFeatureSupport(LanguageFeature.Coroutines).ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                diagnosticHolder.report(Errors.EXPERIMENTAL_FEATURE_WARNING.on(reportOn, diagnosticData));
                break;
            }
            case 3: {
                diagnosticHolder.report(Errors.EXPERIMENTAL_FEATURE_ERROR.on(reportOn, diagnosticData));
                break;
            }
            case 4: {
                diagnosticHolder.report(Errors.UNSUPPORTED_FEATURE.on(reportOn, diagnosticData));
            }
        }
    }

    private static final void checkRestrictsSuspension(CallableDescriptor enclosingCallableDescriptor, ResolvedCall<?> resolvedCall2, PsiElement reportOn, CallCheckerContext context) {
        Object object = enclosingCallableDescriptor.getExtensionReceiverParameter();
        if (object == null || (object = object.getValue()) == null) {
            return;
        }
        Object enclosingSuspendReceiverValue = object;
        checkRestrictsSuspension.1 isRestrictsSuspensionReceiver$ = checkRestrictsSuspension.1.INSTANCE;
        Function2<ReceiverValue, ReceiverValue, Boolean> sameInstance$ = new Function2<ReceiverValue, ReceiverValue, Boolean>(context){
            final /* synthetic */ CallCheckerContext $context;

            public final boolean invoke(@NotNull ReceiverValue $receiver, @Nullable ReceiverValue other) {
                CallableDescriptor callableDescriptor;
                DeclarationDescriptor referenceTarget;
                DeclarationDescriptor declarationDescriptor;
                DeclarationDescriptor declarationDescriptor2;
                KtReferenceExpression referenceExpression;
                Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                if (other == null) {
                    return false;
                }
                if ($receiver == other) {
                    return true;
                }
                ReceiverValue receiverValue = other;
                if (!(receiverValue instanceof ExpressionReceiver)) {
                    receiverValue = null;
                }
                ExpressionReceiver expressionReceiver = (ExpressionReceiver)receiverValue;
                KtExpression ktExpression = expressionReceiver != null ? expressionReceiver.getExpression() : null;
                if (!(ktExpression instanceof KtThisExpression)) {
                    ktExpression = null;
                }
                KtThisExpression ktThisExpression = (KtThisExpression)ktExpression;
                KtReferenceExpression ktReferenceExpression = referenceExpression = ktThisExpression != null ? ktThisExpression.getInstanceReference() : null;
                if (ktReferenceExpression != null) {
                    KtReferenceExpression ktReferenceExpression2;
                    KtReferenceExpression it = ktReferenceExpression2 = ktReferenceExpression;
                    declarationDescriptor2 = (DeclarationDescriptor)this.$context.getTrace().get(BindingContext.REFERENCE_TARGET, referenceExpression);
                } else {
                    declarationDescriptor2 = null;
                }
                if (!((declarationDescriptor = (referenceTarget = declarationDescriptor2)) instanceof CallableDescriptor)) {
                    declarationDescriptor = null;
                }
                return $receiver == ((callableDescriptor = (CallableDescriptor)declarationDescriptor) != null && (callableDescriptor = callableDescriptor.getExtensionReceiverParameter()) != null ? callableDescriptor.getValue() : null);
            }
            {
                this.$context = callCheckerContext;
                super(2);
            }
        };
        Object object2 = enclosingSuspendReceiverValue;
        Intrinsics.checkExpressionValueIsNotNull(object2, "enclosingSuspendReceiverValue");
        if (!isRestrictsSuspensionReceiver$.invoke((ReceiverValue)object2)) {
            return;
        }
        if (sameInstance$.invoke((ReceiverValue)enclosingSuspendReceiverValue, resolvedCall2.getDispatchReceiver())) {
            return;
        }
        if (sameInstance$.invoke((ReceiverValue)enclosingSuspendReceiverValue, resolvedCall2.getExtensionReceiver())) {
            Object obj = resolvedCall2.getCandidateDescriptor();
            Intrinsics.checkExpressionValueIsNotNull(obj, "resolvedCall.candidateDescriptor");
            ReceiverParameterDescriptor receiverParameterDescriptor = obj.getExtensionReceiverParameter();
            if (receiverParameterDescriptor == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull(receiverParameterDescriptor, "resolvedCall.candidateDe\u2026ensionReceiverParameter!!");
            ReceiverValue receiverValue = receiverParameterDescriptor.getValue();
            Intrinsics.checkExpressionValueIsNotNull(receiverValue, "resolvedCall.candidateDe\u2026ReceiverParameter!!.value");
            if (isRestrictsSuspensionReceiver$.invoke(receiverValue)) {
                return;
            }
        }
        context.getTrace().report(Errors.ILLEGAL_RESTRICTED_SUSPENDING_FUNCTION_CALL.on(reportOn));
    }

    public static final /* synthetic */ boolean access$isScopeForDefaultParameterValuesOf(@NotNull HierarchicalScope $receiver, @NotNull FunctionDescriptor enclosingSuspendFunction) {
        return CoroutineCallCheckerKt.isScopeForDefaultParameterValuesOf($receiver, enclosingSuspendFunction);
    }

    public static final /* synthetic */ void access$checkRestrictsSuspension(@NotNull CallableDescriptor enclosingCallableDescriptor, @NotNull ResolvedCall resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        CoroutineCallCheckerKt.checkRestrictsSuspension(enclosingCallableDescriptor, resolvedCall2, reportOn, context);
    }
}

