/*
 * Decompiled with CFR 0.152.
 */
package jdepend.framework;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import jdepend.framework.JavaClass;
import jdepend.framework.PackageFilter;
import jdepend.framework.ParserListener;

public abstract class AbstractParser {
    private ArrayList parseListeners;
    private PackageFilter filter;
    public static boolean DEBUG = false;

    public AbstractParser() {
        this(new PackageFilter());
    }

    public AbstractParser(PackageFilter filter) {
        this.setFilter(filter);
        this.parseListeners = new ArrayList();
    }

    public void addParseListener(ParserListener listener) {
        this.parseListeners.add(listener);
    }

    public abstract JavaClass parse(InputStream var1) throws IOException;

    protected void onParsedJavaClass(JavaClass jClass) {
        Iterator i = this.parseListeners.iterator();
        while (i.hasNext()) {
            ((ParserListener)i.next()).onParsedJavaClass(jClass);
        }
    }

    protected PackageFilter getFilter() {
        if (this.filter == null) {
            this.setFilter(new PackageFilter());
        }
        return this.filter;
    }

    protected void setFilter(PackageFilter filter) {
        this.filter = filter;
    }

    protected void debug(String message) {
        if (DEBUG) {
            System.err.println(message);
        }
    }
}

