/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bib2gls;

import com.dickimawbooks.bib2gls.Bib2Gls;
import com.dickimawbooks.bib2gls.Bib2GlsEntry;
import com.dickimawbooks.bib2gls.Bib2GlsException;
import com.dickimawbooks.bib2gls.EmptyGroupTitle;
import com.dickimawbooks.bib2gls.GlsResource;
import com.dickimawbooks.bib2gls.GroupTitle;
import com.dickimawbooks.bib2gls.OtherGroupTitle;
import com.dickimawbooks.bib2gls.SortComparator;
import com.dickimawbooks.bib2gls.SortSettings;
import java.text.BreakIterator;
import java.text.CollationElementIterator;
import java.text.CollationKey;
import java.text.Collator;
import java.text.Normalizer;
import java.text.ParseException;
import java.text.RuleBasedCollator;
import java.util.Locale;
import java.util.Vector;

public class Bib2GlsEntryComparator
extends SortComparator {
    private Collator collator;
    private BreakIterator breakIterator = null;
    private String breakPointMarker = "|";
    private int breakPoint;
    public static final int BREAK_NONE = 0;
    public static final int BREAK_WORD = 1;
    public static final int BREAK_CHAR = 2;
    public static final int BREAK_SENTENCE = 3;
    public static final int BREAK_UPPER_NOTLOWER = 4;
    public static final int BREAK_UPPER_UPPER = 5;
    public static final int BREAK_UPPER_NOTLOWER_WORD = 6;
    public static final int BREAK_UPPER_UPPER_WORD = 7;

    public Bib2GlsEntryComparator(Bib2Gls bib2Gls, Vector<Bib2GlsEntry> vector, SortSettings sortSettings, String string, String string2, String string3) throws ParseException {
        super(bib2Gls, vector, sortSettings, string, string2, string3);
        int n = sortSettings.getBreakPoint();
        String string4 = sortSettings.getBreakPointMarker();
        if (sortSettings.isCustom()) {
            this.collator = new RuleBasedCollator(sortSettings.getCollationRule());
            if (n != 0) {
                String string5 = bib2Gls.getDocDefaultLocale();
                this.setBreakPoint(n, string4, Locale.forLanguageTag(string5));
            }
        } else {
            Locale locale = sortSettings.getLocale();
            this.collator = Collator.getInstance(locale);
            this.setBreakPoint(n, string4, locale);
        }
        this.collator.setStrength(sortSettings.getCollatorStrength());
        this.collator.setDecomposition(sortSettings.getCollatorDecomposition());
        if (this.collator instanceof RuleBasedCollator && bib2Gls.getDebugLevel() > 0) {
            bib2Gls.debug(bib2Gls.getMessage("message.collator.rules", ((RuleBasedCollator)this.collator).getRules()));
        }
    }

    private void setBreakPoint(int n, String string, Locale locale) {
        this.breakPointMarker = string;
        this.breakPoint = n;
        switch (n) {
            case 0: 
            case 4: 
            case 5: {
                this.breakIterator = null;
                break;
            }
            case 1: 
            case 6: 
            case 7: {
                this.breakIterator = BreakIterator.getWordInstance(locale);
                break;
            }
            case 2: {
                this.breakIterator = BreakIterator.getCharacterInstance(locale);
                break;
            }
            case 3: {
                this.breakIterator = BreakIterator.getSentenceInstance(locale);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid break identifier: " + n);
            }
        }
    }

    @Override
    protected long getDefaultGroupId(Bib2GlsEntry bib2GlsEntry, int n, Object object) {
        String string = object.toString();
        if (string.isEmpty()) {
            return 0L;
        }
        return n;
    }

    @Override
    protected GroupTitle createDefaultGroupTitle(int n, Object object, String string) {
        String string2;
        String string3 = object.toString();
        if (string3.isEmpty()) {
            return new EmptyGroupTitle(string);
        }
        String string4 = string2 = new String(Character.toChars(n));
        if (Character.isAlphabetic(n)) {
            string4 = string2.toUpperCase();
            int n2 = string4.codePointAt(0);
            return new GroupTitle(string4, string2, n2, string);
        }
        if (string2.equals("\\") || string2.equals("{") || string2.equals("}")) {
            string2 = "\\char`\\" + string2;
        }
        return new OtherGroupTitle(string2, n, string);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected String updateSortValue(Bib2GlsEntry bib2GlsEntry, Vector<Bib2GlsEntry> vector) {
        String string = super.updateSortValue(bib2GlsEntry, vector);
        String string2 = bib2GlsEntry.getId();
        String string3 = null;
        string = this.breakPoints(string).toString();
        if (this.breakPoint != 0) {
            this.bib2gls.debug(this.bib2gls.getMessage("message.break.points", string));
        }
        bib2GlsEntry.putField(this.sortStorageField, string);
        CollationKey collationKey = this.collator.getCollationKey(string);
        bib2GlsEntry.setCollationKey(collationKey);
        GlsResource glsResource = this.bib2gls.getCurrentResource();
        String string4 = glsResource.getType(bib2GlsEntry, this.entryType);
        if (string4 == null) {
            string4 = "";
        }
        if (this.bib2gls.useGroupField() && !bib2GlsEntry.hasParent() && bib2GlsEntry.getFieldValue(this.groupField) == null) {
            if (string.isEmpty()) {
                String string5;
                GroupTitle groupTitle = glsResource.getGroupTitle(string4, 0L);
                if (groupTitle == null) {
                    groupTitle = new EmptyGroupTitle(string4);
                    glsResource.putGroupTitle(groupTitle, bib2GlsEntry);
                    string5 = groupTitle.toString();
                } else {
                    string5 = groupTitle.format(string);
                }
                bib2GlsEntry.putField(this.groupField, String.format("\\%s%s", groupTitle.getCsLabelName(), string5));
            } else if (this.collator instanceof RuleBasedCollator) {
                int n;
                Object object;
                String string5;
                CollationElementIterator collationElementIterator = ((RuleBasedCollator)this.collator).getCollationElementIterator(string);
                int n2 = collationElementIterator.next();
                int n22 = collationElementIterator.getOffset();
                int n3 = 0;
                while (n2 == 0) {
                    n3 = n22;
                    n2 = collationElementIterator.next();
                    n22 = collationElementIterator.getOffset();
                }
                boolean n4 = false;
                if (n2 == -1) {
                    this.bib2gls.debug(this.bib2gls.getMessage("message.no.collation.element", string));
                    if (this.collator.getStrength() == 0) {
                        string5 = Normalizer.normalize(string, Normalizer.Form.NFD);
                        string5 = string5.replaceAll("\\p{M}", "");
                        collationElementIterator = ((RuleBasedCollator)this.collator).getCollationElementIterator(string5);
                        n2 = collationElementIterator.next();
                        n22 = collationElementIterator.getOffset();
                    } else {
                        int n5 = string.codePointAt(0);
                        n22 = Character.charCount(n5);
                        string5 = string;
                        n2 = n5;
                    }
                    string3 = string5 = string5.substring(0, n22);
                } else {
                    string3 = string5 = string.substring(n3, n22 == 0 ? 1 : n22);
                    int n6 = this.collator.getStrength();
                    this.collator.setStrength(0);
                    object = Normalizer.normalize(string5.toLowerCase(), Normalizer.Form.NFD);
                    object = ((String)object).replaceAll("\\p{M}", "");
                    if (this.collator.compare(string5, (String)object) == 0) {
                        string3 = object;
                    }
                    this.collator.setStrength(n6);
                }
                if (!string3.isEmpty()) {
                    n = string3.codePointAt(0);
                }
                if (this.settings.getGroupFormation() != 0) {
                    string3 = this.setGroupTitle(bib2GlsEntry, n, string, string5, string4);
                } else {
                    String string6;
                    void var14_25;
                    String string7 = this.bib2gls.getMessageIfExists(String.format("grouptitle.case.%s", string3));
                    if (string7 != null) {
                        string3 = string7;
                        int n7 = Character.toTitleCase(n);
                    } else if (Character.isAlphabetic(n)) {
                        int n8 = Character.toTitleCase(n);
                        string3 = String.format("%c%s", n8, string3.substring(Character.charCount(n)).toLowerCase());
                        int n9 = n8;
                    }
                    if (Character.isAlphabetic((int)var14_25)) {
                        if (this.collator.getStrength() != 0) {
                            n2 = var14_25;
                        }
                        if ((object = glsResource.getGroupTitle(string4, n2)) == null) {
                            object = new GroupTitle(string3, string5, n2, string4);
                            glsResource.putGroupTitle((GroupTitle)object, bib2GlsEntry);
                            string6 = ((GroupTitle)object).toString();
                        } else {
                            string6 = ((GroupTitle)object).format(string5);
                            if (((GroupTitle)object).getTitle().matches(".*[^\\p{ASCII}].*") && string3.matches("\\p{ASCII}+")) {
                                ((GroupTitle)object).setTitle(string3);
                            }
                        }
                        bib2GlsEntry.putField(this.groupField, String.format("\\%s%s", ((GroupTitle)object).getCsLabelName(), string6));
                    } else {
                        if (string5.equals("\\") || string5.equals("{") || string5.equals("}")) {
                            string5 = "\\char`\\" + string5;
                        }
                        if ((object = glsResource.getGroupTitle(string4, n2)) == null) {
                            object = new OtherGroupTitle(string5, n2, string4);
                            glsResource.putGroupTitle((GroupTitle)object, bib2GlsEntry);
                            string6 = ((GroupTitle)object).toString();
                        } else {
                            string6 = ((GroupTitle)object).format(string5);
                        }
                        bib2GlsEntry.putField(this.groupField, String.format("\\%s%s", ((GroupTitle)object).getCsLabelName(), string6));
                    }
                }
            } else {
                int n = string.codePointAt(0);
                String string9 = new String(Character.toChars(n));
                if (Character.isAlphabetic(n)) {
                    string3 = string9.toUpperCase();
                    n = string3.codePointAt(0);
                }
                string3 = this.setGroupTitle(bib2GlsEntry, n, string, string9, string4);
            }
        }
        if (this.bib2gls.getVerboseLevel() > 0) {
            byte[] byArray;
            StringBuilder stringBuilder = new StringBuilder();
            for (byte by : byArray = collationKey.toByteArray()) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(' ');
                }
                stringBuilder.append(by);
            }
            if (string3 == null) {
                this.bib2gls.verbose(String.format("%s -> '%s' [%s]", string2, string, stringBuilder));
            } else {
                this.bib2gls.verbose(String.format("%s -> '%s' (%s) [%s]", string2, string, string3, stringBuilder));
            }
        }
        return string;
    }

    @Override
    public int compareElements(Bib2GlsEntry bib2GlsEntry, Bib2GlsEntry bib2GlsEntry2) {
        CollationKey collationKey = bib2GlsEntry.getCollationKey();
        CollationKey collationKey2 = bib2GlsEntry2.getCollationKey();
        return collationKey.compareTo(collationKey2);
    }

    public Collator getCollator() {
        return this.collator;
    }

    @Override
    public void sortEntries() throws Bib2GlsException {
        this.bib2gls.debug(this.bib2gls.getMessage("message.setting.sort", this.collator.getStrength(), this.collator.getDecomposition()));
        super.sortEntries();
    }

    protected CharSequence breakUpperNotLower(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            int n3;
            int n4 = string.codePointAt(n);
            stringBuffer.appendCodePoint(n4);
            if (!Character.isUpperCase(n4) || Character.isLowerCase(n3 = n < n2 ? string.codePointAt(n += Character.charCount(n4)) : -1)) continue;
            stringBuffer.append(this.breakPointMarker);
        }
        return stringBuffer;
    }

    protected CharSequence breakUpperUpper(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            int n3;
            int n4 = string.codePointAt(n);
            stringBuffer.appendCodePoint(n4);
            if (!Character.isUpperCase(n4) || !Character.isUpperCase(n3 = n < n2 ? string.codePointAt(n += Character.charCount(n4)) : -1)) continue;
            stringBuffer.append(this.breakPointMarker);
        }
        return stringBuffer;
    }

    public CharSequence breakPoints(String string) {
        switch (this.breakPoint) {
            case 4: 
            case 6: {
                string = this.breakUpperNotLower(string).toString();
                break;
            }
            case 5: 
            case 7: {
                string = this.breakUpperUpper(string).toString();
            }
        }
        if (this.breakIterator == null) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        this.breakIterator.setText(string);
        int n = this.breakIterator.first();
        int n2 = this.breakIterator.next();
        while (n2 != -1) {
            String string2 = string.substring(n, n2);
            int n3 = string2.codePointAt(0);
            if (Character.isLetterOrDigit(n3)) {
                stringBuffer.append(string2);
                stringBuffer.append(this.breakPointMarker);
            }
            n = n2;
            n2 = this.breakIterator.next();
        }
        return stringBuffer;
    }
}

