/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.datatool;

import com.dickimawbooks.texparserlib.Expandable;
import com.dickimawbooks.texparserlib.Numerical;
import com.dickimawbooks.texparserlib.TeXNumber;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import com.dickimawbooks.texparserlib.latex.datatool.DataNumericElement;
import com.dickimawbooks.texparserlib.latex.datatool.DataToolSty;
import java.io.IOException;

public class DataRealElement
implements DataNumericElement,
Expandable {
    private double value;
    protected DataToolSty sty;

    public DataRealElement(DataToolSty dataToolSty) {
        this(dataToolSty, 0.0);
    }

    public DataRealElement(DataToolSty dataToolSty, TeXNumber teXNumber) {
        this(dataToolSty, teXNumber.getValue());
    }

    public DataRealElement(DataToolSty dataToolSty, double d) {
        this.sty = dataToolSty;
        this.value = d;
    }

    @Override
    public Object clone() {
        return new DataRealElement(this.sty, this.value);
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return (float)this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public void advance(TeXParser teXParser, Numerical numerical) throws TeXSyntaxException {
        this.value += (double)numerical.number(teXParser);
    }

    @Override
    public void divide(int n) {
        this.value /= (double)n;
    }

    @Override
    public void multiply(int n) {
        this.value *= (double)n;
    }

    @Override
    public int number(TeXParser teXParser) throws TeXSyntaxException {
        return this.intValue();
    }

    @Override
    public byte getDataType() {
        return 2;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser) throws IOException {
        return this.string(teXParser);
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return this.expandonce(teXParser);
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser) throws IOException {
        TeXObjectList teXObjectList = this.expandonce(teXParser);
        if (teXObjectList == null) {
            return null;
        }
        return teXObjectList.expandfully(teXParser);
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObjectList teXObjectList2 = this.expandonce(teXParser, teXObjectList);
        if (teXObjectList2 == null) {
            return null;
        }
        return teXObjectList2.expandfully(teXParser, teXObjectList);
    }

    @Override
    public String format() {
        return String.format("%f", this.value);
    }

    @Override
    public String toString(TeXParser teXParser) {
        return this.format();
    }

    @Override
    public TeXObjectList string(TeXParser teXParser) throws IOException {
        return teXParser.string(this.toString(teXParser));
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        teXParser.getListener().getWriteable().write(this.toString(teXParser));
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        this.process(teXParser);
    }

    @Override
    public boolean isPar() {
        return false;
    }
}

