/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.jmolpanel;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import org.jmol.i18n.GT;
import org.openscience.jmol.app.SplashInterface;

public class Splash
extends Window
implements SplashInterface {
    private Image splashImage;
    private int imgWidth;
    private int imgHeight;
    private static final int BORDERSIZE = 10;
    private static final Color BORDERCOLOR = Color.blue;
    private String status = GT._("Loading...");
    private int textY;
    private int statusTop;
    private static final int STATUSSIZE = 10;
    private static final Color TEXTCOLOR = Color.white;

    public Splash(Frame parent, ImageIcon ii) {
        super(new Frame());
        this.splashImage = ii.getImage();
        this.imgWidth = this.splashImage.getWidth(this);
        this.imgHeight = this.splashImage.getHeight(this);
        if (parent == null) {
            return;
        }
        this.showSplashScreen();
        parent.addWindowListener(new WindowListener());
    }

    public void showSplashScreen() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension screenSize = tk.getScreenSize();
        this.setBackground(BORDERCOLOR);
        int w = this.imgWidth + 20;
        int h = this.imgHeight + 20 + 10;
        int x = (screenSize.width - w) / 2;
        int y = (screenSize.height - h) / 2;
        this.setBounds(x, y, w, h);
        this.statusTop = 10 + this.imgHeight;
        this.textY = 20 + this.imgHeight + 1;
        this.setVisible(true);
    }

    @Override
    public void paint(Graphics g) {
        g.drawImage(this.splashImage, 10, 10, this.imgWidth, this.imgHeight, this);
        g.setColor(BORDERCOLOR);
        g.fillRect(10, this.statusTop, this.imgWidth, this.textY);
        g.setColor(TEXTCOLOR);
        g.drawString(this.status, 10, this.textY);
    }

    @Override
    public void showStatus(String message) {
        if (message != null) {
            this.status = message;
            Graphics g = this.getGraphics();
            if (g == null) {
                return;
            }
            g.setColor(BORDERCOLOR);
            g.fillRect(10, this.statusTop, this.imgWidth + 10, this.textY);
            g.setColor(TEXTCOLOR);
            g.drawString(this.status, 10, this.textY);
        }
    }

    class WindowListener
    extends WindowAdapter {
        WindowListener() {
        }

        @Override
        public void windowActivated(WindowEvent we) {
            Splash.this.setVisible(false);
            Splash.this.dispose();
        }
    }
}

