/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.quantum;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.PT;
import org.jmol.adapter.readers.quantum.BasisFunctionReader;
import org.jmol.adapter.readers.quantum.MOReader;
import org.jmol.util.Logger;

public abstract class GamessReader
extends MOReader {
    protected Lst<String> atomNames;
    private Map<String, String> calcOptions;
    private boolean isTypeSet;

    protected abstract void readAtomsInBohrCoordinates() throws Exception;

    protected void readEnergy() {
        String[] tokens = PT.getTokens((String)this.line.substring(this.line.indexOf("ENERGY")));
        if (tokens.length < 3) {
            return;
        }
        String strEnergy = tokens[2];
        float e = this.parseFloatStr(strEnergy);
        if (!Float.isNaN(e)) {
            this.asc.setAtomSetEnergy(strEnergy, e);
        }
    }

    protected void readGaussianBasis(String initiator, String terminator) throws Exception {
        String[] tokens;
        Lst gdata = new Lst();
        this.gaussianCount = 0;
        int nGaussians = 0;
        this.shellCount = 0;
        String thisShell = "0";
        this.discardLinesUntilContains(initiator);
        this.rd();
        int[] slater = null;
        Hashtable<String, Lst> shellsByAtomType = new Hashtable<String, Lst>();
        Lst slatersByAtomType = new Lst();
        String atomType = null;
        block4: while (this.rd() != null && this.line.indexOf(terminator) < 0) {
            if (this.line.indexOf("(") >= 0) {
                this.line = GamessReader.fixBasisLine(this.line);
            }
            tokens = this.getTokens();
            switch (tokens.length) {
                case 1: {
                    if (atomType != null) {
                        if (slater != null) {
                            slater[2] = nGaussians;
                            slatersByAtomType.addLast(slater);
                            slater = null;
                        }
                        shellsByAtomType.put(atomType, slatersByAtomType);
                    }
                    slatersByAtomType = new Lst();
                    atomType = tokens[0];
                    continue block4;
                }
                case 0: {
                    continue block4;
                }
            }
            if (!tokens[0].equals(thisShell)) {
                if (slater != null) {
                    slater[2] = nGaussians;
                    slatersByAtomType.addLast(slater);
                }
                thisShell = tokens[0];
                ++this.shellCount;
                slater = new int[]{BasisFunctionReader.getQuantumShellTagID(this.fixShellTag(tokens[1])), this.gaussianCount, 0};
                nGaussians = 0;
            }
            ++nGaussians;
            ++this.gaussianCount;
            gdata.addLast((Object)tokens);
        }
        if (slater != null) {
            slater[2] = nGaussians;
            slatersByAtomType.addLast(slater);
        }
        if (atomType != null) {
            shellsByAtomType.put(atomType, slatersByAtomType);
        }
        this.gaussians = AU.newFloat2((int)this.gaussianCount);
        for (int i = 0; i < this.gaussianCount; ++i) {
            tokens = (String[])gdata.get(i);
            this.gaussians[i] = new float[tokens.length - 3];
            for (int j = 3; j < tokens.length; ++j) {
                this.gaussians[i][j - 3] = this.parseFloatStr(tokens[j]);
            }
        }
        int ac = this.atomNames.size();
        if (this.shells == null && ac > 0) {
            this.shells = new Lst();
            for (int i = 0; i < ac; ++i) {
                atomType = (String)this.atomNames.get(i);
                Lst slaters = (Lst)shellsByAtomType.get(atomType);
                if (slaters == null) {
                    Logger.error((String)("slater for atom " + i + " atomType " + atomType + " was not found in listing. Ignoring molecular orbitals"));
                    return;
                }
                for (int j = 0; j < slaters.size(); ++j) {
                    slater = (int[])slaters.get(j);
                    this.shells.addLast((Object)new int[]{i + 1, slater[0], slater[1] + 1, slater[2]});
                }
            }
        }
        if (this.debugging) {
            Logger.debug((String)(this.shellCount + " slater shells read"));
            Logger.debug((String)(this.gaussianCount + " gaussian primitives read"));
        }
    }

    protected abstract String fixShellTag(String var1);

    protected void readFrequencies() throws Exception {
        this.discardLinesUntilContains("FREQUENCY:");
        boolean haveFreq = false;
        while (this.line != null && this.line.indexOf("FREQUENCY:") >= 0) {
            int frequencyCount = 0;
            String[] tokens = this.getTokens();
            float[] frequencies = new float[tokens.length];
            for (int i = 0; i < tokens.length; ++i) {
                float frequency = this.parseFloatStr(tokens[i]);
                if (tokens[i].equals("I")) {
                    frequencies[frequencyCount - 1] = -frequencies[frequencyCount - 1];
                }
                if (Float.isNaN(frequency)) continue;
                frequencies[frequencyCount++] = frequency;
                if (!this.debugging) continue;
                Logger.debug((String)(this.vibrationNumber + 1 + " frequency=" + frequency));
            }
            String[] red_masses = null;
            String[] intensities = null;
            this.rd();
            if (this.line.indexOf("MASS") >= 0) {
                red_masses = this.getTokens();
                this.rd();
            }
            if (this.line.indexOf("INTENS") >= 0) {
                intensities = this.getTokens();
            }
            int ac = this.asc.getLastAtomSetAtomCount();
            int iAtom0 = this.asc.ac;
            boolean[] ignore = new boolean[frequencyCount];
            for (int i = 0; i < frequencyCount; ++i) {
                boolean bl = ignore[i] = !this.doGetVibration(++this.vibrationNumber);
                if (ignore[i]) continue;
                if (haveFreq) {
                    this.asc.cloneLastAtomSet();
                } else {
                    haveFreq = true;
                    iAtom0 -= ac;
                }
                this.asc.setAtomSetFrequency(null, null, "" + frequencies[i], null);
                if (red_masses != null) {
                    this.asc.setAtomSetModelProperty("ReducedMass", red_masses[red_masses.length - frequencyCount + i] + " AMU");
                }
                if (intensities == null) continue;
                this.asc.setAtomSetModelProperty("IRIntensity", intensities[intensities.length - frequencyCount + i] + " D^2/AMU-Angstrom^2");
            }
            this.discardLinesUntilBlank();
            this.fillFrequencyData(iAtom0, ac, ac, ignore, false, 20, 12, null, 0, null);
            this.readLines(13);
        }
    }

    protected static String fixBasisLine(String line) {
        int pt;
        line = line.replace(')', ' ');
        while ((pt = line.indexOf("(")) >= 0) {
            int pt1 = pt;
            while (line.charAt(--pt1) == ' ') {
            }
            while (line.charAt(--pt1) != ' ') {
            }
            line = line.substring(0, ++pt1) + line.substring(pt + 1);
        }
        return line;
    }

    protected void setCalculationType() {
        if (this.calcOptions == null || this.isTypeSet) {
            return;
        }
        this.isTypeSet = true;
        String SCFtype = this.calcOptions.get("contrl_options_SCFTYP");
        String Runtype = this.calcOptions.get("contrl_options_RUNTYP");
        String igauss = this.calcOptions.get("basis_options_IGAUSS");
        String gbasis = this.calcOptions.get("basis_options_GBASIS");
        boolean DFunc = !"0".equals(this.calcOptions.get("basis_options_NDFUNC"));
        boolean PFunc = !"0".equals(this.calcOptions.get("basis_options_NPFUNC"));
        boolean FFunc = !"0".equals(this.calcOptions.get("basis_options_NFFUNC"));
        String DFTtype = this.calcOptions.get("contrl_options_DFTTYP");
        int perturb = this.parseIntStr(this.calcOptions.get("contrl_options_MPLEVL"));
        String CItype = this.calcOptions.get("contrl_options_CITYP");
        String CCtype = this.calcOptions.get("contrl_options_CCTYP");
        if (igauss == null && SCFtype == null) {
            return;
        }
        if (this.calculationType.equals("?")) {
            this.calculationType = "";
        }
        if (igauss != null) {
            if ("0".equals(igauss)) {
                boolean recognized = false;
                if (this.calculationType.length() > 0) {
                    this.calculationType = this.calculationType + " ";
                }
                if (gbasis.startsWith("ACC")) {
                    this.calculationType = this.calculationType + "aug-cc-p";
                }
                if (gbasis.startsWith("CC")) {
                    this.calculationType = this.calculationType + "cc-p";
                }
                if ((gbasis.startsWith("ACC") || gbasis.startsWith("CC")) && gbasis.endsWith("C")) {
                    this.calculationType = this.calculationType + "C";
                }
                if (gbasis.indexOf("CCD") >= 0) {
                    this.calculationType = this.calculationType + "VDZ";
                    recognized = true;
                }
                if (gbasis.indexOf("CCT") >= 0) {
                    this.calculationType = this.calculationType + "VTZ";
                    recognized = true;
                }
                if (gbasis.indexOf("CCQ") >= 0) {
                    this.calculationType = this.calculationType + "VQZ";
                    recognized = true;
                }
                if (gbasis.indexOf("CC5") >= 0) {
                    this.calculationType = this.calculationType + "V5Z";
                    recognized = true;
                }
                if (gbasis.indexOf("CC6") >= 0) {
                    this.calculationType = this.calculationType + "V6Z";
                    recognized = true;
                }
                if (!recognized) {
                    this.calculationType = this.calculationType + gbasis;
                }
            } else {
                if (this.calculationType.length() > 0) {
                    this.calculationType = this.calculationType + " ";
                }
                this.calculationType = this.calculationType + igauss + "-" + PT.rep((String)gbasis, (String)"N", (String)"");
                if ("T".equals(this.calcOptions.get("basis_options_DIFFSP"))) {
                    if ("T".equals(this.calcOptions.get("basis_options_DIFFS"))) {
                        this.calculationType = this.calculationType + "+";
                    }
                    this.calculationType = this.calculationType + "+";
                }
                this.calculationType = this.calculationType + "G";
                if (DFunc || PFunc || FFunc) {
                    this.calculationType = this.calculationType + "(";
                    if (FFunc) {
                        this.calculationType = this.calculationType + "f";
                        if (DFunc || PFunc) {
                            this.calculationType = this.calculationType + ",";
                        }
                    }
                    if (DFunc) {
                        this.calculationType = this.calculationType + "d";
                        if (PFunc) {
                            this.calculationType = this.calculationType + ",";
                        }
                    }
                    if (PFunc) {
                        this.calculationType = this.calculationType + "p";
                    }
                    this.calculationType = this.calculationType + ")";
                }
            }
            if (DFTtype != null && DFTtype.indexOf("NONE") < 0) {
                if (this.calculationType.length() > 0) {
                    this.calculationType = this.calculationType + " ";
                }
                this.calculationType = this.calculationType + DFTtype;
            }
            if (CItype != null && CItype.indexOf("NONE") < 0) {
                if (this.calculationType.length() > 0) {
                    this.calculationType = this.calculationType + " ";
                }
                this.calculationType = this.calculationType + CItype;
            }
            if (CCtype != null && CCtype.indexOf("NONE") < 0) {
                if (this.calculationType.length() > 0) {
                    this.calculationType = this.calculationType + " ";
                }
                this.calculationType = this.calculationType + CCtype;
            }
            if (perturb > 0) {
                if (this.calculationType.length() > 0) {
                    this.calculationType = this.calculationType + " ";
                }
                this.calculationType = this.calculationType + "MP" + perturb;
            }
            if (SCFtype != null) {
                if (this.calculationType.length() > 0) {
                    this.calculationType = this.calculationType + " ";
                }
                this.calculationType = this.calculationType + SCFtype + " " + Runtype;
            }
        }
    }

    protected void readControlInfo() throws Exception {
        this.readCalculationInfo("contrl_options_");
    }

    protected void readBasisInfo() throws Exception {
        this.readCalculationInfo("basis_options_");
    }

    private void readCalculationInfo(String type) throws Exception {
        if (this.calcOptions == null) {
            this.calcOptions = new Hashtable<String, String>();
            this.asc.setInfo("calculationOptions", this.calcOptions);
        }
        while (this.rd() != null && (this.line = this.line.trim()).length() > 0) {
            if (this.line.indexOf("=") < 0) continue;
            String[] tokens = PT.getTokens((String)(PT.rep((String)this.line, (String)"=", (String)" = ") + " ?"));
            for (int i = 0; i < tokens.length; ++i) {
                if (!tokens[i].equals("=")) continue;
                try {
                    String value;
                    String key = type + tokens[i - 1];
                    String string = value = key.equals("basis_options_SPLIT3") ? tokens[++i] + " " + tokens[++i] + " " + tokens[++i] : tokens[++i];
                    if (this.debugging) {
                        Logger.debug((String)(key + " = " + value));
                    }
                    this.calcOptions.put(key, value);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }
}

