/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.Map;
import javajs.util.BS;
import javajs.util.M4;
import javajs.util.P3;
import javajs.util.P3i;
import org.jmol.api.Interface;
import org.jmol.atomdata.RadiusData;
import org.jmol.c.PAL;
import org.jmol.c.VDW;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Group;
import org.jmol.modelset.ModelSet;
import org.jmol.shape.Shape;
import org.jmol.util.BSUtil;
import org.jmol.util.GData;
import org.jmol.util.JmolMolecule;
import org.jmol.util.Vibration;
import org.jmol.viewer.JC;
import org.jmol.viewer.TransformManager;
import org.jmol.viewer.Viewer;

public class ShapeManager {
    private ModelSet ms;
    public Shape[] shapes;
    public Viewer vwr;
    private static final int[] hoverable = new int[]{31, 25, 24, 22, 36};
    private static int clickableMax = hoverable.length - 1;
    public final BS bsRenderableAtoms;
    public final BS bsSlabbedInternal;
    private final int[] navMinMax = new int[4];

    public ShapeManager(Viewer vwr) {
        this.vwr = vwr;
        this.bsRenderableAtoms = new BS();
        this.bsSlabbedInternal = new BS();
    }

    public void setParallel() {
        this.resetShapes();
        this.loadDefaultShapes(this.vwr.ms);
    }

    public void findNearestShapeAtomIndex(int x, int y, Atom[] closest, BS bsNot) {
        if (this.shapes != null) {
            for (int i = 0; i < this.shapes.length && closest[0] == null; ++i) {
                if (this.shapes[i] == null) continue;
                this.shapes[i].findNearestAtomIndex(x, y, closest, bsNot);
            }
        }
    }

    public Object getShapePropertyIndex(int shapeID, String propertyName, int index) {
        if (this.shapes == null || this.shapes[shapeID] == null) {
            return null;
        }
        this.vwr.setShapeErrorState(shapeID, "get " + propertyName);
        Object result = this.shapes[shapeID].getProperty(propertyName, index);
        this.vwr.setShapeErrorState(-1, null);
        return result;
    }

    public boolean getShapePropertyData(int shapeID, String propertyName, Object[] data) {
        if (this.shapes == null || this.shapes[shapeID] == null) {
            return false;
        }
        this.vwr.setShapeErrorState(shapeID, "get " + propertyName);
        boolean result = this.shapes[shapeID].getPropertyData(propertyName, data);
        this.vwr.setShapeErrorState(-1, null);
        return result;
    }

    public int getShapeIdFromObjectName(String objectName) {
        if (this.shapes != null) {
            for (int i = 16; i < 30; ++i) {
                if (this.shapes[i] == null || this.shapes[i].getIndexFromName(objectName) < 0) continue;
                return i;
            }
        }
        return -1;
    }

    public void loadDefaultShapes(ModelSet newModelSet) {
        this.ms = newModelSet;
        if (this.shapes != null) {
            for (int i = 0; i < this.shapes.length; ++i) {
                if (this.shapes[i] == null) continue;
                this.shapes[i].setModelSet(newModelSet);
            }
        }
        this.loadShape(0);
        this.loadShape(1);
    }

    public Shape loadShape(int shapeID) {
        if (this.shapes == null) {
            return null;
        }
        if (this.shapes[shapeID] != null) {
            return this.shapes[shapeID];
        }
        if (shapeID == 2 || shapeID == 3 || shapeID == 4) {
            return null;
        }
        String className = JC.getShapeClassName(shapeID, false);
        Shape shape = (Shape)Interface.getInterface(className, this.vwr, "shape");
        if (shape == null) {
            return null;
        }
        this.vwr.setShapeErrorState(shapeID, "allocate");
        shape.initializeShape(this.vwr, this.ms, shapeID);
        this.vwr.setShapeErrorState(-1, null);
        this.shapes[shapeID] = shape;
        return this.shapes[shapeID];
    }

    public void notifyAtomPositionsChanged(int baseModel, BS bs, M4 mat) {
        Integer Imodel = baseModel;
        BS bsModelAtoms = this.vwr.getModelUndeletedAtomsBitSet(baseModel);
        for (int i = 0; i < 37; ++i) {
            if (this.shapes[i] == null) continue;
            this.setShapePropertyBs(i, "refreshTrajectories", new Object[]{Imodel, bs, mat}, bsModelAtoms);
        }
    }

    public void releaseShape(int shapeID) {
        if (this.shapes != null) {
            this.shapes[shapeID] = null;
        }
    }

    public void resetShapes() {
        this.shapes = new Shape[37];
    }

    public void setShapeSizeBs(int shapeID, int size, RadiusData rd, BS bsSelected) {
        if (this.shapes == null) {
            return;
        }
        if (bsSelected == null && (shapeID != 1 || size != Integer.MAX_VALUE)) {
            bsSelected = this.vwr.bsA();
        }
        if (rd != null && rd.value != 0.0f && rd.vdwType == VDW.TEMP) {
            this.ms.getBfactor100Lo();
        }
        this.vwr.setShapeErrorState(shapeID, "set size");
        if (rd == null ? size != 0 : rd.value != 0.0f) {
            this.loadShape(shapeID);
        }
        if (this.shapes[shapeID] != null) {
            this.shapes[shapeID].setShapeSizeRD(size, rd, bsSelected);
        }
        this.vwr.setShapeErrorState(-1, null);
    }

    public void setLabel(Object strLabel, BS bsSelection) {
        if (strLabel == null) {
            if (this.shapes[5] == null) {
                return;
            }
        } else {
            this.loadShape(5);
            this.setShapeSizeBs(5, 0, null, bsSelection);
        }
        this.setShapePropertyBs(5, "label", strLabel, bsSelection);
    }

    public void setShapePropertyBs(int shapeID, String propertyName, Object value, BS bsSelected) {
        if (this.shapes == null || this.shapes[shapeID] == null) {
            return;
        }
        if (bsSelected == null) {
            bsSelected = this.vwr.bsA();
        }
        this.vwr.setShapeErrorState(shapeID, "set " + propertyName);
        this.shapes[shapeID].setProperty(propertyName.intern(), value, bsSelected);
        this.vwr.setShapeErrorState(-1, null);
    }

    boolean checkFrankclicked(int x, int y) {
        Shape frankShape = this.shapes[36];
        return frankShape != null && frankShape.wasClicked(x, y);
    }

    Map<String, Object> checkObjectClicked(int x, int y, int modifiers, BS bsVisible, boolean drawPicking) {
        Map<String, Object> map = null;
        if (this.vwr.getPickingMode() == 2) {
            return this.shapes[5].checkObjectClicked(x, y, modifiers, bsVisible, false);
        }
        if (modifiers != 0 && this.vwr.getBondPicking() && (map = this.shapes[1].checkObjectClicked(x, y, modifiers, bsVisible, false)) != null) {
            return map;
        }
        for (int i = 0; i < clickableMax; ++i) {
            Shape shape = this.shapes[hoverable[i]];
            if (shape == null || (map = shape.checkObjectClicked(x, y, modifiers, bsVisible, drawPicking)) == null) continue;
            return map;
        }
        return null;
    }

    boolean checkObjectDragged(int prevX, int prevY, int x, int y, int modifiers, BS bsVisible, int iShape) {
        boolean found = false;
        int n = iShape > 0 ? iShape + 1 : 37;
        for (int i = iShape; !found && i < n; ++i) {
            if (this.shapes[i] == null) continue;
            found = this.shapes[i].checkObjectDragged(prevX, prevY, x, y, modifiers, bsVisible);
        }
        return found;
    }

    boolean checkObjectHovered(int x, int y, BS bsVisible, boolean checkBonds) {
        Shape shape = this.shapes[1];
        if (checkBonds && shape != null && shape.checkObjectHovered(x, y, bsVisible)) {
            return true;
        }
        for (int i = 0; i < hoverable.length; ++i) {
            shape = this.shapes[hoverable[i]];
            if (shape == null || !shape.checkObjectHovered(x, y, bsVisible)) continue;
            return true;
        }
        return false;
    }

    public void deleteShapeAtoms(Object[] value, BS bs) {
        if (this.shapes != null) {
            for (int j = 0; j < 37; ++j) {
                if (this.shapes[j] == null) continue;
                this.setShapePropertyBs(j, "deleteModelAtoms", value, bs);
            }
        }
    }

    void deleteVdwDependentShapes(BS bs) {
        if (bs == null) {
            bs = this.vwr.bsA();
        }
        if (this.shapes[24] != null) {
            this.shapes[24].setProperty("deleteVdw", null, bs);
        }
        if (this.shapes[25] != null) {
            this.shapes[25].setProperty("deleteVdw", null, bs);
        }
    }

    public float getAtomShapeValue(int tok, Group group, int atomIndex) {
        int iShape = JC.shapeTokenIndex(tok);
        if (iShape < 0 || this.shapes[iShape] == null) {
            return 0.0f;
        }
        int mad = this.shapes[iShape].getSize(atomIndex);
        if (mad == 0) {
            if ((group.shapeVisibilityFlags & this.shapes[iShape].vf) == 0) {
                return 0.0f;
            }
            mad = this.shapes[iShape].getSizeG(group);
        }
        return (float)mad / 2000.0f;
    }

    public void replaceGroup(Group g0, Group g1) {
        if (this.shapes == null) {
            return;
        }
        for (int i = 9; i < 16; ++i) {
            if (this.shapes[i] == null) continue;
            this.shapes[i].replaceGroup(g0, g1);
        }
    }

    void getObjectMap(Map<String, ?> map, boolean withDollar) {
        if (this.shapes == null) {
            return;
        }
        Boolean bDollar = withDollar;
        for (int i = 16; i < 30; ++i) {
            this.getShapePropertyData(i, "getNames", new Object[]{map, bDollar});
        }
    }

    Object getProperty(Object paramInfo) {
        if (paramInfo.equals("getShapes")) {
            return this.shapes;
        }
        return null;
    }

    public Shape getShape(int i) {
        return this.shapes == null ? null : this.shapes[i];
    }

    public void resetBioshapes(BS bsAllAtoms) {
        if (this.shapes == null) {
            return;
        }
        for (int i = 0; i < this.shapes.length; ++i) {
            if (this.shapes[i] == null || !this.shapes[i].isBioShape) continue;
            this.shapes[i].setModelSet(this.ms);
            this.shapes[i].setShapeSizeRD(0, null, bsAllAtoms);
            this.shapes[i].setProperty("color", (Object)PAL.NONE, bsAllAtoms);
        }
    }

    public void setAtomLabel(String strLabel, int i) {
        if (this.shapes != null) {
            this.shapes[5].setProperty("label:" + strLabel, i, null);
        }
    }

    void setModelVisibility() {
        Shape[] shapes = this.shapes;
        if (shapes == null || shapes[0] == null) {
            return;
        }
        BS bs = this.vwr.getVisibleFramesBitSet();
        for (int i = 8; i < 33; ++i) {
            if (shapes[i] == null) continue;
            shapes[i].setModelVisibilityFlags(bs);
        }
        boolean showHydrogens = this.vwr.getBoolean(603979922);
        BS bsDeleted = this.vwr.slm.bsDeleted;
        Atom[] atoms = this.ms.at;
        this.ms.clearVisibleSets();
        if (atoms.length > 0) {
            int i = this.ms.ac;
            while (--i >= 0) {
                Atom atom = atoms[i];
                atom.shapeVisibilityFlags &= 0xFFFFFFC0;
                if (bsDeleted != null && bsDeleted.get(i) || !bs.get(atom.mi)) continue;
                int f = 1;
                if (this.ms.isAtomHidden(i) || !showHydrogens && atom.getElementNumber() == 1) continue;
                f |= 8;
                if (atom.madAtom != 0) {
                    f |= 0x10;
                }
                atom.setShapeVisibility(f, true);
            }
        }
        this.setShapeVis();
    }

    private void setShapeVis() {
        for (int i = 0; i < 37; ++i) {
            Shape shape = this.shapes[i];
            if (shape == null) continue;
            shape.setAtomClickability();
        }
    }

    public int[] finalizeAtoms(BS bsTranslateSelected, boolean finalizeParams) {
        int i;
        Viewer vwr = this.vwr;
        TransformManager tm = vwr.tm;
        if (finalizeParams) {
            vwr.finalizeTransformParameters();
        }
        if (bsTranslateSelected != null) {
            P3 ptCenter = this.ms.getAtomSetCenter(bsTranslateSelected);
            P3 pt = new P3();
            tm.transformPt3f(ptCenter, pt);
            pt.add(tm.ptOffset);
            tm.unTransformPoint(pt, pt);
            pt.sub(ptCenter);
            vwr.setAtomCoordsRelative(pt, bsTranslateSelected);
            tm.ptOffset.set(0.0f, 0.0f, 0.0f);
            tm.bsSelectedAtoms = null;
        }
        BS bsOK = this.bsRenderableAtoms;
        this.ms.getAtomsInFrame(bsOK);
        Vibration[] vibrationVectors = this.ms.vibrations;
        boolean vibs = vibrationVectors != null && tm.vibrationOn;
        boolean checkOccupancy = this.ms.bsModulated != null && this.ms.occupancies != null;
        Atom[] atoms = this.ms.at;
        boolean haveMods = false;
        BS bsSlabbed = this.bsSlabbedInternal;
        bsSlabbed.clearAll();
        int i2 = bsOK.nextSetBit(0);
        while (i2 >= 0) {
            int occ;
            P3i screen;
            Atom atom = atoms[i2];
            P3i p3i = screen = vibs && atom.hasVibration() ? tm.transformPtVib(atom, vibrationVectors[i2]) : tm.transformPt(atom);
            if (screen.z == 1 && tm.internalSlab && tm.xyzIsSlabbedInternal(atom)) {
                bsSlabbed.set(i2);
            }
            atom.sX = screen.x;
            atom.sY = screen.y;
            atom.sZ = screen.z;
            int d = Math.abs(atom.madAtom);
            if (d == Atom.MAD_GLOBAL) {
                d = (int)(vwr.getFloat(0x44000001) * 2000.0f);
            }
            atom.sD = (short)vwr.tm.scaleToScreen(screen.z, d);
            if (checkOccupancy && vibrationVectors[i2] != null && (occ = vibrationVectors[i2].getOccupancy100(vibs)) != Integer.MIN_VALUE) {
                haveMods = true;
                atom.setShapeVisibility(2, false);
                if (occ >= 0 && occ < 50) {
                    atom.setShapeVisibility(24, false);
                } else {
                    atom.setShapeVisibility(8 | (atom.madAtom > 0 ? 16 : 0), true);
                }
                this.ms.occupancies[atom.i] = Math.abs(occ);
            }
            i2 = bsOK.nextSetBit(i2 + 1);
        }
        if (haveMods) {
            this.setShapeVis();
        }
        GData gdata = vwr.gdata;
        if (tm.slabEnabled) {
            boolean slabByMolecule = vwr.getBoolean(603979940);
            boolean slabByAtom = vwr.getBoolean(603979939);
            int minZ = gdata.slab;
            int maxZ = gdata.depth;
            if (slabByMolecule) {
                JmolMolecule[] molecules = this.ms.getMolecules();
                int moleculeCount = this.ms.getMoleculeCountInModel(-1);
                for (int i3 = 0; i3 < moleculeCount; ++i3) {
                    JmolMolecule m = molecules[i3];
                    int j = 0;
                    int pt = m.firstAtomIndex;
                    if (!bsOK.get(pt)) continue;
                    while (j < m.ac && !gdata.isClippedZ(atoms[pt].sZ - (atoms[pt].sD >> 1))) {
                        ++j;
                        ++pt;
                    }
                    if (j == m.ac) continue;
                    pt = m.firstAtomIndex;
                    for (int k = 0; k < m.ac; ++k) {
                        bsOK.clear(pt);
                        atoms[pt++].sZ = 0;
                    }
                }
            }
            i = bsOK.nextSetBit(0);
            while (i >= 0) {
                Atom atom = atoms[i];
                if (gdata.isClippedZ(atom.sZ - (slabByAtom ? atoms[i].sD >> 1 : 0))) {
                    atom.setClickable(0);
                    int r = (slabByAtom ? -1 : 1) * atom.sD / 2;
                    if (atom.sZ + r < minZ || atom.sZ - r > maxZ || !gdata.isInDisplayRange(atom.sX, atom.sY)) {
                        bsOK.clear(i);
                    }
                }
                i = bsOK.nextSetBit(i + 1);
            }
        }
        if (this.ms.ac == 0 || !vwr.getShowNavigationPoint()) {
            return null;
        }
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxY = Integer.MIN_VALUE;
        i = bsOK.nextSetBit(0);
        while (i >= 0) {
            Atom atom = atoms[i];
            if (atom.sX < minX) {
                minX = atom.sX;
            }
            if (atom.sX > maxX) {
                maxX = atom.sX;
            }
            if (atom.sY < minY) {
                minY = atom.sY;
            }
            if (atom.sY > maxY) {
                maxY = atom.sY;
            }
            i = bsOK.nextSetBit(i + 1);
        }
        this.navMinMax[0] = minX;
        this.navMinMax[1] = maxX;
        this.navMinMax[2] = minY;
        this.navMinMax[3] = maxY;
        return this.navMinMax;
    }

    public void setModelSet(ModelSet modelSet) {
        this.ms = this.vwr.ms = modelSet;
    }

    public void checkInheritedShapes() {
        if (this.shapes[24] == null) {
            return;
        }
        this.setShapePropertyBs(24, "remapInherited", null, null);
    }

    public void restrictSelected(boolean isBond, boolean doInvert) {
        BS bsSelected = this.vwr.slm.getSelectedAtomsNoSubset();
        if (doInvert) {
            this.vwr.slm.invertSelection();
            BS bsSubset = this.vwr.slm.bsSubset;
            if (bsSubset != null) {
                bsSelected = this.vwr.slm.getSelectedAtomsNoSubset();
                bsSelected.and(bsSubset);
                this.vwr.select(bsSelected, false, 0, true);
                BSUtil.invertInPlace(bsSelected, this.vwr.ms.ac);
                bsSelected.and(bsSubset);
            }
        }
        BSUtil.andNot(bsSelected, this.vwr.slm.bsDeleted);
        boolean bondmode = this.vwr.getBoolean(0x24000024);
        if (!isBond) {
            this.vwr.setBooleanProperty("bondModeOr", true);
        }
        this.setShapeSizeBs(1, 0, null, null);
        this.setShapePropertyBs(1, "type", 32768, null);
        this.setShapeSizeBs(1, 0, null, null);
        this.setShapePropertyBs(1, "type", 1023, null);
        BS bs = this.vwr.bsA();
        int iShape = 21;
        while (--iShape >= 0) {
            if (iShape == 6 || this.getShape(iShape) == null) continue;
            this.setShapeSizeBs(iShape, 0, null, bs);
        }
        if (this.getShape(21) != null) {
            this.setShapePropertyBs(21, "off", bs, null);
        }
        this.setLabel(null, bs);
        if (!isBond) {
            this.vwr.setBooleanProperty("bondModeOr", bondmode);
        }
        this.vwr.select(bsSelected, false, 0, true);
    }
}

