<?php
/**
 * Aliases for Special:Gadgets
 *
 * @file
 * @ingroup Extensions
 */

$specialPageAliases = [];

/** English (English) */
$specialPageAliases['en'] = [
	'Gadgets' => [ 'Gadgets' ],
	'GadgetUsage' => [ 'GadgetUsage' ],
];

/** Afrikaans (Afrikaans) */
$specialPageAliases['af'] = [
	'Gadgets' => [ 'Geriewe' ],
];

/** Arabic (العربية) */
$specialPageAliases['ar'] = [
	'Gadgets' => [ 'إضافات' ],
];

/** Egyptian Arabic (مصرى) */
$specialPageAliases['arz'] = [
	'Gadgets' => [ 'ادوات' ],
];

/** Assamese (অসমীয়া) */
$specialPageAliases['as'] = [
	'Gadgets' => [ 'গেজেটসমূহ' ],
];

/** Avaric (авар) */
$specialPageAliases['av'] = [
	'Gadgets' => [ 'Гаджеты' ],
];

/** Bulgarian (български) */
$specialPageAliases['bg'] = [
	'Gadgets' => [ 'Джаджи' ],
];

/** Western Balochi (بلوچی رخشانی) */
$specialPageAliases['bgn'] = [
	'Gadgets' => [ 'وسایل_ئان' ],
];

/** Banjar (Bahasa Banjar) */
$specialPageAliases['bjn'] = [
	'Gadgets' => [ 'Pakakas' ],
];

/** Bengali (বাংলা) */
$specialPageAliases['bn'] = [
	'Gadgets' => [ 'গ্যাজেট' ],
	'GadgetUsage' => [ 'গ্যাজেট_ব্যবহার' ],
];

/** Breton (brezhoneg) */
$specialPageAliases['br'] = [
	'Gadgets' => [ 'Bitrakoù' ],
];

/** Bosnian (bosanski) */
$specialPageAliases['bs'] = [
	'Gadgets' => [ 'Dodaci' ],
];

/** Chechen (нохчийн) */
$specialPageAliases['ce'] = [
	'Gadgets' => [ 'Гаджеташ' ],
];

/** Central Kurdish (کوردیی ناوەندی) */
$specialPageAliases['ckb'] = [
	'Gadgets' => [ 'ئامرازەکان' ],
];

/** Czech (čeština) */
$specialPageAliases['cs'] = [
	'Gadgets' => [ 'Udělátka' ],
];

/** German (Deutsch) */
$specialPageAliases['de'] = [
	'Gadgets' => [ 'Helferlein' ],
];

/** Zazaki (Zazaki) */
$specialPageAliases['diq'] = [
	'Gadgets' => [ 'Gadgeti' ],
];

/** Lower Sorbian (dolnoserbski) */
$specialPageAliases['dsb'] = [
	'Gadgets' => [ 'Gadgety' ],
];

/** Greek (Ελληνικά) */
$specialPageAliases['el'] = [
	'Gadgets' => [ 'Εργαλεία', 'Προσαρτήματα' ],
];

/** Esperanto (Esperanto) */
$specialPageAliases['eo'] = [
	'Gadgets' => [ 'Aldonaĵoj' ],
];

/** Spanish (español) */
$specialPageAliases['es'] = [
	'Gadgets' => [ 'Accesorios', 'Artilugios' ],
];

/** Estonian (eesti) */
$specialPageAliases['et'] = [
	'Gadgets' => [ 'Tööriistad' ],
];

/** Basque (euskara) */
$specialPageAliases['eu'] = [
	'Gadgets' => [ 'Gadgetak' ],
];

/** Persian (فارسی) */
$specialPageAliases['fa'] = [
	'Gadgets' => [ 'ابزارها' ],
	'GadgetUsage' => [ 'استفاده_ابزار' ],
];

/** Finnish (suomi) */
$specialPageAliases['fi'] = [
	'Gadgets' => [ 'Pienoisohjelmat' ],
];

/** Arpitan (arpetan) */
$specialPageAliases['frp'] = [
	'Gadgets' => [ 'Outils' ],
];

/** Galician (galego) */
$specialPageAliases['gl'] = [
	'Gadgets' => [ 'Trebellos' ],
];

/** Swiss German (Alemannisch) */
$specialPageAliases['gsw'] = [
	'Gadgets' => [ 'Hälferli' ],
];

/** Hawaiian (Hawai`i) */
$specialPageAliases['haw'] = [
	'Gadgets' => [ 'Hāmeʻa', 'Hamea' ],
];

/** Hebrew (עברית) */
$specialPageAliases['he'] = [
	'Gadgets' => [ 'גאדג\'טים', 'סקריפטים' ],
];

/** Hindi (हिन्दी) */
$specialPageAliases['hi'] = [
	'Gadgets' => [ 'उपकरण', 'गैजेट' ],
];

/** Croatian (hrvatski) */
$specialPageAliases['hr'] = [
	'Gadgets' => [ 'Dodaci' ],
];

/** Upper Sorbian (hornjoserbsce) */
$specialPageAliases['hsb'] = [
	'Gadgets' => [ 'Specialne_funkcije' ],
];

/** Haitian (Kreyòl ayisyen) */
$specialPageAliases['ht'] = [
	'Gadgets' => [ 'Gajèt' ],
];

/** Hungarian (magyar) */
$specialPageAliases['hu'] = [
	'Gadgets' => [ 'Segédeszközök' ],
];

/** Interlingua (interlingua) */
$specialPageAliases['ia'] = [
	'Gadgets' => [ 'Gadgetes' ],
];

/** Indonesian (Bahasa Indonesia) */
$specialPageAliases['id'] = [
	'Gadgets' => [ 'Alat', 'Gadget' ],
];

/** Italian (italiano) */
$specialPageAliases['it'] = [
	'Gadgets' => [ 'Accessori' ],
];

/** Japanese (日本語) */
$specialPageAliases['ja'] = [
	'Gadgets' => [ 'ガジェット' ],
];

/** Korean (한국어) */
$specialPageAliases['ko'] = [
	'Gadgets' => [ '소도구', '가젯' ],
];

/** Ladino (Ladino) */
$specialPageAliases['lad'] = [
	'Gadgets' => [ 'Instrumenticos' ],
];

/** Luxembourgish (Lëtzebuergesch) */
$specialPageAliases['lb'] = [
	'Gadgets' => [ 'Gadgeten' ],
];

/** Northern Luri (لۊری شومالی) */
$specialPageAliases['lrc'] = [
	'Gadgets' => [ 'گأجئتیا' ],
];

/** Minangkabau (Baso Minangkabau) */
$specialPageAliases['min'] = [
	'Gadgets' => [ 'Pakakeh' ],
];

/** Macedonian (македонски) */
$specialPageAliases['mk'] = [
	'Gadgets' => [ 'Алатки' ],
];

/** Malayalam (മലയാളം) */
$specialPageAliases['ml'] = [
	'Gadgets' => [ 'കൂട' ],
];

/** Marathi (मराठी) */
$specialPageAliases['mr'] = [
	'Gadgets' => [ 'सुविधा' ],
];

/** Malay (Bahasa Melayu) */
$specialPageAliases['ms'] = [
	'Gadgets' => [ 'Gajet' ],
];

/** Maltese (Malti) */
$specialPageAliases['mt'] = [
	'Gadgets' => [ 'Aġġeġġi', 'Aċċessorji' ],
];

/** Norwegian Bokmål (norsk bokmål) */
$specialPageAliases['nb'] = [
	'Gadgets' => [ 'Tilleggsfunksjoner' ],
];

/** Low Saxon (Netherlands) (Nedersaksies) */
$specialPageAliases['nds-nl'] = [
	'Gadgets' => [ 'Technies_spul' ],
];

/** Dutch (Nederlands) */
$specialPageAliases['nl'] = [
	'Gadgets' => [ 'Extensies' ],
];

/** Norwegian Nynorsk (norsk nynorsk) */
$specialPageAliases['nn'] = [
	'Gadgets' => [ 'Tilleggsfunksjonar' ],
];

/** Occitan (occitan) */
$specialPageAliases['oc'] = [
	'Gadgets' => [ 'Gadgèts' ],
];

/** Punjabi (ਪੰਜਾਬੀ) */
$specialPageAliases['pa'] = [
	'Gadgets' => [ 'ਛੋਟੇ_ਸੰਦ', 'ਛੋਟੇ_ਔਜ਼ਾਰ' ],
];

/** Polish (polski) */
$specialPageAliases['pl'] = [
	'Gadgets' => [ 'Gadżety' ],
];

/** Romanian (română) */
$specialPageAliases['ro'] = [
	'Gadgets' => [ 'Gadgeturi' ],
];

/** Russian (русский) */
$specialPageAliases['ru'] = [
	'Gadgets' => [ 'Гаджеты' ],
];

/** Sanskrit (संस्कृतम्) */
$specialPageAliases['sa'] = [
	'Gadgets' => [ 'सुविधा_(गॅजेट)' ],
];

/** Sicilian (sicilianu) */
$specialPageAliases['scn'] = [
	'Gadgets' => [ 'Accessori' ],
];

/** Sinhala (සිංහල) */
$specialPageAliases['si'] = [
	'Gadgets' => [ 'විජෙට්ටු' ],
];

/** Slovak (slovenčina) */
$specialPageAliases['sk'] = [
	'Gadgets' => [ 'Hračky' ],
];

/** Slovenian (slovenščina) */
$specialPageAliases['sl'] = [
	'Gadgets' => [ 'Vtičniki', 'Vticniki' ],
];

/** Serbian (Cyrillic script) (српски (ћирилица)‎) */
$specialPageAliases['sr-ec'] = [
	'Gadgets' => [ 'Гаџети', 'Геџети' ],
];

/** Swedish (svenska) */
$specialPageAliases['sv'] = [
	'Gadgets' => [ 'Finesser' ],
];

/** Thai (ไทย) */
$specialPageAliases['th'] = [
	'Gadgets' => [ 'อุปกรณ์เสริม', 'แกเจต' ],
];

/** Tagalog (Tagalog) */
$specialPageAliases['tl'] = [
	'Gadgets' => [ 'Mga_gadyet' ],
];

/** Turkish (Türkçe) */
$specialPageAliases['tr'] = [
	'Gadgets' => [ 'KüçükAraçlar' ],
];

/** Tatar (Cyrillic script) (татарча) */
$specialPageAliases['tt-cyrl'] = [
	'Gadgets' => [ 'Гаджетлар' ],
];

/** Ukrainian (українська) */
$specialPageAliases['uk'] = [
	'Gadgets' => [ 'Додатки', 'Гаджеты' ],
];

/** Venetian (vèneto) */
$specialPageAliases['vec'] = [
	'Gadgets' => [ 'Strumenti' ],
];

/** Vietnamese (Tiếng Việt) */
$specialPageAliases['vi'] = [
	'Gadgets' => [ 'Tiện_ích', 'Công_cụ_đa_năng' ],
];

/** Chinese (中文) */
$specialPageAliases['zh'] = [
	'Gadgets' => [ '小工具' ],
];

/** Simplified Chinese (中文（简体）‎) */
$specialPageAliases['zh-hans'] = [
	'Gadgets' => [ '小工具' ],
];

/** Traditional Chinese (中文（繁體）‎) */
$specialPageAliases['zh-hant'] = [
	'Gadgets' => [ '小工具' ],
];
