/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.auth;

import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.WaitForProgressToShow;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.net.IdeHttpClientHelpers;
import com.intellij.util.net.ssl.CertificateManager;
import com.intellij.util.proxy.CommonProxy;
import java.io.File;
import java.io.IOException;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URI;
import java.net.URL;
import java.security.KeyManagementException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.TrustManager;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.auth.AcceptResult;
import org.jetbrains.idea.svn.auth.CertificateTrustManager;
import org.jetbrains.idea.svn.auth.SSLServerCertificateAuthenticator;
import org.jetbrains.idea.svn.auth.SvnAuthenticationManager;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.dialogs.SimpleCredentialsDialog;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.SVNAuthentication;

public class AuthenticationService {
    @NotNull
    private final SvnVcs myVcs;
    private final boolean myIsActive;
    private static final Logger LOG = Logger.getInstance(AuthenticationService.class);
    private File myTempDirectory;
    private boolean myProxyCredentialsWereReturned;
    @NotNull
    private final SvnConfiguration myConfiguration;
    private final Set<String> myRequestedCredentials;

    public AuthenticationService(@NotNull SvnVcs vcs, boolean isActive) {
        if (vcs == null) {
            AuthenticationService.$$$reportNull$$$0(0);
        }
        this.myVcs = vcs;
        this.myIsActive = isActive;
        this.myConfiguration = this.myVcs.getSvnConfiguration();
        this.myRequestedCredentials = ContainerUtil.newHashSet();
    }

    @NotNull
    public SvnVcs getVcs() {
        SvnVcs svnVcs = this.myVcs;
        if (svnVcs == null) {
            AuthenticationService.$$$reportNull$$$0(1);
        }
        return svnVcs;
    }

    @Nullable
    public File getTempDirectory() {
        return this.myTempDirectory;
    }

    public boolean isActive() {
        return this.myIsActive;
    }

    @Nullable
    public SVNAuthentication requestCredentials(SVNURL repositoryUrl, String type) {
        SVNAuthentication authentication = null;
        if (repositoryUrl != null) {
            String realm = repositoryUrl.toDecodedString();
            authentication = (SVNAuthentication)this.requestCredentials(realm, type, () -> this.myConfiguration.getInteractiveManager(this.myVcs).getInnerProvider().requestClientAuthentication(type, repositoryUrl, realm, null, null, true));
        }
        if (authentication == null) {
            LOG.warn("Could not get authentication. Type - " + type + ", Url - " + repositoryUrl);
        }
        return authentication;
    }

    @Nullable
    private <T> T requestCredentials(@NotNull String realm, @NotNull String type, @NotNull Getter<T> fromUserProvider) {
        if (realm == null) {
            AuthenticationService.$$$reportNull$$$0(2);
        }
        if (type == null) {
            AuthenticationService.$$$reportNull$$$0(3);
        }
        if (fromUserProvider == null) {
            AuthenticationService.$$$reportNull$$$0(4);
        }
        Object result = null;
        Object data = SvnConfiguration.RUNTIME_AUTH_CACHE.getDataWithLowerCheck(type, realm);
        String key = SvnConfiguration.AuthStorage.getKey(type, realm);
        if (data != null && !this.myRequestedCredentials.contains(key)) {
            result = data;
            this.myRequestedCredentials.add(key);
        } else if (this.myIsActive && (result = fromUserProvider.get()) != null) {
            this.myConfiguration.acknowledge(type, realm, result);
            this.myRequestedCredentials.add(key);
        }
        return (T)result;
    }

    @Nullable
    public String requestSshCredentials(@NotNull String realm, @NotNull SimpleCredentialsDialog.Mode mode, @NotNull String key) {
        if (realm == null) {
            AuthenticationService.$$$reportNull$$$0(5);
        }
        if (mode == null) {
            AuthenticationService.$$$reportNull$$$0(6);
        }
        if (key == null) {
            AuthenticationService.$$$reportNull$$$0(7);
        }
        return (String)this.requestCredentials(realm, StringUtil.toLowerCase((String)mode.toString()), () -> {
            if (mode == null) {
                AuthenticationService.$$$reportNull$$$0(27);
            }
            if (realm == null) {
                AuthenticationService.$$$reportNull$$$0(28);
            }
            if (key == null) {
                AuthenticationService.$$$reportNull$$$0(29);
            }
            Ref answer = new Ref();
            Runnable command = () -> {
                if (mode == null) {
                    AuthenticationService.$$$reportNull$$$0(30);
                }
                if (realm == null) {
                    AuthenticationService.$$$reportNull$$$0(31);
                }
                if (key == null) {
                    AuthenticationService.$$$reportNull$$$0(32);
                }
                SimpleCredentialsDialog dialog = new SimpleCredentialsDialog(this.myVcs.getProject());
                dialog.setup(mode, realm, key, true);
                dialog.setTitle(SvnBundle.message("dialog.title.authentication.required", new Object[0]));
                dialog.setSaveEnabled(false);
                if (dialog.showAndGet()) {
                    answer.set((Object)dialog.getPassword());
                }
            };
            WaitForProgressToShow.runOrInvokeAndWaitAboveProgress((Runnable)command, (ModalityState)ModalityState.any());
            return (String)answer.get();
        });
    }

    @NotNull
    public AcceptResult acceptCertificate(@NotNull SVNURL url, @NotNull String certificateInfo) {
        AcceptResult result;
        String realm;
        String kind;
        Object data;
        if (url == null) {
            AuthenticationService.$$$reportNull$$$0(8);
        }
        if (certificateInfo == null) {
            AuthenticationService.$$$reportNull$$$0(9);
        }
        if ((data = SvnConfiguration.RUNTIME_AUTH_CACHE.getDataWithLowerCheck(kind = "terminal.ssl.server", realm = url.toDecodedString())) != null) {
            result = (AcceptResult)((Object)data);
        } else {
            result = AcceptResult.from(this.getAuthenticationManager().getInnerProvider().acceptServerAuthentication(url, realm, (Object)certificateInfo, true));
            if (!AcceptResult.REJECTED.equals((Object)result)) {
                this.myConfiguration.acknowledge(kind, realm, (Object)result);
            }
        }
        AcceptResult acceptResult = result;
        if (acceptResult == null) {
            AuthenticationService.$$$reportNull$$$0(10);
        }
        return acceptResult;
    }

    public boolean acceptSSLServerCertificate(@Nullable SVNURL repositoryUrl, String realm) throws SvnBindException {
        boolean result;
        if (repositoryUrl == null) {
            return false;
        }
        if (Registry.is((String)"svn.use.svnkit.for.https.server.certificate.check")) {
            result = new SSLServerCertificateAuthenticator(this, repositoryUrl, realm).tryAuthenticate();
        } else {
            HttpClient client = this.getClient(repositoryUrl);
            try {
                client.execute((HttpUriRequest)new HttpGet(repositoryUrl.toDecodedString()));
                result = true;
            }
            catch (IOException e) {
                throw new SvnBindException(AuthenticationService.fixMessage(e), e);
            }
        }
        return result;
    }

    @Nullable
    private static String fixMessage(@NotNull IOException e) {
        if (e == null) {
            AuthenticationService.$$$reportNull$$$0(11);
        }
        String message = null;
        if (e instanceof SSLHandshakeException) {
            if (StringUtil.containsIgnoreCase((String)e.getMessage(), (String)"received fatal alert: handshake_failure")) {
                message = e.getMessage() + ". Please try to specify SSL protocol manually - SSLv3 or TLSv1";
            } else if (e.getCause() != null) {
                message = e.getCause().getMessage();
            }
        }
        return message;
    }

    @NotNull
    private HttpClient getClient(@NotNull SVNURL repositoryUrl) {
        if (repositoryUrl == null) {
            AuthenticationService.$$$reportNull$$$0(12);
        }
        SSLContext sslContext = this.createSslContext(repositoryUrl);
        List<String> supportedProtocols = this.getSupportedSslProtocols();
        SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(sslContext, ArrayUtil.toStringArray(supportedProtocols), null, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        if (this.haveDataForTmpConfig()) {
            IdeHttpClientHelpers.ApacheHttpClient4.setProxyIfEnabled((RequestConfig.Builder)requestConfigBuilder);
            IdeHttpClientHelpers.ApacheHttpClient4.setProxyCredentialsIfEnabled((CredentialsProvider)credentialsProvider);
        }
        CloseableHttpClient closeableHttpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)socketFactory).setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(this.getAuthenticationManager().getReadTimeout(repositoryUrl)).build()).setDefaultRequestConfig(requestConfigBuilder.setConnectTimeout(this.getAuthenticationManager().getConnectTimeout(repositoryUrl)).build()).setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).build();
        if (closeableHttpClient == null) {
            AuthenticationService.$$$reportNull$$$0(13);
        }
        return closeableHttpClient;
    }

    @NotNull
    private List<String> getSupportedSslProtocols() {
        ArrayList result = ContainerUtil.newArrayList();
        switch (this.myConfiguration.getSslProtocols()) {
            case sslv3: {
                result.add("SSLv3");
                break;
            }
            case tlsv1: {
                result.add("TLSv1");
                break;
            }
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            AuthenticationService.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    @NotNull
    private SSLContext createSslContext(@NotNull SVNURL url) {
        if (url == null) {
            AuthenticationService.$$$reportNull$$$0(15);
        }
        SSLContext result = CertificateManager.getSystemSslContext();
        CertificateTrustManager trustManager = new CertificateTrustManager(this, url);
        try {
            result.init(CertificateManager.getDefaultKeyManagers(), new TrustManager[]{trustManager}, null);
        }
        catch (KeyManagementException e) {
            LOG.error((Throwable)e);
        }
        SSLContext sSLContext = result;
        if (sSLContext == null) {
            AuthenticationService.$$$reportNull$$$0(16);
        }
        return sSLContext;
    }

    @NotNull
    public SvnAuthenticationManager getAuthenticationManager() {
        SvnAuthenticationManager svnAuthenticationManager = this.isActive() ? this.myConfiguration.getInteractiveManager(this.myVcs) : this.myConfiguration.getPassiveAuthenticationManager(this.myVcs);
        if (svnAuthenticationManager == null) {
            AuthenticationService.$$$reportNull$$$0(17);
        }
        return svnAuthenticationManager;
    }

    public void clearPassiveCredentials(String realm, SVNURL repositoryUrl, boolean password) {
        if (repositoryUrl == null) {
            return;
        }
        for (String kind : AuthenticationService.getKinds(repositoryUrl, password)) {
            this.myConfiguration.clearCredentials(kind, realm);
        }
    }

    public boolean haveDataForTmpConfig() {
        HttpConfigurable instance = HttpConfigurable.getInstance();
        return this.myConfiguration.isIsUseDefaultProxy() && (instance.USE_HTTP_PROXY || instance.USE_PROXY_PAC);
    }

    @Nullable
    public static Proxy getIdeaDefinedProxy(@NotNull SVNURL url) {
        if (url == null) {
            AuthenticationService.$$$reportNull$$$0(18);
        }
        CommonProxy.getInstance().removeNoProxy(url.getProtocol(), url.getHost(), url.getPort());
        List proxies = CommonProxy.getInstance().select(URI.create(url.toString()));
        if (proxies != null && !proxies.isEmpty()) {
            for (Proxy proxy : proxies) {
                if (!HttpConfigurable.isRealProxy((Proxy)proxy) || !Proxy.Type.HTTP.equals((Object)proxy.type())) continue;
                return proxy;
            }
        }
        return null;
    }

    @Nullable
    public PasswordAuthentication getProxyAuthentication(@NotNull SVNURL repositoryUrl) {
        if (repositoryUrl == null) {
            AuthenticationService.$$$reportNull$$$0(19);
        }
        Proxy proxy = AuthenticationService.getIdeaDefinedProxy(repositoryUrl);
        PasswordAuthentication result = null;
        if (proxy != null) {
            if (this.myProxyCredentialsWereReturned) {
                AuthenticationService.showFailedAuthenticateProxy();
            } else {
                result = AuthenticationService.getProxyAuthentication(proxy, repositoryUrl);
                this.myProxyCredentialsWereReturned = result != null;
            }
        }
        return result;
    }

    private static void showFailedAuthenticateProxy() {
        HttpConfigurable instance = HttpConfigurable.getInstance();
        String message = instance.USE_HTTP_PROXY || instance.USE_PROXY_PAC ? "Failed to authenticate to proxy. You can change proxy credentials in HTTP proxy settings." : "Failed to authenticate to proxy.";
        PopupUtil.showBalloonForActiveComponent((String)message, (MessageType)MessageType.ERROR);
    }

    @Nullable
    private static PasswordAuthentication getProxyAuthentication(@NotNull Proxy proxy, @NotNull SVNURL repositoryUrl) {
        if (proxy == null) {
            AuthenticationService.$$$reportNull$$$0(20);
        }
        if (repositoryUrl == null) {
            AuthenticationService.$$$reportNull$$$0(21);
        }
        PasswordAuthentication result = null;
        try {
            result = Authenticator.requestPasswordAuthentication(repositoryUrl.getHost(), ((InetSocketAddress)proxy.address()).getAddress(), repositoryUrl.getPort(), repositoryUrl.getProtocol(), repositoryUrl.getHost(), repositoryUrl.getProtocol(), new URL(repositoryUrl.toString()), Authenticator.RequestorType.PROXY);
        }
        catch (MalformedURLException e) {
            LOG.info((Throwable)e);
        }
        return result;
    }

    public void reset() {
        if (this.myTempDirectory != null) {
            FileUtil.delete((File)this.myTempDirectory);
        }
    }

    @NotNull
    public static List<String> getKinds(SVNURL url, boolean passwordRequest) {
        if (passwordRequest || "http".equals(url.getProtocol())) {
            List<String> list = Collections.singletonList("svn.simple");
            if (list == null) {
                AuthenticationService.$$$reportNull$$$0(22);
            }
            return list;
        }
        if ("https".equals(url.getProtocol())) {
            List<String> list = Collections.singletonList("svn.ssl.client-passphrase");
            if (list == null) {
                AuthenticationService.$$$reportNull$$$0(23);
            }
            return list;
        }
        if ("svn".equals(url.getProtocol())) {
            List<String> list = Collections.singletonList("svn.simple");
            if (list == null) {
                AuthenticationService.$$$reportNull$$$0(24);
            }
            return list;
        }
        if (url.getProtocol().contains("svn+")) {
            List<String> list = Arrays.asList("svn.ssh", "svn.username");
            if (list == null) {
                AuthenticationService.$$$reportNull$$$0(25);
            }
            return list;
        }
        List<String> list = Collections.singletonList("svn.username");
        if (list == null) {
            AuthenticationService.$$$reportNull$$$0(26);
        }
        return list;
    }

    @Nullable
    public File getSpecialConfigDir() {
        return this.myTempDirectory != null ? this.myTempDirectory : new File(this.myConfiguration.getConfigurationDirectory());
    }

    public void initTmpDir() throws IOException {
        if (this.myTempDirectory == null) {
            this.myTempDirectory = FileUtil.createTempDirectory((String)"tmp", (String)"Subversion");
            FileUtil.copyDir((File)new File(this.myConfiguration.getConfigurationDirectory()), (File)this.myTempDirectory);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 10: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 10: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 1: 
            case 10: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/auth/AuthenticationService";
                break;
            }
            case 2: 
            case 5: 
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "realm";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromUserProvider";
                break;
            }
            case 6: 
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 7: 
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 8: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "certificateInfo";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 12: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositoryUrl";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "proxy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/auth/AuthenticationService";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getVcs";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "acceptCertificate";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getClient";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedSslProtocols";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createSslContext";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getAuthenticationManager";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getKinds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 10: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "requestCredentials";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "requestSshCredentials";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "acceptCertificate";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "fixMessage";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getClient";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createSslContext";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getIdeaDefinedProxy";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getProxyAuthentication";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "lambda$requestSshCredentials$2";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 10: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

