/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.status;

import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tmatesoft.svn.core.wc.SVNStatusType;

public enum StatusType {
    UNUSED("unused"),
    INAPPLICABLE("inapplicable"),
    UNKNOWN("unknown"),
    UNCHANGED("unchanged"),
    MISSING("missing"),
    OBSTRUCTED("obstructed"),
    CHANGED("changed"),
    MERGED("merged"),
    CONFLICTED("conflicted"),
    STATUS_NONE("none"),
    STATUS_NORMAL("normal", ' '),
    STATUS_MODIFIED("modified", 'M'),
    STATUS_ADDED("added", 'A'),
    STATUS_DELETED("deleted", 'D'),
    STATUS_UNVERSIONED("unversioned", '?'),
    STATUS_MISSING("missing", '!'),
    STATUS_REPLACED("replaced", 'R'),
    STATUS_CONFLICTED("conflicted", 'C'),
    STATUS_OBSTRUCTED("obstructed", '~'),
    STATUS_IGNORED("ignored", 'I'),
    STATUS_INCOMPLETE("incomplete", '!'),
    STATUS_EXTERNAL("external", 'X');

    private static final String STATUS_PREFIX = "STATUS_";
    @NotNull
    private static final Map<String, StatusType> ourOtherStatusTypes;
    @NotNull
    private static final Map<String, StatusType> ourStatusTypesForStatusOperation;
    private String myName;
    private char myCode;

    private StatusType(String name) {
        this(name, ' ');
    }

    private StatusType(String name, char code) {
        this.myName = name;
        this.myCode = code;
    }

    public char getCode() {
        return this.myCode;
    }

    public String toString() {
        return this.myName;
    }

    private static void register(@NotNull StatusType action) {
        if (action == null) {
            StatusType.$$$reportNull$$$0(0);
        }
        (action.name().startsWith(STATUS_PREFIX) ? ourStatusTypesForStatusOperation : ourOtherStatusTypes).put(action.myName, action);
    }

    @NotNull
    public static StatusType from(@NotNull SVNStatusType type) {
        if (type == null) {
            StatusType.$$$reportNull$$$0(1);
        }
        StatusType result = ourOtherStatusTypes.get(type.toString());
        if (type != SVNStatusType.CONFLICTED && type != SVNStatusType.OBSTRUCTED && type != SVNStatusType.MISSING) {
            result = (StatusType)((Object)ObjectUtils.chooseNotNull((Object)((Object)ourStatusTypesForStatusOperation.get(type.toString())), (Object)((Object)result)));
        }
        StatusType statusType = (StatusType)((Object)ObjectUtils.notNull((Object)((Object)result), (Object)((Object)UNUSED)));
        if (statusType == null) {
            StatusType.$$$reportNull$$$0(2);
        }
        return statusType;
    }

    @Nullable
    public static StatusType forStatusOperation(@NotNull String statusName) {
        if (statusName == null) {
            StatusType.$$$reportNull$$$0(3);
        }
        return ourStatusTypesForStatusOperation.get(statusName);
    }

    static {
        ourOtherStatusTypes = ContainerUtil.newHashMap();
        ourStatusTypesForStatusOperation = ContainerUtil.newHashMap();
        for (StatusType action : StatusType.values()) {
            StatusType.register(action);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/status/StatusType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statusName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/status/StatusType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "from";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "from";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "forStatusOperation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

