/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.parsing;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.LighterASTTokenNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.lang.impl.PsiBuilderImpl;
import com.intellij.lang.properties.parsing.Parsing;
import com.intellij.lang.properties.parsing.PropertiesElementTypes;
import com.intellij.lang.properties.parsing.PropertiesTokenTypes;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ThreeState;
import com.intellij.util.TripleFunction;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import org.jetbrains.annotations.NotNull;

public class PropertiesParser
implements PsiParser {
    private static final TripleFunction<ASTNode, LighterASTNode, FlyweightCapableTreeStructure<LighterASTNode>, ThreeState> MATCH_BY_KEY = (oldNode, newNode, structure) -> {
        CharSequence newNameStr;
        CharSequence oldNameStr;
        ASTNode oldName;
        if (oldNode.getElementType() == PropertiesElementTypes.PROPERTY && (oldName = oldNode.findChildByType(PropertiesTokenTypes.KEY_CHARACTERS)) != null && !Comparing.equal((CharSequence)(oldNameStr = oldName.getChars()), (CharSequence)(newNameStr = PropertiesParser.findKeyCharacters(newNode, (FlyweightCapableTreeStructure<LighterASTNode>)structure)))) {
            return ThreeState.NO;
        }
        return ThreeState.UNSURE;
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CharSequence findKeyCharacters(LighterASTNode newNode, FlyweightCapableTreeStructure<LighterASTNode> structure) {
        Ref childrenRef = Ref.create(null);
        int childrenCount = structure.getChildren((Object)newNode, childrenRef);
        Object[] children = (LighterASTNode[])childrenRef.get();
        try {
            for (Object aChildren : children) {
                if (aChildren.getTokenType() != PropertiesTokenTypes.KEY_CHARACTERS) continue;
                CharSequence charSequence = ((LighterASTTokenNode)aChildren).getText();
                return charSequence;
            }
            Object[] objectArray = null;
            return objectArray;
        }
        finally {
            structure.disposeChildren(children, childrenCount);
        }
    }

    @NotNull
    public ASTNode parse(@NotNull IElementType root, @NotNull PsiBuilder builder) {
        if (root == null) {
            PropertiesParser.$$$reportNull$$$0(0);
        }
        if (builder == null) {
            PropertiesParser.$$$reportNull$$$0(1);
        }
        this.doParse(root, builder);
        ASTNode aSTNode = builder.getTreeBuilt();
        if (aSTNode == null) {
            PropertiesParser.$$$reportNull$$$0(2);
        }
        return aSTNode;
    }

    @NotNull
    public FlyweightCapableTreeStructure<LighterASTNode> parseLight(IElementType root, PsiBuilder builder) {
        this.doParse(root, builder);
        FlyweightCapableTreeStructure flyweightCapableTreeStructure = builder.getLightTree();
        if (flyweightCapableTreeStructure == null) {
            PropertiesParser.$$$reportNull$$$0(3);
        }
        return flyweightCapableTreeStructure;
    }

    public void doParse(IElementType root, PsiBuilder builder) {
        builder.putUserDataUnprotected(PsiBuilderImpl.CUSTOM_COMPARATOR, MATCH_BY_KEY);
        PsiBuilder.Marker rootMarker = builder.mark();
        PsiBuilder.Marker propertiesList = builder.mark();
        while (!builder.eof()) {
            Parsing.parseProperty(builder);
        }
        propertiesList.done((IElementType)PropertiesElementTypes.PROPERTIES_LIST);
        rootMarker.done(root);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/properties/parsing/PropertiesParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/properties/parsing/PropertiesParser";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "parseLight";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

