/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.actions.CodeInsightEditorAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.actionSystem.DocCommandGroupId;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CodeInsightAction
extends AnAction {
    @Override
    public void actionPerformed(AnActionEvent e) {
        Project project = e.getProject();
        if (project != null) {
            Editor editor = this.getEditor(e.getDataContext(), project, false);
            this.actionPerformedImpl(project, editor);
        }
    }

    @Override
    public boolean startInTransaction() {
        return true;
    }

    @Nullable
    protected Editor getEditor(@NotNull DataContext dataContext, @NotNull Project project, boolean forUpdate) {
        if (dataContext == null) {
            CodeInsightAction.$$$reportNull$$$0(0);
        }
        if (project == null) {
            CodeInsightAction.$$$reportNull$$$0(1);
        }
        return CommonDataKeys.EDITOR.getData(dataContext);
    }

    public void actionPerformedImpl(@NotNull Project project, Editor editor) {
        if (project == null) {
            CodeInsightAction.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            return;
        }
        PsiFile psiFile = PsiUtilBase.getPsiFileInEditor(editor, project);
        if (psiFile == null) {
            return;
        }
        CodeInsightActionHandler handler = this.getHandler();
        PsiElement elementToMakeWritable = handler.getElementToMakeWritable(psiFile);
        if (!(elementToMakeWritable == null || EditorModificationUtil.checkModificationAllowed(editor) && FileModificationService.getInstance().preparePsiElementsForWrite(elementToMakeWritable))) {
            return;
        }
        CommandProcessor.getInstance().executeCommand(project, () -> {
            if (project == null) {
                CodeInsightAction.$$$reportNull$$$0(16);
            }
            Runnable action = () -> {
                if (project == null) {
                    CodeInsightAction.$$$reportNull$$$0(17);
                }
                if (!ApplicationManager.getApplication().isUnitTestMode() && !editor.getContentComponent().isShowing()) {
                    return;
                }
                handler.invoke(project, editor, psiFile);
            };
            if (handler.startInWriteAction()) {
                ApplicationManager.getApplication().runWriteAction(action);
            } else {
                action.run();
            }
        }, this.getCommandName(), DocCommandGroupId.noneGroupId(editor.getDocument()));
    }

    @Override
    public void beforeActionPerformedUpdate(@NotNull AnActionEvent e) {
        if (e == null) {
            CodeInsightAction.$$$reportNull$$$0(3);
        }
        CodeInsightEditorAction.beforeActionPerformedUpdate(e);
        super.beforeActionPerformedUpdate(e);
    }

    @Override
    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        Project project = e.getProject();
        if (project == null) {
            presentation.setEnabled(false);
            return;
        }
        DataContext dataContext = e.getDataContext();
        Editor editor = this.getEditor(dataContext, project, true);
        if (editor == null) {
            presentation.setEnabled(false);
            return;
        }
        PsiFile file = PsiUtilBase.getPsiFileInEditor(editor, project);
        if (file == null) {
            presentation.setEnabled(false);
            return;
        }
        this.update(presentation, project, editor, file, dataContext, e.getPlace());
    }

    protected void update(@NotNull Presentation presentation, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (presentation == null) {
            CodeInsightAction.$$$reportNull$$$0(4);
        }
        if (project == null) {
            CodeInsightAction.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            CodeInsightAction.$$$reportNull$$$0(6);
        }
        if (file == null) {
            CodeInsightAction.$$$reportNull$$$0(7);
        }
        presentation.setEnabled(this.isValidForFile(project, editor, file));
    }

    protected void update(@NotNull Presentation presentation, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, @NotNull DataContext dataContext, @Nullable String actionPlace) {
        if (presentation == null) {
            CodeInsightAction.$$$reportNull$$$0(8);
        }
        if (project == null) {
            CodeInsightAction.$$$reportNull$$$0(9);
        }
        if (editor == null) {
            CodeInsightAction.$$$reportNull$$$0(10);
        }
        if (file == null) {
            CodeInsightAction.$$$reportNull$$$0(11);
        }
        if (dataContext == null) {
            CodeInsightAction.$$$reportNull$$$0(12);
        }
        this.update(presentation, project, editor, file);
    }

    protected boolean isValidForFile(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            CodeInsightAction.$$$reportNull$$$0(13);
        }
        if (editor == null) {
            CodeInsightAction.$$$reportNull$$$0(14);
        }
        if (file == null) {
            CodeInsightAction.$$$reportNull$$$0(15);
        }
        return true;
    }

    @NotNull
    protected abstract CodeInsightActionHandler getHandler();

    protected String getCommandName() {
        String text = this.getTemplatePresentation().getText();
        return text == null ? "" : text;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 9: 
            case 13: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 6: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 7: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/actions/CodeInsightAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformedImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeActionPerformedUpdate";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "isValidForFile";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$actionPerformedImpl$1";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

