/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ClassExtension;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ElementManipulators
extends ClassExtension<ElementManipulator> {
    @NonNls
    public static final String EP_NAME = "com.intellij.lang.elementManipulator";
    public static final ElementManipulators INSTANCE = new ElementManipulators();
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.ElementManipulators");

    private ElementManipulators() {
        super(EP_NAME);
    }

    public static <T extends PsiElement> ElementManipulator<T> getManipulator(@NotNull T element) {
        if (element == null) {
            ElementManipulators.$$$reportNull$$$0(0);
        }
        return (ElementManipulator)INSTANCE.forClass(element.getClass());
    }

    public static int getOffsetInElement(@NotNull PsiElement element) {
        if (element == null) {
            ElementManipulators.$$$reportNull$$$0(1);
        }
        ElementManipulator<PsiElement> manipulator = ElementManipulators.getNotNullManipulator(element);
        return manipulator.getRangeInElement(element).getStartOffset();
    }

    @NotNull
    public static <T extends PsiElement> ElementManipulator<T> getNotNullManipulator(@NotNull T element) {
        ElementManipulator<T> manipulator;
        if (element == null) {
            ElementManipulators.$$$reportNull$$$0(2);
        }
        LOG.assertTrue((manipulator = ElementManipulators.getManipulator(element)) != null, (Object)element.getClass().getName());
        ElementManipulator<T> elementManipulator = manipulator;
        if (elementManipulator == null) {
            ElementManipulators.$$$reportNull$$$0(3);
        }
        return elementManipulator;
    }

    public static TextRange getValueTextRange(@NotNull PsiElement element) {
        ElementManipulator<PsiElement> manipulator;
        if (element == null) {
            ElementManipulators.$$$reportNull$$$0(4);
        }
        return (manipulator = ElementManipulators.getManipulator(element)) == null ? TextRange.from((int)0, (int)element.getTextLength()) : manipulator.getRangeInElement(element);
    }

    @NotNull
    public static String getValueText(@NotNull PsiElement element) {
        TextRange valueTextRange;
        if (element == null) {
            ElementManipulators.$$$reportNull$$$0(5);
        }
        if ((valueTextRange = ElementManipulators.getValueTextRange(element)).isEmpty()) {
            if ("" == null) {
                ElementManipulators.$$$reportNull$$$0(6);
            }
            return "";
        }
        String text = element.getText();
        if (valueTextRange.getEndOffset() > text.length()) {
            LOG.error("Wrong range for " + element + " text: " + text + " range " + valueTextRange);
        }
        String string = valueTextRange.substring(text);
        if (string == null) {
            ElementManipulators.$$$reportNull$$$0(7);
        }
        return string;
    }

    public static <T extends PsiElement> T handleContentChange(@NotNull T element, String text) {
        if (element == null) {
            ElementManipulators.$$$reportNull$$$0(8);
        }
        ElementManipulator<T> manipulator = ElementManipulators.getNotNullManipulator(element);
        return manipulator.handleContentChange(element, text);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/ElementManipulators";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/ElementManipulators";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotNullManipulator";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getManipulator";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getOffsetInElement";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getNotNullManipulator";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getValueTextRange";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getValueText";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "handleContentChange";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

