/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.MultiMap;
import git4idea.GitUtil;
import git4idea.branch.GitRebaseParams;
import git4idea.changes.GitChangeUtils;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitUntrackedFilesOverwrittenByOperationDetector;
import git4idea.merge.GitConflictResolver;
import git4idea.rebase.GitRebaseLineListener;
import git4idea.rebase.GitRebaseProblemDetector;
import git4idea.rebase.GitRebaseResumeMode;
import git4idea.rebase.GitRebaseSpec;
import git4idea.rebase.GitRebaseStatus;
import git4idea.rebase.GitRebaseUtils;
import git4idea.rebase.GitSuccessfulRebase;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.stash.GitChangesSaver;
import git4idea.util.GitFreezingProcess;
import git4idea.util.GitUntrackedFilesHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitRebaseProcess {
    private static final Logger LOG = Logger.getInstance(GitRebaseProcess.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final Git myGit;
    @NotNull
    private final ChangeListManager myChangeListManager;
    @NotNull
    private final VcsNotifier myNotifier;
    @NotNull
    private final GitRepositoryManager myRepositoryManager;
    @NotNull
    private final GitRebaseSpec myRebaseSpec;
    @Nullable
    private final GitRebaseResumeMode myCustomMode;
    @NotNull
    private final GitChangesSaver mySaver;
    @NotNull
    private final ProgressManager myProgressManager;

    public GitRebaseProcess(@NotNull Project project, @NotNull GitRebaseSpec rebaseSpec, @Nullable GitRebaseResumeMode customMode) {
        if (project == null) {
            GitRebaseProcess.$$$reportNull$$$0(0);
        }
        if (rebaseSpec == null) {
            GitRebaseProcess.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myRebaseSpec = rebaseSpec;
        this.myCustomMode = customMode;
        this.mySaver = rebaseSpec.getSaver();
        this.myGit = Git.getInstance();
        this.myChangeListManager = ChangeListManager.getInstance((Project)this.myProject);
        this.myNotifier = VcsNotifier.getInstance((Project)this.myProject);
        this.myRepositoryManager = GitUtil.getRepositoryManager(this.myProject);
        this.myProgressManager = ProgressManager.getInstance();
    }

    public void rebase() {
        new GitFreezingProcess(this.myProject, "rebase", this::doRebase).execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRebase() {
        LOG.info("Started rebase");
        LOG.debug("Started rebase with the following spec: " + this.myRebaseSpec);
        LinkedHashMap statuses = ContainerUtil.newLinkedHashMap(this.myRebaseSpec.getStatuses());
        List<GitRepository> repositoriesToRebase = this.myRepositoryManager.sortByDependency(this.myRebaseSpec.getIncompleteRepositories());
        AccessToken token = DvcsUtil.workingTreeChangeStarted((Project)this.myProject);
        try {
            if (!this.saveDirtyRootsInitially(repositoriesToRebase)) {
                return;
            }
            GitRepository failed = null;
            for (GitRepository repository : repositoriesToRebase) {
                GitRebaseResumeMode customMode = null;
                if (repository == this.myRebaseSpec.getOngoingRebase()) {
                    customMode = this.myCustomMode == null ? GitRebaseResumeMode.CONTINUE : this.myCustomMode;
                }
                Collection<Change> changes = this.collectFutureChanges(repository);
                GitRebaseStatus rebaseStatus = this.rebaseSingleRoot(repository, customMode, GitRebaseProcess.getSuccessfulRepositories(statuses));
                repository.update();
                statuses.put(repository, rebaseStatus);
                if (this.shouldBeRefreshed(rebaseStatus)) {
                    GitUtil.refreshVfs(repository.getRoot(), changes);
                }
                if (rebaseStatus.getType() == GitRebaseStatus.Type.SUCCESS) continue;
                failed = repository;
                break;
            }
            if (failed == null) {
                LOG.debug("Rebase completed successfully.");
                this.mySaver.load();
            }
            if (failed == null) {
                this.notifySuccess(GitRebaseProcess.getSuccessfulRepositories(statuses), GitRebaseProcess.getSkippedCommits(statuses));
            }
            this.saveUpdatedSpec(statuses);
        }
        catch (ProcessCanceledException pce) {
            throw pce;
        }
        catch (Throwable e) {
            this.myRepositoryManager.setOngoingRebaseSpec(null);
            ExceptionUtil.rethrowUnchecked((Throwable)e);
        }
        finally {
            token.finish();
        }
    }

    @Nullable
    private Collection<Change> collectFutureChanges(@NotNull GitRepository repository) {
        String rev2;
        String rev1;
        Collection<Change> changesFromRebase;
        GitRebaseParams params;
        if (repository == null) {
            GitRebaseProcess.$$$reportNull$$$0(2);
        }
        if ((params = this.myRebaseSpec.getParams()) == null) {
            return null;
        }
        ArrayList<Change> changes = new ArrayList<Change>();
        String branch = params.getBranch();
        if (branch != null) {
            Collection<Change> changesFromCheckout = GitChangeUtils.getDiff(repository, "HEAD", branch, false);
            if (changesFromCheckout == null) {
                return null;
            }
            changes.addAll(changesFromCheckout);
        }
        if ((changesFromRebase = GitChangeUtils.getDiff(repository, rev1 = (String)ObjectUtils.coalesce((Object)params.getNewBase(), (Object)branch, (Object)"HEAD"), rev2 = params.getUpstream(), false)) == null) {
            return null;
        }
        changes.addAll(changesFromRebase);
        return changes;
    }

    private void saveUpdatedSpec(@NotNull Map<GitRepository, GitRebaseStatus> statuses) {
        if (statuses == null) {
            GitRebaseProcess.$$$reportNull$$$0(3);
        }
        if (this.myRebaseSpec.shouldBeSaved()) {
            GitRebaseSpec newRebaseInfo = this.myRebaseSpec.cloneWithNewStatuses(statuses);
            this.myRepositoryManager.setOngoingRebaseSpec(newRebaseInfo);
        } else {
            this.myRepositoryManager.setOngoingRebaseSpec(null);
        }
    }

    @NotNull
    private GitRebaseStatus rebaseSingleRoot(@NotNull GitRepository repository, @Nullable GitRebaseResumeMode customMode, @NotNull Map<GitRepository, GitSuccessfulRebase> alreadyRebased) {
        GitRebaseStatus.Type type;
        boolean somethingRebased;
        GitCommandResult result2;
        MultiMap<GitRepository, GitRebaseUtils.CommitInfo> allSkippedCommits;
        ArrayList skippedCommits;
        String repoName;
        block19: {
            ResolveConflictResult resolveResult;
            if (repository == null) {
                GitRebaseProcess.$$$reportNull$$$0(4);
            }
            if (alreadyRebased == null) {
                GitRebaseProcess.$$$reportNull$$$0(5);
            }
            VirtualFile root = repository.getRoot();
            repoName = DvcsUtil.getShortRepositoryName((Repository)repository);
            LOG.info("Rebasing root " + repoName + ", mode: " + ObjectUtils.notNull((Object)((Object)customMode), (Object)"standard"));
            skippedCommits = ContainerUtilRt.newArrayList();
            allSkippedCommits = GitRebaseProcess.getSkippedCommits(alreadyRebased);
            boolean retryWhenDirty = false;
            while (true) {
                GitRebaseProblemDetector rebaseDetector = new GitRebaseProblemDetector();
                GitUntrackedFilesOverwrittenByOperationDetector untrackedDetector = new GitUntrackedFilesOverwrittenByOperationDetector(root);
                GitRebaseLineListener progressListener = new GitRebaseLineListener();
                result2 = this.callRebase(repository, customMode, rebaseDetector, untrackedDetector, progressListener);
                boolean bl = somethingRebased = customMode != null || progressListener.getResult().current > 1;
                if (result2.success()) {
                    if (rebaseDetector.hasStoppedForEditing()) {
                        this.showStoppedForEditingMessage(repository);
                        GitRebaseStatus gitRebaseStatus = new GitRebaseStatus(GitRebaseStatus.Type.SUSPENDED, skippedCommits);
                        if (gitRebaseStatus == null) {
                            GitRebaseProcess.$$$reportNull$$$0(6);
                        }
                        return gitRebaseStatus;
                    }
                    LOG.debug("Successfully rebased " + repoName);
                    GitSuccessfulRebase gitSuccessfulRebase = GitSuccessfulRebase.parseFromOutput(result2.getOutput(), skippedCommits);
                    if (gitSuccessfulRebase == null) {
                        GitRebaseProcess.$$$reportNull$$$0(7);
                    }
                    return gitSuccessfulRebase;
                }
                if (result2.cancelled()) {
                    LOG.info("Rebase was cancelled");
                    throw new ProcessCanceledException();
                }
                if (rebaseDetector.isDirtyTree() && customMode == null && !retryWhenDirty) {
                    LOG.debug("Dirty tree detected in " + repoName);
                    String saveError = this.saveLocalChanges(Collections.singleton(repository.getRoot()));
                    if (saveError == null) {
                        retryWhenDirty = true;
                        continue;
                    }
                    LOG.warn("Couldn't " + this.mySaver.getOperationName() + " root " + repository.getRoot() + ": " + saveError);
                    this.showFatalError(saveError, repository, somethingRebased, alreadyRebased.keySet(), allSkippedCommits);
                    GitRebaseStatus.Type type2 = somethingRebased ? GitRebaseStatus.Type.SUSPENDED : GitRebaseStatus.Type.ERROR;
                    GitRebaseStatus gitRebaseStatus = new GitRebaseStatus(type2, skippedCommits);
                    if (gitRebaseStatus == null) {
                        GitRebaseProcess.$$$reportNull$$$0(8);
                    }
                    return gitRebaseStatus;
                }
                if (untrackedDetector.wasMessageDetected()) {
                    LOG.info("Untracked files detected in " + repoName);
                    this.showUntrackedFilesError(untrackedDetector.getRelativeFilePaths(), repository, somethingRebased, alreadyRebased.keySet(), allSkippedCommits);
                    type = somethingRebased ? GitRebaseStatus.Type.SUSPENDED : GitRebaseStatus.Type.ERROR;
                    GitRebaseStatus gitRebaseStatus = new GitRebaseStatus(type, skippedCommits);
                    if (gitRebaseStatus == null) {
                        GitRebaseProcess.$$$reportNull$$$0(9);
                    }
                    return gitRebaseStatus;
                }
                if (rebaseDetector.isNoChangeError()) {
                    LOG.info("'No changes' situation detected in " + repoName);
                    GitRebaseUtils.CommitInfo currentRebaseCommit = GitRebaseUtils.getCurrentRebaseCommit(this.myProject, root);
                    if (currentRebaseCommit != null) {
                        skippedCommits.add(currentRebaseCommit);
                    }
                    customMode = GitRebaseResumeMode.SKIP;
                    continue;
                }
                if (!rebaseDetector.isMergeConflict()) break block19;
                LOG.info("Merge conflict in " + repoName);
                resolveResult = this.showConflictResolver(repository, false);
                if (resolveResult != ResolveConflictResult.ALL_RESOLVED) break;
                customMode = GitRebaseResumeMode.CONTINUE;
            }
            if (resolveResult == ResolveConflictResult.NOTHING_TO_MERGE) {
                LOG.info("Unmerged changes while rebasing root " + repoName + ": " + result2.getErrorOutputAsJoinedString());
                this.showFatalError(result2.getErrorOutputAsHtmlString(), repository, somethingRebased, alreadyRebased.keySet(), allSkippedCommits);
                GitRebaseStatus.Type type3 = somethingRebased ? GitRebaseStatus.Type.SUSPENDED : GitRebaseStatus.Type.ERROR;
                GitRebaseStatus gitRebaseStatus = new GitRebaseStatus(type3, skippedCommits);
                if (gitRebaseStatus == null) {
                    GitRebaseProcess.$$$reportNull$$$0(10);
                }
                return gitRebaseStatus;
            }
            this.notifyNotAllConflictsResolved(repository, allSkippedCommits);
            GitRebaseStatus gitRebaseStatus = new GitRebaseStatus(GitRebaseStatus.Type.SUSPENDED, skippedCommits);
            if (gitRebaseStatus == null) {
                GitRebaseProcess.$$$reportNull$$$0(11);
            }
            return gitRebaseStatus;
        }
        LOG.info("Error rebasing root " + repoName + ": " + result2.getErrorOutputAsJoinedString());
        this.showFatalError(result2.getErrorOutputAsHtmlString(), repository, somethingRebased, alreadyRebased.keySet(), allSkippedCommits);
        type = somethingRebased ? GitRebaseStatus.Type.SUSPENDED : GitRebaseStatus.Type.ERROR;
        GitRebaseStatus gitRebaseStatus = new GitRebaseStatus(type, skippedCommits);
        if (gitRebaseStatus == null) {
            GitRebaseProcess.$$$reportNull$$$0(12);
        }
        return gitRebaseStatus;
    }

    @NotNull
    private GitCommandResult callRebase(@NotNull GitRepository repository, @Nullable GitRebaseResumeMode mode, GitLineHandlerListener ... listeners) {
        if (repository == null) {
            GitRebaseProcess.$$$reportNull$$$0(13);
        }
        if (listeners == null) {
            GitRebaseProcess.$$$reportNull$$$0(14);
        }
        if (mode == null) {
            GitRebaseParams params = (GitRebaseParams)ObjectUtils.assertNotNull((Object)this.myRebaseSpec.getParams());
            GitCommandResult gitCommandResult = this.myGit.rebase(repository, params, listeners);
            if (gitCommandResult == null) {
                GitRebaseProcess.$$$reportNull$$$0(15);
            }
            return gitCommandResult;
        }
        if (mode == GitRebaseResumeMode.SKIP) {
            GitCommandResult gitCommandResult = this.myGit.rebaseSkip(repository, listeners);
            if (gitCommandResult == null) {
                GitRebaseProcess.$$$reportNull$$$0(16);
            }
            return gitCommandResult;
        }
        LOG.assertTrue(mode == GitRebaseResumeMode.CONTINUE, (Object)("Unexpected rebase mode: " + (Object)((Object)mode)));
        GitCommandResult gitCommandResult = this.myGit.rebaseContinue(repository, listeners);
        if (gitCommandResult == null) {
            GitRebaseProcess.$$$reportNull$$$0(17);
        }
        return gitCommandResult;
    }

    @VisibleForTesting
    @NotNull
    protected Collection<GitRepository> getDirtyRoots(@NotNull Collection<GitRepository> repositories) {
        if (repositories == null) {
            GitRebaseProcess.$$$reportNull$$$0(18);
        }
        Collection<GitRepository> collection = this.findRootsWithLocalChanges(repositories);
        if (collection == null) {
            GitRebaseProcess.$$$reportNull$$$0(19);
        }
        return collection;
    }

    private boolean shouldBeRefreshed(@NotNull GitRebaseStatus rebaseStatus) {
        if (rebaseStatus == null) {
            GitRebaseProcess.$$$reportNull$$$0(20);
        }
        return rebaseStatus.getType() != GitRebaseStatus.Type.SUCCESS || this.shouldRefreshOnSuccess(((GitSuccessfulRebase)rebaseStatus).getSuccessType());
    }

    protected boolean shouldRefreshOnSuccess(@NotNull GitSuccessfulRebase.SuccessType successType) {
        if (successType == null) {
            GitRebaseProcess.$$$reportNull$$$0(21);
        }
        return successType != GitSuccessfulRebase.SuccessType.UP_TO_DATE;
    }

    private static void refresh(@NotNull Collection<GitRepository> repositories) {
        if (repositories == null) {
            GitRebaseProcess.$$$reportNull$$$0(22);
        }
        GitUtil.updateRepositories(repositories);
        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)false, (VirtualFile[])VfsUtilCore.toVirtualFileArray(GitUtil.getRootsFromRepositories(repositories)));
    }

    private boolean saveDirtyRootsInitially(@NotNull List<GitRepository> repositories) {
        List repositoriesToSave;
        if (repositories == null) {
            GitRebaseProcess.$$$reportNull$$$0(23);
        }
        if ((repositoriesToSave = ContainerUtil.filter(repositories, repository -> !repository.equals(this.myRebaseSpec.getOngoingRebase()))).isEmpty()) {
            return true;
        }
        Collection<VirtualFile> rootsToSave = GitUtil.getRootsFromRepositories(this.getDirtyRoots(repositoriesToSave));
        String error = this.saveLocalChanges(rootsToSave);
        if (error != null) {
            this.myNotifier.notifyError("Rebase not Started", error);
            return false;
        }
        return true;
    }

    @Nullable
    private String saveLocalChanges(@NotNull Collection<VirtualFile> rootsToSave) {
        if (rootsToSave == null) {
            GitRebaseProcess.$$$reportNull$$$0(24);
        }
        try {
            this.mySaver.saveLocalChanges(rootsToSave);
            return null;
        }
        catch (VcsException e) {
            LOG.warn((Throwable)e);
            return "Couldn't " + this.mySaver.getSaverName() + " local uncommitted changes:<br/>" + e.getMessage();
        }
    }

    private Collection<GitRepository> findRootsWithLocalChanges(@NotNull Collection<GitRepository> repositories) {
        if (repositories == null) {
            GitRebaseProcess.$$$reportNull$$$0(25);
        }
        return ContainerUtil.filter(repositories, repository -> this.myChangeListManager.haveChangesUnder(repository.getRoot()) != ThreeState.NO);
    }

    protected void notifySuccess(@NotNull Map<GitRepository, GitSuccessfulRebase> successful, final @NotNull MultiMap<GitRepository, GitRebaseUtils.CommitInfo> skippedCommits) {
        String baseBranch;
        if (successful == null) {
            GitRebaseProcess.$$$reportNull$$$0(26);
        }
        if (skippedCommits == null) {
            GitRebaseProcess.$$$reportNull$$$0(27);
        }
        String rebasedBranch = GitRebaseProcess.getCommonCurrentBranchNameIfAllTheSame(this.myRebaseSpec.getAllRepositories());
        List successTypes = ContainerUtil.map(successful.values(), GitSuccessfulRebase::getSuccessType);
        GitSuccessfulRebase.SuccessType commonType = GitRebaseProcess.getItemIfAllTheSame(successTypes, GitSuccessfulRebase.SuccessType.REBASED);
        GitRebaseParams params = this.myRebaseSpec.getParams();
        String string = baseBranch = params == null ? null : (String)ObjectUtils.notNull((Object)params.getNewBase(), (Object)params.getUpstream());
        if ("HEAD".equals(baseBranch)) {
            baseBranch = GitRebaseProcess.getItemIfAllTheSame(this.myRebaseSpec.getInitialBranchNames().values(), baseBranch);
        }
        String message = commonType.formatMessage(rebasedBranch, baseBranch, params != null && params.getBranch() != null);
        message = message + GitRebaseProcess.mentionSkippedCommits(skippedCommits);
        this.myNotifier.notifyMinorInfo("Rebase Successful", message, (NotificationListener)new NotificationListener.Adapter(){

            protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                if (notification == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (e == null) {
                    1.$$$reportNull$$$0(1);
                }
                GitRebaseProcess.this.handlePossibleCommitLinks(e.getDescription(), (MultiMap<GitRepository, GitRebaseUtils.CommitInfo>)skippedCommits);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "e";
                        break;
                    }
                }
                objectArray[1] = "git4idea/rebase/GitRebaseProcess$1";
                objectArray[2] = "hyperlinkActivated";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Nullable
    private static String getCommonCurrentBranchNameIfAllTheSame(@NotNull Collection<GitRepository> repositories) {
        if (repositories == null) {
            GitRebaseProcess.$$$reportNull$$$0(28);
        }
        return GitRebaseProcess.getItemIfAllTheSame(ContainerUtil.map(repositories, Repository::getCurrentBranchName), null);
    }

    @Contract(value="_, !null -> !null")
    private static <T> T getItemIfAllTheSame(@NotNull Collection<T> collection, @Nullable T defaultItem) {
        if (collection == null) {
            GitRebaseProcess.$$$reportNull$$$0(29);
        }
        return (T)(ContainerUtil.newHashSet(collection).size() == 1 ? ContainerUtil.getFirstItem(collection) : defaultItem);
    }

    private void notifyNotAllConflictsResolved(@NotNull GitRepository conflictingRepository, MultiMap<GitRepository, GitRebaseUtils.CommitInfo> skippedCommits) {
        if (conflictingRepository == null) {
            GitRebaseProcess.$$$reportNull$$$0(30);
        }
        String description = "You have to <a href='resolve'>resolve</a> the conflicts and <a href='continue'>continue</a> rebase.<br/>If you want to start from the beginning, you can <a href='abort'>abort</a> rebase.";
        description = description + GitRebaseUtils.mentionLocalChangesRemainingInStash(this.mySaver);
        this.myNotifier.notifyImportantWarning("Rebase Suspended", description, (NotificationListener)new RebaseNotificationListener(conflictingRepository, skippedCommits));
    }

    @NotNull
    private ResolveConflictResult showConflictResolver(@NotNull GitRepository conflicting, boolean calledFromNotification) {
        if (conflicting == null) {
            GitRebaseProcess.$$$reportNull$$$0(31);
        }
        GitConflictResolver.Params params = new GitConflictResolver.Params().setReverse(true);
        RebaseConflictResolver conflictResolver = new RebaseConflictResolver(this.myProject, this.myGit, conflicting, params, calledFromNotification);
        boolean allResolved = conflictResolver.merge();
        if (conflictResolver.myWasNothingToMerge) {
            ResolveConflictResult resolveConflictResult = ResolveConflictResult.NOTHING_TO_MERGE;
            if (resolveConflictResult == null) {
                GitRebaseProcess.$$$reportNull$$$0(32);
            }
            return resolveConflictResult;
        }
        if (allResolved) {
            ResolveConflictResult resolveConflictResult = ResolveConflictResult.ALL_RESOLVED;
            if (resolveConflictResult == null) {
                GitRebaseProcess.$$$reportNull$$$0(33);
            }
            return resolveConflictResult;
        }
        ResolveConflictResult resolveConflictResult = ResolveConflictResult.UNRESOLVED_REMAIN;
        if (resolveConflictResult == null) {
            GitRebaseProcess.$$$reportNull$$$0(34);
        }
        return resolveConflictResult;
    }

    private void showStoppedForEditingMessage(@NotNull GitRepository repository) {
        if (repository == null) {
            GitRebaseProcess.$$$reportNull$$$0(35);
        }
        String description = "Once you are satisfied with your changes you may <a href='continue'>continue</a>";
        this.myNotifier.notifyImportantInfo("Rebase Stopped for Editing", description, (NotificationListener)new RebaseNotificationListener(repository, (MultiMap<GitRepository, GitRebaseUtils.CommitInfo>)MultiMap.empty()));
    }

    private void showFatalError(@NotNull String error, @NotNull GitRepository currentRepository, boolean somethingWasRebased, @NotNull Collection<GitRepository> successful, @NotNull MultiMap<GitRepository, GitRebaseUtils.CommitInfo> skippedCommits) {
        if (error == null) {
            GitRebaseProcess.$$$reportNull$$$0(36);
        }
        if (currentRepository == null) {
            GitRebaseProcess.$$$reportNull$$$0(37);
        }
        if (successful == null) {
            GitRebaseProcess.$$$reportNull$$$0(38);
        }
        if (skippedCommits == null) {
            GitRebaseProcess.$$$reportNull$$$0(39);
        }
        String repo = this.myRepositoryManager.moreThanOneRoot() ? DvcsUtil.getShortRepositoryName((Repository)currentRepository) + ": " : "";
        String description = repo + error + "<br/>" + GitRebaseProcess.mentionRetryAndAbort(somethingWasRebased, successful) + GitRebaseProcess.mentionSkippedCommits(skippedCommits) + GitRebaseUtils.mentionLocalChangesRemainingInStash(this.mySaver);
        String title = this.myRebaseSpec.getOngoingRebase() == null ? "Rebase Failed" : "Continue Rebase Failed";
        this.myNotifier.notifyError(title, description, (NotificationListener)new RebaseNotificationListener(currentRepository, skippedCommits));
    }

    private void showUntrackedFilesError(@NotNull Set<String> untrackedPaths, @NotNull GitRepository currentRepository, boolean somethingWasRebased, @NotNull Collection<GitRepository> successful, MultiMap<GitRepository, GitRebaseUtils.CommitInfo> skippedCommits) {
        if (untrackedPaths == null) {
            GitRebaseProcess.$$$reportNull$$$0(40);
        }
        if (currentRepository == null) {
            GitRebaseProcess.$$$reportNull$$$0(41);
        }
        if (successful == null) {
            GitRebaseProcess.$$$reportNull$$$0(42);
        }
        String message = GitUntrackedFilesHelper.createUntrackedFilesOverwrittenDescription("rebase", true) + GitRebaseProcess.mentionRetryAndAbort(somethingWasRebased, successful) + GitRebaseProcess.mentionSkippedCommits(skippedCommits) + GitRebaseUtils.mentionLocalChangesRemainingInStash(this.mySaver);
        GitUntrackedFilesHelper.notifyUntrackedFilesOverwrittenBy(this.myProject, currentRepository.getRoot(), untrackedPaths, "rebase", message);
    }

    @NotNull
    private static String mentionRetryAndAbort(boolean somethingWasRebased, @NotNull Collection<GitRepository> successful) {
        if (successful == null) {
            GitRebaseProcess.$$$reportNull$$$0(43);
        }
        String string = somethingWasRebased || !successful.isEmpty() ? "You can <a href='retry'>retry</a> or <a href='abort'>abort</a> rebase." : "<a href='retry'>Retry.</a>";
        if (string == null) {
            GitRebaseProcess.$$$reportNull$$$0(44);
        }
        return string;
    }

    @NotNull
    private static String mentionSkippedCommits(@NotNull MultiMap<GitRepository, GitRebaseUtils.CommitInfo> skippedCommits) {
        if (skippedCommits == null) {
            GitRebaseProcess.$$$reportNull$$$0(45);
        }
        if (skippedCommits.isEmpty()) {
            if ("" == null) {
                GitRebaseProcess.$$$reportNull$$$0(46);
            }
            return "";
        }
        String message = "<br/>";
        message = skippedCommits.values().size() == 1 ? message + "The following commit was skipped during rebase:<br/>" : message + "The following commits were skipped during rebase:<br/>";
        String string = message = message + StringUtil.join((Collection)skippedCommits.values(), commitInfo -> {
            String commitMessage = StringUtil.shortenPathWithEllipsis((String)commitInfo.subject, (int)72, (boolean)true);
            String hash = commitInfo.revision.asString();
            String shortHash = DvcsUtil.getShortHash((String)commitInfo.revision.asString());
            return String.format("<a href='%s'>%s</a> %s", hash, shortHash, commitMessage);
        }, (String)"<br/>");
        if (string == null) {
            GitRebaseProcess.$$$reportNull$$$0(47);
        }
        return string;
    }

    @NotNull
    private static MultiMap<GitRepository, GitRebaseUtils.CommitInfo> getSkippedCommits(@NotNull Map<GitRepository, ? extends GitRebaseStatus> statuses) {
        if (statuses == null) {
            GitRebaseProcess.$$$reportNull$$$0(48);
        }
        MultiMap map = MultiMap.create();
        for (GitRepository repository : statuses.keySet()) {
            map.put((Object)repository, statuses.get(repository).getSkippedCommits());
        }
        MultiMap multiMap = map;
        if (multiMap == null) {
            GitRebaseProcess.$$$reportNull$$$0(49);
        }
        return multiMap;
    }

    @NotNull
    private static Map<GitRepository, GitSuccessfulRebase> getSuccessfulRepositories(@NotNull Map<GitRepository, GitRebaseStatus> statuses) {
        if (statuses == null) {
            GitRebaseProcess.$$$reportNull$$$0(50);
        }
        LinkedHashMap map = ContainerUtil.newLinkedHashMap();
        for (GitRepository repository : statuses.keySet()) {
            GitRebaseStatus status = statuses.get(repository);
            if (!(status instanceof GitSuccessfulRebase)) continue;
            map.put(repository, (GitSuccessfulRebase)status);
        }
        LinkedHashMap linkedHashMap = map;
        if (linkedHashMap == null) {
            GitRebaseProcess.$$$reportNull$$$0(51);
        }
        return linkedHashMap;
    }

    private void abort() {
        this.myProgressManager.run((Task)new Task.Backgroundable(this.myProject, "Aborting Rebase Process..."){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                GitRebaseUtils.abort(this.myProject, indicator);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/rebase/GitRebaseProcess$2", "run"));
            }
        });
    }

    private void retry(@NotNull String processTitle) {
        if (processTitle == null) {
            GitRebaseProcess.$$$reportNull$$$0(52);
        }
        this.myProgressManager.run((Task)new Task.Backgroundable(this.myProject, processTitle, true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    3.$$$reportNull$$$0(0);
                }
                GitRebaseUtils.continueRebase(this.myProject);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/rebase/GitRebaseProcess$3", "run"));
            }
        });
    }

    private void handlePossibleCommitLinks(@NotNull String href, @NotNull MultiMap<GitRepository, GitRebaseUtils.CommitInfo> skippedCommits) {
        GitRepository repository;
        if (href == null) {
            GitRebaseProcess.$$$reportNull$$$0(53);
        }
        if (skippedCommits == null) {
            GitRebaseProcess.$$$reportNull$$$0(54);
        }
        if ((repository = GitRebaseProcess.findRootBySkippedCommit(href, skippedCommits)) != null) {
            GitUtil.showSubmittedFiles(this.myProject, href, repository.getRoot(), true, false);
        }
    }

    @Nullable
    private static GitRepository findRootBySkippedCommit(@NotNull String hash, @NotNull MultiMap<GitRepository, GitRebaseUtils.CommitInfo> skippedCommits) {
        if (hash == null) {
            GitRebaseProcess.$$$reportNull$$$0(55);
        }
        if (skippedCommits == null) {
            GitRebaseProcess.$$$reportNull$$$0(56);
        }
        return (GitRepository)ContainerUtil.find((Iterable)skippedCommits.keySet(), repository -> {
            if (skippedCommits == null) {
                GitRebaseProcess.$$$reportNull$$$0(57);
            }
            if (hash == null) {
                GitRebaseProcess.$$$reportNull$$$0(58);
            }
            return ContainerUtil.exists((Iterable)skippedCommits.get(repository), info -> {
                if (hash == null) {
                    GitRebaseProcess.$$$reportNull$$$0(59);
                }
                return info.revision.asString().equals(hash);
            });
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 32: 
            case 33: 
            case 34: 
            case 44: 
            case 46: 
            case 47: 
            case 49: 
            case 51: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 32: 
            case 33: 
            case 34: 
            case 44: 
            case 46: 
            case 47: 
            case 49: 
            case 51: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rebaseSpec";
                break;
            }
            case 2: 
            case 4: 
            case 13: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 3: 
            case 48: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statuses";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alreadyRebased";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 32: 
            case 33: 
            case 34: 
            case 44: 
            case 46: 
            case 47: 
            case 49: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/rebase/GitRebaseProcess";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listeners";
                break;
            }
            case 18: 
            case 22: 
            case 23: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rebaseStatus";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "successType";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootsToSave";
                break;
            }
            case 26: 
            case 38: 
            case 42: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "successful";
                break;
            }
            case 27: 
            case 39: 
            case 45: 
            case 54: 
            case 56: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "skippedCommits";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflictingRepository";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicting";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 37: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentRepository";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "untrackedPaths";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processTitle";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "href";
                break;
            }
            case 55: 
            case 58: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hash";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/rebase/GitRebaseProcess";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "rebaseSingleRoot";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "callRebase";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirtyRoots";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "showConflictResolver";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "mentionRetryAndAbort";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "mentionSkippedCommits";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getSkippedCommits";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuccessfulRepositories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "collectFutureChanges";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "saveUpdatedSpec";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "rebaseSingleRoot";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 32: 
            case 33: 
            case 34: 
            case 44: 
            case 46: 
            case 47: 
            case 49: 
            case 51: {
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "callRebase";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getDirtyRoots";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "shouldBeRefreshed";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "shouldRefreshOnSuccess";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "refresh";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "saveDirtyRootsInitially";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "saveLocalChanges";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findRootsWithLocalChanges";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "notifySuccess";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getCommonCurrentBranchNameIfAllTheSame";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getItemIfAllTheSame";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "notifyNotAllConflictsResolved";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "showConflictResolver";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "showStoppedForEditingMessage";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "showFatalError";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "showUntrackedFilesError";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "mentionRetryAndAbort";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "mentionSkippedCommits";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getSkippedCommits";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getSuccessfulRepositories";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "retry";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "handlePossibleCommitLinks";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "findRootBySkippedCommit";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findRootBySkippedCommit$4";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 32: 
            case 33: 
            case 34: 
            case 44: 
            case 46: 
            case 47: 
            case 49: 
            case 51: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class RebaseNotificationListener
    extends NotificationListener.Adapter {
        @NotNull
        private final GitRepository myCurrentRepository;
        @NotNull
        private final MultiMap<GitRepository, GitRebaseUtils.CommitInfo> mySkippedCommits;

        RebaseNotificationListener(@NotNull GitRepository currentRepository, MultiMap<GitRepository, GitRebaseUtils.CommitInfo> skippedCommits) {
            if (currentRepository == null) {
                RebaseNotificationListener.$$$reportNull$$$0(0);
            }
            if (skippedCommits == null) {
                RebaseNotificationListener.$$$reportNull$$$0(1);
            }
            this.myCurrentRepository = currentRepository;
            this.mySkippedCommits = skippedCommits;
        }

        protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
            String href;
            if (notification == null) {
                RebaseNotificationListener.$$$reportNull$$$0(2);
            }
            if (e == null) {
                RebaseNotificationListener.$$$reportNull$$$0(3);
            }
            if ("abort".equals(href = e.getDescription())) {
                GitRebaseProcess.this.abort();
            } else if ("continue".equals(href)) {
                GitRebaseProcess.this.retry("Continue Rebase Process...");
            } else if ("retry".equals(href)) {
                GitRebaseProcess.this.retry("Retry Rebase Process...");
            } else if ("resolve".equals(href)) {
                GitRebaseProcess.this.showConflictResolver(this.myCurrentRepository, true);
            } else if ("stash".equals(href)) {
                GitRebaseProcess.this.mySaver.showSavedChanges();
            } else {
                GitRebaseProcess.this.handlePossibleCommitLinks(href, (MultiMap<GitRepository, GitRebaseUtils.CommitInfo>)this.mySkippedCommits);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "currentRepository";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "skippedCommits";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "notification";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "git4idea/rebase/GitRebaseProcess$RebaseNotificationListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "hyperlinkActivated";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static enum ResolveConflictResult {
        ALL_RESOLVED,
        NOTHING_TO_MERGE,
        UNRESOLVED_REMAIN;

    }

    private class RebaseConflictResolver
    extends GitConflictResolver {
        private final boolean myCalledFromNotification;
        private boolean myWasNothingToMerge;

        RebaseConflictResolver(@NotNull Project project, @NotNull Git git, @NotNull GitRepository repository, GitConflictResolver.Params params, boolean calledFromNotification) {
            if (project == null) {
                RebaseConflictResolver.$$$reportNull$$$0(0);
            }
            if (git == null) {
                RebaseConflictResolver.$$$reportNull$$$0(1);
            }
            if (repository == null) {
                RebaseConflictResolver.$$$reportNull$$$0(2);
            }
            if (params == null) {
                RebaseConflictResolver.$$$reportNull$$$0(3);
            }
            super(project, git, Collections.singleton(repository.getRoot()), params);
            this.myCalledFromNotification = calledFromNotification;
        }

        @Override
        protected void notifyUnresolvedRemain() {
        }

        @Override
        protected boolean proceedAfterAllMerged() {
            if (this.myCalledFromNotification) {
                GitRebaseProcess.this.retry("Continue Rebase Process...");
            }
            return true;
        }

        @Override
        protected boolean proceedIfNothingToMerge() {
            this.myWasNothingToMerge = true;
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "git";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "repository";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "params";
                    break;
                }
            }
            objectArray[1] = "git4idea/rebase/GitRebaseProcess$RebaseConflictResolver";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

