/*
 * Decompiled with CFR 0.152.
 */
package git4idea.util;

import com.intellij.ide.SaveAndSyncHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerEx;
import org.jetbrains.annotations.NotNull;

public class GitFreezingProcess {
    private static final Logger LOG = Logger.getInstance(GitFreezingProcess.class);
    @NotNull
    private final String myOperationTitle;
    @NotNull
    private final Runnable myRunnable;
    @NotNull
    private final ChangeListManagerEx myChangeListManager;
    @NotNull
    private final ProjectManagerEx myProjectManager;
    @NotNull
    private final SaveAndSyncHandler mySaveAndSyncHandler;

    public GitFreezingProcess(@NotNull Project project, @NotNull String operationTitle, @NotNull Runnable runnable) {
        if (project == null) {
            GitFreezingProcess.$$$reportNull$$$0(0);
        }
        if (operationTitle == null) {
            GitFreezingProcess.$$$reportNull$$$0(1);
        }
        if (runnable == null) {
            GitFreezingProcess.$$$reportNull$$$0(2);
        }
        this.myOperationTitle = operationTitle;
        this.myRunnable = runnable;
        this.myChangeListManager = (ChangeListManagerEx)ChangeListManager.getInstance((Project)project);
        this.myProjectManager = ProjectManagerEx.getInstanceEx();
        this.mySaveAndSyncHandler = SaveAndSyncHandler.getInstance();
    }

    public void execute() {
        LOG.debug("starting");
        try {
            LOG.debug("saving documents, blocking project autosync");
            this.saveAndBlockInAwt();
            LOG.debug("freezing the ChangeListManager");
            this.freeze();
            try {
                LOG.debug("running the operation");
                this.myRunnable.run();
                LOG.debug("operation completed.");
            }
            finally {
                LOG.debug("unfreezing the ChangeListManager");
                this.unfreeze();
            }
        }
        finally {
            LOG.debug("unblocking project autosync");
            this.unblockInAwt();
        }
        LOG.debug("finished.");
    }

    private void saveAndBlockInAwt() {
        ApplicationManager.getApplication().invokeAndWait(() -> {
            this.myProjectManager.blockReloadingProjectOnExternalChanges();
            FileDocumentManager.getInstance().saveAllDocuments();
            this.mySaveAndSyncHandler.blockSaveOnFrameDeactivation();
            this.mySaveAndSyncHandler.blockSyncOnFrameActivation();
        });
    }

    private void unblockInAwt() {
        ApplicationManager.getApplication().invokeAndWait(() -> {
            this.myProjectManager.unblockReloadingProjectOnExternalChanges();
            this.mySaveAndSyncHandler.unblockSaveOnFrameDeactivation();
            this.mySaveAndSyncHandler.unblockSyncOnFrameActivation();
        });
    }

    private void freeze() {
        this.myChangeListManager.freeze("Local changes are not available until Git " + this.myOperationTitle + " is finished.");
    }

    private void unfreeze() {
        this.myChangeListManager.unfreeze();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "operationTitle";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "runnable";
                break;
            }
        }
        objectArray[1] = "git4idea/util/GitFreezingProcess";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

