/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.pydev;

import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.SuspendPolicy;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.jetbrains.python.console.pydev.PydevCompletionVariant;
import com.jetbrains.python.debugger.ArrayChunk;
import com.jetbrains.python.debugger.IPyDebugProcess;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.PyDebuggerException;
import com.jetbrains.python.debugger.PyFrameAccessor;
import com.jetbrains.python.debugger.PyReferringObjectsValue;
import com.jetbrains.python.debugger.PyThreadInfo;
import com.jetbrains.python.debugger.pydev.AbstractCommand;
import com.jetbrains.python.debugger.pydev.ExceptionBreakpointCommandFactory;
import com.jetbrains.python.debugger.pydev.ProcessDebugger;
import com.jetbrains.python.debugger.pydev.PyDebugCallback;
import com.jetbrains.python.debugger.pydev.RemoteDebugger;
import com.jetbrains.python.debugger.pydev.RemoteDebuggerCloseListener;
import com.jetbrains.python.debugger.pydev.ResumeOrStepCommand;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClientModeMultiProcessDebugger
implements ProcessDebugger {
    private static final Logger LOG = Logger.getInstance(ClientModeMultiProcessDebugger.class);
    private final IPyDebugProcess myDebugProcess;
    @NotNull
    private final String myHost;
    private final int myPort;
    @NotNull
    private final RemoteDebugger myMainDebugger;
    private final Object myOtherDebuggersObject;
    private final List<RemoteDebugger> myOtherDebuggers;
    private ThreadRegistry myThreadRegistry;

    public ClientModeMultiProcessDebugger(@NotNull IPyDebugProcess debugProcess, @NotNull String host, int port) {
        if (debugProcess == null) {
            ClientModeMultiProcessDebugger.$$$reportNull$$$0(0);
        }
        if (host == null) {
            ClientModeMultiProcessDebugger.$$$reportNull$$$0(1);
        }
        this.myOtherDebuggersObject = new Object();
        this.myOtherDebuggers = Lists.newArrayList();
        this.myThreadRegistry = new ThreadRegistry();
        this.myDebugProcess = debugProcess;
        this.myHost = host;
        this.myPort = port;
        this.myMainDebugger = this.createDebugger();
        this.myOtherDebuggers.add(this.myMainDebugger);
    }

    @NotNull
    private RemoteDebugger createDebugger() {
        RemoteDebugger remoteDebugger = new RemoteDebugger(this.myDebugProcess, this.myHost, this.myPort){

            @Override
            protected void onProcessCreatedEvent() {
                ApplicationManager.getApplication().executeOnPooledThread(() -> ClientModeMultiProcessDebugger.this.connectToSubprocess());
            }
        };
        if (remoteDebugger == null) {
            ClientModeMultiProcessDebugger.$$$reportNull$$$0(2);
        }
        return remoteDebugger;
    }

    @Override
    public boolean isConnected() {
        return this.getOtherDebuggers().stream().anyMatch(RemoteDebugger::isConnected);
    }

    @Override
    public void waitForConnect() throws Exception {
        Thread.sleep(500L);
        this.myMainDebugger.waitForConnect();
    }

    private void connectToSubprocess() {
        try {
            RemoteDebugger debugger = this.createDebugger();
            debugger.waitForConnect();
            this.addDebugger(debugger);
            this.myDebugProcess.init();
            debugger.run();
            return;
        }
        catch (RuntimeException e) {
            LOG.warn((Throwable)e);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        LOG.debug("Could not connect to subprocess");
    }

    @Override
    public void close() {
        for (ProcessDebugger processDebugger : this.allDebuggers()) {
            processDebugger.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<RemoteDebugger> allDebuggers() {
        ArrayList<RemoteDebugger> result;
        Object object = this.myOtherDebuggersObject;
        synchronized (object) {
            result = new ArrayList<RemoteDebugger>(this.myOtherDebuggers);
        }
        return result;
    }

    @Override
    public void disconnect() {
        for (ProcessDebugger processDebugger : this.allDebuggers()) {
            processDebugger.disconnect();
        }
    }

    @Override
    public String handshake() throws PyDebuggerException {
        return this.myMainDebugger.handshake();
    }

    @Override
    public PyDebugValue evaluate(String threadId, String frameId, String expression, boolean execute2) throws PyDebuggerException {
        return this.debugger(threadId).evaluate(threadId, frameId, expression, execute2);
    }

    @Override
    public PyDebugValue evaluate(String threadId, String frameId, String expression, boolean execute2, boolean trimResult) throws PyDebuggerException {
        return this.debugger(threadId).evaluate(threadId, frameId, expression, execute2, trimResult);
    }

    @Override
    public void consoleExec(String threadId, String frameId, String expression, PyDebugCallback<String> callback) {
        this.debugger(threadId).consoleExec(threadId, frameId, expression, callback);
    }

    @Override
    public XValueChildrenList loadFrame(String threadId, String frameId) throws PyDebuggerException {
        return this.debugger(threadId).loadFrame(threadId, frameId);
    }

    @Override
    public XValueChildrenList loadVariable(String threadId, String frameId, PyDebugValue var) throws PyDebuggerException {
        return this.debugger(threadId).loadVariable(threadId, frameId, var);
    }

    @Override
    public ArrayChunk loadArrayItems(String threadId, String frameId, PyDebugValue var, int rowOffset, int colOffset, int rows, int cols, String format) throws PyDebuggerException {
        return this.debugger(threadId).loadArrayItems(threadId, frameId, var, rowOffset, colOffset, rows, cols, format);
    }

    @Override
    public void loadReferrers(String threadId, String frameId, PyReferringObjectsValue var, PyDebugCallback<XValueChildrenList> callback) {
        this.debugger(threadId).loadReferrers(threadId, frameId, var, callback);
    }

    @NotNull
    private ProcessDebugger debugger(@NotNull String threadId) {
        RemoteDebugger debugger;
        if (threadId == null) {
            ClientModeMultiProcessDebugger.$$$reportNull$$$0(3);
        }
        if ((debugger = this.myThreadRegistry.getDebugger(threadId)) != null) {
            RemoteDebugger remoteDebugger = debugger;
            if (remoteDebugger == null) {
                ClientModeMultiProcessDebugger.$$$reportNull$$$0(4);
            }
            return remoteDebugger;
        }
        for (ProcessDebugger processDebugger : this.getOtherDebuggers()) {
            for (PyThreadInfo thread : processDebugger.getThreads()) {
                if (!threadId.equals(thread.getId())) continue;
                ProcessDebugger processDebugger2 = processDebugger;
                if (processDebugger2 == null) {
                    ClientModeMultiProcessDebugger.$$$reportNull$$$0(5);
                }
                return processDebugger2;
            }
        }
        RemoteDebugger remoteDebugger = this.myMainDebugger;
        if (remoteDebugger == null) {
            ClientModeMultiProcessDebugger.$$$reportNull$$$0(6);
        }
        return remoteDebugger;
    }

    @Override
    public PyDebugValue changeVariable(String threadId, String frameId, PyDebugValue var, String value) throws PyDebuggerException {
        return this.debugger(threadId).changeVariable(threadId, frameId, var, value);
    }

    @Override
    public void loadFullVariableValues(@NotNull String threadId, @NotNull String frameId, @NotNull List<PyFrameAccessor.PyAsyncValue<String>> vars) throws PyDebuggerException {
        if (threadId == null) {
            ClientModeMultiProcessDebugger.$$$reportNull$$$0(7);
        }
        if (frameId == null) {
            ClientModeMultiProcessDebugger.$$$reportNull$$$0(8);
        }
        if (vars == null) {
            ClientModeMultiProcessDebugger.$$$reportNull$$$0(9);
        }
        this.debugger(threadId).loadFullVariableValues(threadId, frameId, vars);
    }

    @Override
    public String loadSource(String path) {
        return this.myMainDebugger.loadSource(path);
    }

    @Override
    public Collection<PyThreadInfo> getThreads() {
        this.cleanOtherDebuggers();
        List<PyThreadInfo> threads = this.collectAllThreads();
        if (!this.isOtherDebuggersEmpty()) {
            return Collections.unmodifiableCollection(Collections2.transform(threads, t -> {
                String threadName = ThreadRegistry.threadName(t.getName(), t.getId());
                PyThreadInfo newThread = new PyThreadInfo(t.getId(), threadName, t.getFrames(), t.getStopReason(), t.getMessage());
                newThread.updateState(t.getState(), t.getFrames());
                return newThread;
            }));
        }
        return Collections.unmodifiableCollection(threads);
    }

    private List<PyThreadInfo> collectAllThreads() {
        ArrayList result = Lists.newArrayList();
        result.addAll(this.myMainDebugger.getThreads());
        for (RemoteDebugger d : this.myOtherDebuggers) {
            result.addAll(d.getThreads());
            for (PyThreadInfo t : d.getThreads()) {
                this.myThreadRegistry.register(t.getId(), d);
            }
        }
        return result;
    }

    private void cleanOtherDebuggers() {
        this.removeDisconnected(this.getOtherDebuggers());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDisconnected(ArrayList<RemoteDebugger> debuggers) {
        boolean allConnected = true;
        for (RemoteDebugger d : debuggers) {
            if (d.isConnected()) continue;
            allConnected = false;
        }
        if (!allConnected) {
            ArrayList newList = Lists.newArrayList();
            for (RemoteDebugger d : debuggers) {
                if (!d.isConnected()) continue;
                newList.add(d);
            }
            Object object = this.myOtherDebuggersObject;
            synchronized (object) {
                this.myOtherDebuggers.clear();
                this.myOtherDebuggers.addAll(newList);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<RemoteDebugger> getOtherDebuggers() {
        Object object = this.myOtherDebuggersObject;
        synchronized (object) {
            return Lists.newArrayList(this.myOtherDebuggers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isOtherDebuggersEmpty() {
        Object object = this.myOtherDebuggersObject;
        synchronized (object) {
            return this.myOtherDebuggers.isEmpty();
        }
    }

    @Override
    public void execute(@NotNull AbstractCommand command) {
        if (command == null) {
            ClientModeMultiProcessDebugger.$$$reportNull$$$0(10);
        }
        for (ProcessDebugger processDebugger : this.allDebuggers()) {
            processDebugger.execute(command);
        }
    }

    @Override
    public void suspendAllThreads() {
        for (ProcessDebugger processDebugger : this.allDebuggers()) {
            processDebugger.suspendAllThreads();
        }
    }

    @Override
    public void suspendThread(String threadId) {
        this.debugger(threadId).suspendThread(threadId);
    }

    @Override
    public void run() throws PyDebuggerException {
        this.myMainDebugger.run();
    }

    @Override
    public void smartStepInto(String threadId, String functionName) {
        this.debugger(threadId).smartStepInto(threadId, functionName);
    }

    @Override
    public void resumeOrStep(String threadId, ResumeOrStepCommand.Mode mode) {
        this.debugger(threadId).resumeOrStep(threadId, mode);
    }

    @Override
    public void setNextStatement(@NotNull String threadId, @NotNull XSourcePosition sourcePosition, @Nullable String functionName, @NotNull PyDebugCallback<Pair<Boolean, String>> callback) {
        if (threadId == null) {
            ClientModeMultiProcessDebugger.$$$reportNull$$$0(11);
        }
        if (sourcePosition == null) {
            ClientModeMultiProcessDebugger.$$$reportNull$$$0(12);
        }
        if (callback == null) {
            ClientModeMultiProcessDebugger.$$$reportNull$$$0(13);
        }
        this.debugger(threadId).setNextStatement(threadId, sourcePosition, functionName, callback);
    }

    @Override
    public void setTempBreakpoint(@NotNull String type, @NotNull String file, int line) {
        if (type == null) {
            ClientModeMultiProcessDebugger.$$$reportNull$$$0(14);
        }
        if (file == null) {
            ClientModeMultiProcessDebugger.$$$reportNull$$$0(15);
        }
        for (ProcessDebugger processDebugger : this.allDebuggers()) {
            processDebugger.setTempBreakpoint(type, file, line);
        }
    }

    @Override
    public void removeTempBreakpoint(@NotNull String file, int line) {
        if (file == null) {
            ClientModeMultiProcessDebugger.$$$reportNull$$$0(16);
        }
        for (ProcessDebugger processDebugger : this.allDebuggers()) {
            processDebugger.removeTempBreakpoint(file, line);
        }
    }

    @Override
    public void setBreakpoint(@NotNull String typeId, @NotNull String file, int line, @Nullable String condition, @Nullable String logExpression, @Nullable String funcName, @NotNull SuspendPolicy policy) {
        if (typeId == null) {
            ClientModeMultiProcessDebugger.$$$reportNull$$$0(17);
        }
        if (file == null) {
            ClientModeMultiProcessDebugger.$$$reportNull$$$0(18);
        }
        if (policy == null) {
            ClientModeMultiProcessDebugger.$$$reportNull$$$0(19);
        }
        for (ProcessDebugger processDebugger : this.allDebuggers()) {
            processDebugger.setBreakpoint(typeId, file, line, condition, logExpression, funcName, policy);
        }
    }

    @Override
    public void removeBreakpoint(@NotNull String typeId, @NotNull String file, int line) {
        if (typeId == null) {
            ClientModeMultiProcessDebugger.$$$reportNull$$$0(20);
        }
        if (file == null) {
            ClientModeMultiProcessDebugger.$$$reportNull$$$0(21);
        }
        for (ProcessDebugger processDebugger : this.allDebuggers()) {
            processDebugger.removeBreakpoint(typeId, file, line);
        }
    }

    @Override
    public void setShowReturnValues(boolean isShowReturnValues) {
        for (ProcessDebugger processDebugger : this.allDebuggers()) {
            processDebugger.setShowReturnValues(isShowReturnValues);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDebugger(RemoteDebugger debugger) {
        Object object = this.myOtherDebuggersObject;
        synchronized (object) {
            this.myOtherDebuggers.add(debugger);
        }
    }

    @Override
    public void addCloseListener(RemoteDebuggerCloseListener listener) {
        this.myMainDebugger.addCloseListener(listener);
    }

    @Override
    public List<PydevCompletionVariant> getCompletions(String threadId, String frameId, String prefix) {
        return this.debugger(threadId).getCompletions(threadId, frameId, prefix);
    }

    @Override
    public String getDescription(String threadId, String frameId, String cmd) {
        return this.debugger(threadId).getDescription(threadId, frameId, cmd);
    }

    @Override
    public void addExceptionBreakpoint(ExceptionBreakpointCommandFactory factory) {
        for (RemoteDebugger d : this.allDebuggers()) {
            d.execute(factory.createAddCommand(d));
        }
    }

    @Override
    public void removeExceptionBreakpoint(ExceptionBreakpointCommandFactory factory) {
        for (RemoteDebugger d : this.allDebuggers()) {
            d.execute(factory.createRemoveCommand(d));
        }
    }

    @Override
    public void suspendOtherThreads(PyThreadInfo thread) {
        for (RemoteDebugger d : this.allDebuggers()) {
            d.suspendOtherThreads(thread);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/debugger/pydev/ClientModeMultiProcessDebugger";
                break;
            }
            case 3: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadId";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameId";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vars";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourcePosition";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 15: 
            case 16: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeId";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "policy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/debugger/pydev/ClientModeMultiProcessDebugger";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createDebugger";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "debugger";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "debugger";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "loadFullVariableValues";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setNextStatement";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setTempBreakpoint";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "removeTempBreakpoint";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setBreakpoint";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "removeBreakpoint";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ThreadRegistry {
        private Map<String, RemoteDebugger> myThreadIdToDebugger = Maps.newHashMap();

        private ThreadRegistry() {
        }

        public void register(String id, RemoteDebugger debugger) {
            this.myThreadIdToDebugger.put(id, debugger);
        }

        public RemoteDebugger getDebugger(String threadId) {
            return this.myThreadIdToDebugger.get(threadId);
        }

        public static String threadName(@NotNull String name, @NotNull String id) {
            int indx;
            if (name == null) {
                ThreadRegistry.$$$reportNull$$$0(0);
            }
            if (id == null) {
                ThreadRegistry.$$$reportNull$$$0(1);
            }
            if ((indx = id.indexOf("_", id.indexOf("_") + 1)) != -1) {
                id = id.substring(0, indx);
            }
            return name + "(" + id + ")";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "id";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/python/debugger/pydev/ClientModeMultiProcessDebugger$ThreadRegistry";
            objectArray[2] = "threadName";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

