/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.ExtendWordSelectionHandler;
import com.intellij.diagnostic.LogEventException;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ExtendWordSelectionHandlerBase
implements ExtendWordSelectionHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.editorActions.ExtendWordSelectionHandlerBase");

    public abstract boolean canSelect(PsiElement var1);

    public List<TextRange> select(PsiElement e, CharSequence editorText, int cursorOffset, Editor editor) {
        TextRange originalRange = e.getTextRange();
        if (originalRange.getEndOffset() > editorText.length()) {
            throw new LogEventException("Invalid element range in " + this.getClass(), "element=" + e + "; range=" + originalRange + "; text length=" + editorText.length() + "; editor=" + editor + "; committed=" + PsiDocumentManager.getInstance((Project)e.getProject()).isCommitted(editor.getDocument()), new Attachment("editor_text.txt", editorText.toString()), new Attachment("psi_text.txt", e.getText()));
        }
        List<TextRange> ranges = ExtendWordSelectionHandlerBase.expandToWholeLine(editorText, originalRange, true);
        if (ranges.size() == 1 && ranges.contains(originalRange)) {
            return ExtendWordSelectionHandlerBase.expandToWholeLine(editorText, originalRange, false);
        }
        return ranges;
    }

    public int getMinimalTextRangeLength(@NotNull PsiElement element, @NotNull CharSequence text, int cursorOffset) {
        if (element == null) {
            ExtendWordSelectionHandlerBase.$$$reportNull$$$0(0);
        }
        if (text == null) {
            ExtendWordSelectionHandlerBase.$$$reportNull$$$0(1);
        }
        return 0;
    }

    public static List<TextRange> expandToWholeLine(CharSequence text, @Nullable TextRange range, boolean isSymmetric) {
        TextRange expanded;
        ArrayList<TextRange> result2 = new ArrayList<TextRange>();
        if (range == null) {
            return result2;
        }
        LOG.assertTrue(range.getEndOffset() <= text.length());
        if (!StringUtil.contains((CharSequence)text, (int)range.getStartOffset(), (int)range.getEndOffset(), (char)'\n')) {
            result2.add(range);
        }
        if ((expanded = ExtendWordSelectionHandlerBase.getExpandedRange(text, range, isSymmetric)) != null) {
            result2.add(expanded);
        } else {
            result2.add(range);
        }
        return result2;
    }

    @Nullable
    private static TextRange getExpandedRange(CharSequence text, TextRange range, boolean isSymmetric) {
        int startOffset = range.getStartOffset();
        int endOffset = range.getEndOffset();
        int index1 = CharArrayUtil.shiftBackward((CharSequence)text, (int)(startOffset - 1), (String)" \t");
        if (endOffset > startOffset && text.charAt(endOffset - 1) == '\n') {
            --endOffset;
        }
        int textLength = text.length();
        int index2 = Math.min(textLength, CharArrayUtil.shiftForward((CharSequence)text, (int)endOffset, (String)" \t"));
        if (index1 < 0 || text.charAt(index1) == '\n' || index2 == textLength || text.charAt(index2) == '\n') {
            if (!isSymmetric) {
                if (index1 < 0 || text.charAt(index1) == '\n') {
                    startOffset = index1 + 1;
                }
                if ((index2 == textLength || text.charAt(index2) == '\n') && (endOffset = index2) < textLength) {
                    ++endOffset;
                }
                return new TextRange(startOffset, endOffset);
            }
            if (!(index1 >= 0 && text.charAt(index1) != '\n' || index2 != textLength && text.charAt(index2) != '\n')) {
                startOffset = index1 + 1;
                endOffset = index2;
                if (endOffset < textLength) {
                    ++endOffset;
                }
                return new TextRange(startOffset, endOffset);
            }
        }
        return null;
    }

    public static List<TextRange> expandToWholeLinesWithBlanks(CharSequence text, TextRange range) {
        int blankLineEnd;
        ArrayList result2 = ContainerUtil.newArrayList();
        result2.addAll(ExtendWordSelectionHandlerBase.expandToWholeLine(text, range, true));
        TextRange last = result2.isEmpty() ? range : (TextRange)result2.get(result2.size() - 1);
        int start = last.getStartOffset();
        int end = last.getEndOffset();
        while ((blankLineEnd = CharArrayUtil.shiftForward((CharSequence)text, (int)end, (String)" \t")) < text.length() && text.charAt(blankLineEnd) == '\n') {
            end = blankLineEnd + 1;
        }
        if (end == last.getEndOffset()) {
            int blankLineStart;
            while (start > 0 && text.charAt(start - 1) == '\n' && (blankLineStart = CharArrayUtil.shiftBackward((CharSequence)text, (int)(start - 2), (String)" \t")) > 0 && text.charAt(blankLineStart) == '\n') {
                start = blankLineStart + 1;
            }
        }
        if (start != last.getStartOffset() || end != last.getEndOffset()) {
            result2.add(new TextRange(start, end));
        }
        return result2;
    }

    public static List<TextRange> expandToWholeLine(CharSequence text, TextRange range) {
        return ExtendWordSelectionHandlerBase.expandToWholeLine(text, range, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "text";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/editorActions/ExtendWordSelectionHandlerBase";
        objectArray[2] = "getMinimalTextRangeLength";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

