/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ex.InspectionProfileModifiableModel;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Descriptor {
    private final String myText;
    private final String[] myGroup;
    private final HighlightDisplayKey myKey;
    private Element myConfig;
    private final InspectionToolWrapper myToolWrapper;
    private final HighlightDisplayLevel myLevel;
    private boolean myEnabled;
    @Nullable
    private final NamedScope myScope;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.ex.Descriptor");
    private final ScopeToolState myState;
    private final InspectionProfileModifiableModel myInspectionProfile;
    private final String myScopeName;

    public Descriptor(@NotNull ScopeToolState state2, @NotNull InspectionProfileModifiableModel inspectionProfile, @NotNull Project project) {
        String[] stringArray;
        if (state2 == null) {
            Descriptor.$$$reportNull$$$0(0);
        }
        if (inspectionProfile == null) {
            Descriptor.$$$reportNull$$$0(1);
        }
        if (project == null) {
            Descriptor.$$$reportNull$$$0(2);
        }
        this.myEnabled = false;
        this.myState = state2;
        this.myInspectionProfile = inspectionProfile;
        InspectionToolWrapper tool = state2.getTool();
        this.myText = tool.getDisplayName();
        String[] groupPath = tool.getGroupPath();
        if (groupPath.length == 0) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = InspectionProfileEntry.GENERAL_GROUP_NAME;
        } else {
            stringArray = groupPath;
        }
        this.myGroup = stringArray;
        this.myKey = HighlightDisplayKey.find((String)tool.getShortName());
        this.myScopeName = state2.getScopeName();
        this.myScope = state2.getScope(project);
        this.myLevel = inspectionProfile.getErrorLevel(this.myKey, this.myScope, project);
        this.myEnabled = inspectionProfile.isToolEnabled(this.myKey, this.myScope, project);
        this.myToolWrapper = tool;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Descriptor)) {
            return false;
        }
        Descriptor descriptor2 = (Descriptor)obj;
        return this.myKey.equals(descriptor2.getKey()) && this.myLevel.equals(descriptor2.getLevel()) && this.myEnabled == descriptor2.isEnabled() && this.myState.equalTo(descriptor2.getState());
    }

    public int hashCode() {
        int hash = this.myKey.hashCode() + 29 * this.myLevel.hashCode();
        return this.myScope != null ? this.myScope.hashCode() + 29 * hash : hash;
    }

    public boolean isEnabled() {
        return this.myEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.myEnabled = enabled;
    }

    public String getText() {
        return this.myText;
    }

    @NotNull
    public HighlightDisplayKey getKey() {
        HighlightDisplayKey highlightDisplayKey = this.myKey;
        if (highlightDisplayKey == null) {
            Descriptor.$$$reportNull$$$0(3);
        }
        return highlightDisplayKey;
    }

    public HighlightDisplayLevel getLevel() {
        return this.myLevel;
    }

    @Nullable
    public Element getConfig() {
        return this.myConfig;
    }

    public void loadConfig() {
        if (this.myConfig == null) {
            InspectionToolWrapper toolWrapper = this.getToolWrapper();
            this.myConfig = Descriptor.createConfigElement(toolWrapper);
        }
    }

    @NotNull
    public InspectionToolWrapper getToolWrapper() {
        InspectionToolWrapper inspectionToolWrapper = this.myToolWrapper;
        if (inspectionToolWrapper == null) {
            Descriptor.$$$reportNull$$$0(4);
        }
        return inspectionToolWrapper;
    }

    @Nullable
    public String loadDescription() {
        this.loadConfig();
        return this.myToolWrapper.loadDescription();
    }

    public InspectionProfileModifiableModel getInspectionProfile() {
        return this.myInspectionProfile;
    }

    public static Element createConfigElement(InspectionToolWrapper toolWrapper) {
        Element element = new Element("options");
        try {
            toolWrapper.getTool().writeSettings(element);
        }
        catch (WriteExternalException e) {
            LOG.error((Throwable)e);
        }
        return element;
    }

    @NotNull
    public String[] getGroup() {
        if (this.myGroup == null) {
            Descriptor.$$$reportNull$$$0(5);
        }
        return this.myGroup;
    }

    @NotNull
    public String getScopeName() {
        String string = this.myScopeName;
        if (string == null) {
            Descriptor.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    public NamedScope getScope() {
        return this.myScope;
    }

    public ScopeToolState getState() {
        return this.myState;
    }

    public String toString() {
        return this.myKey.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionProfile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ex/Descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ex/Descriptor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolWrapper";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroup";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

