/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.gdpr;

import com.intellij.ide.Prefs;
import com.intellij.ide.gdpr.Locations;
import com.intellij.ide.gdpr.Version;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;

public final class EndUserAgreement {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.PrivacyPolicy");
    private static final String POLICY_TEXT_PROPERTY = "jb.privacy.policy.text";
    private static final String PRIVACY_POLICY_DOCUMENT_NAME = "privacy";
    private static final String EULA_DOCUMENT_NAME = "eua";
    private static final String PRIVACY_POLICY_CONTENT_FILE_NAME = "Cached";
    private static final String DEFAULT_DOC_NAME = "privacy";
    private static final String DEFAULT_DOC_EAP_NAME = "privacyEap";
    private static final String ACTIVE_DOC_FILE_NAME = "documentName";
    private static final String ACTIVE_DOC_EAP_FILE_NAME = "documentName.eap";
    private static final String RELATIVE_RESOURCE_PATH = "PrivacyPolicy";
    private static final String VERSION_COMMENT_START = "<!--";
    private static final String VERSION_COMMENT_END = "-->";
    private static final Version MAGIC_VERSION = new Version(999, 999);

    public static File getDocumentContentFile() {
        return EndUserAgreement.getDocumentContentFile(EndUserAgreement.getDocumentName());
    }

    @NotNull
    private static File getDocumentContentFile(String docName) {
        File file2 = new File(EndUserAgreement.getDataRoot(), "privacy".equals(docName) ? PRIVACY_POLICY_CONTENT_FILE_NAME : docName + ".cached");
        if (file2 == null) {
            EndUserAgreement.$$$reportNull$$$0(0);
        }
        return file2;
    }

    @NotNull
    private static File getDocumentNameFile() {
        File file2 = new File(EndUserAgreement.getDataRoot(), ApplicationInfoImpl.getShadowInstance().isEAP() ? ACTIVE_DOC_EAP_FILE_NAME : ACTIVE_DOC_FILE_NAME);
        if (file2 == null) {
            EndUserAgreement.$$$reportNull$$$0(1);
        }
        return file2;
    }

    private static File getDataRoot() {
        return new File(Locations.getDataRoot(), RELATIVE_RESOURCE_PATH);
    }

    private static String getBundledResourcePath(String docName) {
        return "privacy".equals(docName) ? "/PrivacyPolicy.html" : "/" + docName + ".html";
    }

    public static void setAccepted(@NotNull Document doc) {
        Version version;
        if (doc == null) {
            EndUserAgreement.$$$reportNull$$$0(2);
        }
        if ((version = doc.getVersion()).isUnknown()) {
            Prefs.remove((String)EndUserAgreement.getAcceptedVersionKey(doc.getName()));
        } else {
            Prefs.put((String)EndUserAgreement.getAcceptedVersionKey(doc.getName()), (String)version.toString());
        }
    }

    @NotNull
    private static Version getAcceptedVersion(String docName) {
        Version version = Version.fromString(Prefs.get((String)EndUserAgreement.getAcceptedVersionKey(docName), null));
        if (version == null) {
            EndUserAgreement.$$$reportNull$$$0(3);
        }
        return version;
    }

    @NotNull
    public static Document getLatestDocument() {
        String docName;
        block6: {
            Document document;
            Document fromProperty;
            String text = System.getProperty(POLICY_TEXT_PROPERTY, null);
            if (text != null && !(fromProperty = EndUserAgreement.loadContent("privacy", new ByteArrayInputStream(text.getBytes(StandardCharsets.UTF_8)))).getVersion().isUnknown()) {
                Document document2 = fromProperty;
                if (document2 == null) {
                    EndUserAgreement.$$$reportNull$$$0(4);
                }
                return document2;
            }
            docName = EndUserAgreement.getDocumentName();
            try {
                Document fromFile = EndUserAgreement.loadContent(docName, new FileInputStream(EndUserAgreement.getDocumentContentFile(docName)));
                if (fromFile.getVersion().isUnknown()) break block6;
                document = fromFile;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (document == null) {
                EndUserAgreement.$$$reportNull$$$0(5);
            }
            return document;
        }
        Document document = EndUserAgreement.loadContent(docName, EndUserAgreement.class.getResourceAsStream(EndUserAgreement.getBundledResourcePath(docName)));
        if (document == null) {
            EndUserAgreement.$$$reportNull$$$0(6);
        }
        return document;
    }

    public static void update(String docName, String text) {
        try {
            FileUtil.writeToFile((File)EndUserAgreement.getDocumentContentFile(docName), (String)text);
            FileUtil.writeToFile((File)EndUserAgreement.getDocumentNameFile(), (String)docName);
        }
        catch (FileNotFoundException e) {
            LOG.info(e.getMessage());
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @NotNull
    private static Document loadContent(String docName, InputStream stream) {
        block7: {
            if (stream == null) break block7;
            InputStreamReader reader = new InputStreamReader(stream instanceof ByteArrayInputStream ? stream : new BufferedInputStream(stream), StandardCharsets.UTF_8);
            Document document = new Document(docName, new String(FileUtil.adaptiveLoadText((Reader)reader)));
            ((Reader)reader).close();
            Document document2 = document;
            if (document2 == null) {
                EndUserAgreement.$$$reportNull$$$0(7);
            }
            return document2;
            {
                catch (Throwable throwable) {
                    try {
                        ((Reader)reader).close();
                        throw throwable;
                    }
                    catch (IOException e) {
                        LOG.info((Throwable)e);
                    }
                }
            }
        }
        Document document = new Document(docName, "");
        if (document == null) {
            EndUserAgreement.$$$reportNull$$$0(8);
        }
        return document;
    }

    @NotNull
    private static String getDocumentName() {
        block6: {
            String string;
            try {
                String docName = new String(FileUtilRt.loadFileText((File)EndUserAgreement.getDocumentNameFile(), (Charset)StandardCharsets.UTF_8));
                if (StringUtil.isEmptyOrSpaces((String)docName)) break block6;
                string = docName;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (string == null) {
                EndUserAgreement.$$$reportNull$$$0(9);
            }
            return string;
        }
        if ("privacy".equals("privacy")) {
            if ("privacy" == null) {
                EndUserAgreement.$$$reportNull$$$0(10);
            }
            return "privacy";
        }
        String string = ApplicationInfoImpl.getShadowInstance().isEAP() ? DEFAULT_DOC_EAP_NAME : "privacy";
        if (string == null) {
            EndUserAgreement.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    private static String getAcceptedVersionKey(String docName) {
        String string = "privacy".equals(docName) ? "JetBrains.privacy_policy.accepted_version" : "JetBrains.privacy_policy." + docName + "_accepted_version";
        if (string == null) {
            EndUserAgreement.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/gdpr/EndUserAgreement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doc";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocumentContentFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocumentNameFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/gdpr/EndUserAgreement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAcceptedVersion";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLatestDocument";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "loadContent";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocumentName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getAcceptedVersionKey";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setAccepted";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class Document {
        private final String myName;
        private final String myText;
        private final Version myVersion;

        public Document(String name, String text) {
            this.myName = name;
            this.myText = text;
            this.myVersion = Document.parseVersion(text);
        }

        public boolean isAccepted() {
            Version thisVersion = this.getVersion();
            if (thisVersion.isUnknown() || MAGIC_VERSION.equals(thisVersion)) {
                return true;
            }
            Version acceptedByUser = EndUserAgreement.getAcceptedVersion(this.getName());
            return !acceptedByUser.isUnknown() && acceptedByUser.getMajor() >= thisVersion.getMajor();
        }

        public String getName() {
            return this.myName;
        }

        public Version getVersion() {
            return this.myVersion;
        }

        public String getText() {
            return this.myText;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @NotNull
        private static Version parseVersion(String text) {
            block9: {
                if (!StringUtil.isEmptyOrSpaces((String)text)) {
                    BufferedReader reader;
                    block8: {
                        int endComment;
                        int startComment;
                        reader = new BufferedReader(new StringReader(text));
                        String line = reader.readLine();
                        if (line == null || (startComment = line.indexOf(EndUserAgreement.VERSION_COMMENT_START)) < 0 || (endComment = line.indexOf(EndUserAgreement.VERSION_COMMENT_END)) <= startComment) break block8;
                        Version version = Version.fromString(line.substring(startComment + EndUserAgreement.VERSION_COMMENT_START.length(), endComment).trim());
                        reader.close();
                        Version version2 = version;
                        if (version2 == null) {
                            Document.$$$reportNull$$$0(0);
                        }
                        return version2;
                    }
                    try {
                        reader.close();
                        break block9;
                        {
                            catch (Throwable throwable) {
                                reader.close();
                                throw throwable;
                            }
                        }
                    }
                    catch (IOException e) {
                        LOG.info((Throwable)e);
                    }
                }
            }
            Version version = Version.UNKNOWN;
            if (version == null) {
                Document.$$$reportNull$$$0(1);
            }
            return version;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/gdpr/EndUserAgreement$Document", "parseVersion"));
        }
    }
}

