/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.GeneralSettings;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.TipAndTrickBean;
import com.intellij.ide.util.TipUIUtil;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collections;
import java.util.List;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class TipPanel
extends JPanel
implements DialogWrapper.DoNotAskOption {
    private static final JBColor DIVIDER_COLOR = new JBColor(0xD9D9D9, 0x515151);
    private static final int DEFAULT_WIDTH = 400;
    private static final int DEFAULT_HEIGHT = 200;
    private final JEditorPane myBrowser;
    private final JLabel myPoweredByLabel;
    private final List<TipAndTrickBean> myTips = ContainerUtil.newArrayList();

    public TipPanel() {
        this.setLayout(new BorderLayout());
        this.myBrowser = TipUIUtil.createTipBrowser();
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)this.myBrowser, (boolean)true);
        scrollPane.setBorder(JBUI.Borders.customLine((Color)DIVIDER_COLOR, (int)1, (int)0, (int)1, (int)0));
        this.add((Component)scrollPane, "Center");
        this.myPoweredByLabel = new JBLabel();
        this.myPoweredByLabel.setBorder((Border)JBUI.Borders.empty((int)0, (int)10));
        this.myPoweredByLabel.setForeground(SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES.getFgColor());
        this.add((Component)this.myPoweredByLabel, "South");
        Collections.addAll(this.myTips, Extensions.getExtensions(TipAndTrickBean.EP_NAME));
    }

    @Override
    public Dimension getPreferredSize() {
        return new JBDimension(400, 200);
    }

    public void prevTip() {
        TipAndTrickBean tip;
        if (this.myTips.size() == 0) {
            this.myBrowser.setText(IdeBundle.message((String)"error.tips.not.found", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()}));
            return;
        }
        GeneralSettings settings = GeneralSettings.getInstance();
        int lastTip = settings.getLastTip();
        if (--lastTip <= 0) {
            tip = this.myTips.get(this.myTips.size() - 1);
            lastTip = this.myTips.size();
        } else {
            tip = this.myTips.get(lastTip - 1);
        }
        this.setTip(tip, lastTip, this.myBrowser, settings);
    }

    private void setTip(TipAndTrickBean tip, int lastTip, JEditorPane browser, GeneralSettings settings) {
        TipUIUtil.openTipInBrowser(tip, browser);
        this.myPoweredByLabel.setText(TipUIUtil.getPoweredByText(tip));
        settings.setLastTip(lastTip);
    }

    public void nextTip() {
        TipAndTrickBean tip;
        if (this.myTips.size() == 0) {
            this.myBrowser.setText(IdeBundle.message((String)"error.tips.not.found", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()}));
            return;
        }
        GeneralSettings settings = GeneralSettings.getInstance();
        int lastTip = settings.getLastTip();
        if (++lastTip - 1 >= this.myTips.size()) {
            tip = this.myTips.get(0);
            lastTip = 1;
        } else {
            tip = this.myTips.get(lastTip - 1);
        }
        this.setTip(tip, lastTip, this.myBrowser, settings);
    }

    public boolean canBeHidden() {
        return true;
    }

    public boolean shouldSaveOptionsOnCancel() {
        return true;
    }

    public boolean isToBeShown() {
        return !GeneralSettings.getInstance().isShowTipsOnStartup();
    }

    public void setToBeShown(boolean toBeShown, int exitCode) {
        GeneralSettings.getInstance().setShowTipsOnStartup(!toBeShown);
    }

    @NotNull
    public String getDoNotShowMessage() {
        String string = IdeBundle.message((String)"checkbox.show.tips.on.startup", (Object[])new Object[0]);
        if (string == null) {
            TipPanel.$$$reportNull$$$0(0);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/TipPanel", "getDoNotShowMessage"));
    }
}

