/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.scopeChooser;

import com.intellij.ide.DataManager;
import com.intellij.ide.util.scopeChooser.EditScopesDialog;
import com.intellij.ide.util.scopeChooser.IgnoringComboBox;
import com.intellij.ide.util.scopeChooser.ScopeDescriptor;
import com.intellij.ide.util.scopeChooser.ScopeDescriptorProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Condition;
import com.intellij.packageDependencies.ChangeListsScopesProvider;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.PredefinedSearchScopeProvider;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.util.ui.JBUI;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScopeChooserCombo
extends ComboboxWithBrowseButton
implements Disposable {
    private Project myProject;
    private boolean mySuggestSearchInLibs;
    private boolean myPrevSearchFiles;
    private NamedScopesHolder.ScopeListener myScopeListener;
    private NamedScopeManager myNamedScopeManager;
    private DependencyValidationManager myValidationManager;
    private boolean myCurrentSelection = true;
    private boolean myUsageView = true;
    private Condition<ScopeDescriptor> myScopeFilter;
    private boolean myShowEmptyScopes;
    private BrowseListener myBrowseListener = null;

    public ScopeChooserCombo() {
        super((JComboBox)((Object)new IgnoringComboBox(){

            @Override
            protected boolean isIgnored(Object item) {
                return item instanceof ScopeSeparator;
            }
        }));
    }

    public ScopeChooserCombo(Project project, boolean suggestSearchInLibs, boolean prevSearchWholeFiles, String preselect) {
        this();
        this.init(project, suggestSearchInLibs, prevSearchWholeFiles, preselect);
    }

    public void init(Project project, String preselect) {
        this.init(project, false, true, preselect);
    }

    public void init(Project project, boolean suggestSearchInLibs, boolean prevSearchWholeFiles, String preselect) {
        this.init(project, suggestSearchInLibs, prevSearchWholeFiles, preselect, null);
    }

    public void init(Project project, boolean suggestSearchInLibs, boolean prevSearchWholeFiles, String preselect, @Nullable Condition<ScopeDescriptor> scopeFilter) {
        this.mySuggestSearchInLibs = suggestSearchInLibs;
        this.myPrevSearchFiles = prevSearchWholeFiles;
        this.myProject = project;
        this.myScopeListener = () -> {
            SearchScope selectedScope = this.getSelectedScope();
            this.rebuildModel();
            if (selectedScope != null) {
                this.selectScope(selectedScope.getDisplayName());
            }
        };
        this.myScopeFilter = scopeFilter;
        this.myNamedScopeManager = NamedScopeManager.getInstance((Project)project);
        this.myNamedScopeManager.addScopeListener(this.myScopeListener);
        this.myValidationManager = DependencyValidationManager.getInstance((Project)project);
        this.myValidationManager.addScopeListener(this.myScopeListener);
        this.addActionListener(this.createScopeChooserListener());
        ComboBox combo = (ComboBox)this.getComboBox();
        combo.setMinimumAndPreferredWidth(JBUI.scale((int)300));
        combo.setRenderer((ListCellRenderer)((Object)new ScopeDescriptionWithDelimiterRenderer()));
        this.rebuildModel();
        this.selectScope(preselect);
        new ComboboxSpeedSearch((JComboBox)combo){

            @Override
            protected String getElementText(Object element) {
                if (element instanceof ScopeDescriptor) {
                    ScopeDescriptor descriptor2 = (ScopeDescriptor)element;
                    return descriptor2.getDisplay();
                }
                return null;
            }
        };
    }

    public void setBrowseListener(BrowseListener browseListener) {
        this.myBrowseListener = browseListener;
    }

    public void setCurrentSelection(boolean currentSelection) {
        this.myCurrentSelection = currentSelection;
    }

    public void setUsageView(boolean usageView) {
        this.myUsageView = usageView;
    }

    public void dispose() {
        super.dispose();
        if (this.myValidationManager != null) {
            this.myValidationManager.removeScopeListener(this.myScopeListener);
            this.myValidationManager = null;
        }
        if (this.myNamedScopeManager != null) {
            this.myNamedScopeManager.removeScopeListener(this.myScopeListener);
            this.myNamedScopeManager = null;
        }
        this.myScopeListener = null;
    }

    private void selectScope(String preselect) {
        if (preselect != null) {
            JComboBox combo = this.getComboBox();
            DefaultComboBoxModel model = (DefaultComboBoxModel)combo.getModel();
            for (int i = 0; i < model.getSize(); ++i) {
                ScopeDescriptor descriptor2 = (ScopeDescriptor)model.getElementAt(i);
                if (!preselect.equals(descriptor2.getDisplay())) continue;
                combo.setSelectedIndex(i);
                break;
            }
        }
    }

    private ActionListener createScopeChooserListener() {
        return e -> {
            EditScopesDialog dlg;
            String selection = this.getSelectedScopeName();
            if (this.myBrowseListener != null) {
                this.myBrowseListener.onBeforeBrowseStarted();
            }
            if ((dlg = EditScopesDialog.showDialog(this.myProject, selection)).isOK()) {
                this.rebuildModel();
                NamedScope namedScope = dlg.getSelectedScope();
                if (namedScope != null) {
                    this.selectScope(namedScope.getName());
                }
            }
            if (this.myBrowseListener != null) {
                this.myBrowseListener.onAfterBrowseFinished();
            }
        };
    }

    private void rebuildModel() {
        this.getComboBox().setModel(this.createModel());
    }

    @NotNull
    private DefaultComboBoxModel<ScopeDescriptor> createModel() {
        DefaultComboBoxModel<ScopeDescriptor> model = new DefaultComboBoxModel<ScopeDescriptor>();
        this.createPredefinedScopeDescriptors(model);
        List changeLists = ChangeListsScopesProvider.getInstance(this.myProject).getFilteredScopes();
        if (!changeLists.isEmpty()) {
            model.addElement(new ScopeSeparator("VCS Scopes"));
            for (NamedScope changeListScope : changeLists) {
                GlobalSearchScope scope = GlobalSearchScopesCore.filterScope((Project)this.myProject, (NamedScope)changeListScope);
                this.addScopeDescriptor(model, new ScopeDescriptor((SearchScope)scope));
            }
        }
        ArrayList<ScopeDescriptor> customScopes = new ArrayList<ScopeDescriptor>();
        NamedScopesHolder[] holders = NamedScopesHolder.getAllNamedScopeHolders((Project)this.myProject);
        for (NamedScopesHolder holder : holders) {
            NamedScope[] scopes;
            for (NamedScope scope : scopes = holder.getEditableScopes()) {
                GlobalSearchScope searchScope = GlobalSearchScopesCore.filterScope((Project)this.myProject, (NamedScope)scope);
                customScopes.add(new ScopeDescriptor((SearchScope)searchScope));
            }
        }
        if (!customScopes.isEmpty()) {
            model.addElement(new ScopeSeparator("Custom Scopes"));
            for (ScopeDescriptor scope : customScopes) {
                this.addScopeDescriptor(model, scope);
            }
        }
        DefaultComboBoxModel<ScopeDescriptor> defaultComboBoxModel = model;
        if (defaultComboBoxModel == null) {
            ScopeChooserCombo.$$$reportNull$$$0(0);
        }
        return defaultComboBoxModel;
    }

    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        Dimension preferredSize = super.getPreferredSize();
        return new Dimension(Math.min(400, preferredSize.width), preferredSize.height);
    }

    public Dimension getMinimumSize() {
        if (this.isMinimumSizeSet()) {
            return super.getMinimumSize();
        }
        Dimension minimumSize = super.getMinimumSize();
        return new Dimension(Math.min(200, minimumSize.width), minimumSize.height);
    }

    private void createPredefinedScopeDescriptors(@NotNull DefaultComboBoxModel<ScopeDescriptor> model) {
        if (model == null) {
            ScopeChooserCombo.$$$reportNull$$$0(1);
        }
        DataContext context = DataManager.getInstance().getDataContext();
        for (SearchScope scope : PredefinedSearchScopeProvider.getInstance().getPredefinedScopes(this.myProject, context, this.mySuggestSearchInLibs, this.myPrevSearchFiles, this.myCurrentSelection, this.myUsageView, this.myShowEmptyScopes)) {
            this.addScopeDescriptor(model, new ScopeDescriptor(scope));
        }
        for (ScopeDescriptorProvider provider : (ScopeDescriptorProvider[])Extensions.getExtensions(ScopeDescriptorProvider.EP_NAME)) {
            for (ScopeDescriptor scopeDescriptor : provider.getScopeDescriptors(this.myProject)) {
                if (this.myScopeFilter != null && !this.myScopeFilter.value((Object)scopeDescriptor)) continue;
                model.addElement(scopeDescriptor);
            }
        }
    }

    private void addScopeDescriptor(DefaultComboBoxModel<ScopeDescriptor> model, ScopeDescriptor scopeDescriptor) {
        if (this.myScopeFilter == null || this.myScopeFilter.value((Object)scopeDescriptor)) {
            model.addElement(scopeDescriptor);
        }
    }

    public void setShowEmptyScopes(boolean showEmptyScopes) {
        this.myShowEmptyScopes = showEmptyScopes;
    }

    @Nullable
    public SearchScope getSelectedScope() {
        JComboBox combo = this.getComboBox();
        int idx = combo.getSelectedIndex();
        return idx < 0 ? null : ((ScopeDescriptor)combo.getSelectedItem()).getScope();
    }

    @Nullable
    public String getSelectedScopeName() {
        JComboBox combo = this.getComboBox();
        int idx = combo.getSelectedIndex();
        return idx < 0 ? null : ((ScopeDescriptor)combo.getSelectedItem()).getDisplay();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/scopeChooser/ScopeChooserCombo";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/scopeChooser/ScopeChooserCombo";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createPredefinedScopeDescriptors";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface BrowseListener {
        public void onBeforeBrowseStarted();

        public void onAfterBrowseFinished();
    }

    private static class ScopeDescriptionWithDelimiterRenderer
    extends ListCellRendererWrapper<ScopeDescriptor> {
        private ScopeDescriptionWithDelimiterRenderer() {
        }

        public void customize(JList list2, ScopeDescriptor value, int index, boolean selected, boolean hasFocus) {
            this.setText(value.getDisplay());
            if (value instanceof ScopeSeparator) {
                this.setSeparator();
            }
        }
    }

    private static class ScopeSeparator
    extends ScopeDescriptor {
        private final String myText;

        ScopeSeparator(@NotNull String text) {
            if (text == null) {
                ScopeSeparator.$$$reportNull$$$0(0);
            }
            super(null);
            this.myText = text;
        }

        @Override
        public String getDisplay() {
            return this.myText;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/ide/util/scopeChooser/ScopeChooserCombo$ScopeSeparator", "<init>"));
        }
    }
}

