/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorComposite;
import com.intellij.openapi.fileEditor.impl.HistoryEntry;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;

public class EditorWithProviderComposite
extends EditorComposite {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.fileEditor.impl.EditorWithProviderComposite");
    private FileEditorProvider[] myProviders;

    EditorWithProviderComposite(@NotNull VirtualFile file2, @NotNull FileEditor[] editors, @NotNull FileEditorProvider[] providers, @NotNull FileEditorManagerEx fileEditorManager) {
        if (file2 == null) {
            EditorWithProviderComposite.$$$reportNull$$$0(0);
        }
        if (editors == null) {
            EditorWithProviderComposite.$$$reportNull$$$0(1);
        }
        if (providers == null) {
            EditorWithProviderComposite.$$$reportNull$$$0(2);
        }
        if (fileEditorManager == null) {
            EditorWithProviderComposite.$$$reportNull$$$0(3);
        }
        super(file2, editors, fileEditorManager);
        this.myProviders = providers;
    }

    @NotNull
    public FileEditorProvider[] getProviders() {
        if (this.myProviders == null) {
            EditorWithProviderComposite.$$$reportNull$$$0(4);
        }
        return this.myProviders;
    }

    @Override
    public boolean isModified() {
        FileEditor[] editors;
        for (FileEditor editor : editors = this.getEditors()) {
            if (!editor.isModified()) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public Pair<FileEditor, FileEditorProvider> getSelectedEditorWithProvider() {
        LOG.assertTrue(this.myEditors.length > 0, (Object)this.myEditors.length);
        if (this.myEditors.length == 1) {
            LOG.assertTrue(this.myTabbedPaneWrapper == null);
            Pair pair = Pair.create((Object)this.myEditors[0], (Object)this.myProviders[0]);
            if (pair == null) {
                EditorWithProviderComposite.$$$reportNull$$$0(5);
            }
            return pair;
        }
        LOG.assertTrue(this.myTabbedPaneWrapper != null);
        int index = this.myTabbedPaneWrapper.getSelectedIndex();
        if (index == -1) {
            index = 0;
        }
        LOG.assertTrue(index >= 0, (Object)index);
        LOG.assertTrue(index < this.myEditors.length, (Object)index);
        Pair pair = Pair.create((Object)this.myEditors[index], (Object)this.myProviders[index]);
        if (pair == null) {
            EditorWithProviderComposite.$$$reportNull$$$0(6);
        }
        return pair;
    }

    @NotNull
    public HistoryEntry currentStateAsHistoryEntry() {
        Object[] editors = this.getEditors();
        FileEditorState[] states = new FileEditorState[editors.length];
        for (int j = 0; j < states.length; ++j) {
            states[j] = editors[j].getState(FileEditorStateLevel.FULL);
            LOG.assertTrue(states[j] != null);
        }
        int selectedProviderIndex = ArrayUtil.find((Object[])editors, (Object)this.getSelectedEditor());
        LOG.assertTrue(selectedProviderIndex != -1);
        FileEditorProvider[] providers = this.getProviders();
        HistoryEntry historyEntry = HistoryEntry.createLight(this.getFile(), providers, states, providers[selectedProviderIndex]);
        if (historyEntry == null) {
            EditorWithProviderComposite.$$$reportNull$$$0(7);
        }
        return historyEntry;
    }

    public void addEditor(@NotNull FileEditor editor, FileEditorProvider provider) {
        if (editor == null) {
            EditorWithProviderComposite.$$$reportNull$$$0(8);
        }
        this.addEditor(editor);
        this.myProviders = (FileEditorProvider[])ArrayUtil.append((Object[])this.myProviders, (Object)provider);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editors";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providers";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditorManager";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileEditor/impl/EditorWithProviderComposite";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileEditor/impl/EditorWithProviderComposite";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProviders";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedEditorWithProvider";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "currentStateAsHistoryEntry";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addEditor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

