/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.libraries;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.libraries.LibraryPresentationProvider;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.NewLibraryConfiguration;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.roots.libraries.ui.LibraryEditorComponent;
import com.intellij.openapi.roots.libraries.ui.LibraryPropertiesEditor;
import com.intellij.openapi.roots.libraries.ui.LibraryRootsComponentDescriptor;
import com.intellij.openapi.roots.ui.configuration.FacetsProvider;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LibraryType<P extends LibraryProperties>
extends LibraryPresentationProvider<P> {
    public static final ExtensionPointName<LibraryType<?>> EP_NAME = ExtensionPointName.create((String)"com.intellij.library.type");
    public static final OrderRootType[] DEFAULT_EXTERNAL_ROOT_TYPES = new OrderRootType[]{OrderRootType.CLASSES};

    protected LibraryType(@NotNull PersistentLibraryKind<P> libraryKind) {
        if (libraryKind == null) {
            LibraryType.$$$reportNull$$$0(0);
        }
        super((LibraryKind)libraryKind);
    }

    @NotNull
    public PersistentLibraryKind<P> getKind() {
        PersistentLibraryKind persistentLibraryKind = (PersistentLibraryKind)super.getKind();
        if (persistentLibraryKind == null) {
            LibraryType.$$$reportNull$$$0(1);
        }
        return persistentLibraryKind;
    }

    @Nullable
    public abstract String getCreateActionName();

    @Nullable
    public abstract NewLibraryConfiguration createNewLibrary(@NotNull JComponent var1, @Nullable VirtualFile var2, @NotNull Project var3);

    public boolean isSuitableModule(@NotNull Module module2, @NotNull FacetsProvider facetsProvider) {
        if (module2 == null) {
            LibraryType.$$$reportNull$$$0(2);
        }
        if (facetsProvider == null) {
            LibraryType.$$$reportNull$$$0(3);
        }
        return true;
    }

    @Nullable
    public LibraryRootsComponentDescriptor createLibraryRootsComponentDescriptor() {
        return null;
    }

    @Nullable
    public abstract LibraryPropertiesEditor createPropertiesEditor(@NotNull LibraryEditorComponent<P> var1);

    @Override
    public P detect(@NotNull List<VirtualFile> classesRoots) {
        if (classesRoots == null) {
            LibraryType.$$$reportNull$$$0(4);
        }
        return null;
    }

    public OrderRootType[] getExternalRootTypes() {
        return DEFAULT_EXTERNAL_ROOT_TYPES;
    }

    public static LibraryType findByKind(LibraryKind kind) {
        for (LibraryType type : (LibraryType[])EP_NAME.getExtensions()) {
            if (type.getKind() != kind) continue;
            return type;
        }
        throw new IllegalArgumentException("Library with kind " + kind + " is not registered");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryKind";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/libraries/LibraryType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facetsProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classesRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/libraries/LibraryType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isSuitableModule";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "detect";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

