/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.actions.ChangeListRemoveConfirmation;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoveChangeListAction
extends AnAction
implements DumbAware {
    public void update(@NotNull AnActionEvent e) {
        ChangeList[] changeListsArray;
        if (e == null) {
            RemoveChangeListAction.$$$reportNull$$$0(0);
        }
        List<ChangeList> changeLists = (changeListsArray = (ChangeList[])e.getData(VcsDataKeys.CHANGE_LISTS)) != null ? Arrays.asList(changeListsArray) : Collections.emptyList();
        boolean hasChanges = !ArrayUtil.isEmpty((Object[])((Object[])e.getData(VcsDataKeys.CHANGES)));
        boolean enabled = RemoveChangeListAction.canRemoveChangeLists(e.getProject(), changeLists);
        Presentation presentation = e.getPresentation();
        presentation.setEnabled(enabled);
        if (e.getPlace().equals("ChangesViewPopup")) {
            presentation.setVisible(enabled);
        }
        presentation.setText(ActionsBundle.message((String)"action.ChangesView.RemoveChangeList.text.template", (Object[])new Object[]{changeLists.size()}));
        if (hasChanges) {
            boolean containsActiveChangelist = ContainerUtil.exists(changeLists, l -> l instanceof LocalChangeList && ((LocalChangeList)l).isDefault());
            presentation.setDescription(ActionsBundle.message((String)"action.ChangesView.RemoveChangeList.description.template", (Object[])new Object[]{changeLists.size(), containsActiveChangelist ? "another" : "default"}));
        } else {
            presentation.setDescription(null);
        }
    }

    private static boolean canRemoveChangeLists(@Nullable Project project, @NotNull List<ChangeList> lists) {
        if (lists == null) {
            RemoveChangeListAction.$$$reportNull$$$0(1);
        }
        if (project == null || lists.size() == 0) {
            return false;
        }
        int allChangeListsCount = ChangeListManager.getInstance((Project)project).getChangeListsNumber();
        for (ChangeList changeList : lists) {
            if (!(changeList instanceof LocalChangeList)) {
                return false;
            }
            LocalChangeList localChangeList = (LocalChangeList)changeList;
            if (localChangeList.isReadOnly()) {
                return false;
            }
            if (!localChangeList.isDefault() || allChangeListsCount > lists.size()) continue;
            return false;
        }
        return true;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            RemoveChangeListAction.$$$reportNull$$$0(2);
        }
        final Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        ChangeList[] selectedLists = (ChangeList[])e.getRequiredData(VcsDataKeys.CHANGE_LISTS);
        ChangeListRemoveConfirmation.processLists(project, true, Arrays.asList(selectedLists), new ChangeListRemoveConfirmation(){

            @Override
            public boolean askIfShouldRemoveChangeLists(@NotNull List<? extends LocalChangeList> lists) {
                if (lists == null) {
                    1.$$$reportNull$$$0(0);
                }
                return RemoveChangeListAction.askIfShouldRemoveChangeLists(lists, project);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lists", "com/intellij/openapi/vcs/changes/actions/RemoveChangeListAction$1", "askIfShouldRemoveChangeLists"));
            }
        });
    }

    private static boolean askIfShouldRemoveChangeLists(@NotNull List<? extends LocalChangeList> lists, Project project) {
        if (lists == null) {
            RemoveChangeListAction.$$$reportNull$$$0(3);
        }
        boolean activeChangelistSelected = lists.stream().anyMatch(LocalChangeList::isDefault);
        boolean haveNoChanges = lists.stream().allMatch(l -> l.getChanges().isEmpty());
        if (activeChangelistSelected) {
            return RemoveChangeListAction.confirmActiveChangeListRemoval(project, lists, haveNoChanges);
        }
        String message = lists.size() == 1 ? VcsBundle.message((String)"changes.removechangelist.warning.text", (Object[])new Object[]{lists.get(0).getName()}) : VcsBundle.message((String)"changes.removechangelist.multiple.warning.text", (Object[])new Object[]{lists.size()});
        return haveNoChanges || 0 == Messages.showYesNoDialog((Project)project, (String)message, (String)VcsBundle.message((String)"changes.removechangelist.warning.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
    }

    static boolean confirmActiveChangeListRemoval(@NotNull Project project, @NotNull List<? extends LocalChangeList> lists, boolean empty) {
        if (project == null) {
            RemoveChangeListAction.$$$reportNull$$$0(4);
        }
        if (lists == null) {
            RemoveChangeListAction.$$$reportNull$$$0(5);
        }
        List remainingLists = ChangeListManager.getInstance((Project)project).getChangeListsCopy();
        remainingLists.removeAll(lists);
        if (remainingLists.size() == 1 && empty) {
            ChangeListManager.getInstance((Project)project).setDefaultChangeList((LocalChangeList)remainingLists.get(0));
            return true;
        }
        String[] remainingListsNames = (String[])remainingLists.stream().map(ChangeList::getName).toArray(String[]::new);
        int nameIndex = Messages.showChooseDialog((Project)project, (String)(empty ? VcsBundle.message((String)"changes.remove.active.empty.prompt", (Object[])new Object[0]) : VcsBundle.message((String)"changes.remove.active.prompt", (Object[])new Object[0])), (String)VcsBundle.message((String)"changes.remove.active.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon(), (String[])remainingListsNames, (String)remainingListsNames[0]);
        if (nameIndex < 0) {
            return false;
        }
        ChangeListManager.getInstance((Project)project).setDefaultChangeList((LocalChangeList)remainingLists.get(nameIndex));
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lists";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/RemoveChangeListAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "canRemoveChangeLists";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "askIfShouldRemoveChangeLists";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "confirmActiveChangeListRemoval";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

