/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies.ui;

import com.intellij.analysis.AnalysisScopeBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiElement;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfoToUsageConverter;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.Alarm;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class UsagesPanel
extends JPanel
implements Disposable,
DataProvider {
    protected static final Logger LOG = Logger.getInstance((String)"#com.intellij.packageDependencies.ui.UsagesPanel");
    private final Project myProject;
    ProgressIndicator myCurrentProgress;
    private JComponent myCurrentComponent;
    private UsageView myCurrentUsageView;
    protected final Alarm myAlarm;

    public UsagesPanel(@NotNull Project project) {
        if (project == null) {
            UsagesPanel.$$$reportNull$$$0(0);
        }
        super(new BorderLayout());
        this.myAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        this.myProject = project;
    }

    public void setToInitialPosition() {
        this.cancelCurrentFindRequest();
        this.setToComponent(UsagesPanel.createLabel(this.getInitialPositionText()));
    }

    public abstract String getInitialPositionText();

    public abstract String getCodeUsagesString();

    void cancelCurrentFindRequest() {
        if (this.myCurrentProgress != null) {
            this.myCurrentProgress.cancel();
        }
    }

    protected void showUsages(@NotNull PsiElement[] primaryElements, @NotNull UsageInfo[] usageInfos) {
        if (primaryElements == null) {
            UsagesPanel.$$$reportNull$$$0(1);
        }
        if (usageInfos == null) {
            UsagesPanel.$$$reportNull$$$0(2);
        }
        if (this.myCurrentUsageView != null) {
            Disposer.dispose((Disposable)this.myCurrentUsageView);
        }
        try {
            Usage[] usages = UsageInfoToUsageConverter.convert((PsiElement[])primaryElements, (UsageInfo[])usageInfos);
            UsageViewPresentation presentation = new UsageViewPresentation();
            presentation.setCodeUsagesString(this.getCodeUsagesString());
            this.myCurrentUsageView = UsageViewManager.getInstance((Project)this.myProject).createUsageView(UsageTarget.EMPTY_ARRAY, usages, presentation, null);
            this.setToComponent(this.myCurrentUsageView.getComponent());
        }
        catch (ProcessCanceledException e) {
            this.setToCanceled();
        }
    }

    private void setToCanceled() {
        this.setToComponent(UsagesPanel.createLabel(AnalysisScopeBundle.message((String)"usage.view.canceled", (Object[])new Object[0])));
    }

    void setToComponent(JComponent cmp) {
        SwingUtilities.invokeLater(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            if (this.myCurrentComponent != null) {
                if (this.myCurrentUsageView != null && this.myCurrentComponent == this.myCurrentUsageView.getComponent()) {
                    Disposer.dispose((Disposable)this.myCurrentUsageView);
                    this.myCurrentUsageView = null;
                }
                this.remove(this.myCurrentComponent);
            }
            this.myCurrentComponent = cmp;
            this.add((Component)cmp, "Center");
            this.revalidate();
        });
    }

    public void dispose() {
        if (this.myCurrentUsageView != null) {
            Disposer.dispose((Disposable)this.myCurrentUsageView);
            this.myCurrentUsageView = null;
        }
    }

    private static JComponent createLabel(String text) {
        JLabel label = new JLabel(text);
        label.setHorizontalAlignment(0);
        return label;
    }

    @Nullable
    @NonNls
    public Object getData(@NonNls String dataId) {
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return "ideaInterface.find";
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "primaryElements";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageInfos";
                break;
            }
        }
        objectArray2[1] = "com/intellij/packageDependencies/ui/UsagesPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "showUsages";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

