/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.LogUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.StaticGetter;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.source.tree.AstPath;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ILazyParseableElementTypeBase;
import com.intellij.reference.SoftReference;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.ImmutableCharSequence;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LazyParseableElement
extends CompositeElement {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.tree.LazyParseableElement");
    private static final StaticGetter<CharSequence> NO_TEXT = new StaticGetter(null);
    private final ChameleonLock lock;
    @NotNull
    private Getter<CharSequence> myText;
    private boolean myParsed;
    private static boolean ourParsingAllowed = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LazyParseableElement(@NotNull IElementType type, @Nullable CharSequence text) {
        if (type == null) {
            LazyParseableElement.$$$reportNull$$$0(0);
        }
        super(type);
        ChameleonLock chameleonLock = this.lock = new ChameleonLock();
        synchronized (chameleonLock) {
            boolean bl = this.myParsed = text == null;
            if (text == null) {
                this.myText = NO_TEXT;
            } else {
                this.myText = new StaticGetter((Object)ImmutableCharSequence.asImmutable((CharSequence)text));
                this.setCachedLength(text.length());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCaches() {
        super.clearCaches();
        ChameleonLock chameleonLock = this.lock;
        synchronized (chameleonLock) {
            if (this.myParsed) {
                this.myText = NO_TEXT;
            } else {
                this.setCachedLength(((CharSequence)this.myText.get()).length());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public String getText() {
        CharSequence text = this.myText();
        if (text != null) {
            String string = text.toString();
            if (string == null) {
                LazyParseableElement.$$$reportNull$$$0(1);
            }
            return string;
        }
        String s = super.getText();
        ChameleonLock chameleonLock = this.lock;
        synchronized (chameleonLock) {
            this.myText = new SoftReference((Object)s);
        }
        String string = s;
        if (string == null) {
            LazyParseableElement.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public CharSequence getChars() {
        CharSequence text = this.myText();
        CharSequence charSequence = text != null ? text : this.getText();
        if (charSequence == null) {
            LazyParseableElement.$$$reportNull$$$0(3);
        }
        return charSequence;
    }

    @Override
    public int getTextLength() {
        CharSequence text = this.myText();
        if (text != null) {
            return text.length();
        }
        return super.getTextLength();
    }

    @Override
    public int getNotCachedLength() {
        CharSequence text = this.myText();
        if (text != null) {
            return text.length();
        }
        return super.getNotCachedLength();
    }

    @Override
    public int hc() {
        CharSequence text = this.myText();
        return text == null ? super.hc() : LeafElement.leafHC(text);
    }

    @Override
    protected int textMatches(@NotNull CharSequence buffer, int start) {
        CharSequence text;
        if (buffer == null) {
            LazyParseableElement.$$$reportNull$$$0(4);
        }
        if ((text = this.myText()) != null) {
            return LeafElement.leafTextMatches(text, buffer, start);
        }
        return super.textMatches(buffer, start);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isParsed() {
        ChameleonLock chameleonLock = this.lock;
        synchronized (chameleonLock) {
            return this.myParsed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CharSequence myText() {
        ChameleonLock chameleonLock = this.lock;
        synchronized (chameleonLock) {
            return (CharSequence)this.myText.get();
        }
    }

    @Override
    final void setFirstChildNode(TreeElement child) {
        if (!this.isParsed()) {
            LOG.error("Mutating collapsed chameleon");
        }
        super.setFirstChildNode(child);
    }

    @Override
    final void setLastChildNode(TreeElement child) {
        if (!this.isParsed()) {
            LOG.error("Mutating collapsed chameleon");
        }
        super.setLastChildNode(child);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureParsed() {
        CharSequence text;
        if (!ourParsingAllowed) {
            LOG.error("Parsing not allowed!!!");
        }
        ChameleonLock chameleonLock = this.lock;
        synchronized (chameleonLock) {
            if (this.myParsed) {
                return;
            }
            text = (CharSequence)this.myText.get();
            assert (text != null);
        }
        if (TreeUtil.getFileElement(this) == null) {
            LOG.error("Chameleons must not be parsed till they're in file tree: " + this);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        DebugUtil.startPsiModification("lazy-parsing");
        try {
            ILazyParseableElementTypeBase type = (ILazyParseableElementTypeBase)this.getElementType();
            ASTNode parsedNode = type.parseContents((ASTNode)this);
            if (parsedNode == null && text.length() > 0) {
                CharSequence diagText = ApplicationManager.getApplication().isInternal() ? text : "";
                LOG.error("No parse for a non-empty string: " + diagText + "; type=" + LogUtil.objectAndClass((Object)type));
            }
            ChameleonLock chameleonLock2 = this.lock;
            synchronized (chameleonLock2) {
                block18: {
                    if (!this.myParsed) break block18;
                    return;
                }
                if (this.rawFirstChild() != null) {
                    LOG.error("Reentrant parsing?");
                }
                this.myParsed = true;
                if (parsedNode != null) {
                    super.rawAddChildrenWithoutNotifications((TreeElement)parsedNode);
                }
                AstPath.cacheNodePaths(this);
                this.assertTextLengthIntact(text.length());
                this.myText = new SoftReference((Object)text);
            }
        }
        finally {
            DebugUtil.finishPsiModification();
        }
    }

    private void assertTextLengthIntact(int expected) {
        int length = 0;
        for (ASTNode node : this.getChildren(null)) {
            length += node.getTextLength();
        }
        assert (length == expected) : "Text mismatch in " + this.getElementType();
    }

    @Override
    public void rawAddChildrenWithoutNotifications(@NotNull TreeElement first) {
        if (first == null) {
            LazyParseableElement.$$$reportNull$$$0(5);
        }
        if (!this.isParsed()) {
            LOG.error("Mutating collapsed chameleon");
        }
        super.rawAddChildrenWithoutNotifications(first);
    }

    @Override
    public TreeElement getFirstChildNode() {
        this.ensureParsed();
        return super.getFirstChildNode();
    }

    @Override
    public TreeElement getLastChildNode() {
        this.ensureParsed();
        return super.getLastChildNode();
    }

    public int copyTo(@Nullable char[] buffer, int start) {
        CharSequence text = this.myText();
        if (text == null) {
            return -1;
        }
        if (buffer != null) {
            CharArrayUtil.getChars((CharSequence)text, (char[])buffer, (int)start);
        }
        return start + text.length();
    }

    public static void setParsingAllowed(boolean allowed) {
        ourParsingAllowed = allowed;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/tree/LazyParseableElement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/tree/LazyParseableElement";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChars";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "textMatches";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "rawAddChildrenWithoutNotifications";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ChameleonLock {
        private ChameleonLock() {
        }

        @NonNls
        public String toString() {
            return "chameleon parsing lock";
        }
    }
}

