/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remote;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.remote.RemoteSdkCredentialsHolder;
import org.jetbrains.annotations.NotNull;

public class RemoteFile {
    private final boolean myWin;
    private final String myPath;

    public RemoteFile(@NotNull String path, boolean isWin) {
        if (path == null) {
            RemoteFile.$$$reportNull$$$0(0);
        }
        this.myPath = RemoteFile.toSystemDependent(path, isWin);
        this.myWin = isWin;
    }

    public RemoteFile(@NotNull String parent, String child) {
        if (parent == null) {
            RemoteFile.$$$reportNull$$$0(1);
        }
        this(RemoteFile.resolveChild(parent, child, RemoteFile.isWindowsPath(parent)), RemoteFile.isWindowsPath(parent));
    }

    public RemoteFile(@NotNull String parent, String child, boolean isWin) {
        if (parent == null) {
            RemoteFile.$$$reportNull$$$0(2);
        }
        this(RemoteFile.resolveChild(parent, child, isWin), isWin);
    }

    @NotNull
    public String getName() {
        int ind = this.myPath.lastIndexOf(RemoteFile.getSeparator(this.myWin));
        if (ind != -1 && ind < this.myPath.length() - 1) {
            String string = this.myPath.substring(ind + 1);
            if (string == null) {
                RemoteFile.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = this.myPath;
        if (string == null) {
            RemoteFile.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static String resolveChild(@NotNull String parent, @NotNull String child, boolean win) {
        String separator;
        if (parent == null) {
            RemoteFile.$$$reportNull$$$0(5);
        }
        if (child == null) {
            RemoteFile.$$$reportNull$$$0(6);
        }
        String path = parent.endsWith(separator = RemoteFile.getSeparator(win)) ? parent + child : parent + separator + child;
        return path;
    }

    private static String getSeparator(boolean win) {
        String separator = win ? "\\" : "/";
        return separator;
    }

    public String getPath() {
        return this.myPath;
    }

    public boolean isWin() {
        return RemoteFile.isWindowsPath(this.myPath);
    }

    public static boolean isWindowsPath(@NotNull String path) {
        if (path == null) {
            RemoteFile.$$$reportNull$$$0(7);
        }
        return (path = RemoteSdkCredentialsHolder.getInterpreterPathFromFullPath(path)).length() > 1 && path.charAt(1) == ':';
    }

    private static String toSystemDependent(@NotNull String path, boolean isWin) {
        if (path == null) {
            RemoteFile.$$$reportNull$$$0(8);
        }
        char separator = isWin ? (char)'\\' : '/';
        return FileUtil.toSystemIndependentName((String)path).replace('/', separator);
    }

    public static RemoteFileBuilder detectSystemByPath(@NotNull String path) {
        if (path == null) {
            RemoteFile.$$$reportNull$$$0(9);
        }
        return new RemoteFileBuilder(RemoteFile.isWindowsPath(path));
    }

    public static RemoteFile createRemoteFile(String path, String script) {
        return RemoteFile.detectSystemByPath(path).createRemoteFile(path, script);
    }

    public static RemoteFile createRemoteFile(String path) {
        return RemoteFile.detectSystemByPath(path).createRemoteFile(path);
    }

    public static RemoteFile createRemoteFile(String path, String script, boolean isWindows) {
        return new RemoteFileBuilder(isWindows).createRemoteFile(path, script);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/remote/RemoteFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/remote/RemoteFile";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resolveChild";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isWindowsPath";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "toSystemDependent";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "detectSystemByPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class RemoteFileBuilder {
        private final boolean isWin;

        private RemoteFileBuilder(boolean win) {
            this.isWin = win;
        }

        public RemoteFile createRemoteFile(String path) {
            return new RemoteFile(path, this.isWin);
        }

        public RemoteFile createRemoteFile(String path, String child) {
            return new RemoteFile(path, child, this.isWin);
        }
    }
}

