/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup;

import com.intellij.util.ReflectionUtil;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayDeque;
import javax.swing.JWindow;

final class HeavyWeightPopupCache
implements ComponentListener {
    private final ArrayDeque<Window> myWindows = new ArrayDeque();

    HeavyWeightPopupCache() {
    }

    public static Window create(Window owner) {
        Window popup2;
        HeavyWeightPopupCache cache;
        if (owner != null && (cache = HeavyWeightPopupCache.getCache(owner)) != null && (popup2 = cache.poll()) != null) {
            return popup2;
        }
        JWindow popup3 = new JWindow(owner);
        popup3.setType(Window.Type.POPUP);
        return popup3;
    }

    public static void dispose(Window popup2) {
        if (popup2 != null) {
            HeavyWeightPopupCache.hide(popup2);
            Window owner = popup2.getOwner();
            if (owner == null || !owner.isDisplayable()) {
                popup2.dispose();
            } else {
                HeavyWeightPopupCache cache = HeavyWeightPopupCache.getCache(owner);
                if (cache == null) {
                    cache = new HeavyWeightPopupCache();
                    owner.addComponentListener(cache);
                }
                cache.push(popup2);
            }
        }
    }

    private static HeavyWeightPopupCache getCache(Window owner) {
        for (ComponentListener listener2 : owner.getComponentListeners()) {
            if (!(listener2 instanceof HeavyWeightPopupCache)) continue;
            return (HeavyWeightPopupCache)listener2;
        }
        return null;
    }

    private static Window poll(ArrayDeque<Window> windows) {
        return windows.poll();
    }

    private static void push(ArrayDeque<Window> windows, Window popup2) {
        windows.push(popup2);
    }

    private static void hide(ArrayDeque<Window> windows) {
        for (Window window : windows) {
            HeavyWeightPopupCache.hide(window);
        }
    }

    private static void hide(Window window) {
        ReflectionUtil.setField(Window.class, (Object)window, Boolean.TYPE, (String)"showWithParent", (Object)false);
    }

    private Window poll() {
        return HeavyWeightPopupCache.poll(this.myWindows);
    }

    private void push(Window popup2) {
        HeavyWeightPopupCache.push(this.myWindows, popup2);
    }

    private void hide() {
        HeavyWeightPopupCache.hide(this.myWindows);
    }

    @Override
    public void componentResized(ComponentEvent event) {
    }

    @Override
    public void componentMoved(ComponentEvent event) {
    }

    @Override
    public void componentShown(ComponentEvent event) {
    }

    @Override
    public void componentHidden(ComponentEvent event) {
        HeavyWeightPopupCache cache;
        Object source = event.getSource();
        if (source instanceof Window && (cache = HeavyWeightPopupCache.getCache((Window)source)) != null) {
            cache.hide();
        }
    }
}

