/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.impl.cache.impl.id.IdIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processor;
import com.intellij.util.indexing.CustomInputsIndexFileBasedIndexExtension;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.IndexingStamp;
import com.intellij.util.indexing.MemoryIndexStorage;
import com.intellij.util.indexing.SharedIndicesData;
import com.intellij.util.indexing.SharedMapBasedForwardIndex;
import com.intellij.util.indexing.SnapshotInputMappings;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.UpdatableIndex;
import com.intellij.util.indexing.VfsAwareIndexStorage;
import com.intellij.util.indexing.impl.CollectionInputDataDiffBuilder;
import com.intellij.util.indexing.impl.DebugAssertions;
import com.intellij.util.indexing.impl.ForwardIndex;
import com.intellij.util.indexing.impl.IndexStorage;
import com.intellij.util.indexing.impl.InputIndexDataExternalizer;
import com.intellij.util.indexing.impl.KeyCollectionBasedForwardIndex;
import com.intellij.util.indexing.impl.MapInputDataDiffBuilder;
import com.intellij.util.indexing.impl.MapReduceIndex;
import com.intellij.util.indexing.impl.UpdateData;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import gnu.trove.TIntObjectHashMap;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VfsAwareMapReduceIndex<Key, Value, Input>
extends MapReduceIndex<Key, Value, Input>
implements UpdatableIndex<Key, Value, Input> {
    private static final Logger LOG = Logger.getInstance(VfsAwareMapReduceIndex.class);
    private final AtomicBoolean myInMemoryMode;
    private final TIntObjectHashMap<Collection<Key>> myInMemoryKeys;
    private final SnapshotInputMappings<Key, Value, Input> mySnapshotInputMappings;

    public VfsAwareMapReduceIndex(@NotNull IndexExtension<Key, Value, Input> extension, @NotNull IndexStorage<Key, Value> storage2) throws IOException {
        if (extension == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(0);
        }
        if (storage2 == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(1);
        }
        this(extension, storage2, VfsAwareMapReduceIndex.getForwardIndex(extension));
        if (!(this.myIndexId instanceof ID)) {
            throw new IllegalArgumentException("myIndexId should be instance of com.intellij.util.indexing.ID");
        }
    }

    public VfsAwareMapReduceIndex(@NotNull IndexExtension<Key, Value, Input> extension, @NotNull IndexStorage<Key, Value> storage2, @Nullable ForwardIndex<Key, Value> forwardIndex) throws IOException {
        if (extension == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(2);
        }
        if (storage2 == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(3);
        }
        super(extension, storage2, forwardIndex);
        this.myInMemoryMode = new AtomicBoolean();
        this.myInMemoryKeys = new TIntObjectHashMap();
        SharedIndicesData.registerIndex((ID)this.myIndexId, extension);
        this.mySnapshotInputMappings = this.myForwardIndex == null && VfsAwareMapReduceIndex.hasSnapshotMapping(extension) ? new SnapshotInputMappings<Key, Value, Input>(extension) : null;
        this.installMemoryModeListener();
    }

    private static <Key, Value> boolean hasSnapshotMapping(@NotNull IndexExtension<Key, Value, ?> indexExtension) {
        if (indexExtension == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(4);
        }
        return indexExtension instanceof FileBasedIndexExtension && ((FileBasedIndexExtension)indexExtension).hasSnapshotMapping() && IdIndex.ourSnapshotMappingsEnabled;
    }

    @NotNull
    protected UpdateData<Key, Value> calculateUpdateData(int inputId, @Nullable Input content) {
        int hashId;
        Map<Key, Value> data;
        boolean isContentPhysical = this.isContentPhysical(content);
        if (this.mySnapshotInputMappings != null && content != null && isContentPhysical) {
            SnapshotInputMappings.Snapshot<Key, Value> snapshot = this.mySnapshotInputMappings.readPersistentDataOrMap(content);
            data = snapshot.getData();
            hashId = snapshot.getHashId();
        } else {
            data = this.mapInput(content);
            hashId = 0;
        }
        UpdateData updateData = this.createUpdateData(data, () -> {
            if (this.mySnapshotInputMappings != null && isContentPhysical) {
                return new MapInputDataDiffBuilder(inputId, this.mySnapshotInputMappings.readInputKeys(inputId));
            }
            if (this.myInMemoryMode.get()) {
                TIntObjectHashMap<Collection<Key>> tIntObjectHashMap = this.myInMemoryKeys;
                synchronized (tIntObjectHashMap) {
                    Collection keys = (Collection)this.myInMemoryKeys.get(inputId);
                    if (keys != null) {
                        return new CollectionInputDataDiffBuilder(inputId, keys);
                    }
                }
                if (this.mySnapshotInputMappings != null) {
                    return new MapInputDataDiffBuilder(inputId, this.mySnapshotInputMappings.readInputKeys(inputId));
                }
            }
            return this.getKeysDiffBuilder(inputId);
        }, () -> {
            if (this.myInMemoryMode.get()) {
                TIntObjectHashMap<Collection<Key>> tIntObjectHashMap = this.myInMemoryKeys;
                synchronized (tIntObjectHashMap) {
                    this.myInMemoryKeys.put(inputId, data.keySet());
                }
            } else if (this.mySnapshotInputMappings != null) {
                this.mySnapshotInputMappings.putInputHash(inputId, hashId);
            } else {
                this.myForwardIndex.putInputData(inputId, data);
            }
        });
        if (updateData == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(5);
        }
        return updateData;
    }

    @Override
    public void setIndexedStateForFile(int fileId, @NotNull VirtualFile file2) {
        if (file2 == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(6);
        }
        IndexingStamp.setFileIndexedStateCurrent(fileId, (ID)this.myIndexId);
    }

    @Override
    public void resetIndexedStateForFile(int fileId) {
        IndexingStamp.setFileIndexedStateOutdated(fileId, (ID)this.myIndexId);
    }

    @Override
    public boolean isIndexedStateForFile(int fileId, @NotNull VirtualFile file2) {
        if (file2 == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(7);
        }
        return IndexingStamp.isFileIndexedStateCurrent(fileId, (ID)this.myIndexId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processAllKeys(@NotNull Processor<Key> processor2, @NotNull GlobalSearchScope scope, IdFilter idFilter) throws StorageException {
        if (processor2 == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(8);
        }
        if (scope == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(9);
        }
        Lock lock = this.getReadLock();
        try {
            lock.lock();
            boolean bl = ((VfsAwareIndexStorage)this.myStorage).processKeys(processor2, scope, idFilter);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    public void checkCanceled() {
        ProgressManager.checkCanceled();
    }

    protected void requestRebuild(@NotNull Throwable ex) {
        if (ex == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(10);
        }
        Runnable action = () -> {
            if (ex == null) {
                VfsAwareMapReduceIndex.$$$reportNull$$$0(12);
            }
            FileBasedIndex.getInstance().requestRebuild((ID)this.myIndexId, ex);
        };
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode() || application.isHeadlessEnvironment()) {
            application.invokeLater(action, ModalityState.any());
        } else {
            action.run();
        }
    }

    protected void doClear() throws StorageException, IOException {
        super.doClear();
        if (this.mySnapshotInputMappings != null) {
            try {
                this.mySnapshotInputMappings.clear();
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    protected void doFlush() throws IOException, StorageException {
        super.doFlush();
        if (this.mySnapshotInputMappings != null) {
            this.mySnapshotInputMappings.flush();
        }
    }

    protected void doDispose() throws StorageException {
        super.doDispose();
        if (this.mySnapshotInputMappings != null) {
            try {
                this.mySnapshotInputMappings.close();
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    @Nullable
    private static <Key, Value> ForwardIndex<Key, Value> getForwardIndex(@NotNull IndexExtension<Key, Value, ?> indexExtension) throws IOException {
        if (indexExtension == null) {
            VfsAwareMapReduceIndex.$$$reportNull$$$0(11);
        }
        if (VfsAwareMapReduceIndex.hasSnapshotMapping(indexExtension)) {
            return null;
        }
        MyForwardIndex<Key, Value> backgroundIndex = !SharedIndicesData.ourFileSharedIndicesEnabled || SharedIndicesData.DO_CHECKS ? new MyForwardIndex<Key, Value>(indexExtension) : null;
        return new SharedMapBasedForwardIndex<Key, Value>(indexExtension, backgroundIndex);
    }

    private boolean isContentPhysical(Input content) {
        return content == null || content instanceof UserDataHolder && (Boolean)FileBasedIndexImpl.ourPhysicalContentKey.get((UserDataHolder)content, (Object)Boolean.FALSE) != false;
    }

    private void installMemoryModeListener() {
        IndexStorage storage2 = this.getStorage();
        if (storage2 instanceof MemoryIndexStorage) {
            ((MemoryIndexStorage)storage2).addBufferingStateListener(new MemoryIndexStorage.BufferingStateListener(){

                @Override
                public void bufferingStateChanged(boolean newState) {
                    VfsAwareMapReduceIndex.this.myInMemoryMode.set(newState);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void memoryStorageCleared() {
                    TIntObjectHashMap tIntObjectHashMap = VfsAwareMapReduceIndex.this.myInMemoryKeys;
                    synchronized (tIntObjectHashMap) {
                        VfsAwareMapReduceIndex.this.myInMemoryKeys.clear();
                    }
                }
            });
        }
    }

    protected static <K> DataExternalizer<Collection<K>> createInputsIndexExternalizer(IndexExtension<K, ?, ?> extension) {
        return extension instanceof CustomInputsIndexFileBasedIndexExtension ? ((CustomInputsIndexFileBasedIndexExtension)extension).createExternalizer() : new InputIndexDataExternalizer(extension.getKeyDescriptor(), extension.getName());
    }

    static {
        if (!DebugAssertions.DEBUG) {
            Application app = ApplicationManager.getApplication();
            DebugAssertions.DEBUG = app.isEAP() || app.isInternal();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexExtension";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/VfsAwareMapReduceIndex";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/VfsAwareMapReduceIndex";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateUpdateData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "hasSnapshotMapping";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setIndexedStateForFile";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isIndexedStateForFile";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processAllKeys";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "requestRebuild";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getForwardIndex";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$requestRebuild$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyForwardIndex<Key, Value>
    extends KeyCollectionBasedForwardIndex<Key, Value> {
        protected MyForwardIndex(IndexExtension<Key, Value, ?> indexExtension) throws IOException {
            super(indexExtension);
        }

        @NotNull
        public PersistentHashMap<Integer, Collection<Key>> createMap() throws IOException {
            PersistentHashMap persistentHashMap = MyForwardIndex.createIdToDataKeysIndex(this.myIndexExtension);
            if (persistentHashMap == null) {
                MyForwardIndex.$$$reportNull$$$0(0);
            }
            return persistentHashMap;
        }

        @NotNull
        private static <K> PersistentHashMap<Integer, Collection<K>> createIdToDataKeysIndex(@NotNull IndexExtension<K, ?, ?> extension) throws IOException {
            if (extension == null) {
                MyForwardIndex.$$$reportNull$$$0(1);
            }
            File indexStorageFile = IndexInfrastructure.getInputIndexStorageFile((ID)extension.getName());
            PersistentHashMap persistentHashMap = new PersistentHashMap(indexStorageFile, (KeyDescriptor)EnumeratorIntegerDescriptor.INSTANCE, VfsAwareMapReduceIndex.createInputsIndexExternalizer(extension));
            if (persistentHashMap == null) {
                MyForwardIndex.$$$reportNull$$$0(2);
            }
            return persistentHashMap;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/indexing/VfsAwareMapReduceIndex$MyForwardIndex";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extension";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createMap";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/indexing/VfsAwareMapReduceIndex$MyForwardIndex";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createIdToDataKeysIndex";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "createIdToDataKeysIndex";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

