/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.visible;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogBranchFilter;
import com.intellij.vcs.log.VcsLogDetailsFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogHashFilter;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRefs;
import com.intellij.vcs.log.VcsLogRootFilter;
import com.intellij.vcs.log.VcsLogStructureFilter;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.CommitIdByStringCondition;
import com.intellij.vcs.log.data.DataGetter;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.TopCommitsCache;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.VcsLogStructureFilterImpl;
import com.intellij.vcs.log.data.index.VcsLogIndex;
import com.intellij.vcs.log.graph.GraphCommit;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.graph.VisibleGraph;
import com.intellij.vcs.log.impl.VcsLogFilterCollectionImpl;
import com.intellij.vcs.log.impl.VcsLogHashFilterImpl;
import com.intellij.vcs.log.impl.VcsLogUtil;
import com.intellij.vcs.log.util.StopWatch;
import com.intellij.vcs.log.visible.CommitCountStage;
import com.intellij.vcs.log.visible.EmptyVisibleGraph;
import com.intellij.vcs.log.visible.VisiblePack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogFilterer {
    private static final Logger LOG = Logger.getInstance(VcsLogFilterer.class);
    @NotNull
    protected final VcsLogStorage myStorage;
    @NotNull
    private final TopCommitsCache myTopCommitsDetailsCache;
    @NotNull
    private final DataGetter<VcsFullCommitDetails> myCommitDetailsGetter;
    @NotNull
    private final Map<VirtualFile, VcsLogProvider> myLogProviders;
    @NotNull
    protected final VcsLogIndex myIndex;

    public VcsLogFilterer(@NotNull Map<VirtualFile, VcsLogProvider> providers, @NotNull VcsLogStorage storage2, @NotNull TopCommitsCache topCommitsDetailsCache, @NotNull DataGetter<VcsFullCommitDetails> detailsGetter, @NotNull VcsLogIndex index) {
        if (providers == null) {
            VcsLogFilterer.$$$reportNull$$$0(0);
        }
        if (storage2 == null) {
            VcsLogFilterer.$$$reportNull$$$0(1);
        }
        if (topCommitsDetailsCache == null) {
            VcsLogFilterer.$$$reportNull$$$0(2);
        }
        if (detailsGetter == null) {
            VcsLogFilterer.$$$reportNull$$$0(3);
        }
        if (index == null) {
            VcsLogFilterer.$$$reportNull$$$0(4);
        }
        this.myStorage = storage2;
        this.myTopCommitsDetailsCache = topCommitsDetailsCache;
        this.myCommitDetailsGetter = detailsGetter;
        this.myLogProviders = providers;
        this.myIndex = index;
    }

    @NotNull
    protected Pair<VisiblePack, CommitCountStage> filter(@NotNull DataPack dataPack, @NotNull PermanentGraph.SortType sortType, @NotNull VcsLogFilterCollection filters, @NotNull CommitCountStage commitCount) {
        if (dataPack == null) {
            VcsLogFilterer.$$$reportNull$$$0(5);
        }
        if (sortType == null) {
            VcsLogFilterer.$$$reportNull$$$0(6);
        }
        if (filters == null) {
            VcsLogFilterer.$$$reportNull$$$0(7);
        }
        if (commitCount == null) {
            VcsLogFilterer.$$$reportNull$$$0(8);
        }
        long start = System.currentTimeMillis();
        VcsLogHashFilter hashFilter = filters.getHashFilter();
        if (hashFilter != null && !hashFilter.getHashes().isEmpty()) {
            Pair pair = Pair.create((Object)this.applyHashFilter(dataPack, hashFilter.getHashes(), sortType), (Object)((Object)commitCount));
            if (pair == null) {
                VcsLogFilterer.$$$reportNull$$$0(9);
            }
            return pair;
        }
        Set<VirtualFile> visibleRoots = VcsLogUtil.getAllVisibleRoots(dataPack.getLogProviders().keySet(), filters.getRootFilter(), filters.getStructureFilter());
        Set<Integer> matchingHeads = this.getMatchingHeads(dataPack.getRefsModel(), visibleRoots, filters);
        FilterByDetailsResult filterResult = this.filterByDetails(dataPack, filters, commitCount, visibleRoots, matchingHeads);
        VisibleGraph<Integer> visibleGraph = this.createVisibleGraph(dataPack, sortType, matchingHeads, filterResult.matchingCommits);
        VisiblePack visiblePack = new VisiblePack(dataPack, visibleGraph, filterResult.canRequestMore, filters);
        LOG.debug(StopWatch.formatTime(System.currentTimeMillis() - start) + " for filtering by " + filters);
        Pair pair = Pair.create((Object)visiblePack, (Object)((Object)filterResult.commitCount));
        if (pair == null) {
            VcsLogFilterer.$$$reportNull$$$0(10);
        }
        return pair;
    }

    @NotNull
    protected VisibleGraph<Integer> createVisibleGraph(@NotNull DataPack dataPack, @NotNull PermanentGraph.SortType sortType, @Nullable Set<Integer> matchingHeads, @Nullable Set<Integer> matchingCommits) {
        if (dataPack == null) {
            VcsLogFilterer.$$$reportNull$$$0(11);
        }
        if (sortType == null) {
            VcsLogFilterer.$$$reportNull$$$0(12);
        }
        VisibleGraph visibleGraph = VcsLogFilterer.matchesNothing(matchingHeads) || VcsLogFilterer.matchesNothing(matchingCommits) ? EmptyVisibleGraph.getInstance() : dataPack.getPermanentGraph().createVisibleGraph(sortType, matchingHeads, matchingCommits);
        VisibleGraph visibleGraph2 = visibleGraph;
        if (visibleGraph2 == null) {
            VcsLogFilterer.$$$reportNull$$$0(13);
        }
        return visibleGraph2;
    }

    @NotNull
    private FilterByDetailsResult filterByDetails(@NotNull DataPack dataPack, @NotNull VcsLogFilterCollection filters, @NotNull CommitCountStage commitCount, @NotNull Collection<VirtualFile> visibleRoots, @Nullable Set<Integer> matchingHeads) {
        List notIndexedRoots;
        List detailsFilters;
        if (dataPack == null) {
            VcsLogFilterer.$$$reportNull$$$0(14);
        }
        if (filters == null) {
            VcsLogFilterer.$$$reportNull$$$0(15);
        }
        if (commitCount == null) {
            VcsLogFilterer.$$$reportNull$$$0(16);
        }
        if (visibleRoots == null) {
            VcsLogFilterer.$$$reportNull$$$0(17);
        }
        if ((detailsFilters = filters.getDetailsFilters()).isEmpty()) {
            FilterByDetailsResult filterByDetailsResult = new FilterByDetailsResult(null, false, commitCount);
            if (filterByDetailsResult == null) {
                VcsLogFilterer.$$$reportNull$$$0(18);
            }
            return filterByDetailsResult;
        }
        Set<Integer> filteredWidthIndex = null;
        if (this.myIndex.canFilter(detailsFilters) && (notIndexedRoots = ContainerUtil.filter(visibleRoots, root -> !this.myIndex.isIndexed((VirtualFile)root))).size() < visibleRoots.size()) {
            filteredWidthIndex = this.myIndex.filter(detailsFilters);
            if (notIndexedRoots.isEmpty()) {
                FilterByDetailsResult filterByDetailsResult = new FilterByDetailsResult(filteredWidthIndex, false, commitCount);
                if (filterByDetailsResult == null) {
                    VcsLogFilterer.$$$reportNull$$$0(19);
                }
                return filterByDetailsResult;
            }
            matchingHeads = this.getMatchingHeads(dataPack.getRefsModel(), notIndexedRoots, filters);
        }
        FilterByDetailsResult filteredWithVcs = this.filterWithVcs(dataPack.getPermanentGraph(), filters, detailsFilters, matchingHeads, commitCount);
        Set<Integer> filteredCommits = filteredWidthIndex == null ? filteredWithVcs.matchingCommits : (filteredWithVcs.matchingCommits == null ? filteredWidthIndex : ContainerUtil.union(filteredWidthIndex, filteredWithVcs.matchingCommits));
        FilterByDetailsResult filterByDetailsResult = new FilterByDetailsResult(filteredCommits, filteredWithVcs.canRequestMore, filteredWithVcs.commitCount);
        if (filterByDetailsResult == null) {
            VcsLogFilterer.$$$reportNull$$$0(20);
        }
        return filterByDetailsResult;
    }

    @NotNull
    private FilterByDetailsResult filterWithVcs(@NotNull PermanentGraph graph, @NotNull VcsLogFilterCollection filters, @NotNull List<VcsLogDetailsFilter> detailsFilters, @Nullable Set<Integer> matchingHeads, @NotNull CommitCountStage commitCount) {
        if (graph == null) {
            VcsLogFilterer.$$$reportNull$$$0(21);
        }
        if (filters == null) {
            VcsLogFilterer.$$$reportNull$$$0(22);
        }
        if (detailsFilters == null) {
            VcsLogFilterer.$$$reportNull$$$0(23);
        }
        if (commitCount == null) {
            VcsLogFilterer.$$$reportNull$$$0(24);
        }
        Set<Object> matchingCommits = null;
        if (commitCount == CommitCountStage.INITIAL && (matchingCommits = this.getMatchedCommitIndex(this.filterInMemory((PermanentGraph<Integer>)graph, detailsFilters, matchingHeads))).size() < commitCount.getCount()) {
            commitCount = commitCount.next();
            matchingCommits = null;
        }
        if (matchingCommits == null) {
            try {
                matchingCommits = this.getMatchedCommitIndex(VcsLogFilterer.getFilteredDetailsFromTheVcs(this.myLogProviders, filters, commitCount.getCount()));
            }
            catch (VcsException e) {
                matchingCommits = Collections.emptySet();
                LOG.error((Throwable)e);
            }
        }
        FilterByDetailsResult filterByDetailsResult = new FilterByDetailsResult(matchingCommits, matchingCommits.size() >= commitCount.getCount(), commitCount);
        if (filterByDetailsResult == null) {
            VcsLogFilterer.$$$reportNull$$$0(25);
        }
        return filterByDetailsResult;
    }

    private static <T> boolean matchesNothing(@Nullable Collection<T> matchingSet) {
        return matchingSet != null && matchingSet.isEmpty();
    }

    private VisiblePack applyHashFilter(@NotNull DataPack dataPack, @NotNull Collection<String> hashes, @NotNull PermanentGraph.SortType sortType) {
        if (dataPack == null) {
            VcsLogFilterer.$$$reportNull$$$0(26);
        }
        if (hashes == null) {
            VcsLogFilterer.$$$reportNull$$$0(27);
        }
        if (sortType == null) {
            VcsLogFilterer.$$$reportNull$$$0(28);
        }
        Set indices = ContainerUtil.map2SetNotNull(hashes, partOfHash -> {
            CommitId commitId = this.myStorage.findCommitId(new CommitIdByStringCondition((String)partOfHash));
            return commitId != null ? Integer.valueOf(this.myStorage.getCommitIndex(commitId.getHash(), commitId.getRoot())) : null;
        });
        VisibleGraph visibleGraph = dataPack.getPermanentGraph().createVisibleGraph(sortType, null, indices);
        return new VisiblePack(dataPack, (VisibleGraph<Integer>)visibleGraph, false, new VcsLogFilterCollectionImpl.VcsLogFilterCollectionBuilder().with(new VcsLogHashFilterImpl(hashes)).build());
    }

    @Nullable
    protected Set<Integer> getMatchingHeads(@NotNull VcsLogRefs refs, @NotNull Collection<VirtualFile> roots, @NotNull VcsLogFilterCollection filters) {
        if (refs == null) {
            VcsLogFilterer.$$$reportNull$$$0(29);
        }
        if (roots == null) {
            VcsLogFilterer.$$$reportNull$$$0(30);
        }
        if (filters == null) {
            VcsLogFilterer.$$$reportNull$$$0(31);
        }
        VcsLogBranchFilter branchFilter = filters.getBranchFilter();
        VcsLogRootFilter rootFilter = filters.getRootFilter();
        VcsLogStructureFilter structureFilter = filters.getStructureFilter();
        if (branchFilter == null && rootFilter == null && structureFilter == null) {
            return null;
        }
        Set<Integer> filteredByBranch = null;
        if (branchFilter != null) {
            filteredByBranch = this.getMatchingHeads(refs, branchFilter);
        }
        Set<Integer> filteredByFile = this.getMatchingHeads(refs, roots);
        if (filteredByBranch == null) {
            return filteredByFile;
        }
        if (filteredByFile == null) {
            return filteredByBranch;
        }
        return new HashSet(ContainerUtil.intersection(filteredByBranch, filteredByFile));
    }

    private Set<Integer> getMatchingHeads(@NotNull VcsLogRefs refs, @NotNull VcsLogBranchFilter filter2) {
        if (refs == null) {
            VcsLogFilterer.$$$reportNull$$$0(32);
        }
        if (filter2 == null) {
            VcsLogFilterer.$$$reportNull$$$0(33);
        }
        return new HashSet((Collection)ContainerUtil.mapNotNull((Collection)refs.getBranches(), ref -> {
            boolean acceptRef;
            if (filter2 == null) {
                VcsLogFilterer.$$$reportNull$$$0(50);
            }
            return (acceptRef = filter2.matches(ref.getName())) ? Integer.valueOf(this.myStorage.getCommitIndex(ref.getCommitHash(), ref.getRoot())) : null;
        }));
    }

    private Set<Integer> getMatchingHeads(@NotNull VcsLogRefs refs, @NotNull Collection<VirtualFile> roots) {
        if (refs == null) {
            VcsLogFilterer.$$$reportNull$$$0(34);
        }
        if (roots == null) {
            VcsLogFilterer.$$$reportNull$$$0(35);
        }
        HashSet result2 = new HashSet();
        for (VcsRef branch : refs.getBranches()) {
            if (!roots.contains(branch.getRoot())) continue;
            result2.add(this.myStorage.getCommitIndex(branch.getCommitHash(), branch.getRoot()));
        }
        return result2;
    }

    @NotNull
    private Collection<CommitId> filterInMemory(@NotNull PermanentGraph<Integer> permanentGraph, @NotNull List<VcsLogDetailsFilter> detailsFilters, @Nullable Set<Integer> matchingHeads) {
        GraphCommit commit;
        VcsCommitMetadata data;
        if (permanentGraph == null) {
            VcsLogFilterer.$$$reportNull$$$0(36);
        }
        if (detailsFilters == null) {
            VcsLogFilterer.$$$reportNull$$$0(37);
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        Iterator iterator = permanentGraph.getAllCommits().iterator();
        while (iterator.hasNext() && (data = this.getDetailsFromCache((Integer)(commit = (GraphCommit)iterator.next()).getId())) != null) {
            if (!this.matchesAllFilters(data, permanentGraph, detailsFilters, matchingHeads)) continue;
            result2.add(new CommitId((Hash)data.getId(), data.getRoot()));
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            VcsLogFilterer.$$$reportNull$$$0(38);
        }
        return arrayList;
    }

    private boolean matchesAllFilters(@NotNull VcsCommitMetadata commit, @NotNull PermanentGraph<Integer> permanentGraph, @NotNull List<VcsLogDetailsFilter> detailsFilters, @Nullable Set<Integer> matchingHeads) {
        boolean matchesAllDetails;
        if (commit == null) {
            VcsLogFilterer.$$$reportNull$$$0(39);
        }
        if (permanentGraph == null) {
            VcsLogFilterer.$$$reportNull$$$0(40);
        }
        if (detailsFilters == null) {
            VcsLogFilterer.$$$reportNull$$$0(41);
        }
        return (matchesAllDetails = ContainerUtil.and(detailsFilters, filter2 -> {
            if (commit == null) {
                VcsLogFilterer.$$$reportNull$$$0(49);
            }
            return filter2.matches(commit);
        })) && this.matchesAnyHead(permanentGraph, commit, matchingHeads);
    }

    private boolean matchesAnyHead(@NotNull PermanentGraph<Integer> permanentGraph, @NotNull VcsCommitMetadata commit, @Nullable Set<Integer> matchingHeads) {
        if (permanentGraph == null) {
            VcsLogFilterer.$$$reportNull$$$0(42);
        }
        if (commit == null) {
            VcsLogFilterer.$$$reportNull$$$0(43);
        }
        if (matchingHeads == null) {
            return true;
        }
        int commitIndex = this.myStorage.getCommitIndex((Hash)commit.getId(), commit.getRoot());
        return ContainerUtil.intersects((Collection)permanentGraph.getContainingBranches((Object)commitIndex), matchingHeads);
    }

    @Nullable
    private VcsCommitMetadata getDetailsFromCache(int commitIndex) {
        VcsCommitMetadata details = this.myTopCommitsDetailsCache.get(commitIndex);
        if (details != null) {
            return details;
        }
        return (VcsCommitMetadata)UIUtil.invokeAndWaitIfNeeded(() -> this.myCommitDetailsGetter.getCommitDataIfAvailable(commitIndex));
    }

    @NotNull
    private static Collection<CommitId> getFilteredDetailsFromTheVcs(@NotNull Map<VirtualFile, VcsLogProvider> providers, @NotNull VcsLogFilterCollection filterCollection, int maxCount) throws VcsException {
        if (providers == null) {
            VcsLogFilterer.$$$reportNull$$$0(44);
        }
        if (filterCollection == null) {
            VcsLogFilterer.$$$reportNull$$$0(45);
        }
        Set<VirtualFile> visibleRoots = VcsLogUtil.getAllVisibleRoots(providers.keySet(), filterCollection.getRootFilter(), filterCollection.getStructureFilter());
        ArrayList commits = ContainerUtil.newArrayList();
        for (Map.Entry<VirtualFile, VcsLogProvider> entry : providers.entrySet()) {
            VirtualFile root = entry.getKey();
            if (!visibleRoots.contains(root) || filterCollection.getUserFilter() != null && filterCollection.getUserFilter().getUsers(root).isEmpty()) continue;
            VcsLogFilterCollection rootSpecificCollection = filterCollection;
            if (rootSpecificCollection.getStructureFilter() != null) {
                rootSpecificCollection = new VcsLogFilterCollectionImpl.VcsLogFilterCollectionBuilder(filterCollection).with(new VcsLogStructureFilterImpl(ContainerUtil.newHashSet(VcsLogUtil.getFilteredFilesForRoot(root, filterCollection)))).build();
            }
            List matchingCommits = entry.getValue().getCommitsMatchingFilter(root, rootSpecificCollection, maxCount);
            commits.addAll(ContainerUtil.map((Collection)matchingCommits, commit -> new CommitId((Hash)commit.getId(), root)));
        }
        ArrayList arrayList = commits;
        if (arrayList == null) {
            VcsLogFilterer.$$$reportNull$$$0(46);
        }
        return arrayList;
    }

    @Nullable
    private Set<Integer> getMatchedCommitIndex(@Nullable Collection<CommitId> commits) {
        if (commits == null) {
            return null;
        }
        return ContainerUtil.map2Set(commits, commitId -> this.myStorage.getCommitIndex(commitId.getHash(), commitId.getRoot()));
    }

    public boolean affectedByIndexingRoots(@NotNull VcsLogFilterCollection filters, @NotNull List<VirtualFile> roots) {
        boolean needsIndex;
        List detailsFilters;
        if (filters == null) {
            VcsLogFilterer.$$$reportNull$$$0(47);
        }
        if (roots == null) {
            VcsLogFilterer.$$$reportNull$$$0(48);
        }
        if ((detailsFilters = filters.getDetailsFilters()).isEmpty()) {
            return false;
        }
        Set<VirtualFile> affectedRoots = VcsLogUtil.getAllVisibleRoots(roots, filters.getRootFilter(), filters.getStructureFilter());
        boolean bl = needsIndex = !affectedRoots.isEmpty();
        if (needsIndex) {
            LOG.debug(filters + " are affected by indexing of " + affectedRoots);
        }
        return needsIndex;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: 
            case 13: 
            case 18: 
            case 19: 
            case 20: 
            case 25: 
            case 38: 
            case 46: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: 
            case 13: 
            case 18: 
            case 19: 
            case 20: 
            case 25: 
            case 38: 
            case 46: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providers";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topCommitsDetailsCache";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detailsGetter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 5: 
            case 11: 
            case 14: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataPack";
                break;
            }
            case 6: 
            case 12: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sortType";
                break;
            }
            case 7: 
            case 15: 
            case 22: 
            case 31: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filters";
                break;
            }
            case 8: 
            case 16: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitCount";
                break;
            }
            case 9: 
            case 10: 
            case 13: 
            case 18: 
            case 19: 
            case 20: 
            case 25: 
            case 38: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/visible/VcsLogFilterer";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibleRoots";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 23: 
            case 37: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detailsFilters";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashes";
                break;
            }
            case 29: 
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refs";
                break;
            }
            case 30: 
            case 35: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 33: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 36: 
            case 40: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "permanentGraph";
                break;
            }
            case 39: 
            case 43: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commit";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filterCollection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/visible/VcsLogFilterer";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "filter";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisibleGraph";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "filterByDetails";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "filterWithVcs";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "filterInMemory";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilteredDetailsFromTheVcs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "filter";
                break;
            }
            case 9: 
            case 10: 
            case 13: 
            case 18: 
            case 19: 
            case 20: 
            case 25: 
            case 38: 
            case 46: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createVisibleGraph";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "filterByDetails";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "filterWithVcs";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "applyHashFilter";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getMatchingHeads";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "filterInMemory";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "matchesAllFilters";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "matchesAnyHead";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getFilteredDetailsFromTheVcs";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "affectedByIndexingRoots";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "lambda$matchesAllFilters$3";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getMatchingHeads$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: 
            case 13: 
            case 18: 
            case 19: 
            case 20: 
            case 25: 
            case 38: 
            case 46: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class FilterByDetailsResult {
        @Nullable
        public final Set<Integer> matchingCommits;
        public final boolean canRequestMore;
        @NotNull
        private final CommitCountStage commitCount;

        protected FilterByDetailsResult(@Nullable Set<Integer> commits, boolean more, @NotNull CommitCountStage count) {
            if (count == null) {
                FilterByDetailsResult.$$$reportNull$$$0(0);
            }
            this.matchingCommits = commits;
            this.canRequestMore = more;
            this.commitCount = count;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "count", "com/intellij/vcs/log/visible/VcsLogFilterer$FilterByDetailsResult", "<init>"));
        }
    }
}

