/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ProcessingContext;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyKeyValueExpression;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyNumericLiteralExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import org.jetbrains.annotations.NotNull;

public class PyDictKeyNamesCompletionContributor
extends CompletionContributor {
    public PyDictKeyNamesCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().inside(PySubscriptionExpression.class), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result2) {
                PsiElement resolvedElement;
                if (parameters == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (result2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                PsiElement original = parameters.getOriginalPosition();
                int offset = parameters.getOffset();
                if (original == null) {
                    return;
                }
                CompletionResultSet dictCompletion = PyDictKeyNamesCompletionContributor.createResult(original, result2, offset);
                PySubscriptionExpression subscription = (PySubscriptionExpression)PsiTreeUtil.getParentOfType((PsiElement)original, PySubscriptionExpression.class);
                if (subscription == null) {
                    return;
                }
                PyExpression operand = subscription.getOperand();
                PsiReference reference = operand.getReference();
                if (reference != null && (resolvedElement = reference.resolve()) instanceof PyTargetExpression) {
                    PyCallExpression dictConstructor;
                    PyDictLiteralExpression dict = (PyDictLiteralExpression)PsiTreeUtil.getNextSiblingOfType((PsiElement)resolvedElement, PyDictLiteralExpression.class);
                    if (dict != null) {
                        PyDictKeyNamesCompletionContributor.addDictLiteralKeys(dict, dictCompletion);
                        PsiFile file2 = parameters.getOriginalFile();
                        PyDictKeyNamesCompletionContributor.addAdditionalKeys(file2, (PsiElement)operand, dictCompletion);
                    }
                    if ((dictConstructor = (PyCallExpression)PsiTreeUtil.getNextSiblingOfType((PsiElement)resolvedElement, PyCallExpression.class)) != null) {
                        PyDictKeyNamesCompletionContributor.addDictConstructorKeys(dictConstructor, dictCompletion);
                        PsiFile file3 = parameters.getOriginalFile();
                        PyDictKeyNamesCompletionContributor.addAdditionalKeys(file3, (PsiElement)operand, dictCompletion);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/python/codeInsight/completion/PyDictKeyNamesCompletionContributor$1";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static CompletionResultSet createResult(@NotNull PsiElement original, @NotNull CompletionResultSet result2, int offset) {
        ASTNode prevNode;
        PyStringLiteralExpression prevElement;
        if (original == null) {
            PyDictKeyNamesCompletionContributor.$$$reportNull$$$0(0);
        }
        if (result2 == null) {
            PyDictKeyNamesCompletionContributor.$$$reportNull$$$0(1);
        }
        if ((prevElement = (PyStringLiteralExpression)PsiTreeUtil.getPrevSiblingOfType((PsiElement)original, PyStringLiteralExpression.class)) != null && (prevNode = prevElement.getNode()) != null && prevNode.getElementType() != PyTokenTypes.LBRACKET) {
            return result2.withPrefixMatcher(PyDictKeyNamesCompletionContributor.findPrefix(prevElement, offset));
        }
        PsiElement parentElement = original.getParent();
        if (parentElement != null && parentElement instanceof PyStringLiteralExpression) {
            return result2.withPrefixMatcher(PyDictKeyNamesCompletionContributor.findPrefix((PyElement)parentElement, offset));
        }
        PyNumericLiteralExpression number = (PyNumericLiteralExpression)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)original.getContainingFile(), (int)(offset - 1), PyNumericLiteralExpression.class, (boolean)false);
        if (number != null) {
            return result2.withPrefixMatcher(PyDictKeyNamesCompletionContributor.findPrefix(number, offset));
        }
        return result2;
    }

    private static String findPrefix(PyElement element, int offset) {
        return TextRange.create((int)element.getTextRange().getStartOffset(), (int)offset).substring(element.getContainingFile().getText());
    }

    private static void addDictConstructorKeys(PyCallExpression dictConstructor, CompletionResultSet result2) {
        TypeEvalContext context;
        PyType type;
        PyExpression callee = dictConstructor.getCallee();
        if (callee == null) {
            return;
        }
        String name = callee.getText();
        if ("dict".equals(name) && (type = (context = TypeEvalContext.codeCompletion(callee.getProject(), callee.getContainingFile())).getType(dictConstructor)) != null && type.isBuiltin()) {
            PyExpression[] argumentList;
            PyArgumentList list2 = dictConstructor.getArgumentList();
            if (list2 == null) {
                return;
            }
            for (PyExpression argument : argumentList = list2.getArguments()) {
                if (!(argument instanceof PyKeywordArgument)) continue;
                result2.addElement((LookupElement)PyDictKeyNamesCompletionContributor.createElement("'" + ((PyKeywordArgument)argument).getKeyword() + "'"));
            }
        }
    }

    private static void addAdditionalKeys(PsiFile file2, PsiElement operand, CompletionResultSet result2) {
        PySubscriptionExpression[] subscriptionExpressions;
        for (PySubscriptionExpression expr : subscriptionExpressions = (PySubscriptionExpression[])PyUtil.getAllChildrenOfType((PsiElement)file2, PySubscriptionExpression.class)) {
            PyExpression key;
            PsiElement parent;
            if (!expr.getOperand().getText().equals(operand.getText()) || !((parent = expr.getParent()) instanceof PyAssignmentStatement) || !expr.equals(((PyAssignmentStatement)parent).getLeftHandSideExpression()) || (key = expr.getIndexExpression()) == null) continue;
            boolean addHandler = PsiTreeUtil.findElementOfClassAtRange((PsiFile)file2, (int)key.getTextRange().getStartOffset(), (int)key.getTextRange().getEndOffset(), PyStringLiteralExpression.class) != null;
            result2.addElement((LookupElement)PyDictKeyNamesCompletionContributor.createElement(key.getText(), addHandler));
        }
    }

    public static void addDictLiteralKeys(PyDictLiteralExpression dict, CompletionResultSet result2) {
        PyKeyValueExpression[] keyValues;
        for (PyKeyValueExpression expression : keyValues = dict.getElements()) {
            boolean addHandler = PsiTreeUtil.findElementOfClassAtRange((PsiFile)dict.getContainingFile(), (int)expression.getTextRange().getStartOffset(), (int)expression.getTextRange().getEndOffset(), PyStringLiteralExpression.class) != null;
            result2.addElement((LookupElement)PyDictKeyNamesCompletionContributor.createElement(expression.getKey().getText(), addHandler));
        }
    }

    private static LookupElementBuilder createElement(String key) {
        return PyDictKeyNamesCompletionContributor.createElement(key, true);
    }

    private static LookupElementBuilder createElement(String key, boolean addHandler) {
        LookupElementBuilder item = LookupElementBuilder.create((String)key).withTypeText("dict key").withIcon(PlatformIcons.PARAMETER_ICON);
        if (addHandler) {
            item = item.withInsertHandler((InsertHandler)new InsertHandler<LookupElement>(){

                public void handleInsert(InsertionContext context, LookupElement item) {
                    PyStringLiteralExpression str = (PyStringLiteralExpression)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)context.getFile(), (int)context.getStartOffset(), PyStringLiteralExpression.class, (boolean)false);
                    if (str != null) {
                        boolean isDictKeys;
                        boolean bl = isDictKeys = PsiTreeUtil.getParentOfType((PsiElement)str, PySubscriptionExpression.class) != null;
                        if (isDictKeys) {
                            boolean badQuoting;
                            int off = context.getStartOffset() + str.getTextLength();
                            PsiElement element = context.getFile().findElementAt(off);
                            boolean atRBrace = element == null || element.getNode().getElementType() == PyTokenTypes.RBRACKET;
                            boolean bl2 = badQuoting = !(StringUtil.startsWithChar((CharSequence)str.getText(), (char)'\'') && StringUtil.endsWithChar((CharSequence)str.getText(), (char)'\'') || StringUtil.startsWithChar((CharSequence)str.getText(), (char)'\"') && StringUtil.endsWithChar((CharSequence)str.getText(), (char)'\"'));
                            if (badQuoting || !atRBrace) {
                                Document document = context.getEditor().getDocument();
                                int offset = context.getTailOffset();
                                document.deleteString(offset - 1, offset);
                            }
                        }
                    }
                }
            });
        }
        return item;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "original";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/codeInsight/completion/PyDictKeyNamesCompletionContributor";
        objectArray[2] = "createResult";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

