/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.controlflow;

import com.google.common.collect.Lists;
import com.intellij.codeInsight.controlflow.ControlFlowBuilder;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.codeInsight.controlflow.PyTypeAssertionEvaluator;
import com.jetbrains.python.codeInsight.controlflow.ReadWriteInstruction;
import com.jetbrains.python.psi.PyReferenceExpression;
import java.util.ArrayList;
import java.util.List;

public class InstructionBuilder {
    private InstructionBuilder() {
    }

    public static List<Instruction> buildInstructions(ControlFlowBuilder builder, List<PyTypeAssertionEvaluator.Assertion> assertions) {
        ArrayList result2 = Lists.newArrayList();
        for (PyTypeAssertionEvaluator.Assertion def : assertions) {
            PyReferenceExpression e = def.getElement();
            QualifiedName qname = e.asQualifiedName();
            String name = qname != null ? qname.toString() : e.getName();
            result2.add(ReadWriteInstruction.assertType(builder, (PsiElement)e, name, def.getTypeEvalFunction()));
        }
        return result2;
    }

    public static void addAssertInstructions(ControlFlowBuilder builder, PyTypeAssertionEvaluator assertionEvaluator) {
        for (Instruction instr : InstructionBuilder.buildInstructions(builder, assertionEvaluator.getDefinitions())) {
            builder.addNode(instr);
        }
    }
}

