/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.google.common.collect.Sets;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.breakpoints.SuspendPolicy;
import com.intellij.xdebugger.breakpoints.XLineBreakpointTypeBase;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.debugger.PyDebugSupportUtils;
import com.jetbrains.python.debugger.PyDebuggerEditorsProvider;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class PyLineBreakpointType
extends XLineBreakpointTypeBase {
    public static final String ID = "python-line";
    private static final String NAME = "Python Line Breakpoint";
    private static final Set<IElementType> UNSTOPPABLE_ELEMENT_TYPES = Sets.newHashSet((Object[])new IElementType[]{PyTokenTypes.TRIPLE_QUOTED_STRING, PyTokenTypes.SINGLE_QUOTED_STRING, PyTokenTypes.SINGLE_QUOTED_UNICODE, PyTokenTypes.DOCSTRING});
    private static final Class[] UNSTOPPABLE_ELEMENTS = new Class[]{PsiWhiteSpace.class, PsiComment.class};

    public PyLineBreakpointType() {
        super(ID, NAME, (XDebuggerEditorsProvider)new PyDebuggerEditorsProvider());
    }

    public boolean canPutAt(@NotNull VirtualFile file2, int line, @NotNull Project project) {
        if (file2 == null) {
            PyLineBreakpointType.$$$reportNull$$$0(0);
        }
        if (project == null) {
            PyLineBreakpointType.$$$reportNull$$$0(1);
        }
        Ref stoppable = Ref.create((Object)false);
        Document document = FileDocumentManager.getInstance().getDocument(file2);
        if (document != null) {
            PyLineBreakpointType.lineHasStoppablePsi(project, file2, line, PythonFileType.INSTANCE, document, UNSTOPPABLE_ELEMENTS, UNSTOPPABLE_ELEMENT_TYPES, (Ref<Boolean>)stoppable);
        }
        return (Boolean)stoppable.get();
    }

    public static void lineHasStoppablePsi(@NotNull Project project, @NotNull VirtualFile file2, int line, PythonFileType fileType, Document document, Class[] unstoppablePsiElements, Set<IElementType> unstoppableElementTypes, Ref<Boolean> stoppable) {
        if (project == null) {
            PyLineBreakpointType.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            PyLineBreakpointType.$$$reportNull$$$0(3);
        }
        if (file2.getFileType() == fileType || PyLineBreakpointType.isPythonScratch(project, file2)) {
            XDebuggerUtil.getInstance().iterateLine(project, document, line, psiElement -> {
                if (PsiTreeUtil.getNonStrictParentOfType((PsiElement)psiElement, (Class[])unstoppablePsiElements) != null) {
                    return true;
                }
                if (psiElement.getNode() != null && unstoppableElementTypes.contains(psiElement.getNode().getElementType())) {
                    return true;
                }
                stoppable.set((Object)true);
                return false;
            });
            if (PyDebugSupportUtils.isContinuationLine(document, line - 1)) {
                stoppable.set((Object)false);
            }
        }
    }

    public boolean isSuspendThreadSupported() {
        return true;
    }

    public SuspendPolicy getDefaultSuspendPolicy() {
        return SuspendPolicy.THREAD;
    }

    private static boolean isPythonScratch(@NotNull Project project, @NotNull VirtualFile file2) {
        if (project == null) {
            PyLineBreakpointType.$$$reportNull$$$0(4);
        }
        if (file2 == null) {
            PyLineBreakpointType.$$$reportNull$$$0(5);
        }
        return ScratchUtil.isScratch(file2) && LanguageUtil.getLanguageForPsi((Project)project, (VirtualFile)file2) == PythonLanguage.INSTANCE;
    }

    public String getBreakpointsDialogHelpTopic() {
        return "reference.dialogs.breakpoints";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/debugger/PyLineBreakpointType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canPutAt";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "lineHasStoppablePsi";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isPythonScratch";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

