/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ObjectUtils;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyElementType;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChainedComparisonsQuickFix
implements LocalQuickFix {
    private final boolean myCommonIsInLeftLeft;
    private final boolean myCommonIsInRightLeft;
    private final boolean myUseRightChildOfLeft;

    public ChainedComparisonsQuickFix(boolean commonIsInLeftLeft, boolean commonIsInRightLeft, boolean useRightChildOfLeft) {
        this.myCommonIsInLeftLeft = commonIsInLeftLeft;
        this.myCommonIsInRightLeft = commonIsInRightLeft;
        this.myUseRightChildOfLeft = useRightChildOfLeft;
    }

    @NotNull
    public String getFamilyName() {
        String string = PyBundle.message("QFIX.chained.comparison", new Object[0]);
        if (string == null) {
            ChainedComparisonsQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        PyBinaryExpression expression;
        if (project == null) {
            ChainedComparisonsQuickFix.$$$reportNull$$$0(1);
        }
        if (descriptor2 == null) {
            ChainedComparisonsQuickFix.$$$reportNull$$$0(2);
        }
        if ((expression = PyUtil.as(descriptor2.getPsiElement(), PyBinaryExpression.class)) != null && expression.isWritable()) {
            PyBinaryExpression rightExpression = PyUtil.as(expression.getRightExpression(), PyBinaryExpression.class);
            PyBinaryExpression leftExpression = PyUtil.as(expression.getLeftExpression(), PyBinaryExpression.class);
            if (rightExpression != null && leftExpression != null && ChainedComparisonsQuickFix.isLogicalAndExpression(expression)) {
                this.applyFix(this.goDownIfNeeded(leftExpression), rightExpression, project);
            }
        }
    }

    @NotNull
    private PyBinaryExpression goDownIfNeeded(@NotNull PyBinaryExpression expression) {
        if (expression == null) {
            ChainedComparisonsQuickFix.$$$reportNull$$$0(3);
        }
        PyExpression rightExpression = expression.getRightExpression();
        if (this.myUseRightChildOfLeft && rightExpression instanceof PyBinaryExpression && ChainedComparisonsQuickFix.isLogicalAndExpression(expression)) {
            PyBinaryExpression pyBinaryExpression = (PyBinaryExpression)rightExpression;
            if (pyBinaryExpression == null) {
                ChainedComparisonsQuickFix.$$$reportNull$$$0(4);
            }
            return pyBinaryExpression;
        }
        PyBinaryExpression pyBinaryExpression = expression;
        if (pyBinaryExpression == null) {
            ChainedComparisonsQuickFix.$$$reportNull$$$0(5);
        }
        return pyBinaryExpression;
    }

    private void applyFix(@NotNull PyBinaryExpression leftExpression, @NotNull PyBinaryExpression rightExpression, @NotNull Project project) {
        PyExpression newRightExpression;
        String operator;
        if (leftExpression == null) {
            ChainedComparisonsQuickFix.$$$reportNull$$$0(6);
        }
        if (rightExpression == null) {
            ChainedComparisonsQuickFix.$$$reportNull$$$0(7);
        }
        if (project == null) {
            ChainedComparisonsQuickFix.$$$reportNull$$$0(8);
        }
        PyElementGenerator elementGenerator = PyElementGenerator.getInstance(project);
        PyExpression newLeftExpression = this.myCommonIsInLeftLeft ? ChainedComparisonsQuickFix.invertExpression(leftExpression, elementGenerator) : leftExpression;
        if (this.myCommonIsInRightLeft) {
            operator = ChainedComparisonsQuickFix.getLeftestOperator(rightExpression).getText();
            newRightExpression = ChainedComparisonsQuickFix.getLargeRightExpression(rightExpression, project);
        } else {
            operator = ChainedComparisonsQuickFix.invertOperator((PsiElement)ObjectUtils.assertNotNull((Object)rightExpression.getPsiOperator()));
            PyExpression rightLeftExpr = rightExpression.getLeftExpression();
            newRightExpression = rightLeftExpr instanceof PyBinaryExpression ? ChainedComparisonsQuickFix.invertExpression((PyBinaryExpression)rightLeftExpr, elementGenerator) : rightLeftExpr;
        }
        PyBinaryExpression binaryExpression = elementGenerator.createBinaryExpression(operator, newLeftExpression, newRightExpression);
        leftExpression.replace((PsiElement)binaryExpression);
        rightExpression.delete();
    }

    @NotNull
    private static PsiElement getLeftestOperator(@NotNull PyBinaryExpression expression) {
        if (expression == null) {
            ChainedComparisonsQuickFix.$$$reportNull$$$0(9);
        }
        PsiElement op = expression.getPsiOperator();
        while (ChainedComparisonsQuickFix.isComparisonExpression(expression.getLeftExpression())) {
            expression = (PyBinaryExpression)expression.getLeftExpression();
            op = expression.getPsiOperator();
        }
        assert (op != null);
        PsiElement psiElement = op;
        if (psiElement == null) {
            ChainedComparisonsQuickFix.$$$reportNull$$$0(10);
        }
        return psiElement;
    }

    @NotNull
    private static PyExpression invertExpression(@NotNull PyBinaryExpression expression, @NotNull PyElementGenerator elementGenerator) {
        if (expression == null) {
            ChainedComparisonsQuickFix.$$$reportNull$$$0(11);
        }
        if (elementGenerator == null) {
            ChainedComparisonsQuickFix.$$$reportNull$$$0(12);
        }
        if (ChainedComparisonsQuickFix.isComparisonExpression(expression)) {
            PyExpression left = expression.getLeftExpression();
            PyExpression right = expression.getRightExpression();
            String newOperator = ChainedComparisonsQuickFix.invertOperator((PsiElement)ObjectUtils.assertNotNull((Object)expression.getPsiOperator()));
            PyExpression newRight = ChainedComparisonsQuickFix.isComparisonExpression(left) ? ChainedComparisonsQuickFix.invertExpression((PyBinaryExpression)left, elementGenerator) : left;
            PyBinaryExpression pyBinaryExpression = elementGenerator.createBinaryExpression(newOperator, right, newRight);
            if (pyBinaryExpression == null) {
                ChainedComparisonsQuickFix.$$$reportNull$$$0(13);
            }
            return pyBinaryExpression;
        }
        PyBinaryExpression pyBinaryExpression = expression;
        if (pyBinaryExpression == null) {
            ChainedComparisonsQuickFix.$$$reportNull$$$0(14);
        }
        return pyBinaryExpression;
    }

    @NotNull
    private static String invertOperator(@NotNull PsiElement op) {
        if (op == null) {
            ChainedComparisonsQuickFix.$$$reportNull$$$0(15);
        }
        if (op.getText().equals(">")) {
            if ("<" == null) {
                ChainedComparisonsQuickFix.$$$reportNull$$$0(16);
            }
            return "<";
        }
        if (op.getText().equals("<")) {
            if (">" == null) {
                ChainedComparisonsQuickFix.$$$reportNull$$$0(17);
            }
            return ">";
        }
        if (op.getText().equals(">=")) {
            if ("<=" == null) {
                ChainedComparisonsQuickFix.$$$reportNull$$$0(18);
            }
            return "<=";
        }
        if (op.getText().equals("<=")) {
            if (">=" == null) {
                ChainedComparisonsQuickFix.$$$reportNull$$$0(19);
            }
            return ">=";
        }
        String string = op.getText();
        if (string == null) {
            ChainedComparisonsQuickFix.$$$reportNull$$$0(20);
        }
        return string;
    }

    @Nullable
    private static PyExpression getLargeRightExpression(@NotNull PyBinaryExpression expression, @NotNull Project project) {
        if (expression == null) {
            ChainedComparisonsQuickFix.$$$reportNull$$$0(21);
        }
        if (project == null) {
            ChainedComparisonsQuickFix.$$$reportNull$$$0(22);
        }
        PyElementGenerator elementGenerator = PyElementGenerator.getInstance(project);
        PyExpression left = expression.getLeftExpression();
        PyExpression right = expression.getRightExpression();
        PsiElement operator = expression.getPsiOperator();
        while (ChainedComparisonsQuickFix.isComparisonExpression(left)) {
            assert (operator != null);
            right = elementGenerator.createBinaryExpression(operator.getText(), ((PyBinaryExpression)left).getRightExpression(), right);
            operator = ((PyBinaryExpression)left).getPsiOperator();
            left = ((PyBinaryExpression)left).getLeftExpression();
        }
        return right;
    }

    private static boolean isComparisonExpression(@Nullable PyExpression expression) {
        if (!(expression instanceof PyBinaryExpression)) {
            return false;
        }
        PyElementType operator = ((PyBinaryExpression)expression).getOperator();
        return PyTokenTypes.RELATIONAL_OPERATIONS.contains((IElementType)operator) || PyTokenTypes.EQUALITY_OPERATIONS.contains((IElementType)operator);
    }

    private static boolean isLogicalAndExpression(@Nullable PyExpression expression) {
        return expression instanceof PyBinaryExpression && ((PyBinaryExpression)expression).getOperator() == PyTokenTypes.AND_KEYWORD;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 15: 
            case 21: 
            case 22: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 15: 
            case 21: 
            case 22: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/quickfix/ChainedComparisonsQuickFix";
                break;
            }
            case 1: 
            case 8: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 3: 
            case 9: 
            case 11: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftExpression";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightExpression";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementGenerator";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "op";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 15: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/quickfix/ChainedComparisonsQuickFix";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "goDownIfNeeded";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getLeftestOperator";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "invertExpression";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "invertOperator";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "goDownIfNeeded";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getLeftestOperator";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "invertExpression";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "invertOperator";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getLargeRightExpression";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 15: 
            case 21: 
            case 22: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

