/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.imports.AddImportHelper;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyImportStatementBase;
import org.jetbrains.annotations.NotNull;

public class PyAddImportFix
implements LocalQuickFix {
    @NotNull
    private final String myImportToAdd;
    @NotNull
    private final PyFile myFile;

    public PyAddImportFix(@NotNull String importToAdd, @NotNull PyFile file2) {
        if (importToAdd == null) {
            PyAddImportFix.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            PyAddImportFix.$$$reportNull$$$0(1);
        }
        this.myImportToAdd = importToAdd;
        this.myFile = file2;
    }

    @NotNull
    public String getFamilyName() {
        String string = PyBundle.message("QFIX.add.import.add.import", this.myImportToAdd);
        if (string == null) {
            PyAddImportFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        if (project == null) {
            PyAddImportFix.$$$reportNull$$$0(3);
        }
        if (descriptor2 == null) {
            PyAddImportFix.$$$reportNull$$$0(4);
        }
        PyElementGenerator generator = PyElementGenerator.getInstance(project);
        PyImportStatementBase statement = generator.createFromText(LanguageLevel.forElement((PsiElement)this.myFile), PyImportStatementBase.class, this.myImportToAdd);
        PsiElement recommendedPosition = AddImportHelper.getFileInsertPosition(this.myFile);
        this.myFile.addAfter((PsiElement)statement, recommendedPosition);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importToAdd";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/quickfix/PyAddImportFix";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/quickfix/PyAddImportFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

