/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging;

import com.google.common.collect.Lists;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunCanceledByUserException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessNotCreatedException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.net.HttpConfigurable;
import com.jetbrains.python.PythonHelpersLocator;
import com.jetbrains.python.packaging.PyExecutionException;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.packaging.PyPackageUtil;
import com.jetbrains.python.packaging.PyRequirement;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.sdk.PyDetectedSdk;
import com.jetbrains.python.sdk.PyLazySdk;
import com.jetbrains.python.sdk.PythonEnvUtil;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyPackageManagerImpl
extends PyPackageManager {
    private static final String SETUPTOOLS_PRE_26_VERSION = "1.4.2";
    private static final String PIP_PRE_26_VERSION = "1.1";
    private static final String VIRTUALENV_PRE_26_VERSION = "1.7.2";
    private static final String SETUPTOOLS_VERSION = "28.8.0";
    private static final String PIP_VERSION = "9.0.1";
    private static final String VIRTUALENV_VERSION = "15.1.0";
    private static final int ERROR_NO_SETUPTOOLS = 3;
    private static final Logger LOG = Logger.getInstance(PyPackageManagerImpl.class);
    private static final String PACKAGING_TOOL = "packaging_tool.py";
    private static final int TIMEOUT = 600000;
    private static final String BUILD_DIR_OPTION = "--build-dir";
    private static final String INSTALL = "install";
    private static final String UNINSTALL = "uninstall";
    private static final String UNTAR = "untar";
    @Nullable
    private volatile List<PyPackage> myPackagesCache;
    private final AtomicBoolean myUpdatingCache;
    @NotNull
    private final Sdk mySdk;

    @Override
    public void refresh() {
        LOG.debug("Refreshing SDK roots and packages cache");
        Application application = ApplicationManager.getApplication();
        application.invokeLater(() -> {
            Sdk sdk = this.getSdk();
            application.runWriteAction(() -> {
                VirtualFile[] files = sdk.getRootProvider().getFiles(OrderRootType.CLASSES);
                VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)true, (boolean)true, (VirtualFile[])files);
            });
            PythonSdkType.getInstance().setupSdkPaths(sdk);
        });
    }

    @Override
    public void installManagement() throws ExecutionException {
        String name;
        Sdk sdk = this.getSdk();
        boolean pre26 = PythonSdkType.getLanguageLevelForSdk(sdk).isOlderThan(LanguageLevel.PYTHON26);
        if (!this.refreshAndCheckForSetuptools()) {
            name = "setuptools-" + (pre26 ? SETUPTOOLS_PRE_26_VERSION : SETUPTOOLS_VERSION);
            this.installManagement(name);
        }
        if (PyPackageUtil.findPackage(this.refreshAndGetPackages(false), "pip") == null) {
            name = "pip-" + (pre26 ? PIP_PRE_26_VERSION : PIP_VERSION);
            this.installManagement(name);
        }
    }

    @Override
    public boolean hasManagement() throws ExecutionException {
        return this.refreshAndCheckForSetuptools() && PyPackageUtil.findPackage(this.refreshAndGetPackages(false), "pip") != null;
    }

    private boolean refreshAndCheckForSetuptools() throws ExecutionException {
        try {
            List<PyPackage> packages = this.refreshAndGetPackages(false);
            return PyPackageUtil.findPackage(packages, "setuptools") != null || PyPackageUtil.findPackage(packages, "distribute") != null;
        }
        catch (PyExecutionException e) {
            if (e.getExitCode() == 3) {
                return false;
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void installManagement(@NotNull String name) throws ExecutionException {
        if (name == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(0);
        }
        String dirName = this.extractHelper(name + ".tar.gz");
        try {
            String fileName = dirName + name + File.separatorChar + "setup.py";
            this.getPythonProcessResult(fileName, Collections.singletonList(INSTALL), true, true, dirName + name);
        }
        finally {
            FileUtil.delete((File)new File(dirName));
        }
    }

    @NotNull
    private String extractHelper(@NotNull String name) throws ExecutionException {
        if (name == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(1);
        }
        String helperPath = this.getHelperPath(name);
        ArrayList args = Lists.newArrayList((Object[])new String[]{UNTAR, helperPath});
        String result2 = this.getHelperResult(PACKAGING_TOOL, args, false, false, null);
        String dirName = FileUtil.toSystemDependentName((String)result2.trim());
        if (!dirName.endsWith(File.separator)) {
            dirName = dirName + File.separator;
        }
        String string = dirName;
        if (string == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    PyPackageManagerImpl(@NotNull Sdk sdk) {
        if (sdk == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(3);
        }
        this.myPackagesCache = null;
        this.myUpdatingCache = new AtomicBoolean(false);
        this.mySdk = sdk;
        this.subscribeToLocalChanges();
    }

    protected void subscribeToLocalChanges() {
        Application app = ApplicationManager.getApplication();
        final MessageBusConnection connection = app.getMessageBus().connect();
        MySdkRootWatcher watcher = new MySdkRootWatcher();
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)watcher);
        connection.subscribe(ProjectJdkTable.JDK_TABLE_TOPIC, (Object)new ProjectJdkTable.Adapter(){

            public void jdkRemoved(@NotNull Sdk jdk) {
                if (jdk == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (jdk == PyPackageManagerImpl.this.getSdk()) {
                    connection.disconnect();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jdk", "com/jetbrains/python/packaging/PyPackageManagerImpl$1", "jdkRemoved"));
            }
        });
    }

    @NotNull
    public Sdk getSdk() {
        Sdk sdk = this.mySdk;
        if (sdk == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(4);
        }
        return sdk;
    }

    @Override
    public void install(@NotNull String requirementString) throws ExecutionException {
        if (requirementString == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(5);
        }
        this.installManagement();
        this.install(Collections.singletonList(PyRequirement.fromLine(requirementString)), Collections.emptyList());
    }

    @Override
    public void install(@NotNull List<PyRequirement> requirements, @NotNull List<String> extraArgs) throws ExecutionException {
        File buildDir;
        if (requirements == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(6);
        }
        if (extraArgs == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(7);
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add(INSTALL);
        try {
            buildDir = FileUtil.createTempDirectory((String)"pycharm-packaging", null);
        }
        catch (IOException e) {
            throw new ExecutionException("Cannot create temporary build directory");
        }
        if (!extraArgs.contains(BUILD_DIR_OPTION)) {
            args.addAll(Arrays.asList(BUILD_DIR_OPTION, buildDir.getAbsolutePath()));
        }
        boolean useUserSite = extraArgs.contains("--user");
        String proxyString = PyPackageManagerImpl.getProxyString();
        if (proxyString != null) {
            args.add("--proxy");
            args.add(proxyString);
        }
        args.addAll(extraArgs);
        for (PyRequirement req : requirements) {
            args.addAll(req.getInstallOptions());
        }
        try {
            this.getHelperResult(PACKAGING_TOOL, args, !useUserSite, true, null);
        }
        catch (PyExecutionException e) {
            ArrayList<String> simplifiedArgs = new ArrayList<String>();
            simplifiedArgs.add(INSTALL);
            if (proxyString != null) {
                simplifiedArgs.add("--proxy");
                simplifiedArgs.add(proxyString);
            }
            simplifiedArgs.addAll(extraArgs);
            for (PyRequirement req : requirements) {
                simplifiedArgs.addAll(req.getInstallOptions());
            }
            throw new PyExecutionException(e.getMessage(), "pip", simplifiedArgs, e.getStdout(), e.getStderr(), e.getExitCode(), e.getFixes());
        }
        finally {
            LOG.debug("Packages cache is about to be refreshed because these requirements were installed: " + requirements);
            this.refreshPackagesSynchronously();
            FileUtil.delete((File)buildDir);
        }
    }

    @Override
    public void uninstall(@NotNull List<PyPackage> packages) throws ExecutionException {
        if (packages == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(8);
        }
        ArrayList<String> args = new ArrayList<String>();
        try {
            args.add(UNINSTALL);
            boolean canModify = true;
            for (PyPackage pkg : packages) {
                String location;
                if (canModify && (location = pkg.getLocation()) != null) {
                    canModify = Files.isWritable(Paths.get(location, new String[0]));
                }
                args.add(pkg.getName());
            }
            this.getHelperResult(PACKAGING_TOOL, args, !canModify, true, null);
        }
        catch (PyExecutionException e) {
            throw new PyExecutionException(e.getMessage(), "pip", args, e.getStdout(), e.getStderr(), e.getExitCode(), e.getFixes());
        }
        finally {
            LOG.debug("Packages cache is about to be refreshed because these packages were uninstalled: " + packages);
            this.refreshPackagesSynchronously();
        }
    }

    @Override
    @Nullable
    public List<PyPackage> getPackages() {
        List<PyPackage> packages = this.myPackagesCache;
        return packages != null ? Collections.unmodifiableList(packages) : null;
    }

    @NotNull
    protected List<PyPackage> collectPackages() throws ExecutionException {
        String output;
        if (this.mySdk instanceof PyLazySdk) {
            List<PyPackage> list2 = Collections.emptyList();
            if (list2 == null) {
                PyPackageManagerImpl.$$$reportNull$$$0(9);
            }
            return list2;
        }
        try {
            LOG.debug("Collecting installed packages for the SDK " + this.mySdk.getName(), new Throwable());
            output = this.getHelperResult(PACKAGING_TOOL, Collections.singletonList("list"), false, false, null);
        }
        catch (ProcessNotCreatedException ex) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                LOG.info("Not-env unit test mode, will return mock packages");
                ArrayList arrayList = Lists.newArrayList((Object[])new PyPackage[]{new PyPackage("pip", PIP_VERSION, null, Collections.emptyList()), new PyPackage("setuptools", SETUPTOOLS_VERSION, null, Collections.emptyList())});
                if (arrayList == null) {
                    PyPackageManagerImpl.$$$reportNull$$$0(10);
                }
                return arrayList;
            }
            throw ex;
        }
        List<PyPackage> list3 = PyPackageManagerImpl.parsePackagingToolOutput(output);
        if (list3 == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(11);
        }
        return list3;
    }

    @Override
    @NotNull
    public Set<PyPackage> getDependents(@NotNull PyPackage pkg) throws ExecutionException {
        if (pkg == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(12);
        }
        List<PyPackage> packages = this.refreshAndGetPackages(false);
        HashSet<PyPackage> dependents = new HashSet<PyPackage>();
        for (PyPackage p : packages) {
            List<PyRequirement> requirements = p.getRequirements();
            for (PyRequirement requirement : requirements) {
                if (!requirement.getName().equals(pkg.getName())) continue;
                dependents.add(p);
            }
        }
        HashSet<PyPackage> hashSet = dependents;
        if (hashSet == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(13);
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public String createVirtualEnv(@NotNull String destinationDir, boolean useGlobalSite) throws ExecutionException {
        VirtualFile binaryFile;
        String path;
        if (destinationDir == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(14);
        }
        ArrayList<String> args = new ArrayList<String>();
        Sdk sdk = this.getSdk();
        LanguageLevel languageLevel = PyPackageManagerImpl.getOrRequestLanguageLevelForSdk(sdk);
        boolean usePyVenv = languageLevel.isAtLeast(LanguageLevel.PYTHON33);
        if (usePyVenv) {
            args.add("pyvenv");
            if (useGlobalSite) {
                args.add("--system-site-packages");
            }
            args.add(destinationDir);
            this.getHelperResult(PACKAGING_TOOL, args, false, true, null);
        } else {
            if (useGlobalSite) {
                args.add("--system-site-packages");
            }
            args.add(destinationDir);
            boolean pre26 = languageLevel.isOlderThan(LanguageLevel.PYTHON26);
            String name = "virtualenv-" + (pre26 ? VIRTUALENV_PRE_26_VERSION : VIRTUALENV_VERSION);
            String dirName = this.extractHelper(name + ".tar.gz");
            try {
                String fileName = dirName + name + File.separatorChar + "virtualenv.py";
                this.getPythonProcessResult(fileName, args, false, true, dirName + name);
            }
            finally {
                FileUtil.delete((File)new File(dirName));
            }
        }
        String binary = PythonSdkType.getPythonExecutable(destinationDir);
        String binaryFallback = destinationDir + File.separator + "bin" + File.separator + "python";
        String string = path = binary != null ? binary : binaryFallback;
        if (usePyVenv && (binaryFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(path)) != null) {
            ProjectJdkImpl tmpSdk = new ProjectJdkImpl("", (SdkTypeId)PythonSdkType.getInstance());
            tmpSdk.setHomePath(path);
            PyPackageManagerImpl manager = new PyPackageManagerImpl(tmpSdk);
            ((PyPackageManager)manager).installManagement();
        }
        String string2 = path;
        if (string2 == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(15);
        }
        return string2;
    }

    @NotNull
    private static LanguageLevel getOrRequestLanguageLevelForSdk(@NotNull Sdk sdk) throws ExecutionException {
        if (sdk == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(16);
        }
        if (sdk instanceof PyDetectedSdk) {
            PythonSdkFlavor flavor = PythonSdkFlavor.getFlavor(sdk);
            if (flavor != null && sdk.getHomePath() != null) {
                LanguageLevel languageLevel = flavor.getLanguageLevel(sdk.getHomePath());
                if (languageLevel == null) {
                    PyPackageManagerImpl.$$$reportNull$$$0(17);
                }
                return languageLevel;
            }
            throw new ExecutionException("Cannot retrieve the version of the detected SDK: " + sdk.getHomePath());
        }
        LanguageLevel languageLevel = PythonSdkType.getLanguageLevelForSdk(sdk);
        if (languageLevel == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(18);
        }
        return languageLevel;
    }

    @Override
    @Nullable
    public List<PyRequirement> getRequirements(@NotNull Module module2) {
        if (module2 == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(19);
        }
        return Optional.ofNullable(PyPackageUtil.getRequirementsFromTxt(module2)).orElseGet(() -> {
            if (module2 == null) {
                PyPackageManagerImpl.$$$reportNull$$$0(35);
            }
            return PyPackageUtil.findSetupPyRequires(module2);
        });
    }

    @Override
    @NotNull
    public List<PyRequirement> parseRequirements(@NotNull String text) {
        if (text == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(20);
        }
        List<PyRequirement> list2 = PyPackageUtil.fix(PyRequirement.fromText(text));
        if (list2 == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(21);
        }
        return list2;
    }

    @Override
    @NotNull
    public List<PyPackage> refreshAndGetPackages(boolean alwaysRefresh) throws ExecutionException {
        List<PyPackage> currentPackages = this.myPackagesCache;
        if (alwaysRefresh || currentPackages == null) {
            List<PyPackage> list2;
            try {
                List<PyPackage> packages = this.collectPackages();
                LOG.debug("Packages installed in " + this.mySdk.getName() + ": " + packages);
                this.myPackagesCache = packages;
                ((PyPackageManager.Listener)ApplicationManager.getApplication().getMessageBus().syncPublisher(PACKAGE_MANAGER_TOPIC)).packagesRefreshed(this.mySdk);
                list2 = Collections.unmodifiableList(packages);
            }
            catch (ExecutionException e) {
                this.myPackagesCache = Collections.emptyList();
                throw e;
            }
            if (list2 == null) {
                PyPackageManagerImpl.$$$reportNull$$$0(22);
            }
            return list2;
        }
        List<PyPackage> list3 = Collections.unmodifiableList(currentPackages);
        if (list3 == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(23);
        }
        return list3;
    }

    private void refreshPackagesSynchronously() {
        PyPackageUtil.updatePackagesSynchronouslyWithGuard(this, this.myUpdatingCache);
    }

    @Nullable
    private static String getProxyString() {
        HttpConfigurable settings = HttpConfigurable.getInstance();
        if (settings != null && settings.USE_HTTP_PROXY) {
            String credentials = settings.PROXY_AUTHENTICATION ? String.format("%s:%s@", settings.getProxyLogin(), settings.getPlainProxyPassword()) : "";
            return "http://" + credentials + String.format("%s:%d", settings.PROXY_HOST, settings.PROXY_PORT);
        }
        return null;
    }

    @NotNull
    private String getHelperResult(@NotNull String helper, @NotNull List<String> args, boolean askForSudo, boolean showProgress, @Nullable String parentDir) throws ExecutionException {
        String helperPath;
        if (helper == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(24);
        }
        if (args == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(25);
        }
        if ((helperPath = this.getHelperPath(helper)) == null) {
            throw new ExecutionException("Cannot find external tool: " + helper);
        }
        String string = this.getPythonProcessResult(helperPath, args, askForSudo, showProgress, parentDir);
        if (string == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(26);
        }
        return string;
    }

    @Nullable
    protected String getHelperPath(String helper) throws ExecutionException {
        return PythonHelpersLocator.getHelperPath(helper);
    }

    @NotNull
    private String getPythonProcessResult(@NotNull String path, @NotNull List<String> args, boolean askForSudo, boolean showProgress, @Nullable String workingDir) throws ExecutionException {
        if (path == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(27);
        }
        if (args == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(28);
        }
        ProcessOutput output = this.getPythonProcessOutput(path, args, askForSudo, showProgress, workingDir);
        int exitCode = output.getExitCode();
        if (output.isTimeout()) {
            throw new PyExecutionException("Timed out", path, args, output);
        }
        if (exitCode != 0) {
            throw new PyExecutionException("Non-zero exit code (" + exitCode + ")", path, args, output);
        }
        String string = output.getStdout();
        if (string == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(29);
        }
        return string;
    }

    @NotNull
    protected ProcessOutput getPythonProcessOutput(@NotNull String helperPath, @NotNull List<String> args, boolean askForSudo, boolean showProgress, @Nullable String workingDir) throws ExecutionException {
        ProcessOutput processOutput;
        String homePath;
        if (helperPath == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(30);
        }
        if (args == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(31);
        }
        if ((homePath = this.getSdk().getHomePath()) == null) {
            throw new ExecutionException("Cannot find Python interpreter for SDK " + this.mySdk.getName());
        }
        if (workingDir == null) {
            workingDir = new File(homePath).getParent();
        }
        ArrayList<String> cmdline = new ArrayList<String>();
        cmdline.add(homePath);
        cmdline.add(helperPath);
        cmdline.addAll(args);
        LOG.info("Running packaging tool: " + StringUtil.join(cmdline, (String)" "));
        boolean canCreate = Files.isWritable(Paths.get(homePath, new String[0]));
        boolean useSudo = !canCreate && askForSudo;
        try {
            ProcessOutput result2;
            GeneralCommandLine commandLine = new GeneralCommandLine(cmdline).withWorkDirectory(workingDir);
            Map environment = commandLine.getEnvironment();
            PythonEnvUtil.setPythonUnbuffered(environment);
            PythonEnvUtil.setPythonDontWriteBytecode(environment);
            PythonEnvUtil.resetHomePathChanges(homePath, environment);
            PythonSdkFlavor flavor = PythonSdkFlavor.getFlavor(this.mySdk);
            if (flavor != null && flavor.commandLinePatcher() != null) {
                flavor.commandLinePatcher().patchCommandLine(commandLine);
            }
            Process process2 = useSudo ? ExecUtil.sudo((GeneralCommandLine)commandLine, (String)"Please enter your password to make changes in system packages: ") : commandLine.createProcess();
            CapturingProcessHandler handler2 = new CapturingProcessHandler(process2, commandLine.getCharset(), commandLine.getCommandLineString());
            final ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            if (showProgress && indicator != null) {
                handler2.addProcessListener((ProcessListener)new ProcessAdapter(){

                    public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                        if (event == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        if (outputType == null) {
                            2.$$$reportNull$$$0(1);
                        }
                        if (outputType == ProcessOutputTypes.STDOUT || outputType == ProcessOutputTypes.STDERR) {
                            for (String line : StringUtil.splitByLines((String)event.getText())) {
                                String trimmed = line.trim();
                                if (!this.isMeaningfulOutput(trimmed)) continue;
                                indicator.setText2(trimmed);
                            }
                        }
                    }

                    private boolean isMeaningfulOutput(@NotNull String trimmed) {
                        if (trimmed == null) {
                            2.$$$reportNull$$$0(2);
                        }
                        return trimmed.length() > 3;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "event";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "outputType";
                                break;
                            }
                            case 2: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "trimmed";
                                break;
                            }
                        }
                        objectArray2[1] = "com/jetbrains/python/packaging/PyPackageManagerImpl$2";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "onTextAvailable";
                                break;
                            }
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[2] = "isMeaningfulOutput";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
                result2 = handler2.runProcessWithProgressIndicator(indicator);
            } else {
                result2 = handler2.runProcess(600000);
            }
            if (result2.isCancelled()) {
                throw new RunCanceledByUserException();
            }
            int exitCode = result2.getExitCode();
            if (exitCode != 0) {
                String message = StringUtil.isEmptyOrSpaces((String)result2.getStdout()) && StringUtil.isEmptyOrSpaces((String)result2.getStderr()) ? "Permission denied" : "Non-zero exit code (" + exitCode + ")";
                throw new PyExecutionException(message, helperPath, args, result2);
            }
            processOutput = result2;
        }
        catch (IOException e) {
            throw new PyExecutionException(e.getMessage(), helperPath, args);
        }
        if (processOutput == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(32);
        }
        return processOutput;
    }

    @NotNull
    private static List<PyPackage> parsePackagingToolOutput(@NotNull String s) throws ExecutionException {
        if (s == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(33);
        }
        String[] lines2 = StringUtil.splitByLines((String)s);
        ArrayList<PyPackage> packages = new ArrayList<PyPackage>();
        for (String line : lines2) {
            List fields = StringUtil.split((String)line, (String)"\t");
            if (fields.size() < 3) {
                throw new PyExecutionException("Invalid output format", PACKAGING_TOOL, Collections.emptyList());
            }
            String name = (String)fields.get(0);
            String version = (String)fields.get(1);
            String location = (String)fields.get(2);
            ArrayList<PyRequirement> requirements = new ArrayList<PyRequirement>();
            if (fields.size() >= 4) {
                String requiresLine = (String)fields.get(3);
                String requiresSpec = StringUtil.join((Collection)StringUtil.split((String)requiresLine, (String)":"), (String)"\n");
                requirements.addAll(PyPackageUtil.fix(PyRequirement.fromText(requiresSpec)));
            }
            if ("Python".equals(name)) continue;
            packages.add(new PyPackage(name, version, location, requirements));
        }
        ArrayList<PyPackage> arrayList = packages;
        if (arrayList == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(34);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 29: 
            case 32: 
            case 34: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 29: 
            case 32: 
            case 34: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 29: 
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/packaging/PyPackageManagerImpl";
                break;
            }
            case 3: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requirementString";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requirements";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extraArgs";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packages";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkg";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destinationDir";
                break;
            }
            case 19: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 25: 
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helperPath";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/packaging/PyPackageManagerImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "extractHelper";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdk";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "collectPackages";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependents";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createVirtualEnv";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrRequestLanguageLevelForSdk";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "parseRequirements";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "refreshAndGetPackages";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelperResult";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getPythonProcessResult";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getPythonProcessOutput";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "parsePackagingToolOutput";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "installManagement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "extractHelper";
                break;
            }
            case 2: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 29: 
            case 32: 
            case 34: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = INSTALL;
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = UNINSTALL;
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getDependents";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createVirtualEnv";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getOrRequestLanguageLevelForSdk";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getRequirements";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "parseRequirements";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getHelperResult";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getPythonProcessResult";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getPythonProcessOutput";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "parsePackagingToolOutput";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getRequirements$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 29: 
            case 32: 
            case 34: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MySdkRootWatcher
    implements BulkFileListener {
        private MySdkRootWatcher() {
        }

        public void after(@NotNull List<? extends VFileEvent> events) {
            if (events == null) {
                MySdkRootWatcher.$$$reportNull$$$0(0);
            }
            Sdk sdk = PyPackageManagerImpl.this.getSdk();
            VirtualFile[] roots = sdk.getRootProvider().getFiles(OrderRootType.CLASSES);
            for (VFileEvent vFileEvent : events) {
                VirtualFile file2 = vFileEvent.getFile();
                if (file2 == null) continue;
                for (VirtualFile root : roots) {
                    if (!VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)file2, (boolean)false)) continue;
                    LOG.debug("Refreshing packages cache on SDK change");
                    ApplicationManager.getApplication().executeOnPooledThread(() -> PyPackageManagerImpl.this.refreshPackagesSynchronously());
                    return;
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/jetbrains/python/packaging/PyPackageManagerImpl$MySdkRootWatcher", "after"));
        }
    }
}

