/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.changeSignature;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.refactoring.changeSignature.MethodDescriptor;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.refactoring.changeSignature.PyParameterInfo;
import java.util.ArrayList;
import java.util.List;

public class PyMethodDescriptor
implements MethodDescriptor<PyParameterInfo, String> {
    private final PyFunction myFunction;

    public PyMethodDescriptor(PyFunction function) {
        this.myFunction = function;
    }

    @Override
    public String getName() {
        return this.myFunction.getName();
    }

    @Override
    public List<PyParameterInfo> getParameters() {
        ArrayList<PyParameterInfo> parameterInfos = new ArrayList<PyParameterInfo>();
        PyParameter[] parameters = this.myFunction.getParameterList().getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            PyParameter parameter = parameters[i];
            PyExpression defaultValue = parameter.getDefaultValue();
            String name = parameter instanceof PyNamedParameter ? (((PyNamedParameter)parameter).isPositionalContainer() ? "*" + parameter.getName() : (((PyNamedParameter)parameter).isKeywordContainer() ? "**" + parameter.getName() : parameter.getName())) : parameter.getText();
            parameterInfos.add(new PyParameterInfo(i, name, defaultValue == null ? null : defaultValue.getText(), defaultValue != null && !StringUtil.isEmptyOrSpaces((String)defaultValue.getText())));
        }
        return parameterInfos;
    }

    @Override
    public int getParametersCount() {
        return this.myFunction.getParameterList().getParameters().length;
    }

    @Override
    public String getVisibility() {
        return "";
    }

    @Override
    public PyFunction getMethod() {
        return this.myFunction;
    }

    @Override
    public boolean canChangeVisibility() {
        return false;
    }

    @Override
    public boolean canChangeParameters() {
        return true;
    }

    @Override
    public boolean canChangeName() {
        return true;
    }

    @Override
    public MethodDescriptor.ReadWriteOption canChangeReturnType() {
        return MethodDescriptor.ReadWriteOption.None;
    }
}

