/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.java.impl.compiler;

import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.compiler.ProcessorConfigProfile;

public final class ProcessorConfigProfileImpl
implements ProcessorConfigProfile {
    private String myName = "";
    private boolean myEnabled = false;
    private boolean myObtainProcessorsFromClasspath = true;
    private String myProcessorPath = "";
    private final Set<String> myProcessors = new THashSet(1);
    private final Map<String, String> myProcessorOptions = new THashMap(1);
    private String myGeneratedProductionDirectoryName = "generated";
    private String myGeneratedTestsDirectoryName = "generated_tests";
    private boolean myOutputRelativeToContentRoot = false;
    private final Set<String> myModuleNames = new THashSet(1);

    public ProcessorConfigProfileImpl(String name) {
        this.myName = name;
    }

    public ProcessorConfigProfileImpl(ProcessorConfigProfile profile2) {
        this.initFrom(profile2);
    }

    public final void initFrom(ProcessorConfigProfile other) {
        this.myName = other.getName();
        this.myEnabled = other.isEnabled();
        this.myObtainProcessorsFromClasspath = other.isObtainProcessorsFromClasspath();
        this.myProcessorPath = other.getProcessorPath();
        this.myProcessors.clear();
        this.myProcessors.addAll(other.getProcessors());
        this.myProcessorOptions.clear();
        this.myProcessorOptions.putAll(other.getProcessorOptions());
        this.myGeneratedProductionDirectoryName = other.getGeneratedSourcesDirectoryName(false);
        this.myGeneratedTestsDirectoryName = other.getGeneratedSourcesDirectoryName(true);
        this.myOutputRelativeToContentRoot = other.isOutputRelativeToContentRoot();
        this.myModuleNames.clear();
        this.myModuleNames.addAll(other.getModuleNames());
    }

    public String getName() {
        return this.myName;
    }

    public void setName(String name) {
        this.myName = name;
    }

    public boolean isEnabled() {
        return this.myEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.myEnabled = enabled;
    }

    @NotNull
    public String getProcessorPath() {
        String string = this.myProcessorPath;
        if (string == null) {
            ProcessorConfigProfileImpl.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void setProcessorPath(@Nullable String processorPath) {
        this.myProcessorPath = processorPath != null ? processorPath : "";
    }

    public boolean isObtainProcessorsFromClasspath() {
        return this.myObtainProcessorsFromClasspath;
    }

    public void setObtainProcessorsFromClasspath(boolean value) {
        this.myObtainProcessorsFromClasspath = value;
    }

    @NotNull
    public String getGeneratedSourcesDirectoryName(boolean forTests) {
        String string = forTests ? this.myGeneratedTestsDirectoryName : this.myGeneratedProductionDirectoryName;
        if (string == null) {
            ProcessorConfigProfileImpl.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void setGeneratedSourcesDirectoryName(@Nullable String name, boolean forTests) {
        if (forTests) {
            this.myGeneratedTestsDirectoryName = name != null ? name.trim() : "generated_tests";
        } else {
            this.myGeneratedProductionDirectoryName = name != null ? name.trim() : "generated";
        }
    }

    public boolean isOutputRelativeToContentRoot() {
        return this.myOutputRelativeToContentRoot;
    }

    public void setOutputRelativeToContentRoot(boolean relativeToContent) {
        this.myOutputRelativeToContentRoot = relativeToContent;
    }

    @NotNull
    public Set<String> getModuleNames() {
        Set<String> set2 = this.myModuleNames;
        if (set2 == null) {
            ProcessorConfigProfileImpl.$$$reportNull$$$0(2);
        }
        return set2;
    }

    public boolean addModuleName(String name) {
        return this.myModuleNames.add(name);
    }

    public boolean addModuleNames(Collection<String> names) {
        return this.myModuleNames.addAll(names);
    }

    public boolean removeModuleName(String name) {
        return this.myModuleNames.remove(name);
    }

    public boolean removeModuleNames(Collection<String> names) {
        return this.myModuleNames.removeAll(names);
    }

    public void clearModuleNames() {
        this.myModuleNames.clear();
    }

    public void clearProcessors() {
        this.myProcessors.clear();
    }

    public boolean addProcessor(String processor2) {
        return this.myProcessors.add(processor2);
    }

    public boolean removeProcessor(String processor2) {
        return this.myProcessors.remove(processor2);
    }

    @NotNull
    public Set<String> getProcessors() {
        Set<String> set2 = Collections.unmodifiableSet(this.myProcessors);
        if (set2 == null) {
            ProcessorConfigProfileImpl.$$$reportNull$$$0(3);
        }
        return set2;
    }

    @NotNull
    public Map<String, String> getProcessorOptions() {
        Map<String, String> map2 = Collections.unmodifiableMap(this.myProcessorOptions);
        if (map2 == null) {
            ProcessorConfigProfileImpl.$$$reportNull$$$0(4);
        }
        return map2;
    }

    public String setOption(String key, String value) {
        return this.myProcessorOptions.put(key, value);
    }

    @Nullable
    public String getOption(String key) {
        return this.myProcessorOptions.get(key);
    }

    public void clearProcessorOptions() {
        this.myProcessorOptions.clear();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessorConfigProfileImpl profile2 = (ProcessorConfigProfileImpl)o;
        if (this.myEnabled != profile2.myEnabled) {
            return false;
        }
        if (this.myObtainProcessorsFromClasspath != profile2.myObtainProcessorsFromClasspath) {
            return false;
        }
        if (this.myGeneratedProductionDirectoryName != null ? !this.myGeneratedProductionDirectoryName.equals(profile2.myGeneratedProductionDirectoryName) : profile2.myGeneratedProductionDirectoryName != null) {
            return false;
        }
        if (this.myGeneratedTestsDirectoryName != null ? !this.myGeneratedTestsDirectoryName.equals(profile2.myGeneratedTestsDirectoryName) : profile2.myGeneratedTestsDirectoryName != null) {
            return false;
        }
        if (this.myOutputRelativeToContentRoot != profile2.myOutputRelativeToContentRoot) {
            return false;
        }
        if (!this.myModuleNames.equals(profile2.myModuleNames)) {
            return false;
        }
        if (!this.myProcessorOptions.equals(profile2.myProcessorOptions)) {
            return false;
        }
        if (this.myProcessorPath != null ? !this.myProcessorPath.equals(profile2.myProcessorPath) : profile2.myProcessorPath != null) {
            return false;
        }
        if (!this.myProcessors.equals(profile2.myProcessors)) {
            return false;
        }
        return this.myName.equals(profile2.myName);
    }

    public int hashCode() {
        int result2 = this.myName.hashCode();
        result2 = 31 * result2 + (this.myEnabled ? 1 : 0);
        result2 = 31 * result2 + (this.myObtainProcessorsFromClasspath ? 1 : 0);
        result2 = 31 * result2 + (this.myProcessorPath != null ? this.myProcessorPath.hashCode() : 0);
        result2 = 31 * result2 + this.myProcessors.hashCode();
        result2 = 31 * result2 + this.myProcessorOptions.hashCode();
        result2 = 31 * result2 + (this.myGeneratedProductionDirectoryName != null ? this.myGeneratedProductionDirectoryName.hashCode() : 0);
        result2 = 31 * result2 + (this.myGeneratedTestsDirectoryName != null ? this.myGeneratedTestsDirectoryName.hashCode() : 0);
        result2 = 31 * result2 + (this.myOutputRelativeToContentRoot ? 1 : 0);
        result2 = 31 * result2 + this.myModuleNames.hashCode();
        return result2;
    }

    public String toString() {
        return this.myName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/jps/model/java/impl/compiler/ProcessorConfigProfileImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessorPath";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGeneratedSourcesDirectoryName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleNames";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessors";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessorOptions";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

