/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github;

import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.VirtualFile;
import icons.GithubIcons;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubApiUtil;
import org.jetbrains.plugins.github.api.data.GithubGist;
import org.jetbrains.plugins.github.api.requests.GithubGistRequest;
import org.jetbrains.plugins.github.ui.GithubCreateGistDialog;
import org.jetbrains.plugins.github.util.AuthLevel;
import org.jetbrains.plugins.github.util.GithubAuthData;
import org.jetbrains.plugins.github.util.GithubAuthDataHolder;
import org.jetbrains.plugins.github.util.GithubNotifications;
import org.jetbrains.plugins.github.util.GithubUtil;

public class GithubCreateGistAction
extends DumbAwareAction {
    private static final Logger LOG = GithubUtil.LOG;
    private static final String FAILED_TO_CREATE_GIST = "Can't create Gist";

    protected GithubCreateGistAction() {
        super("Create Gist...", "Create GitHub Gist", GithubIcons.Github_icon);
    }

    public void update(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null || project.isDefault()) {
            e.getPresentation().setVisible(false);
            e.getPresentation().setEnabled(false);
            return;
        }
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        VirtualFile[] files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (editor == null && file == null && files == null || editor != null && editor.getDocument().getTextLength() == 0) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e.getPresentation().setEnabledAndVisible(true);
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null || project.isDefault()) {
            return;
        }
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        VirtualFile[] files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (editor == null && file == null && files == null) {
            return;
        }
        GithubCreateGistAction.createGistAction(project, editor, file, files);
    }

    static void createGistAction(final @NotNull Project project, final @Nullable Editor editor, final @Nullable VirtualFile file, final @Nullable VirtualFile[] files) {
        GithubCreateGistDialog dialog;
        if (project == null) {
            GithubCreateGistAction.$$$reportNull$$$0(0);
        }
        if (!(dialog = new GithubCreateGistDialog(project, editor, files, file)).showAndGet()) {
            return;
        }
        final GithubAuthDataHolder authHolder = GithubCreateGistAction.getValidAuthData(project, dialog.isAnonymous());
        if (authHolder == null) {
            return;
        }
        final Ref url = new Ref();
        new Task.Backgroundable(project, "Creating Gist..."){

            public void run(@NotNull ProgressIndicator indicator) {
                List<GithubGistRequest.FileContent> contents;
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((contents = GithubCreateGistAction.collectContents(project, editor, file, files)).isEmpty()) {
                    return;
                }
                String gistUrl = GithubCreateGistAction.createGist(project, authHolder, indicator, contents, dialog.isSecret(), dialog.getDescription(), dialog.getFileName());
                url.set((Object)gistUrl);
            }

            public void onSuccess() {
                if (url.isNull()) {
                    return;
                }
                if (dialog.isOpenInBrowser()) {
                    BrowserUtil.browse((String)((String)url.get()));
                } else {
                    GithubNotifications.showInfoURL(project, "Gist Created Successfully", "Your gist url", (String)url.get());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/github/GithubCreateGistAction$1", "run"));
            }
        }.queue();
    }

    @Nullable
    private static GithubAuthDataHolder getValidAuthData(@NotNull Project project, boolean isAnonymous) {
        if (project == null) {
            GithubCreateGistAction.$$$reportNull$$$0(1);
        }
        if (isAnonymous) {
            return new GithubAuthDataHolder(GithubAuthData.createAnonymous());
        }
        try {
            return (GithubAuthDataHolder)GithubUtil.computeValueInModalIO(project, "Access to GitHub", indicator -> {
                if (project == null) {
                    GithubCreateGistAction.$$$reportNull$$$0(30);
                }
                return GithubUtil.getValidAuthDataHolderFromConfig(project, AuthLevel.LOGGED, indicator);
            });
        }
        catch (IOException e) {
            GithubNotifications.showError(project, "Can't create gist", e);
            return null;
        }
    }

    @NotNull
    static List<GithubGistRequest.FileContent> collectContents(@NotNull Project project, @Nullable Editor editor, @Nullable VirtualFile file, @Nullable VirtualFile[] files) {
        if (project == null) {
            GithubCreateGistAction.$$$reportNull$$$0(2);
        }
        if (editor != null) {
            String content = GithubCreateGistAction.getContentFromEditor(editor);
            if (content == null) {
                List<GithubGistRequest.FileContent> list = Collections.emptyList();
                if (list == null) {
                    GithubCreateGistAction.$$$reportNull$$$0(3);
                }
                return list;
            }
            if (file != null) {
                List<GithubGistRequest.FileContent> list = Collections.singletonList(new GithubGistRequest.FileContent(file.getName(), content));
                if (list == null) {
                    GithubCreateGistAction.$$$reportNull$$$0(4);
                }
                return list;
            }
            List<GithubGistRequest.FileContent> list = Collections.singletonList(new GithubGistRequest.FileContent("", content));
            if (list == null) {
                GithubCreateGistAction.$$$reportNull$$$0(5);
            }
            return list;
        }
        if (files != null) {
            ArrayList<GithubGistRequest.FileContent> contents = new ArrayList<GithubGistRequest.FileContent>();
            for (VirtualFile vf : files) {
                contents.addAll(GithubCreateGistAction.getContentFromFile(vf, project, null));
            }
            ArrayList<GithubGistRequest.FileContent> arrayList = contents;
            if (arrayList == null) {
                GithubCreateGistAction.$$$reportNull$$$0(6);
            }
            return arrayList;
        }
        if (file != null) {
            List<GithubGistRequest.FileContent> list = GithubCreateGistAction.getContentFromFile(file, project, null);
            if (list == null) {
                GithubCreateGistAction.$$$reportNull$$$0(7);
            }
            return list;
        }
        LOG.error("File, files and editor can't be null all at once!");
        throw new IllegalStateException("File, files and editor can't be null all at once!");
    }

    @Nullable
    static String createGist(@NotNull Project project, @NotNull GithubAuthDataHolder auth, @NotNull ProgressIndicator indicator, @NotNull List<GithubGistRequest.FileContent> contents, boolean isSecret, @NotNull String description, @Nullable String filename) {
        if (project == null) {
            GithubCreateGistAction.$$$reportNull$$$0(8);
        }
        if (auth == null) {
            GithubCreateGistAction.$$$reportNull$$$0(9);
        }
        if (indicator == null) {
            GithubCreateGistAction.$$$reportNull$$$0(10);
        }
        if (contents == null) {
            GithubCreateGistAction.$$$reportNull$$$0(11);
        }
        if (description == null) {
            GithubCreateGistAction.$$$reportNull$$$0(12);
        }
        if (contents.isEmpty()) {
            GithubNotifications.showWarning(project, FAILED_TO_CREATE_GIST, "Can't create empty gist");
            return null;
        }
        if (contents.size() == 1 && filename != null) {
            GithubGistRequest.FileContent entry = contents.iterator().next();
            contents = Collections.singletonList(new GithubGistRequest.FileContent(filename, entry.getContent()));
        }
        try {
            List<GithubGistRequest.FileContent> finalContents = contents;
            return ((GithubGist)GithubUtil.runTask(project, auth, indicator, AuthLevel.ANY, connection -> {
                if (description == null) {
                    GithubCreateGistAction.$$$reportNull$$$0(29);
                }
                return GithubApiUtil.createGist(connection, finalContents, description, !isSecret);
            })).getHtmlUrl();
        }
        catch (IOException e) {
            GithubNotifications.showError(project, FAILED_TO_CREATE_GIST, e);
            return null;
        }
    }

    @Nullable
    private static String getContentFromEditor(@NotNull Editor editor) {
        String text;
        if (editor == null) {
            GithubCreateGistAction.$$$reportNull$$$0(13);
        }
        if ((text = (String)ReadAction.compute(() -> {
            if (editor == null) {
                GithubCreateGistAction.$$$reportNull$$$0(28);
            }
            return editor.getSelectionModel().getSelectedText();
        })) == null) {
            text = editor.getDocument().getText();
        }
        if (StringUtil.isEmptyOrSpaces((String)text)) {
            return null;
        }
        return text;
    }

    @NotNull
    private static List<GithubGistRequest.FileContent> getContentFromFile(@NotNull VirtualFile file, @NotNull Project project, @Nullable String prefix) {
        if (file == null) {
            GithubCreateGistAction.$$$reportNull$$$0(14);
        }
        if (project == null) {
            GithubCreateGistAction.$$$reportNull$$$0(15);
        }
        if (file.isDirectory()) {
            List<GithubGistRequest.FileContent> list = GithubCreateGistAction.getContentFromDirectory(file, project, prefix);
            if (list == null) {
                GithubCreateGistAction.$$$reportNull$$$0(16);
            }
            return list;
        }
        if (file.getFileType().isBinary()) {
            GithubNotifications.showWarning(project, FAILED_TO_CREATE_GIST, "Can't upload binary file: " + file);
            List<GithubGistRequest.FileContent> list = Collections.emptyList();
            if (list == null) {
                GithubCreateGistAction.$$$reportNull$$$0(17);
            }
            return list;
        }
        String content = (String)ReadAction.compute(() -> {
            if (file == null) {
                GithubCreateGistAction.$$$reportNull$$$0(27);
            }
            try {
                Document document = FileDocumentManager.getInstance().getDocument(file);
                if (document != null) {
                    return document.getText();
                }
                return new String(file.contentsToByteArray(), file.getCharset());
            }
            catch (IOException e) {
                LOG.info("Couldn't read contents of the file " + file, (Throwable)e);
                return null;
            }
        });
        if (content == null) {
            GithubNotifications.showWarning(project, FAILED_TO_CREATE_GIST, "Couldn't read the contents of the file " + file);
            List<GithubGistRequest.FileContent> list = Collections.emptyList();
            if (list == null) {
                GithubCreateGistAction.$$$reportNull$$$0(18);
            }
            return list;
        }
        if (StringUtil.isEmptyOrSpaces((String)content)) {
            List<GithubGistRequest.FileContent> list = Collections.emptyList();
            if (list == null) {
                GithubCreateGistAction.$$$reportNull$$$0(19);
            }
            return list;
        }
        String filename = GithubCreateGistAction.addPrefix(file.getName(), prefix, false);
        List<GithubGistRequest.FileContent> list = Collections.singletonList(new GithubGistRequest.FileContent(filename, content));
        if (list == null) {
            GithubCreateGistAction.$$$reportNull$$$0(20);
        }
        return list;
    }

    @NotNull
    private static List<GithubGistRequest.FileContent> getContentFromDirectory(@NotNull VirtualFile dir, @NotNull Project project, @Nullable String prefix) {
        if (dir == null) {
            GithubCreateGistAction.$$$reportNull$$$0(21);
        }
        if (project == null) {
            GithubCreateGistAction.$$$reportNull$$$0(22);
        }
        ArrayList<GithubGistRequest.FileContent> contents = new ArrayList<GithubGistRequest.FileContent>();
        for (VirtualFile file : dir.getChildren()) {
            if (GithubCreateGistAction.isFileIgnored(file, project)) continue;
            String pref = GithubCreateGistAction.addPrefix(dir.getName(), prefix, true);
            contents.addAll(GithubCreateGistAction.getContentFromFile(file, project, pref));
        }
        ArrayList<GithubGistRequest.FileContent> arrayList = contents;
        if (arrayList == null) {
            GithubCreateGistAction.$$$reportNull$$$0(23);
        }
        return arrayList;
    }

    private static String addPrefix(@NotNull String name, @Nullable String prefix, boolean addTrailingSlash) {
        if (name == null) {
            GithubCreateGistAction.$$$reportNull$$$0(24);
        }
        String pref = prefix == null ? "" : prefix;
        pref = pref + name;
        if (addTrailingSlash) {
            pref = pref + "_";
        }
        return pref;
    }

    private static boolean isFileIgnored(@NotNull VirtualFile file, @NotNull Project project) {
        ChangeListManager manager;
        if (file == null) {
            GithubCreateGistAction.$$$reportNull$$$0(25);
        }
        if (project == null) {
            GithubCreateGistAction.$$$reportNull$$$0(26);
        }
        return (manager = ChangeListManager.getInstance((Project)project)).isIgnoredFile(file) || FileTypeManager.getInstance().isFileIgnored(file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/github/GithubCreateGistAction";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "auth";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contents";
                break;
            }
            case 12: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 13: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 14: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/github/GithubCreateGistAction";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "collectContents";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentFromFile";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentFromDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createGistAction";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getValidAuthData";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "collectContents";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 23: {
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createGist";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getContentFromEditor";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getContentFromFile";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getContentFromDirectory";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "addPrefix";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isFileIgnored";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getContentFromFile$3";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getContentFromEditor$2";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createGist$1";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getValidAuthData$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

