from typing import Any, Iterable, Iterator, Optional, SupportsInt, Tuple, TypeVar, Union

IPV4LENGTH = ...  # type: int
IPV6LENGTH = ...  # type: int

class AddressValueError(ValueError): ...
class NetmaskValueError(ValueError): ...

class _TotalOrderingMixin:
    def __eq__(self, other): ...
    def __ne__(self, other): ...
    def __lt__(self, other): ...
    def __le__(self, other): ...
    def __gt__(self, other): ...
    def __ge__(self, other): ...

class _IPAddressBase(_TotalOrderingMixin):
    @property
    def exploded(self): ...
    @property
    def compressed(self): ...
    @property
    def version(self): ...

class _BaseAddress(_IPAddressBase, SupportsInt):
    def __init__(self, address) -> None: ...
    def __int__(self) -> int: ...
    def __eq__(self, other): ...
    def __lt__(self, other): ...
    def __add__(self, other): ...
    def __sub__(self, other): ...
    def __hash__(self): ...

class _BaseNetwork(_IPAddressBase):
    def __init__(self, address) -> None: ...
    def hosts(self): ...
    def __iter__(self): ...
    def __getitem__(self, n): ...
    def __lt__(self, other): ...
    def __eq__(self, other): ...
    def __hash__(self): ...
    def __contains__(self, other): ...
    def overlaps(self, other): ...
    @property
    def broadcast_address(self): ...
    @property
    def hostmask(self): ...
    @property
    def with_prefixlen(self): ...
    @property
    def with_netmask(self): ...
    @property
    def with_hostmask(self): ...
    @property
    def num_addresses(self): ...
    @property
    def prefixlen(self): ...
    def address_exclude(self, other): ...
    def compare_networks(self, other): ...
    def subnets(self, prefixlen_diff=..., new_prefix=...): ...
    def supernet(self, prefixlen_diff=..., new_prefix=...): ...
    @property
    def is_multicast(self): ...
    @property
    def is_reserved(self): ...
    @property
    def is_link_local(self): ...
    @property
    def is_private(self): ...
    @property
    def is_global(self): ...
    @property
    def is_unspecified(self): ...
    @property
    def is_loopback(self): ...

class _BaseV4:
    def __init__(self, address) -> None: ...
    @property
    def max_prefixlen(self): ...
    @property
    def version(self): ...

class IPv4Address(_BaseV4, _BaseAddress):
    def __init__(self, address: object) -> None: ...
    @property
    def packed(self) -> bytes: ...
    @property
    def is_reserved(self) -> bool: ...
    @property
    def is_private(self) -> bool: ...
    @property
    def is_multicast(self) -> bool: ...
    @property
    def is_unspecified(self) -> bool: ...
    @property
    def is_loopback(self) -> bool: ...
    @property
    def is_link_local(self) -> bool: ...

class IPv4Interface(IPv4Address):
    network = ...  # type: IPv4Network
    netmask = ...  # type: IPv4Address
    hostmask = ...  # type: IPv4Address
    def __init__(self, address: object) -> None: ...
    def __eq__(self, other: Any) -> bool: ...
    def __lt__(self, other: Any) -> bool: ...
    def __hash__(self) -> int: ...
    @property
    def ip(self) -> IPv4Address: ...
    @property
    def with_prefixlen(self) -> str: ...
    @property
    def with_netmask(self) -> str: ...
    @property
    def with_hostmask(self) -> str: ...

class IPv4Network(_BaseV4, _BaseNetwork):
    network_address = ...  # type: IPv4Address
    netmask = ...  # type: IPv4Address
    hosts = ...  # type: Iterator[IPv4Address]
    def __init__(self, address: object, strict: bool = ...) -> None: ...
    @property
    def is_global(self) -> bool: ...

class _BaseV6:
    def __init__(self, address) -> None: ...
    @property
    def max_prefixlen(self): ...
    @property
    def version(self): ...

class IPv6Address(_BaseV6, _BaseAddress):
    def __init__(self, address: object) -> None: ...
    @property
    def packed(self) -> bytes: ...
    @property
    def is_multicast(self) -> bool: ...
    @property
    def is_reserved(self) -> bool: ...
    @property
    def is_link_local(self) -> bool: ...
    @property
    def is_site_local(self) -> bool: ...
    @property
    def is_private(self) -> bool: ...
    @property
    def is_global(self) -> bool: ...
    @property
    def is_unspecified(self) -> bool: ...
    @property
    def is_loopback(self) -> bool: ...
    @property
    def ipv4_mapped(self) -> Optional[IPv4Address]: ...
    @property
    def teredo(self) -> Optional[Tuple[IPv4Address, IPv4Address]]: ...
    @property
    def sixtofour(self) -> Optional[IPv4Address]: ...

class IPv6Interface(IPv6Address):
    network = ...  # type: IPv6Network
    netmask = ...  # type: IPv6Address
    hostmask = ...  # type: IPv6Address
    def __init__(self, address: object) -> None: ...
    def __eq__(self, other: Any) -> bool: ...
    def __lt__(self, other: Any) -> bool: ...
    def __hash__(self) -> int: ...
    @property
    def ip(self) -> IPv6Address: ...
    @property
    def with_prefixlen(self) -> str: ...
    @property
    def with_netmask(self) -> str: ...
    @property
    def with_hostmask(self) -> str: ...
    @property
    def is_unspecified(self) -> bool: ...
    @property
    def is_loopback(self) -> bool: ...

class IPv6Network(_BaseV6, _BaseNetwork):
    network_address = ...  # type: IPv6Address
    netmask = ...  # type: IPv6Address
    def __init__(self, address: object, strict: bool = ...) -> None: ...
    def hosts(self) -> Iterator[IPv6Address]: ...
    @property
    def is_site_local(self) -> bool: ...

_ip_address = Union[IPv4Address, IPv6Address]
_ip_network = Union[IPv4Network, IPv6Network]
_ip_interface = Union[IPv4Interface, IPv6Interface]
_AnyIPAddress = TypeVar("_AnyIPAddress", IPv4Address, IPv6Address)

def ip_address(address: object) -> _ip_address: ...
def ip_network(address: object, strict: bool = ...) -> _ip_network: ...
def ip_interface(address: object) -> _ip_interface: ...
def v4_int_to_packed(address: int) -> bytes: ...
def v6_int_to_packed(address: int) -> bytes: ...
def summarize_address_range(first: _AnyIPAddress, _AnyIPAddress) -> Iterator[_AnyIPAddress]: ...
def collapse_addresses(addresses: Iterable[_AnyIPAddress]) -> Iterator[_AnyIPAddress]: ...
def get_mixed_type_key(obj): ...
