/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.io.stream;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.AccessDeniedException;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemException;
import java.nio.file.FileSystemLoopException;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexFormatTooNewException;
import org.apache.lucene.index.IndexFormatTooOldException;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BitUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRef;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.io.stream.InputStreamStreamInput;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.text.Text;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public abstract class StreamInput
extends InputStream {
    private Version version = Version.CURRENT;
    private final CharsRef spare = new CharsRef();

    public Version getVersion() {
        return this.version;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public abstract byte readByte() throws IOException;

    public abstract void readBytes(byte[] var1, int var2, int var3) throws IOException;

    public BytesReference readBytesReference() throws IOException {
        int length = this.readArraySize();
        return this.readBytesReference(length);
    }

    @Nullable
    public BytesReference readOptionalBytesReference() throws IOException {
        int length = this.readVInt() - 1;
        if (length < 0) {
            return null;
        }
        return this.readBytesReference(length);
    }

    public BytesReference readBytesReference(int length) throws IOException {
        if (length == 0) {
            return BytesArray.EMPTY;
        }
        byte[] bytes = new byte[length];
        this.readBytes(bytes, 0, length);
        return new BytesArray(bytes, 0, length);
    }

    public BytesRef readBytesRef() throws IOException {
        int length = this.readArraySize();
        return this.readBytesRef(length);
    }

    public BytesRef readBytesRef(int length) throws IOException {
        if (length == 0) {
            return new BytesRef();
        }
        byte[] bytes = new byte[length];
        this.readBytes(bytes, 0, length);
        return new BytesRef(bytes, 0, length);
    }

    public void readFully(byte[] b) throws IOException {
        this.readBytes(b, 0, b.length);
    }

    public short readShort() throws IOException {
        return (short)((this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF);
    }

    public int readInt() throws IOException {
        return (this.readByte() & 0xFF) << 24 | (this.readByte() & 0xFF) << 16 | (this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF;
    }

    public int readVInt() throws IOException {
        byte b = this.readByte();
        int i = b & 0x7F;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= (b & 0x7F) << 7;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= (b & 0x7F) << 14;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= (b & 0x7F) << 21;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        if ((b & 0x80) != 0) {
            throw new IOException("Invalid vInt ((" + Integer.toHexString(b) + " & 0x7f) << 28) | " + Integer.toHexString(i));
        }
        return i | (b & 0x7F) << 28;
    }

    public long readLong() throws IOException {
        return (long)this.readInt() << 32 | (long)this.readInt() & 0xFFFFFFFFL;
    }

    public long readVLong() throws IOException {
        byte b = this.readByte();
        long i = (long)b & 0x7FL;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 7;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 14;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 21;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 28;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 35;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 42;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 49;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 56;
        if ((b & 0x80) == 0) {
            return i;
        }
        b = this.readByte();
        if (b != 0 && b != 1) {
            throw new IOException("Invalid vlong (" + Integer.toHexString(b) + " << 63) | " + Long.toHexString(i));
        }
        return i |= (long)b << 63;
    }

    public long readZLong() throws IOException {
        long currentByte;
        long accumulator = 0L;
        int i = 0;
        while (((currentByte = (long)this.readByte()) & 0x80L) != 0L) {
            accumulator |= (currentByte & 0x7FL) << i;
            if ((i += 7) <= 63) continue;
            throw new IOException("variable-length stream is too long");
        }
        return BitUtil.zigZagDecode((long)(accumulator | currentByte << i));
    }

    @Nullable
    public Long readOptionalLong() throws IOException {
        if (this.readBoolean()) {
            return this.readLong();
        }
        return null;
    }

    @Nullable
    public Text readOptionalText() throws IOException {
        int length = this.readInt();
        if (length == -1) {
            return null;
        }
        return new Text(this.readBytesReference(length));
    }

    public Text readText() throws IOException {
        int length = this.readInt();
        return new Text(this.readBytesReference(length));
    }

    @Nullable
    public String readOptionalString() throws IOException {
        if (this.readBoolean()) {
            return this.readString();
        }
        return null;
    }

    @Nullable
    public Float readOptionalFloat() throws IOException {
        if (this.readBoolean()) {
            return Float.valueOf(this.readFloat());
        }
        return null;
    }

    @Nullable
    public Integer readOptionalVInt() throws IOException {
        if (this.readBoolean()) {
            return this.readVInt();
        }
        return null;
    }

    public String readString() throws IOException {
        int charCount = this.readArraySize();
        if (this.spare.chars.length < charCount) {
            this.spare.chars = new char[ArrayUtil.oversize((int)charCount, (int)2)];
        }
        this.spare.length = charCount;
        char[] buffer = this.spare.chars;
        block5: for (int i = 0; i < charCount; ++i) {
            int c = this.readByte() & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    buffer[i] = (char)c;
                    continue block5;
                }
                case 12: 
                case 13: {
                    buffer[i] = (char)((c & 0x1F) << 6 | this.readByte() & 0x3F);
                    continue block5;
                }
                case 14: {
                    buffer[i] = (char)((c & 0xF) << 12 | (this.readByte() & 0x3F) << 6 | (this.readByte() & 0x3F) << 0);
                    continue block5;
                }
                default: {
                    throw new IOException("Invalid string; unexpected character: " + c + " hex: " + Integer.toHexString(c));
                }
            }
        }
        return this.spare.toString();
    }

    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Nullable
    public final Double readOptionalDouble() throws IOException {
        if (this.readBoolean()) {
            return this.readDouble();
        }
        return null;
    }

    public final boolean readBoolean() throws IOException {
        return this.readBoolean(this.readByte());
    }

    private boolean readBoolean(byte value) {
        if (value == 0) {
            return false;
        }
        if (value == 1) {
            return true;
        }
        String message = String.format(Locale.ROOT, "unexpected byte [0x%02x]", value);
        throw new IllegalStateException(message);
    }

    @Nullable
    public final Boolean readOptionalBoolean() throws IOException {
        byte value = this.readByte();
        if (value == 2) {
            return null;
        }
        return this.readBoolean(value);
    }

    @Override
    public abstract void close() throws IOException;

    @Override
    public abstract int available() throws IOException;

    public String[] readStringArray() throws IOException {
        int size = this.readArraySize();
        if (size == 0) {
            return Strings.EMPTY_ARRAY;
        }
        String[] ret = new String[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = this.readString();
        }
        return ret;
    }

    @Nullable
    public String[] readOptionalStringArray() throws IOException {
        if (this.readBoolean()) {
            return this.readStringArray();
        }
        return null;
    }

    public <K, V> Map<K, V> readMap(Writeable.Reader<K> keyReader, Writeable.Reader<V> valueReader) throws IOException {
        int size = this.readArraySize();
        HashMap<K, V> map = new HashMap<K, V>(size);
        for (int i = 0; i < size; ++i) {
            K key = keyReader.read(this);
            V value = valueReader.read(this);
            map.put(key, value);
        }
        return map;
    }

    public <K, V> Map<K, List<V>> readMapOfLists(Writeable.Reader<K> keyReader, Writeable.Reader<V> valueReader) throws IOException {
        int size = this.readArraySize();
        if (size == 0) {
            return Collections.emptyMap();
        }
        HashMap<K, List<V>> map = new HashMap<K, List<V>>(size);
        for (int i = 0; i < size; ++i) {
            map.put(keyReader.read(this), this.readList(valueReader));
        }
        return map;
    }

    @Nullable
    public Map<String, Object> readMap() throws IOException {
        return (Map)this.readGenericValue();
    }

    @Nullable
    public Object readGenericValue() throws IOException {
        byte type = this.readByte();
        switch (type) {
            case -1: {
                return null;
            }
            case 0: {
                return this.readString();
            }
            case 1: {
                return this.readInt();
            }
            case 2: {
                return this.readLong();
            }
            case 3: {
                return Float.valueOf(this.readFloat());
            }
            case 4: {
                return this.readDouble();
            }
            case 5: {
                return this.readBoolean();
            }
            case 6: {
                return this.readByteArray();
            }
            case 7: {
                return this.readArrayList();
            }
            case 8: {
                return this.readArray();
            }
            case 9: {
                return this.readLinkedHashMap();
            }
            case 10: {
                return this.readHashMap();
            }
            case 11: {
                return this.readByte();
            }
            case 12: {
                return this.readDate();
            }
            case 13: {
                return this.readDateTime();
            }
            case 14: {
                return this.readBytesReference();
            }
            case 15: {
                return this.readText();
            }
            case 16: {
                return this.readShort();
            }
            case 17: {
                return this.readIntArray();
            }
            case 18: {
                return this.readLongArray();
            }
            case 19: {
                return this.readFloatArray();
            }
            case 20: {
                return this.readDoubleArray();
            }
            case 21: {
                return this.readBytesRef();
            }
            case 22: {
                return this.readGeoPoint();
            }
            case 23: {
                return this.readZonedDateTime();
            }
        }
        throw new IOException("Can't read unknown type [" + type + "]");
    }

    private List readArrayList() throws IOException {
        int size = this.readArraySize();
        ArrayList<Object> list = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            list.add(this.readGenericValue());
        }
        return list;
    }

    private DateTime readDateTime() throws IOException {
        String timeZoneId = this.readString();
        return new DateTime(this.readLong(), DateTimeZone.forID((String)timeZoneId));
    }

    private ZonedDateTime readZonedDateTime() throws IOException {
        String timeZoneId = this.readString();
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(this.readLong()), ZoneId.of(timeZoneId));
    }

    private Object[] readArray() throws IOException {
        int size8 = this.readArraySize();
        Object[] list8 = new Object[size8];
        for (int i = 0; i < size8; ++i) {
            list8[i] = this.readGenericValue();
        }
        return list8;
    }

    private Map readLinkedHashMap() throws IOException {
        int size9 = this.readArraySize();
        LinkedHashMap<String, Object> map9 = new LinkedHashMap<String, Object>(size9);
        for (int i = 0; i < size9; ++i) {
            map9.put(this.readString(), this.readGenericValue());
        }
        return map9;
    }

    private Map readHashMap() throws IOException {
        int size10 = this.readArraySize();
        HashMap<String, Object> map10 = new HashMap<String, Object>(size10);
        for (int i = 0; i < size10; ++i) {
            map10.put(this.readString(), this.readGenericValue());
        }
        return map10;
    }

    private Date readDate() throws IOException {
        return new Date(this.readLong());
    }

    public GeoPoint readGeoPoint() throws IOException {
        return new GeoPoint(this.readDouble(), this.readDouble());
    }

    public DateTimeZone readTimeZone() throws IOException {
        return DateTimeZone.forID((String)this.readString());
    }

    public DateTimeZone readOptionalTimeZone() throws IOException {
        if (this.readBoolean()) {
            return DateTimeZone.forID((String)this.readString());
        }
        return null;
    }

    public int[] readIntArray() throws IOException {
        int length = this.readArraySize();
        int[] values = new int[length];
        for (int i = 0; i < length; ++i) {
            values[i] = this.readInt();
        }
        return values;
    }

    public int[] readVIntArray() throws IOException {
        int length = this.readArraySize();
        int[] values = new int[length];
        for (int i = 0; i < length; ++i) {
            values[i] = this.readVInt();
        }
        return values;
    }

    public long[] readLongArray() throws IOException {
        int length = this.readArraySize();
        long[] values = new long[length];
        for (int i = 0; i < length; ++i) {
            values[i] = this.readLong();
        }
        return values;
    }

    public long[] readVLongArray() throws IOException {
        int length = this.readArraySize();
        long[] values = new long[length];
        for (int i = 0; i < length; ++i) {
            values[i] = this.readVLong();
        }
        return values;
    }

    public float[] readFloatArray() throws IOException {
        int length = this.readArraySize();
        float[] values = new float[length];
        for (int i = 0; i < length; ++i) {
            values[i] = this.readFloat();
        }
        return values;
    }

    public double[] readDoubleArray() throws IOException {
        int length = this.readArraySize();
        double[] values = new double[length];
        for (int i = 0; i < length; ++i) {
            values[i] = this.readDouble();
        }
        return values;
    }

    public byte[] readByteArray() throws IOException {
        int length = this.readArraySize();
        byte[] bytes = new byte[length];
        this.readBytes(bytes, 0, bytes.length);
        return bytes;
    }

    public <T> T[] readArray(Writeable.Reader<T> reader, IntFunction<T[]> arraySupplier) throws IOException {
        int length = this.readArraySize();
        T[] values = arraySupplier.apply(length);
        for (int i = 0; i < length; ++i) {
            values[i] = reader.read(this);
        }
        return values;
    }

    public <T> T[] readOptionalArray(Writeable.Reader<T> reader, IntFunction<T[]> arraySupplier) throws IOException {
        return this.readBoolean() ? this.readArray(reader, arraySupplier) : null;
    }

    @Nullable
    public <T extends Streamable> T readOptionalStreamable(Supplier<T> supplier) throws IOException {
        if (this.readBoolean()) {
            Streamable streamable = (Streamable)supplier.get();
            streamable.readFrom(this);
            return (T)streamable;
        }
        return null;
    }

    @Nullable
    public <T extends Writeable> T readOptionalWriteable(Writeable.Reader<T> reader) throws IOException {
        if (this.readBoolean()) {
            Writeable t = (Writeable)reader.read(this);
            if (t == null) {
                throw new IOException("Writeable.Reader [" + reader + "] returned null which is not allowed and probably means it screwed up the stream.");
            }
            return (T)t;
        }
        return null;
    }

    public <T extends Exception> T readException() throws IOException {
        if (this.readBoolean()) {
            int key = this.readVInt();
            switch (key) {
                case 0: {
                    int ord = this.readVInt();
                    return (T)ElasticsearchException.readException(this, ord);
                }
                case 1: {
                    String msg1 = this.readOptionalString();
                    String resource1 = this.readOptionalString();
                    return (T)((Exception)((Object)ElasticsearchException.readStackTrace(new CorruptIndexException(msg1, resource1, this.readException()), this)));
                }
                case 2: {
                    String resource2 = this.readOptionalString();
                    int version2 = this.readInt();
                    int minVersion2 = this.readInt();
                    int maxVersion2 = this.readInt();
                    return (T)((Exception)((Object)ElasticsearchException.readStackTrace(new IndexFormatTooNewException(resource2, version2, minVersion2, maxVersion2), this)));
                }
                case 3: {
                    String resource3 = this.readOptionalString();
                    if (this.readBoolean()) {
                        int version3 = this.readInt();
                        int minVersion3 = this.readInt();
                        int maxVersion3 = this.readInt();
                        return (T)((Exception)((Object)ElasticsearchException.readStackTrace(new IndexFormatTooOldException(resource3, version3, minVersion3, maxVersion3), this)));
                    }
                    String version3 = this.readOptionalString();
                    return (T)((Exception)((Object)ElasticsearchException.readStackTrace(new IndexFormatTooOldException(resource3, version3), this)));
                }
                case 4: {
                    return (T)ElasticsearchException.readStackTrace(new NullPointerException(this.readOptionalString()), this);
                }
                case 5: {
                    return (T)ElasticsearchException.readStackTrace(new NumberFormatException(this.readOptionalString()), this);
                }
                case 6: {
                    return (T)ElasticsearchException.readStackTrace(new IllegalArgumentException(this.readOptionalString(), (Throwable)this.readException()), this);
                }
                case 7: {
                    return (T)((Exception)((Object)ElasticsearchException.readStackTrace(new AlreadyClosedException(this.readOptionalString(), this.readException()), this)));
                }
                case 8: {
                    return (T)ElasticsearchException.readStackTrace(new EOFException(this.readOptionalString()), this);
                }
                case 9: {
                    return (T)ElasticsearchException.readStackTrace(new SecurityException(this.readOptionalString(), (Throwable)this.readException()), this);
                }
                case 10: {
                    return (T)ElasticsearchException.readStackTrace(new StringIndexOutOfBoundsException(this.readOptionalString()), this);
                }
                case 11: {
                    return (T)ElasticsearchException.readStackTrace(new ArrayIndexOutOfBoundsException(this.readOptionalString()), this);
                }
                case 12: {
                    return (T)ElasticsearchException.readStackTrace(new FileNotFoundException(this.readOptionalString()), this);
                }
                case 13: {
                    FileSystemException exception;
                    int subclass = this.readVInt();
                    String file = this.readOptionalString();
                    String other = this.readOptionalString();
                    String reason = this.readOptionalString();
                    this.readOptionalString();
                    switch (subclass) {
                        case 0: {
                            exception = new NoSuchFileException(file, other, reason);
                            break;
                        }
                        case 1: {
                            exception = new NotDirectoryException(file);
                            break;
                        }
                        case 2: {
                            exception = new DirectoryNotEmptyException(file);
                            break;
                        }
                        case 3: {
                            exception = new AtomicMoveNotSupportedException(file, other, reason);
                            break;
                        }
                        case 4: {
                            exception = new FileAlreadyExistsException(file, other, reason);
                            break;
                        }
                        case 5: {
                            exception = new AccessDeniedException(file, other, reason);
                            break;
                        }
                        case 6: {
                            exception = new FileSystemLoopException(file);
                            break;
                        }
                        case 7: {
                            exception = new FileSystemException(file, other, reason);
                            break;
                        }
                        default: {
                            throw new IllegalStateException("unknown FileSystemException with index " + subclass);
                        }
                    }
                    return (T)ElasticsearchException.readStackTrace(exception, this);
                }
                case 14: {
                    return (T)ElasticsearchException.readStackTrace(new IllegalStateException(this.readOptionalString(), (Throwable)this.readException()), this);
                }
                case 15: {
                    return (T)((Exception)ElasticsearchException.readStackTrace(new LockObtainFailedException(this.readOptionalString(), this.readException()), this));
                }
                case 16: {
                    return (T)ElasticsearchException.readStackTrace(new InterruptedException(this.readOptionalString()), this);
                }
                case 17: {
                    return (T)ElasticsearchException.readStackTrace(new IOException(this.readOptionalString(), (Throwable)this.readException()), this);
                }
            }
            throw new IOException("no such exception for id: " + key);
        }
        return null;
    }

    @Nullable
    public <C extends NamedWriteable> C readNamedWriteable(Class<C> categoryClass) throws IOException {
        throw new UnsupportedOperationException("can't read named writeable from StreamInput");
    }

    @Nullable
    public <C extends NamedWriteable> C readNamedWriteable(Class<C> categoryClass, String name) throws IOException {
        throw new UnsupportedOperationException("can't read named writeable from StreamInput");
    }

    @Nullable
    public <C extends NamedWriteable> C readOptionalNamedWriteable(Class<C> categoryClass) throws IOException {
        if (this.readBoolean()) {
            return this.readNamedWriteable(categoryClass);
        }
        return null;
    }

    public <T extends Streamable> List<T> readStreamableList(Supplier<T> constructor) throws IOException {
        int count = this.readArraySize();
        ArrayList<Streamable> builder = new ArrayList<Streamable>(count);
        for (int i = 0; i < count; ++i) {
            Streamable instance = (Streamable)constructor.get();
            instance.readFrom(this);
            builder.add(instance);
        }
        return builder;
    }

    public <T> List<T> readList(Writeable.Reader<T> reader) throws IOException {
        int count = this.readArraySize();
        ArrayList<T> builder = new ArrayList<T>(count);
        for (int i = 0; i < count; ++i) {
            builder.add(reader.read(this));
        }
        return builder;
    }

    public <T extends NamedWriteable> List<T> readNamedWriteableList(Class<T> categoryClass) throws IOException {
        int count = this.readArraySize();
        ArrayList<T> builder = new ArrayList<T>(count);
        for (int i = 0; i < count; ++i) {
            builder.add(this.readNamedWriteable(categoryClass));
        }
        return builder;
    }

    public <E extends Enum<E>> E readEnum(Class<E> enumClass) throws IOException {
        int ordinal = this.readVInt();
        Enum[] values = (Enum[])enumClass.getEnumConstants();
        if (ordinal < 0 || ordinal >= values.length) {
            throw new IOException("Unknown " + enumClass.getSimpleName() + " ordinal [" + ordinal + "]");
        }
        return (E)values[ordinal];
    }

    public static StreamInput wrap(byte[] bytes) {
        return StreamInput.wrap(bytes, 0, bytes.length);
    }

    public static StreamInput wrap(byte[] bytes, int offset, int length) {
        return new InputStreamStreamInput(new ByteArrayInputStream(bytes, offset, length), length);
    }

    private int readArraySize() throws IOException {
        int arraySize = this.readVInt();
        if (arraySize > ArrayUtil.MAX_ARRAY_LENGTH) {
            throw new IllegalStateException("array length must be <= to " + ArrayUtil.MAX_ARRAY_LENGTH + " but was: " + arraySize);
        }
        if (arraySize < 0) {
            throw new NegativeArraySizeException("array size must be positive but was: " + arraySize);
        }
        this.ensureCanReadBytes(arraySize);
        return arraySize;
    }

    protected abstract void ensureCanReadBytes(int var1) throws EOFException;
}

