/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.composite;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Set;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.InternalMultiBucketAggregation;
import org.elasticsearch.search.aggregations.KeyComparable;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeAggregation;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeKey;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;

public class InternalComposite
extends InternalMultiBucketAggregation<InternalComposite, InternalBucket>
implements CompositeAggregation {
    private final int size;
    private final List<InternalBucket> buckets;
    private final int[] reverseMuls;
    private final List<String> sourceNames;

    InternalComposite(String name, int size, List<String> sourceNames, List<InternalBucket> buckets, int[] reverseMuls, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) {
        super(name, pipelineAggregators, metaData);
        this.sourceNames = sourceNames;
        this.buckets = buckets;
        this.size = size;
        this.reverseMuls = reverseMuls;
    }

    public InternalComposite(StreamInput in) throws IOException {
        super(in);
        this.size = in.readVInt();
        this.sourceNames = in.readList(StreamInput::readString);
        this.reverseMuls = in.readIntArray();
        this.buckets = in.readList(input -> new InternalBucket(input, this.sourceNames, this.reverseMuls));
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeVInt(this.size);
        out.writeStringList(this.sourceNames);
        out.writeIntArray(this.reverseMuls);
        out.writeList(this.buckets);
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return CompositeAggregation.toXContentFragment(this, builder, params);
    }

    @Override
    public String getWriteableName() {
        return "composite";
    }

    @Override
    public InternalComposite create(List<InternalBucket> buckets) {
        return new InternalComposite(this.name, this.size, this.sourceNames, buckets, this.reverseMuls, this.pipelineAggregators(), this.getMetaData());
    }

    @Override
    public InternalBucket createBucket(InternalAggregations aggregations, InternalBucket prototype) {
        return new InternalBucket(prototype.sourceNames, prototype.key, prototype.reverseMuls, prototype.docCount, aggregations);
    }

    public int getSize() {
        return this.size;
    }

    @Override
    public List<InternalBucket> getBuckets() {
        return this.buckets;
    }

    @Override
    public Map<String, Object> afterKey() {
        return this.buckets.size() > 0 ? this.buckets.get(this.buckets.size() - 1).getKey() : null;
    }

    int[] getReverseMuls() {
        return this.reverseMuls;
    }

    @Override
    public InternalAggregation doReduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        PriorityQueue<BucketIterator> pq = new PriorityQueue<BucketIterator>(aggregations.size());
        for (InternalAggregation agg : aggregations) {
            InternalComposite sortedAgg = (InternalComposite)agg;
            BucketIterator it = new BucketIterator(sortedAgg.buckets);
            if (it.next() == null) continue;
            pq.add(it);
        }
        InternalBucket lastBucket = null;
        ArrayList<InternalBucket> buckets = new ArrayList<InternalBucket>();
        ArrayList<InternalBucket> result = new ArrayList<InternalBucket>();
        while (pq.size() > 0) {
            BucketIterator bucketIt = (BucketIterator)pq.poll();
            if (lastBucket != null && bucketIt.current.compareKey(lastBucket) != 0) {
                InternalBucket reduceBucket = ((InternalBucket)buckets.get(0)).reduce(buckets, reduceContext);
                buckets.clear();
                reduceContext.consumeBucketsAndMaybeBreak(1);
                result.add(reduceBucket);
                if (result.size() >= this.size) break;
            }
            lastBucket = bucketIt.current;
            buckets.add(bucketIt.current);
            if (bucketIt.next() == null) continue;
            pq.add(bucketIt);
        }
        if (buckets.size() > 0) {
            InternalBucket reduceBucket = ((InternalBucket)buckets.get(0)).reduce(buckets, reduceContext);
            reduceContext.consumeBucketsAndMaybeBreak(1);
            result.add(reduceBucket);
        }
        return new InternalComposite(this.name, this.size, this.sourceNames, result, this.reverseMuls, this.pipelineAggregators(), this.metaData);
    }

    @Override
    protected boolean doEquals(Object obj) {
        InternalComposite that = (InternalComposite)obj;
        return Objects.equals(this.size, that.size) && Objects.equals(this.buckets, that.buckets) && Arrays.equals(this.reverseMuls, that.reverseMuls);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.size, this.buckets, Arrays.hashCode(this.reverseMuls));
    }

    static Object formatObject(Object obj) {
        if (obj instanceof BytesRef) {
            return ((BytesRef)obj).utf8ToString();
        }
        return obj;
    }

    private static class ArrayMap
    extends AbstractMap<String, Object> {
        final List<String> keys;
        final Object[] values;

        ArrayMap(List<String> keys, Object[] values) {
            assert (keys.size() == values.length);
            this.keys = keys;
            this.values = values;
        }

        @Override
        public int size() {
            return this.values.length;
        }

        @Override
        public Object get(Object key) {
            for (int i = 0; i < this.keys.size(); ++i) {
                if (!key.equals(this.keys.get(i))) continue;
                return InternalComposite.formatObject(this.values[i]);
            }
            return null;
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            return new AbstractSet<Map.Entry<String, Object>>(){

                @Override
                public Iterator<Map.Entry<String, Object>> iterator() {
                    return new Iterator<Map.Entry<String, Object>>(){
                        int pos = 0;

                        @Override
                        public boolean hasNext() {
                            return this.pos < values.length;
                        }

                        @Override
                        public Map.Entry<String, Object> next() {
                            AbstractMap.SimpleEntry<String, Object> entry = new AbstractMap.SimpleEntry<String, Object>(keys.get(this.pos), InternalComposite.formatObject(values[this.pos]));
                            ++this.pos;
                            return entry;
                        }
                    };
                }

                @Override
                public int size() {
                    return keys.size();
                }
            };
        }
    }

    static class InternalBucket
    extends InternalMultiBucketAggregation.InternalBucket
    implements CompositeAggregation.Bucket,
    KeyComparable<InternalBucket> {
        private final CompositeKey key;
        private final long docCount;
        private final InternalAggregations aggregations;
        private final transient int[] reverseMuls;
        private final transient List<String> sourceNames;

        InternalBucket(List<String> sourceNames, CompositeKey key, int[] reverseMuls, long docCount, InternalAggregations aggregations) {
            this.key = key;
            this.docCount = docCount;
            this.aggregations = aggregations;
            this.reverseMuls = reverseMuls;
            this.sourceNames = sourceNames;
        }

        InternalBucket(StreamInput in, List<String> sourceNames, int[] reverseMuls) throws IOException {
            Comparable[] values = new Comparable[in.readVInt()];
            for (int i = 0; i < values.length; ++i) {
                values[i] = (Comparable)in.readGenericValue();
            }
            this.key = new CompositeKey(values);
            this.docCount = in.readVLong();
            this.aggregations = InternalAggregations.readAggregations(in);
            this.reverseMuls = reverseMuls;
            this.sourceNames = sourceNames;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.key.size());
            for (int i = 0; i < this.key.size(); ++i) {
                out.writeGenericValue(this.key.get(i));
            }
            out.writeVLong(this.docCount);
            this.aggregations.writeTo(out);
        }

        public int hashCode() {
            return Objects.hash(this.getClass(), this.docCount, this.key, this.aggregations);
        }

        public boolean equals(Object obj) {
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            InternalBucket that = (InternalBucket)obj;
            return Objects.equals(this.docCount, that.docCount) && Objects.equals(this.key, that.key) && Objects.equals(this.aggregations, that.aggregations);
        }

        @Override
        public Map<String, Object> getKey() {
            return new ArrayMap(this.sourceNames, this.key.values());
        }

        CompositeKey getRawKey() {
            return this.key;
        }

        @Override
        public String getKeyAsString() {
            StringBuilder builder = new StringBuilder();
            builder.append('{');
            for (int i = 0; i < this.key.size(); ++i) {
                if (i > 0) {
                    builder.append(", ");
                }
                builder.append(this.sourceNames.get(i));
                builder.append('=');
                builder.append(InternalComposite.formatObject(this.key.get(i)));
            }
            builder.append('}');
            return builder.toString();
        }

        @Override
        public long getDocCount() {
            return this.docCount;
        }

        @Override
        public Aggregations getAggregations() {
            return this.aggregations;
        }

        InternalBucket reduce(List<InternalBucket> buckets, InternalAggregation.ReduceContext reduceContext) {
            ArrayList<InternalAggregations> aggregations = new ArrayList<InternalAggregations>(buckets.size());
            long docCount = 0L;
            for (InternalBucket bucket : buckets) {
                docCount += bucket.docCount;
                aggregations.add(bucket.aggregations);
            }
            InternalAggregations aggs = InternalAggregations.reduce(aggregations, reduceContext);
            return new InternalBucket(this.sourceNames, this.key, this.reverseMuls, docCount, aggs);
        }

        @Override
        public int compareKey(InternalBucket other) {
            for (int i = 0; i < this.key.size(); ++i) {
                assert (this.key.get(i).getClass() == other.key.get(i).getClass());
                int cmp = this.key.get(i).compareTo(other.key.get(i)) * this.reverseMuls[i];
                if (cmp == 0) continue;
                return cmp;
            }
            return 0;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            throw new UnsupportedOperationException("not implemented");
        }
    }

    private static class BucketIterator
    implements Comparable<BucketIterator> {
        final Iterator<InternalBucket> it;
        InternalBucket current;

        private BucketIterator(List<InternalBucket> buckets) {
            this.it = buckets.iterator();
        }

        @Override
        public int compareTo(BucketIterator other) {
            return this.current.compareKey(other.current);
        }

        InternalBucket next() {
            this.current = this.it.hasNext() ? this.it.next() : null;
            return this.current;
        }
    }
}

