/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.painless.Definition;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.Operation;
import org.elasticsearch.painless.node.AExpression;
import org.elasticsearch.painless.node.AStoreable;
import org.elasticsearch.painless.node.EBinary;
import org.elasticsearch.painless.node.EConstant;

public final class EAssignment
extends AExpression {
    private AExpression lhs;
    private AExpression rhs;
    private final boolean pre;
    private final boolean post;
    private Operation operation;
    private boolean cat = false;
    private Definition.Type promote = null;
    private Definition.Type shiftDistance;
    private Definition.Cast there = null;
    private Definition.Cast back = null;
    private Definition.Type DefType = null;

    public EAssignment(Location location, AExpression lhs, AExpression rhs, boolean pre, boolean post, Operation operation) {
        super(location);
        this.lhs = Objects.requireNonNull(lhs);
        this.rhs = rhs;
        this.pre = pre;
        this.post = post;
        this.operation = operation;
    }

    @Override
    void extractVariables(Set<String> variables) {
        this.lhs.extractVariables(variables);
        this.rhs.extractVariables(variables);
    }

    @Override
    void analyze(Locals locals) {
        this.analyzeLHS(locals);
        this.analyzeIncrDecr();
        if (this.operation != null) {
            this.analyzeCompound(locals);
        } else if (this.rhs != null) {
            this.analyzeSimple(locals);
        } else {
            throw new IllegalStateException("Illegal tree structure.");
        }
        this.DefType = locals.getDefinition().DefType;
    }

    private void analyzeLHS(Locals locals) {
        if (!(this.lhs instanceof AStoreable)) {
            throw new IllegalArgumentException("Left-hand side cannot be assigned a value.");
        }
        AStoreable lhs = (AStoreable)this.lhs;
        lhs.read = this.read;
        lhs.write = true;
        lhs.analyze(locals);
    }

    private void analyzeIncrDecr() {
        if (this.pre && this.post) {
            throw this.createError(new IllegalStateException("Illegal tree structure."));
        }
        if (this.pre || this.post) {
            if (this.rhs != null) {
                throw this.createError(new IllegalStateException("Illegal tree structure."));
            }
            if (this.operation == Operation.INCR) {
                this.rhs = this.lhs.actual.clazz == Double.TYPE ? new EConstant(this.location, 1.0) : (this.lhs.actual.clazz == Float.TYPE ? new EConstant(this.location, Float.valueOf(1.0f)) : (this.lhs.actual.clazz == Long.TYPE ? new EConstant(this.location, 1L) : new EConstant(this.location, 1)));
                this.operation = Operation.ADD;
            } else if (this.operation == Operation.DECR) {
                this.rhs = this.lhs.actual.clazz == Double.TYPE ? new EConstant(this.location, 1.0) : (this.lhs.actual.clazz == Float.TYPE ? new EConstant(this.location, Float.valueOf(1.0f)) : (this.lhs.actual.clazz == Long.TYPE ? new EConstant(this.location, 1L) : new EConstant(this.location, 1)));
                this.operation = Operation.SUB;
            } else {
                throw this.createError(new IllegalStateException("Illegal tree structure."));
            }
        }
    }

    private void analyzeCompound(Locals locals) {
        this.rhs.analyze(locals);
        boolean shift = false;
        if (this.operation == Operation.MUL) {
            this.promote = locals.getDefinition().caster.promoteNumeric(this.lhs.actual, this.rhs.actual, true);
        } else if (this.operation == Operation.DIV) {
            this.promote = locals.getDefinition().caster.promoteNumeric(this.lhs.actual, this.rhs.actual, true);
        } else if (this.operation == Operation.REM) {
            this.promote = locals.getDefinition().caster.promoteNumeric(this.lhs.actual, this.rhs.actual, true);
        } else if (this.operation == Operation.ADD) {
            this.promote = locals.getDefinition().caster.promoteAdd(this.lhs.actual, this.rhs.actual);
        } else if (this.operation == Operation.SUB) {
            this.promote = locals.getDefinition().caster.promoteNumeric(this.lhs.actual, this.rhs.actual, true);
        } else if (this.operation == Operation.LSH) {
            this.promote = locals.getDefinition().caster.promoteNumeric(this.lhs.actual, false);
            this.shiftDistance = locals.getDefinition().caster.promoteNumeric(this.rhs.actual, false);
            shift = true;
        } else if (this.operation == Operation.RSH) {
            this.promote = locals.getDefinition().caster.promoteNumeric(this.lhs.actual, false);
            this.shiftDistance = locals.getDefinition().caster.promoteNumeric(this.rhs.actual, false);
            shift = true;
        } else if (this.operation == Operation.USH) {
            this.promote = locals.getDefinition().caster.promoteNumeric(this.lhs.actual, false);
            this.shiftDistance = locals.getDefinition().caster.promoteNumeric(this.rhs.actual, false);
            shift = true;
        } else if (this.operation == Operation.BWAND) {
            this.promote = locals.getDefinition().caster.promoteXor(this.lhs.actual, this.rhs.actual);
        } else if (this.operation == Operation.XOR) {
            this.promote = locals.getDefinition().caster.promoteXor(this.lhs.actual, this.rhs.actual);
        } else if (this.operation == Operation.BWOR) {
            this.promote = locals.getDefinition().caster.promoteXor(this.lhs.actual, this.rhs.actual);
        } else {
            throw this.createError(new IllegalStateException("Illegal tree structure."));
        }
        if (this.promote == null || shift && this.shiftDistance == null) {
            throw this.createError(new ClassCastException("Cannot apply compound assignment [" + this.operation.symbol + "=] to types [" + this.lhs.actual + "] and [" + this.rhs.actual + "]."));
        }
        boolean bl = this.cat = this.operation == Operation.ADD && this.promote.clazz == String.class;
        if (this.cat) {
            if (this.rhs instanceof EBinary && ((EBinary)this.rhs).operation == Operation.ADD && this.rhs.actual.clazz == String.class) {
                ((EBinary)this.rhs).cat = true;
            }
            this.rhs.expected = this.rhs.actual;
        } else if (shift) {
            if (this.promote.dynamic) {
                this.rhs.expected = this.promote;
            } else if (this.shiftDistance.clazz == Long.TYPE) {
                this.rhs.expected = locals.getDefinition().intType;
                this.rhs.explicit = true;
            } else {
                this.rhs.expected = this.shiftDistance;
            }
        } else {
            this.rhs.expected = this.promote;
        }
        this.rhs = this.rhs.cast(locals);
        this.there = locals.getDefinition().caster.getLegalCast(this.location, this.lhs.actual, this.promote, false, false);
        this.back = locals.getDefinition().caster.getLegalCast(this.location, this.promote, this.lhs.actual, true, false);
        this.statement = true;
        this.actual = this.read ? this.lhs.actual : locals.getDefinition().voidType;
    }

    private void analyzeSimple(Locals locals) {
        AStoreable lhs = (AStoreable)this.lhs;
        if (lhs.isDefOptimized()) {
            this.rhs.analyze(locals);
            if (this.rhs.actual.clazz == Void.TYPE) {
                throw this.createError(new IllegalArgumentException("Right-hand side cannot be a [void] type for assignment."));
            }
            this.rhs.expected = this.rhs.actual;
            lhs.updateActual(this.rhs.actual);
        } else {
            this.rhs.expected = lhs.actual;
            this.rhs.analyze(locals);
        }
        this.rhs = this.rhs.cast(locals);
        this.statement = true;
        this.actual = this.read ? lhs.actual : locals.getDefinition().voidType;
    }

    @Override
    void write(MethodWriter writer, Globals globals) {
        writer.writeDebugInfo(this.location);
        int catElementStackSize = 0;
        if (this.cat) {
            catElementStackSize = writer.writeNewStrings();
        }
        AStoreable lhs = (AStoreable)this.lhs;
        lhs.setup(writer, globals);
        if (this.cat) {
            writer.writeDup(lhs.accessElementCount(), catElementStackSize);
            lhs.load(writer, globals);
            writer.writeAppendStrings(lhs.actual);
            this.rhs.write(writer, globals);
            if (!(this.rhs instanceof EBinary) || !((EBinary)this.rhs).cat) {
                writer.writeAppendStrings(this.rhs.actual);
            }
            writer.writeToStrings();
            writer.writeCast(this.back);
            if (lhs.read) {
                writer.writeDup(lhs.actual.type.getSize(), lhs.accessElementCount());
            }
            lhs.store(writer, globals);
        } else if (this.operation != null) {
            writer.writeDup(lhs.accessElementCount(), 0);
            lhs.load(writer, globals);
            if (lhs.read && this.post) {
                writer.writeDup(lhs.actual.type.getSize(), lhs.accessElementCount());
            }
            writer.writeCast(this.there);
            this.rhs.write(writer, globals);
            if (this.promote.dynamic) {
                writer.writeDynamicBinaryInstruction(this.location, this.promote, this.DefType, this.DefType, this.operation, 2);
            } else {
                writer.writeBinaryInstruction(this.location, this.promote, this.operation);
            }
            writer.writeCast(this.back);
            if (lhs.read && !this.post) {
                writer.writeDup(lhs.actual.type.getSize(), lhs.accessElementCount());
            }
            lhs.store(writer, globals);
        } else {
            this.rhs.write(writer, globals);
            if (lhs.read) {
                writer.writeDup(lhs.actual.type.getSize(), lhs.accessElementCount());
            }
            lhs.store(writer, globals);
        }
    }

    @Override
    public String toString() {
        ArrayList<Object> subs = new ArrayList<Object>();
        subs.add(this.lhs);
        if (this.rhs != null) {
            subs.add(this.operation == null ? "=" : this.operation.symbol + "=");
            subs.add(this.rhs);
            return this.singleLineToString(subs);
        }
        subs.add(this.operation.symbol);
        if (this.pre) {
            subs.add("pre");
        }
        if (this.post) {
            subs.add("post");
        }
        return this.singleLineToString(subs);
    }
}

